/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import povtree.gui.PreviewPanel;
import povtree.objects3D.Tree3D;

public class TreeView
extends JPanel
implements TreeSelectionListener {
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    private String treeString;
    private String rootString;
    private String rootsString;
    private String trunkString;
    private String branchString;
    private String branchesString;
    private String twigString;
    private String twigsString;
    private String ramiString;
    private PreviewPanel previewPanel;
    private ResourceBundle labels;

    public TreeView(ResourceBundle resourceBundle, PreviewPanel previewPanel) {
        super(new GridBagLayout());
        this.labels = resourceBundle;
        this.previewPanel = previewPanel;
        this.treeString = this.labels.getString("tree");
        this.rootString = this.labels.getString("root");
        this.rootsString = this.labels.getString("roots");
        this.trunkString = this.labels.getString("trunk");
        this.branchString = this.labels.getString("branch");
        this.branchesString = this.labels.getString("branches");
        this.twigString = this.labels.getString("twig");
        this.twigsString = this.labels.getString("twigs");
        this.ramiString = this.labels.getString("ramification");
        this.rootNode = new DefaultMutableTreeNode(this.treeString);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(new ModelListener());
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(false);
        this.tree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        jScrollPane.setBackground(this.tree.getBackground());
        jScrollPane.setViewportBorder(new EmptyBorder(2, 2, 2, 2));
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    public void setTree(Tree3D tree3D) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode;
        int n2;
        this.rootNode.removeAllChildren();
        if (tree3D.getTrunk() != null) {
            this.addObject(null, this.trunkString);
        }
        if (tree3D.getRoot() != null) {
            n2 = tree3D.getRoot().size();
            defaultMutableTreeNode = this.addObject(null, this.rootsString + "(" + n2 + ")");
            n = 0;
            while (n < n2) {
                this.addObject(defaultMutableTreeNode, this.rootString + (n + 1));
                ++n;
            }
        }
        if (tree3D.getBranches() != null) {
            n2 = tree3D.getBranches().size();
            defaultMutableTreeNode = this.addObject(null, this.branchesString + "(" + n2 + ")");
            int n3 = 0;
            while (n3 < n2) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = this.addObject(defaultMutableTreeNode, this.branchString + (n3 + 1));
                if (tree3D.getTwigs() != null) {
                    n = tree3D.getTwigs().get(n3).size();
                    DefaultMutableTreeNode defaultMutableTreeNode3 = this.addObject(defaultMutableTreeNode2, this.twigsString + "(" + n + ")");
                    int n4 = 0;
                    while (n4 < n) {
                        DefaultMutableTreeNode defaultMutableTreeNode4 = this.addObject(defaultMutableTreeNode3, this.twigString + (n4 + 1));
                        if (tree3D.getRami() != null) {
                            int n5 = tree3D.getRami().get(n3).get(n4).size();
                            DefaultMutableTreeNode defaultMutableTreeNode5 = this.addObject(defaultMutableTreeNode4, this.ramiString + "(" + n5 + ")");
                            int n6 = 0;
                            while (n6 < n5) {
                                this.addObject(defaultMutableTreeNode5, this.ramiString + (n6 + 1));
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
        }
        this.treeModel.reload();
    }

    public void removeSelectedNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        MutableTreeNode mutableTreeNode;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (mutableTreeNode = (MutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            if (mutableTreeNode.getChildCount() == 0) {
                this.treeModel.removeNodeFromParent(mutableTreeNode);
            } else if (mutableTreeNode.toString().startsWith(this.rootsString)) {
                mutableTreeNode.setUserObject(this.rootsString + "(" + mutableTreeNode.getChildCount() + ")");
            } else if (mutableTreeNode.toString().startsWith(this.branchesString)) {
                mutableTreeNode.setUserObject(this.branchesString + "(" + mutableTreeNode.getChildCount() + ")");
            } else if (mutableTreeNode.toString().startsWith(this.twigsString)) {
                mutableTreeNode.setUserObject(this.twigsString + "(" + mutableTreeNode.getChildCount() + ")");
            } else if (mutableTreeNode.toString().startsWith(this.ramiString + "(")) {
                mutableTreeNode.setUserObject(this.ramiString + "(" + mutableTreeNode.getChildCount() + ")");
            }
        }
    }

    public DefaultMutableTreeNode addObject(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        TreePath treePath = this.tree.getSelectionPath();
        defaultMutableTreeNode = treePath == null ? this.rootNode : (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return this.addObject(defaultMutableTreeNode, object, true);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        return this.addObject(defaultMutableTreeNode, object, false);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.rootNode;
        }
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        if (bl) {
            this.tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        return defaultMutableTreeNode2;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        String string = (String)defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.getParent() == null && string.startsWith(this.treeString)) {
            this.previewPanel.setNumberOfSelectedElement(-1);
            this.previewPanel.setTypeOfSelectedElement(4);
            return;
        }
        int n = defaultMutableTreeNode.getParent().getIndex(defaultMutableTreeNode);
        if (string.startsWith(this.trunkString)) {
            this.previewPanel.setNumberOfSelectedElement(0);
            this.previewPanel.setTypeOfSelectedElement(5);
        } else if (string.startsWith(this.rootString) && string.indexOf("(") == -1) {
            this.previewPanel.setNumberOfSelectedElement(n);
            this.previewPanel.setTypeOfSelectedElement(0);
        } else if (string.startsWith(this.branchString) && string.indexOf("(") == -1) {
            this.previewPanel.setNumberOfSelectedElement(n);
            this.previewPanel.setTypeOfSelectedElement(1);
        } else if (string.startsWith(this.twigString) && string.indexOf("(") == -1) {
            this.previewPanel.setNumberOfSelectedElement(n);
            DefaultMutableTreeNode defaultMutableTreeNode2 = ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getPreviousNode();
            this.previewPanel.setBranchNumber(defaultMutableTreeNode2.getParent().getIndex(defaultMutableTreeNode2));
            this.previewPanel.setTypeOfSelectedElement(2);
        } else if (string.startsWith(this.ramiString) && string.indexOf("(") == -1) {
            this.previewPanel.setNumberOfSelectedElement(n);
            DefaultMutableTreeNode defaultMutableTreeNode3 = ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getPreviousNode();
            this.previewPanel.setTwigNumber(defaultMutableTreeNode3.getParent().getIndex(defaultMutableTreeNode3));
            DefaultMutableTreeNode defaultMutableTreeNode4 = ((DefaultMutableTreeNode)defaultMutableTreeNode3.getParent()).getPreviousNode();
            this.previewPanel.setBranchNumber(defaultMutableTreeNode4.getParent().getIndex(defaultMutableTreeNode4));
            this.previewPanel.setTypeOfSelectedElement(3);
        }
    }

    class ModelListener
    implements TreeModelListener {
        ModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            int n = treeModelEvent.getChildIndices()[0];
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }
}

