/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import povtree.gui.EnterListener;
import povtree.gui.FloatSliderChangeListener;
import povtree.gui.Helper;
import povtree.gui.IntegerSliderChangeListener;
import povtree.gui.Painter;
import povtree.gui.PovTree;
import povtree.gui.Resources;
import povtree.gui.plaf.GradientPanel;
import povtree.gui.plaf.LabelTip;
import povtree.gui.plaf.LabelUI;
import povtree.interfaces.Paintable;
import povtree.objects.Trunk;
import povtree.objects3D.BlobArray;
import povtree.povTreeGenerator.Accuracy;
import povtree.povTreeGenerator.Parameters;
import povtree.povTreeGenerator.TrunkGenerator;

public class TrunkPanel
extends JPanel
implements Paintable {
    private JSlider trunkRadialSlider = new JSlider(100000, 3000000, 100000);
    private JSlider trunkVertSlider = new JSlider(100000, 1000000, 100000);
    private JSlider radiusSlider = new JSlider(0, 10000000, 0);
    private JSlider strengthSlider = new JSlider(0, 100000, 0);
    private JSlider bendValueXSlider = new JSlider(-10000000, 10000000, 0);
    private JSlider bendFreqXSlider = new JSlider(0, 10000000, 0);
    private JSlider bendValueZSlider = new JSlider(-10000000, 10000000, 0);
    private JSlider bendFreqZSlider = new JSlider(0, 10000000, 0);
    private JSlider curveValueSlider = new JSlider(0, 10000000, 0);
    private JSlider curveFreqSlider = new JSlider(0, 10000000, 0);
    private JSlider snagValueSlider = new JSlider(0, 10000000, 0);
    private JSlider snagFreqSlider = new JSlider(0, 10000000, 0);
    private JSlider spiralSlider = new JSlider(0, 72000000, 0);
    private JSlider taperSlider = new JSlider(0, 100000, 0);
    private JTextField trunkRadial = new JTextField(4);
    private JTextField trunkVertical = new JTextField(4);
    private JTextField radius = new JTextField(7);
    private JTextField strength = new JTextField(7);
    private JTextField bendValueX = new JTextField(7);
    private JTextField bendFrequencyX = new JTextField(7);
    private JTextField bendValueZ = new JTextField(7);
    private JTextField bendFrequencyZ = new JTextField(7);
    private JTextField curveValue = new JTextField(7);
    private JTextField curveFrequency = new JTextField(7);
    private JTextField snagValue = new JTextField(7);
    private JTextField snagFrequency = new JTextField(7);
    private JTextField spiral = new JTextField(7);
    private JTextField taper = new JTextField(7);
    private Resources resources = Resources.getInstance();
    private ResourceBundle rb = Resources.getLabelsBundle();
    private ResourceBundle mb = Resources.getMessagesBundle();
    private String invalidNumber = this.mb.getString("invalidNumber");
    private String errorLabel = this.rb.getString("error");
    private Painter painter = new Painter(this.rb);
    private Parameters parameters = null;
    private PovTree povTree = null;
    private TrunkGenerator tg = null;
    private Accuracy acc = new Accuracy();

    public TrunkPanel(PovTree povTree, String string) {
        this.setLayout(new GridBagLayout());
        this.povTree = povTree;
        this.trunkRadial.addActionListener(new EnterListener(this.trunkRadial, this.trunkRadialSlider, this, this.invalidNumber, this.errorLabel));
        this.trunkRadialSlider.addChangeListener(new IntegerSliderChangeListener(this.trunkRadial, this));
        this.trunkRadial.setText(String.valueOf(this.acc.trunkRadial));
        Helper.setValue(this.trunkRadial, this.trunkRadialSlider, this, this.invalidNumber, this.errorLabel);
        this.trunkVertical.addActionListener(new EnterListener(this.trunkVertical, this.trunkVertSlider, this, this.invalidNumber, this.errorLabel));
        this.trunkVertSlider.addChangeListener(new IntegerSliderChangeListener(this.trunkVertical, this));
        this.trunkVertical.setText(String.valueOf(this.acc.trunkVertical));
        Helper.setValue(this.trunkVertical, this.trunkVertSlider, this, this.invalidNumber, this.errorLabel);
        this.radius.addActionListener(new EnterListener(this.radius, this.radiusSlider, this, this.invalidNumber, this.errorLabel));
        this.radiusSlider.addChangeListener(new FloatSliderChangeListener(this.radius, this));
        this.strength.addActionListener(new EnterListener(this.strength, this.strengthSlider, this, this.invalidNumber, this.errorLabel));
        this.strengthSlider.addChangeListener(new FloatSliderChangeListener(this.strength, this));
        this.bendValueX.addActionListener(new EnterListener(this.bendValueX, this.bendValueXSlider, this, this.invalidNumber, this.errorLabel));
        this.bendValueXSlider.addChangeListener(new FloatSliderChangeListener(this.bendValueX, this));
        this.bendFrequencyX.addActionListener(new EnterListener(this.bendFrequencyX, this.bendFreqXSlider, this, this.invalidNumber, this.errorLabel));
        this.bendFreqXSlider.addChangeListener(new FloatSliderChangeListener(this.bendFrequencyX, this));
        this.bendValueZ.addActionListener(new EnterListener(this.bendValueZ, this.bendValueZSlider, this, this.invalidNumber, this.errorLabel));
        this.bendValueZSlider.addChangeListener(new FloatSliderChangeListener(this.bendValueZ, this));
        this.bendFrequencyZ.addActionListener(new EnterListener(this.bendFrequencyZ, this.bendFreqZSlider, this, this.invalidNumber, this.errorLabel));
        this.bendFreqZSlider.addChangeListener(new FloatSliderChangeListener(this.bendFrequencyZ, this));
        this.curveValue.addActionListener(new EnterListener(this.curveValue, this.curveValueSlider, this, this.invalidNumber, this.errorLabel));
        this.curveValueSlider.addChangeListener(new FloatSliderChangeListener(this.curveValue, this));
        this.curveFrequency.addActionListener(new EnterListener(this.curveFrequency, this.curveFreqSlider, this, this.invalidNumber, this.errorLabel));
        this.curveFreqSlider.addChangeListener(new FloatSliderChangeListener(this.curveFrequency, this));
        this.snagValue.addActionListener(new EnterListener(this.snagValue, this.snagValueSlider, this, this.invalidNumber, this.errorLabel));
        this.snagValueSlider.addChangeListener(new FloatSliderChangeListener(this.snagValue, this));
        this.snagFrequency.addActionListener(new EnterListener(this.snagFrequency, this.snagFreqSlider, this, this.invalidNumber, this.errorLabel));
        this.snagFreqSlider.addChangeListener(new FloatSliderChangeListener(this.snagFrequency, this));
        this.spiral.addActionListener(new EnterListener(this.spiral, this.spiralSlider, this, this.invalidNumber, this.errorLabel));
        this.spiralSlider.addChangeListener(new FloatSliderChangeListener(this.spiral, this));
        this.taper.addActionListener(new EnterListener(this.taper, this.taperSlider, this, this.invalidNumber, this.errorLabel));
        this.taperSlider.addChangeListener(new FloatSliderChangeListener(this.taper, this));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 4.0;
        jPanel.add((Component)this.painter, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        GradientPanel gradientPanel = new GradientPanel(25, 5);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.rb.getString("treeLatitude"));
        LabelUI labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel.setUI(labelUI);
        gradientPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.trunkRadialSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.trunkRadialSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.trunkRadial, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("treeLongitude"));
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel.setUI(labelUI);
        gradientPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.trunkVertSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.trunkVertSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.trunkVertical, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)gradientPanel, "Center");
        GradientPanel gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = new JLabel(this.rb.getString("treeMeshAccuracy"));
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel2, gridBagConstraints);
        jPanel2.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.weightx = 0.5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        GradientPanel gradientPanel3 = new GradientPanel(15, 15);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        LabelTip labelTip = new LabelTip(this.rb.getString("radius"), true, "tipsTrunk", "TRUNK_RADIUS", this, string);
        gradientPanel3.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.radiusSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.radiusSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel3.add((Component)this.radius, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("strength"), true, "tipsTrunk", "TRUNK_STRENGTH", this, string);
        gradientPanel3.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.strengthSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.strengthSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel3.add((Component)this.strength, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("spiral"), true, "tipsTrunk", "TRUNK_SPIRAL", this, string);
        gradientPanel3.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.spiralSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.spiralSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel3.add((Component)this.spiral, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("taper"), true, "tipsTrunk", "TRUNK_TAPER", this, string);
        gradientPanel3.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.taperSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.taperSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel3.add((Component)this.taper, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        gridBagConstraints.weightx = 0.5;
        jPanel.add((Component)gradientPanel3, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gradientPanel = new GradientPanel(20, 10);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("trunkValueX"), true, "tipsTrunk", "TRUNK_BEND_X", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.bendValueXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.bendValueXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.bendValueX, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("trunkFrequencyX"), true, "tipsTrunk", "TRUNK_BEND_X_FREQUENCY", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.bendFreqXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.bendFreqXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.bendFrequencyX, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("trunkValueZ"), true, "tipsTrunk", "TRUNK_BEND_X", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.bendValueZSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.bendValueZSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.bendValueZ, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("trunkFrequencyZ"), true, "tipsTrunk", "TRUNK_BEND_X_FREQUENCY", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.bendFreqZSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.bendFreqZSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.bendFrequencyZ, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel, "Center");
        gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel2 = new JLabel(this.rb.getString("bend"));
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel2, gridBagConstraints);
        jPanel2.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.weightx = 0.5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel = new GradientPanel(20, 10);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("value"), true, "tipsTrunk", "TRUNK_CURVE", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.curveValueSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.curveValueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.curveValue, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("frequency"), true, "tipsTrunk", "TRUNK_CURVE_FREQUENCY", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.curveFreqSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.curveFreqSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.curveFrequency, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel, "Center");
        gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel2 = new JLabel(this.rb.getString("curve"));
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel2, gridBagConstraints);
        jPanel2.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.weightx = 0.5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel = new GradientPanel(20, 10);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("value"), true, "tipsTrunk", "TRUNK_SNAG", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.snagValueSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.snagValueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.snagValue, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("frequency"), true, "tipsTrunk", "TRUNK_SNAG_FREQUENCY", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.snagFreqSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.snagFreqSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.snagFrequency, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel, "Center");
        gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel2 = new JLabel(this.rb.getString("snag"));
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel2, gridBagConstraints);
        jPanel2.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.weightx = 0.5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
    }

    public void paintElement() {
        if (this.povTree.getTree() == null) {
            return;
        }
        BlobArray blobArray = null;
        try {
            this.parameters = new Parameters(this.povTree.getTree());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + numberFormatException.getMessage(), this.rb.getString("error"), 0);
            return;
        }
        this.tg = new TrunkGenerator(this.parameters);
        blobArray = this.tg.generate();
        if (blobArray != null) {
            blobArray.rotateX(180.0f);
            int n = this.getRadialAccuracy();
            int n2 = this.getVerticalAccuracy();
            if (n != 0 && n2 != 0) {
                this.painter.setElement(blobArray, n, n2);
            }
        } else {
            this.painter.setElement(null, 0, 0);
        }
    }

    public void setTrunk(Trunk trunk) {
        this.radius.setText(trunk.radius);
        Helper.setValue(this.radius, this.radiusSlider, this, this.invalidNumber, this.errorLabel);
        this.strength.setText(trunk.strength);
        Helper.setValue(this.strength, this.strengthSlider, this, this.invalidNumber, this.errorLabel);
        this.bendValueX.setText(trunk.bendValueX);
        Helper.setValue(this.bendValueX, this.bendValueXSlider, this, this.invalidNumber, this.errorLabel);
        this.bendFrequencyX.setText(trunk.bendFrequencyX);
        Helper.setValue(this.bendFrequencyX, this.bendFreqXSlider, this, this.invalidNumber, this.errorLabel);
        this.bendValueZ.setText(trunk.bendValueZ);
        Helper.setValue(this.bendValueZ, this.bendValueZSlider, this, this.invalidNumber, this.errorLabel);
        this.bendFrequencyZ.setText(trunk.bendFrequencyZ);
        Helper.setValue(this.bendFrequencyZ, this.bendFreqZSlider, this, this.invalidNumber, this.errorLabel);
        this.curveValue.setText(trunk.curveValue);
        Helper.setValue(this.curveValue, this.curveValueSlider, this, this.invalidNumber, this.errorLabel);
        this.curveFrequency.setText(trunk.curveFrequency);
        Helper.setValue(this.curveFrequency, this.curveFreqSlider, this, this.invalidNumber, this.errorLabel);
        this.snagValue.setText(trunk.snagValue);
        Helper.setValue(this.snagValue, this.snagValueSlider, this, this.invalidNumber, this.errorLabel);
        this.snagFrequency.setText(trunk.snagFrequency);
        Helper.setValue(this.snagFrequency, this.snagFreqSlider, this, this.invalidNumber, this.errorLabel);
        this.spiral.setText(trunk.spiral);
        Helper.setValue(this.spiral, this.spiralSlider, this, this.invalidNumber, this.errorLabel);
        this.taper.setText(trunk.taper);
        Helper.setValue(this.taper, this.taperSlider, this, this.invalidNumber, this.errorLabel);
    }

    public Trunk getTrunk() {
        Trunk trunk = new Trunk();
        trunk.radius = this.radius.getText();
        trunk.strength = this.strength.getText();
        trunk.bendValueX = this.bendValueX.getText();
        trunk.bendFrequencyX = this.bendFrequencyX.getText();
        trunk.bendValueZ = this.bendValueZ.getText();
        trunk.bendFrequencyZ = this.bendFrequencyZ.getText();
        trunk.curveValue = this.curveValue.getText();
        trunk.curveFrequency = this.curveFrequency.getText();
        trunk.snagValue = this.snagValue.getText();
        trunk.snagFrequency = this.snagFrequency.getText();
        trunk.spiral = this.spiral.getText();
        trunk.taper = this.taper.getText();
        return trunk;
    }

    public int getRadialAccuracy() {
        int n = 0;
        String string = this.trunkRadial.getText();
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + string, this.rb.getString("error"), 0);
        }
        return n;
    }

    public int getVerticalAccuracy() {
        int n = 0;
        String string = this.trunkVertical.getText();
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + string, this.rb.getString("error"), 0);
        }
        return n;
    }
}

