/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import povtree.gui.EnterListener;
import povtree.gui.FloatSliderChangeListener;
import povtree.gui.Helper;
import povtree.gui.IntegerSliderChangeListener;
import povtree.gui.Painter;
import povtree.gui.PovTree;
import povtree.gui.Resources;
import povtree.gui.plaf.ButtonUI;
import povtree.gui.plaf.GradientPanel;
import povtree.gui.plaf.LabelTip;
import povtree.gui.plaf.LabelUI;
import povtree.interfaces.Paintable;
import povtree.objects.Twig;
import povtree.objects3D.BlobArray;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.TripleBlobArray;
import povtree.povTreeGenerator.Accuracy;
import povtree.povTreeGenerator.Parameters;
import povtree.povTreeGenerator.TwigGenerator;

public class TwigPanel
extends JPanel
implements Paintable {
    private JSlider twigRadialSlider = new JSlider(100000, 3000000, 100000);
    private JSlider twigVertSlider = new JSlider(100000, 1000000, 100000);
    private JSlider numberSlider = new JSlider(0, 20000000, 0);
    private JSlider startAtSlider = new JSlider(0, 40000000, 0);
    private JSlider areaSlider = new JSlider(0, 40000000, 0);
    private JSlider thicknessSlider = new JSlider(0, 100000, 0);
    private JSlider strengthSlider = new JSlider(0, 100000, 0);
    private JSlider angleXSlider = new JSlider(0, 36000000, 0);
    private JSlider angleScopeXSlider = new JSlider(0, 100000, 0);
    private JSlider alignmentXSlider = new JSlider(0, 100000, 0);
    private JSlider angleYSlider = new JSlider(0, 36000000, 0);
    private JSlider angleScopeYSlider = new JSlider(0, 100000, 0);
    private JSlider alignmentYSlider = new JSlider(0, 100000, 0);
    private JSlider taperSlider = new JSlider(0, 100000, 0);
    private JSlider tipSlider = new JSlider(0, 100000, 0);
    private JSlider straightSlider = new JSlider(0, 100000, 0);
    private JSlider curveValueSlider = new JSlider(0, 200000, 0);
    private JSlider curveFreqSlider = new JSlider(0, 400000, 0);
    private JSlider turnSlider = new JSlider(0, 100000, 0);
    private JSlider alternateSlider = new JSlider(0, 100000, 0);
    private JTextField twigRadial = new JTextField(4);
    private JTextField twigVertical = new JTextField(4);
    private JTextField number = new JTextField(7);
    private JTextField randomness = new JTextField(7);
    private JTextField startAt = new JTextField(7);
    private JTextField areaAtBranch = new JTextField(7);
    private JTextField thicknessRatio = new JTextField(7);
    private JTextField strength = new JTextField(7);
    private JTextField horizontalAngle = new JTextField(7);
    private JTextField horizontalAngleScope = new JTextField(7);
    private JTextField horizontalAlignment = new JTextField(7);
    private JTextField verticalAngle = new JTextField(7);
    private JTextField verticalAngleScope = new JTextField(7);
    private JTextField verticalAlignment = new JTextField(7);
    private JTextField turn = new JTextField(7);
    private JTextField alternate = new JTextField(7);
    private JTextField curveValue = new JTextField(7);
    private JTextField curveFrequency = new JTextField(7);
    private JTextField taper = new JTextField(7);
    private JTextField tipTF = new JTextField(7);
    private JTextField straightenTowardsBranch = new JTextField(7);
    private JButton random = null;
    private Random r = new Random();
    private Resources resources = Resources.getInstance();
    private ResourceBundle rb = Resources.getLabelsBundle();
    private ResourceBundle mb = Resources.getMessagesBundle();
    private String invalidNumber = this.mb.getString("invalidNumber");
    private String errorLabel = this.rb.getString("error");
    private Painter painter = new Painter(this.rb);
    private Parameters parameters = null;
    private PovTree povTree = null;
    private TwigGenerator tg = null;
    private JTabbedPane tabPane = new JTabbedPane();
    private Accuracy acc = new Accuracy();

    public TwigPanel(PovTree povTree, String string) {
        this.povTree = povTree;
        this.random = new JButton(this.rb.getString("randomness"));
        this.random.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TwigPanel.this.setNextFloat();
            }
        });
        this.twigRadial.addActionListener(new EnterListener(this.twigRadial, this.twigRadialSlider, this, this.invalidNumber, this.errorLabel));
        this.twigRadialSlider.addChangeListener(new IntegerSliderChangeListener(this.twigRadial, this));
        this.twigRadial.setText(String.valueOf(this.acc.twigRadial));
        Helper.setValue(this.twigRadial, this.twigRadialSlider, this, this.invalidNumber, this.errorLabel);
        this.twigVertical.addActionListener(new EnterListener(this.twigVertical, this.twigVertSlider, this, this.invalidNumber, this.errorLabel));
        this.twigVertSlider.addChangeListener(new IntegerSliderChangeListener(this.twigVertical, this));
        this.twigVertical.setText(String.valueOf(this.acc.twigVertical));
        Helper.setValue(this.twigVertical, this.twigVertSlider, this, this.invalidNumber, this.errorLabel);
        this.number.addActionListener(new EnterListener(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel));
        this.numberSlider.addChangeListener(new IntegerSliderChangeListener(this.number, this));
        this.startAt.addActionListener(new EnterListener(this.startAt, this.startAtSlider, this, this.invalidNumber, this.errorLabel));
        this.startAtSlider.addChangeListener(new FloatSliderChangeListener(this.startAt, this));
        this.areaAtBranch.addActionListener(new EnterListener(this.areaAtBranch, this.areaSlider, this, this.invalidNumber, this.errorLabel));
        this.areaSlider.addChangeListener(new FloatSliderChangeListener(this.areaAtBranch, this));
        this.thicknessRatio.addActionListener(new EnterListener(this.thicknessRatio, this.thicknessSlider, this, this.invalidNumber, this.errorLabel));
        this.thicknessSlider.addChangeListener(new FloatSliderChangeListener(this.thicknessRatio, this));
        this.strength.addActionListener(new EnterListener(this.strength, this.strengthSlider, this, this.invalidNumber, this.errorLabel));
        this.strengthSlider.addChangeListener(new FloatSliderChangeListener(this.strength, this));
        this.horizontalAngle.addActionListener(new EnterListener(this.horizontalAngle, this.angleXSlider, this, this.invalidNumber, this.errorLabel));
        this.angleXSlider.addChangeListener(new FloatSliderChangeListener(this.horizontalAngle, this));
        this.horizontalAngleScope.addActionListener(new EnterListener(this.horizontalAngleScope, this.angleScopeXSlider, this, this.invalidNumber, this.errorLabel));
        this.angleScopeXSlider.addChangeListener(new FloatSliderChangeListener(this.horizontalAngleScope, this));
        this.horizontalAlignment.addActionListener(new EnterListener(this.horizontalAlignment, this.alignmentXSlider, this, this.invalidNumber, this.errorLabel));
        this.alignmentXSlider.addChangeListener(new FloatSliderChangeListener(this.horizontalAlignment, this));
        this.verticalAngle.addActionListener(new EnterListener(this.verticalAngle, this.angleYSlider, this, this.invalidNumber, this.errorLabel));
        this.angleYSlider.addChangeListener(new FloatSliderChangeListener(this.verticalAngle, this));
        this.verticalAngleScope.addActionListener(new EnterListener(this.verticalAngleScope, this.angleScopeYSlider, this, this.invalidNumber, this.errorLabel));
        this.angleScopeYSlider.addChangeListener(new FloatSliderChangeListener(this.verticalAngleScope, this));
        this.verticalAlignment.addActionListener(new EnterListener(this.verticalAlignment, this.alignmentYSlider, this, this.invalidNumber, this.errorLabel));
        this.alignmentYSlider.addChangeListener(new FloatSliderChangeListener(this.verticalAlignment, this));
        this.taper.addActionListener(new EnterListener(this.taper, this.taperSlider, this, this.invalidNumber, this.errorLabel));
        this.taperSlider.addChangeListener(new FloatSliderChangeListener(this.taper, this));
        this.tipTF.addActionListener(new EnterListener(this.tipTF, this.tipSlider, this, this.invalidNumber, this.errorLabel));
        this.tipSlider.addChangeListener(new FloatSliderChangeListener(this.tipTF, this));
        this.straightenTowardsBranch.addActionListener(new EnterListener(this.straightenTowardsBranch, this.straightSlider, this, this.invalidNumber, this.errorLabel));
        this.straightSlider.addChangeListener(new FloatSliderChangeListener(this.straightenTowardsBranch, this));
        this.curveValue.addActionListener(new EnterListener(this.curveValue, this.curveValueSlider, this, this.invalidNumber, this.errorLabel));
        this.curveValueSlider.addChangeListener(new FloatSliderChangeListener(this.curveValue, this));
        this.curveFrequency.addActionListener(new EnterListener(this.curveFrequency, this.curveFreqSlider, this, this.invalidNumber, this.errorLabel));
        this.curveFreqSlider.addChangeListener(new FloatSliderChangeListener(this.curveFrequency, this));
        this.turn.addActionListener(new EnterListener(this.turn, this.turnSlider, this, this.invalidNumber, this.errorLabel));
        this.turnSlider.addChangeListener(new FloatSliderChangeListener(this.turn, this));
        this.alternate.addActionListener(new EnterListener(this.alternate, this.alternateSlider, this, this.invalidNumber, this.errorLabel));
        this.alternateSlider.addChangeListener(new FloatSliderChangeListener(this.alternate, this));
        this.setLayout(new GridBagLayout());
        GradientPanel gradientPanel = new GradientPanel(15, 15);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        LabelTip labelTip = new LabelTip(this.rb.getString("number"), true, "tipsTwig", "TWIGS", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.numberSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.numberSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.number, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("startAt"), true, "tipsTwig", "FIRST_TWIG_AT_BRANCH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.startAtSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.startAtSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.startAt, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("areaAtBranch"), true, "tipsTwig", "TWIG_AREA_AT_THE_BRANCH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.areaSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.areaSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.areaAtBranch, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("thickness"), true, "tipsTwig", "TWIG_THICKNESS_CHANGE", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.thicknessSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.thicknessSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.thicknessRatio, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("strength"), true, "tipsTwig", "TWIG_STRENGTH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.strengthSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.strengthSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.strength, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("taper"), true, "tipsTwig", "TWIG_TAPER", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.taperSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.taperSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.taper, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("tipEnd"), true, "tipsTwig", "TWIG_TIP", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.tipSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.tipSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.tipTF, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("straightToBranch"), true, "tipsTwig", "STRAIGHTEN_TOWARDS_BRANCH_END", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.straightSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.straightSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.straightenTowardsBranch, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("turn"), true, "tipsTwig", "TWIG_TURN_SWITCH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.turnSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.turnSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.turn, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("alternate"), true, "tipsTwig", "TWIG_ALTERNATE_SWITCH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.alternateSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.alternateSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.alternate, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.random.setUI(new ButtonUI());
        gradientPanel.add((Component)this.random, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gradientPanel.add((Component)this.randomness, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel.add((Component)gradientPanel, gridBagConstraints);
        this.tabPane.addTab(this.rb.getString("general"), jPanel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GradientPanel gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("angle"), true, "tipsTwig", "HORIZONTAL_TWIG_ANGLE", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.angleXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.angleXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.horizontalAngle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("angleScope"), true, "tipsTwig", "HORIZONTAL_TWIG_ANGLE_SCOPE", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.angleScopeXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.angleScopeXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.horizontalAngleScope, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("alignment"), true, "tipsTwig", "VERTICAL_TWIG_ALIGNMENT", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.alignmentXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.alignmentXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.horizontalAlignment, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel2, "Center");
        GradientPanel gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.rb.getString("horizontal"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("angle"), true, "tipsTwig", "VERTICAL_TWIG_ANGLE", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.angleYSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.angleYSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.verticalAngle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("angleScope"), true, "tipsTwig", "VERTICAL_TWIG_ANGLE_SCOPE", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.angleScopeYSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.angleScopeYSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.verticalAngleScope, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("alignment"), true, "tipsTwig", "VERTICAL_TWIG_ALIGNMENT", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.alignmentYSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.alignmentYSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.verticalAlignment, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("vertical"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("value"), true, "tipsTwig", "TWIG_CURVE_ADJUSTMENT", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.curveValueSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.curveValueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.curveValue, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("frequency"), true, "tipsTwig", "TWIG_CURVE_FREQUENCY_ADJUSTMENT", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.curveFreqSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.curveFreqSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.curveFrequency, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("curve"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.painter, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gradientPanel2 = new GradientPanel(25, 5);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = new JLabel(this.rb.getString("treeLatitude"));
        LabelUI labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel2.setUI(labelUI);
        gradientPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.twigRadialSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.twigRadialSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.twigRadial, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jLabel2 = new JLabel(this.rb.getString("treeLongitude"));
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel2.setUI(labelUI);
        gradientPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.twigVertSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.twigVertSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.twigVertical, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("treeMeshAccuracy"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.weightx = 0.5;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        this.tabPane.addTab(this.rb.getString("additional"), jPanel);
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.tabPane, gridBagConstraints);
    }

    public void paintElement() {
        block13: {
            if (this.povTree.getTree() == null) {
                return;
            }
            BlobArray blobArray = null;
            try {
                this.parameters = new Parameters(this.povTree.getTree());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, this.invalidNumber + " " + numberFormatException.getMessage(), this.rb.getString("error"), 0);
                return;
            }
            if (this.parameters.twigs >= 1.0f) {
                this.parameters.branches = 1.0f;
                this.parameters.twigs = 1.0f;
                this.tg = new TwigGenerator(this.parameters);
                try {
                    TripleBlobArray tripleBlobArray = this.tg.generate();
                    if (tripleBlobArray != null) {
                        DoubleBlobArray doubleBlobArray = tripleBlobArray.get(0);
                        if (doubleBlobArray != null) {
                            blobArray = doubleBlobArray.get(0);
                            if (blobArray != null) {
                                blobArray.rotateX(180.0f);
                                int n = this.getRadialAccuracy();
                                int n2 = this.getVerticalAccuracy();
                                if (n != 0 && n2 != 0) {
                                    this.painter.setElement(blobArray, n, n2);
                                }
                            } else {
                                this.painter.setElement(null, 0, 0);
                            }
                        } else {
                            this.painter.setElement(null, 0, 0);
                        }
                        break block13;
                    }
                    this.painter.setElement(null, 0, 0);
                }
                catch (Exception exception) {
                    this.painter.setElement(null, 0, 0);
                }
            } else {
                this.painter.setElement(null, 0, 0);
            }
        }
    }

    public void setNextFloat() {
        float f = this.r.nextFloat();
        String string = String.valueOf(f);
        if (string.length() > 6) {
            string = string.substring(0, 6);
        }
        this.randomness.setText(string);
    }

    public void setTwig(Twig twig) {
        this.number.setText(twig.number);
        Helper.setValue(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel);
        this.randomness.setText(twig.randomness);
        this.startAt.setText(twig.startAt);
        Helper.setValue(this.startAt, this.startAtSlider, this, this.invalidNumber, this.errorLabel);
        this.areaAtBranch.setText(twig.areaAtBranch);
        Helper.setValue(this.areaAtBranch, this.areaSlider, this, this.invalidNumber, this.errorLabel);
        this.thicknessRatio.setText(twig.thicknessRatio);
        Helper.setValue(this.thicknessRatio, this.thicknessSlider, this, this.invalidNumber, this.errorLabel);
        this.strength.setText(twig.strength);
        Helper.setValue(this.strength, this.strengthSlider, this, this.invalidNumber, this.errorLabel);
        this.horizontalAngle.setText(twig.horizontalAngle);
        Helper.setValue(this.horizontalAngle, this.angleXSlider, this, this.invalidNumber, this.errorLabel);
        this.horizontalAngleScope.setText(twig.horizontalAngleScope);
        Helper.setValue(this.horizontalAngleScope, this.angleScopeXSlider, this, this.invalidNumber, this.errorLabel);
        this.horizontalAlignment.setText(twig.horizontalAlignment);
        Helper.setValue(this.horizontalAlignment, this.alignmentXSlider, this, this.invalidNumber, this.errorLabel);
        this.verticalAngle.setText(twig.verticalAngle);
        Helper.setValue(this.verticalAngle, this.angleYSlider, this, this.invalidNumber, this.errorLabel);
        this.verticalAngleScope.setText(twig.verticalAngleScope);
        Helper.setValue(this.verticalAngleScope, this.angleScopeYSlider, this, this.invalidNumber, this.errorLabel);
        this.verticalAlignment.setText(twig.verticalAlignment);
        Helper.setValue(this.verticalAlignment, this.alignmentYSlider, this, this.invalidNumber, this.errorLabel);
        this.turn.setText(twig.turn);
        Helper.setValue(this.turn, this.turnSlider, this, this.invalidNumber, this.errorLabel);
        this.alternate.setText(twig.alternate);
        Helper.setValue(this.alternate, this.alternateSlider, this, this.invalidNumber, this.errorLabel);
        this.curveValue.setText(twig.curveValue);
        Helper.setValue(this.curveValue, this.curveValueSlider, this, this.invalidNumber, this.errorLabel);
        this.curveFrequency.setText(twig.curveFrequency);
        Helper.setValue(this.curveFrequency, this.curveFreqSlider, this, this.invalidNumber, this.errorLabel);
        this.taper.setText(twig.taper);
        Helper.setValue(this.taper, this.taperSlider, this, this.invalidNumber, this.errorLabel);
        this.tipTF.setText(twig.tip);
        this.straightenTowardsBranch.setText(twig.straightenTowardsBranch);
        Helper.setValue(this.straightenTowardsBranch, this.straightSlider, this, this.invalidNumber, this.errorLabel);
    }

    public Twig getTwig() {
        Twig twig = new Twig();
        twig.number = this.number.getText();
        twig.randomness = this.randomness.getText();
        twig.startAt = this.startAt.getText();
        twig.areaAtBranch = this.areaAtBranch.getText();
        twig.thicknessRatio = this.thicknessRatio.getText();
        twig.strength = this.strength.getText();
        twig.horizontalAngle = this.horizontalAngle.getText();
        twig.horizontalAngleScope = this.horizontalAngleScope.getText();
        twig.horizontalAlignment = this.horizontalAlignment.getText();
        twig.verticalAngle = this.verticalAngle.getText();
        twig.verticalAngleScope = this.verticalAngleScope.getText();
        twig.verticalAlignment = this.verticalAlignment.getText();
        twig.turn = this.turn.getText();
        twig.alternate = this.alternate.getText();
        twig.curveValue = this.curveValue.getText();
        twig.curveFrequency = this.curveFrequency.getText();
        twig.taper = this.taper.getText();
        twig.tip = this.tipTF.getText();
        twig.straightenTowardsBranch = this.straightenTowardsBranch.getText();
        return twig;
    }

    public int getRadialAccuracy() {
        int n = 0;
        String string = this.twigRadial.getText();
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + string, this.rb.getString("error"), 0);
        }
        return n;
    }

    public int getVerticalAccuracy() {
        int n = 0;
        String string = this.twigVertical.getText();
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + string, this.rb.getString("error"), 0);
        }
        return n;
    }
}

