/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import povtree.gui.Helper;

public class CheckBoxUI
extends MetalButtonUI {
    protected static CheckBoxUI buttonUI;
    private int radius = 6;
    private Color bg = null;
    private Color dark = null;
    private Color light = null;

    public static ComponentUI createUI(JComponent jComponent) {
        if (buttonUI == null) {
            buttonUI = new CheckBoxUI();
        }
        return buttonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 10));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        int n2;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Dimension dimension = jComponent.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = dimension.height;
        if (this.bg == null) {
            this.bg = jComponent.getBackground();
            this.dark = Helper.getDarker(this.bg, 30);
            this.light = Helper.getLighter(this.bg, 30);
        }
        graphics2D.setPaint(Helper.getDarker(this.bg, 100));
        graphics2D.fillRect(1, n3 / 2 - this.radius + 3, this.radius * 2 - 2, this.radius * 2 - 2);
        GradientPaint gradientPaint = jComponent.hasFocus() ? new GradientPaint(2.0f, n3 / 2 - this.radius + 4, Helper.getDarker(this.light, 15), 2.0f, n3 / 2 - this.radius + 4 + this.radius * 2 - 4, Helper.getDarker(this.dark, 15), false) : new GradientPaint(2.0f, n3 / 2 - this.radius + 4, this.light, 2.0f, n3 / 2 - this.radius + 4 + this.radius * 2 - 4, this.dark, false);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(2, n3 / 2 - this.radius + 4, this.radius * 2 - 4, this.radius * 2 - 4);
        if (buttonModel.isSelected()) {
            int n4;
            graphics2D.setColor(Color.black);
            int n5 = 5;
            int n6 = n5 + 1;
            int n7 = n6 + 4;
            n2 = n7 + 2;
            n = n6;
            int n8 = n5 - 2;
            int n9 = n3 / 2 - this.radius + 6;
            int n10 = n9 + 3;
            int n11 = n4 = n10 - 9;
            int n12 = n10 + 2;
            int n13 = n9;
            int[] nArray = new int[]{n5, n6, n7, n2, n, n8};
            int[] nArray2 = new int[]{n9, n10, n4, n11, n12, n13};
            graphics2D.fillPolygon(nArray, nArray2, 6);
        }
        if (abstractButton.getText() != null) {
            String string = abstractButton.getText();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            TextLayout textLayout = new TextLayout(string, jComponent.getFont(), fontRenderContext);
            n2 = (int)textLayout.getAscent();
            n = n3 / 2 + n2 / 2;
            graphics.setColor(Color.black);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            graphics.drawString(string, this.radius * 2 + 5, n);
        }
    }
}

