/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui.plaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import povtree.gui.plaf.GradientPanel;
import povtree.gui.plaf.LabelUI;
import povtree.gui.plaf.SliderUI;
import povtree.interfaces.Constants;

public class ColorChooser
extends JPanel
implements Constants,
ChangeListener {
    private int maxSliderValue = 100000;
    private JTextField redTextField = new JTextField(7);
    private JTextField greenTextField = new JTextField(7);
    private JTextField blueTextField = new JTextField(7);
    private JSlider redSlider = new JSlider(0, this.maxSliderValue, 0);
    private JSlider greenSlider = new JSlider(0, this.maxSliderValue, 0);
    private JSlider blueSlider = new JSlider(0, this.maxSliderValue, 0);
    private GradientPanel colorPanel = new GradientPanel(1, 1);
    private GradientPanel titlePanel = new GradientPanel(40, 20);
    private GradientPanel mainPanel = new GradientPanel(15, 5);
    private String errorMessage;
    private String errorLabel;

    public ColorChooser(String string, String string2, String string3, String string4, String string5, String string6) {
        super.setOpaque(false);
        this.errorMessage = string5;
        this.errorLabel = string6;
        this.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setGradientDirection(2);
        this.mainPanel.setRadius(0.0f);
        this.mainPanel.setRound(1);
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(string2);
        LabelUI labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel.setUI(labelUI);
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        SliderUI sliderUI = new SliderUI(this.redSlider);
        sliderUI.setLightColor(Color.white);
        sliderUI.setDarkColor(Color.red.darker());
        this.redSlider.setUI(sliderUI);
        this.redSlider.addChangeListener(this);
        this.mainPanel.add((Component)this.redSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.redTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.redTextField.getActionMap().put("check", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooser.this.setColor(ColorChooser.this.redTextField.getText(), ColorChooser.this.greenTextField.getText(), ColorChooser.this.blueTextField.getText());
            }
        });
        this.mainPanel.add((Component)this.redTextField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(string3);
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel.setUI(labelUI);
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        sliderUI = new SliderUI(this.greenSlider);
        sliderUI.setLightColor(Color.white);
        sliderUI.setDarkColor(Color.green.darker());
        this.greenSlider.setUI(sliderUI);
        this.greenSlider.addChangeListener(this);
        this.mainPanel.add((Component)this.greenSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.greenTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.greenTextField.getActionMap().put("check", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooser.this.setColor(ColorChooser.this.redTextField.getText(), ColorChooser.this.greenTextField.getText(), ColorChooser.this.blueTextField.getText());
            }
        });
        this.mainPanel.add((Component)this.greenTextField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(string4);
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel.setUI(labelUI);
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        sliderUI = new SliderUI(this.blueSlider);
        sliderUI.setLightColor(Color.white);
        sliderUI.setDarkColor(Color.blue.darker());
        this.blueSlider.setUI(sliderUI);
        this.blueSlider.addChangeListener(this);
        this.mainPanel.add((Component)this.blueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.blueTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.blueTextField.getActionMap().put("check", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooser.this.setColor(ColorChooser.this.redTextField.getText(), ColorChooser.this.greenTextField.getText(), ColorChooser.this.blueTextField.getText());
            }
        });
        this.mainPanel.add((Component)this.blueTextField, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
        this.titlePanel.setLayout(new GridBagLayout());
        this.titlePanel.setGradientDirection(2);
        this.titlePanel.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jLabel = new JLabel(string);
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gridBagConstraints.fill = 2;
        this.titlePanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        this.add((Component)this.titlePanel, "North");
        this.colorPanel.setLayout(new GridBagLayout());
        this.colorPanel.setRound(1);
        jLabel = new JLabel(" ");
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        this.colorPanel.add((Component)jLabel, gridBagConstraints);
        this.add((Component)this.colorPanel, "South");
    }

    public void setColor(String string, String string2, String string3) {
        try {
            float f = new Float(string).floatValue();
            float f2 = new Float(string2).floatValue();
            float f3 = new Float(string3).floatValue();
            if (f > 1.0f || f2 > 1.0f || f3 > 1.0f || f < 0.0f || f2 < 0.0f || f3 < 0.0f) {
                JOptionPane.showMessageDialog(this, this.errorMessage, this.errorLabel, 0);
            } else {
                if (string.length() == 0) {
                    this.redTextField.setText("0.0");
                } else {
                    this.redTextField.setText(string);
                }
                if (string2.length() == 0) {
                    this.greenTextField.setText("0.0");
                } else {
                    this.greenTextField.setText(string2);
                }
                if (string3.length() == 0) {
                    this.blueTextField.setText("0.0");
                } else {
                    this.blueTextField.setText(string3);
                }
                this.redSlider.setValue((int)(f * (float)this.maxSliderValue));
                this.greenSlider.setValue((int)(f2 * (float)this.maxSliderValue));
                this.blueSlider.setValue((int)(f3 * (float)this.maxSliderValue));
                this.paintPanel(this.makeColorFromSliders(this.redSlider.getValue(), this.greenSlider.getValue(), this.blueSlider.getValue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paintPanel(Color color) {
        this.colorPanel.setDarkColor(color);
        this.colorPanel.setLightColor(color);
        this.colorPanel.repaint();
    }

    public String getRed() {
        return this.redTextField.getText().trim();
    }

    public String getGreen() {
        return this.greenTextField.getText().trim();
    }

    public String getBlue() {
        return this.blueTextField.getText().trim();
    }

    public Color makeColorFromSliders(int n, int n2, int n3) {
        int n4 = (int)((float)n / (float)this.maxSliderValue * 255.0f);
        int n5 = (int)((float)n2 / (float)this.maxSliderValue * 255.0f);
        int n6 = (int)((float)n3 / (float)this.maxSliderValue * 255.0f);
        return new Color(n4, n5, n6);
    }

    public Color getColor() {
        return this.makeColorFromSliders(this.redSlider.getValue(), this.greenSlider.getValue(), this.blueSlider.getValue());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider.getValueIsAdjusting()) {
            int n = jSlider.getValue();
            if (jSlider == this.redSlider) {
                this.redTextField.setText(String.valueOf((float)n / (float)this.maxSliderValue));
            } else if (jSlider == this.greenSlider) {
                this.greenTextField.setText(String.valueOf((float)n / (float)this.maxSliderValue));
            } else if (jSlider == this.blueSlider) {
                this.blueTextField.setText(String.valueOf((float)n / (float)this.maxSliderValue));
            }
        }
        this.paintPanel(this.makeColorFromSliders(this.redSlider.getValue(), this.greenSlider.getValue(), this.blueSlider.getValue()));
    }

    public void setCompact(int n) {
        this.redSlider.setPreferredSize(new Dimension(n, 16));
        this.greenSlider.setPreferredSize(new Dimension(n, 16));
        this.blueSlider.setPreferredSize(new Dimension(n, 16));
    }

    public JTextField getRedTextField() {
        return this.greenTextField;
    }

    public JTextField getGreenTextField() {
        return this.greenTextField;
    }

    public JTextField getBlueTextField() {
        return this.blueTextField;
    }

    public JSlider getRedSlider() {
        return this.redSlider;
    }

    public JSlider getGreenSlider() {
        return this.greenSlider;
    }

    public JSlider getBlueSlider() {
        return this.blueSlider;
    }
}

