/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import povtree.gui.Helper;

public class GradientPanel
extends JPanel {
    private float radius = 10.0f;
    public static final int RIGHT_LEFT = 0;
    public static final int LEFT_RIGHT = 1;
    public static final int TOP_BOTTOM = 2;
    public static final int BOTTOM_TOP = 3;
    private int gradientDirection = 0;
    public static final int ROUND_TOP = 0;
    public static final int ROUND_BOTTOM = 1;
    public static final int ROUND_ALL = 2;
    private int round = 2;
    private int darkDegree;
    private int lightDegree;
    private boolean cyclicGradient = false;
    private Color dark = null;
    private Color light = null;

    public GradientPanel(int n, int n2) {
        super.setOpaque(false);
        this.darkDegree = n;
        this.lightDegree = n2;
        this.setBorder(BorderFactory.createEmptyBorder(0, (int)this.radius, 0, (int)this.radius));
    }

    public GradientPanel(int n) {
        super.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.round = n;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public void setGradientDirection(int n) {
        this.gradientDirection = n;
    }

    public boolean isOpaque() {
        return false;
    }

    public void setCyclicGradient(boolean bl) {
        this.cyclicGradient = bl;
    }

    public void setDarkColor(Color color) {
        this.dark = color;
    }

    public void setLightColor(Color color) {
        this.light = color;
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        Area area = null;
        boolean bl = false;
        if (this.radius >= (float)n2) {
            this.radius = n2;
            bl = false;
        } else {
            bl = true;
        }
        if (this.round == 0) {
            if (bl) {
                object = new RoundRectangle2D.Float(0.0f, 0.0f, n, n2, this.radius * 2.0f, this.radius * 2.0f);
                area = new Area((Shape)object);
                Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, (float)n2 / 2.0f, n, n2);
                Area area2 = new Area(float_);
                area.add(area2);
            } else {
                object = new RoundRectangle2D.Float(0.0f, 0.0f, n, (float)n2 * 2.0f, this.radius * 2.0f, this.radius * 2.0f);
                area = new Area((Shape)object);
                Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, n2, n, (float)n2 + this.radius * 2.0f);
                Area area3 = new Area(float_);
                area.subtract(area3);
            }
        } else if (this.round == 1) {
            if (bl) {
                object = new RoundRectangle2D.Float(0.0f, (float)n2 - this.radius * 2.0f, n, this.radius * 2.0f, this.radius * 2.0f, this.radius * 2.0f);
                area = new Area((Shape)object);
                Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, n, (float)n2 - this.radius);
                Area area4 = new Area(float_);
                area.add(area4);
            } else {
                object = new RoundRectangle2D.Float(0.0f, -this.radius, n, this.radius * 2.0f, this.radius * 2.0f, this.radius * 2.0f);
                area = new Area((Shape)object);
                Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, -this.radius * 3.0f, n, 0.0f);
                Area area5 = new Area(float_);
                area.subtract(area5);
            }
        } else if (this.round == 2) {
            if (bl) {
                object = new RoundRectangle2D.Float(0.0f, 0.0f, n, n2, this.radius * 2.0f, this.radius * 2.0f);
                area = new Area((Shape)object);
            } else {
                object = new RoundRectangle2D.Float(0.0f, 0.0f, n, n2, this.radius * 2.0f, this.radius * 2.0f);
                area = new Area((Shape)object);
            }
        }
        object = null;
        if (this.dark == null) {
            this.dark = Helper.getDarker(this.getBackground(), this.darkDegree);
        }
        if (this.light == null) {
            this.light = Helper.getDarker(this.getBackground(), this.lightDegree);
        }
        if (this.gradientDirection == 0) {
            if (this.cyclicGradient) {
                n /= 2;
            }
            object = new GradientPaint(0.0f, 0.0f, this.dark, n, 0.0f, this.light, this.cyclicGradient);
        } else if (this.gradientDirection == 1) {
            if (this.cyclicGradient) {
                n /= 2;
            }
            object = new GradientPaint(0.0f, 0.0f, this.light, n, 0.0f, this.dark, this.cyclicGradient);
        } else if (this.gradientDirection == 2) {
            if (this.cyclicGradient) {
                n2 /= 2;
            }
            object = new GradientPaint(0.0f, 0.0f, this.light, 0.0f, n2, this.dark, this.cyclicGradient);
        } else if (this.gradientDirection == 3) {
            if (this.cyclicGradient) {
                n2 /= 2;
            }
            object = new GradientPaint(0.0f, 0.0f, this.dark, 0.0f, n2, this.light, this.cyclicGradient);
        }
        graphics2D.setPaint((Paint)object);
        graphics2D.fill(area);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }
}

