/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLabelUI;
import povtree.gui.Helper;

public class LabelUI
extends MetalLabelUI {
    protected static LabelUI buttonUI;
    private boolean isMouseOver = false;
    private boolean isUnderlinable = true;
    private Color tr = null;
    private Color light = null;

    public static ComponentUI createUI(JComponent jComponent) {
        if (buttonUI == null) {
            buttonUI = new LabelUI();
        }
        return buttonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 10));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        jComponent.setOpaque(false);
        if (((JLabel)jComponent).getIcon() == null) {
            this.paintBody(graphics, jComponent);
            this.paintText(graphics, jComponent, jComponent.getBounds(), ((JLabel)jComponent).getText());
        } else {
            this.paintImage(graphics, jComponent);
            if (((JLabel)jComponent).getText() != null) {
                this.paintText(graphics, jComponent, jComponent.getBounds(), ((JLabel)jComponent).getText());
            }
        }
    }

    public void paintBody(Graphics graphics, JComponent jComponent) {
        Paint paint;
        Dimension dimension = jComponent.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.light == null) {
            paint = jComponent.getBackground();
            this.light = Helper.getLighter(paint, 20);
            this.tr = new Color(this.light.getRed(), this.light.getGreen(), this.light.getBlue(), 0);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        paint = new GradientPaint(0.0f, 0.0f, this.light, dimension.width - 10, 0.0f, this.tr, false);
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(0.0f, 3.0f, dimension.width, dimension.height - 6, 14.0f, 14.0f);
        graphics2D.setPaint(paint);
        graphics2D.fill(float_);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        if (string == null || string != null && string.length() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, jComponent.getFont(), fontRenderContext);
        int n = (int)textLayout.getAscent();
        int n2 = (int)textLayout.getBounds().getWidth();
        int n3 = 10;
        int n4 = (int)(jComponent.getBounds().getHeight() / 2.0 + (double)(n / 2) - 2.0);
        if (((JLabel)jComponent).getIcon() != null) {
            n3 = ((JLabel)jComponent).getIcon().getIconWidth() + 4;
        }
        graphics.setColor(Color.black);
        graphics.drawString(string, n3, n4);
        if (this.isUnderlinable && this.isMouseOver) {
            graphics.drawLine(10, n4 + 1, 10 + n2, n4 + 1);
        }
    }

    public void paintImage(Graphics graphics, JComponent jComponent) {
        Icon icon = ((JLabel)jComponent).getIcon();
        Dimension dimension = jComponent.getSize();
        int n = 0;
        int n2 = (dimension.height - icon.getIconHeight()) / 2;
        if (((JLabel)jComponent).getText() != null) {
            n = 2;
        }
        icon.paintIcon(jComponent, graphics, n, n2);
    }

    public void setIsUnderlinable(boolean bl) {
        this.isUnderlinable = bl;
        this.isMouseOver = false;
    }

    public boolean contains(JComponent jComponent, int n, int n2) {
        boolean bl = false;
        Dimension dimension = jComponent.getSize();
        Rectangle rectangle = new Rectangle((int)dimension.getWidth() - 10, (int)dimension.getHeight() - 12);
        if (this.isUnderlinable) {
            if (rectangle.contains(n - 10, n2 - 6)) {
                this.isMouseOver = true;
                jComponent.repaint();
                bl = true;
            } else {
                this.isMouseOver = false;
                jComponent.repaint();
                bl = false;
            }
        }
        return bl;
    }
}

