/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui.plaf;

import java.awt.Font;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import povtree.gui.Theme;

public class PovtreeLookAndFeel
extends MetalLookAndFeel {
    private ResourceBundle rb;
    private Theme theme;

    public PovtreeLookAndFeel(ResourceBundle resourceBundle, int[][] nArray) {
        this.rb = resourceBundle;
        this.theme = new Theme(nArray);
    }

    public String getID() {
        return "PovtreeLookAndFeel";
    }

    public String getName() {
        return "PovtreeLookAndFeel";
    }

    public String getDescription() {
        return "Custom look&feel for POV-Tree";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        Font font = new Font("Default", 0, 10);
        Font font2 = new Font("Default", 0, 12);
        UIManager.put("Panel.font", font2);
        UIManager.put("Label.font", font2);
        UIManager.put("Button.font", font2);
        UIManager.put("TextField.font", font2);
        UIManager.put("CheckBox.font", font2);
        UIManager.put("TabbedPane.font", font2);
        UIManager.put("ComboBox.font", font2);
        UIManager.put("Menu.font", font2);
        UIManager.put("MenuItem.font", font2);
        UIManager.put("RadioButton.font", font2);
        UIManager.put("List.font", font2);
        UIManager.put("TitledBorder.font", font);
        UIManager.put("TextArea.font", font2);
        UIManager.put("ToggleButton.font", font2);
        UIManager.put("Table.font", font);
        UIManager.put("ProgressBar.font", font2);
        UIManager.put("SliderUI", "povtree.gui.plaf.SliderUI");
        UIManager.put("ButtonUI", "povtree.gui.plaf.ButtonUI");
        UIManager.put("RadioButtonUI", "povtree.gui.plaf.RadioButtonUI");
        UIManager.put("CheckBoxUI", "povtree.gui.plaf.CheckBoxUI");
        UIManager.put("TextFieldUI", "povtree.gui.plaf.TextFieldUI");
        UIManager.put("TextField.background", this.theme.getSecondary3());
        UIManager.put("TextField.selectionBackground", this.theme.getSecondary2());
        UIManager.put("TextArea.selectionBackground", this.theme.getSecondary2());
        UIManager.put("RadioButton.background", this.theme.getSecondary1());
        UIManager.put("RadioButton.foreground", this.theme.getSecondary3());
        UIManager.put("FileChooser.lookInLabelText", this.rb.getString("lookInLabelText"));
        UIManager.put("FileChooser.saveInLabelText", this.rb.getString("saveInLabelText"));
        UIManager.put("FileChooser.fileNameLabelText", this.rb.getString("fileNameLabelText"));
        UIManager.put("FileChooser.filesOfTypeLabelText", this.rb.getString("filesOfTypeLabelText"));
        UIManager.put("FileChooser.upFolderToolTipText", this.rb.getString("upFolderToolTipText"));
        UIManager.put("FileChooser.upFolderAccessibleName", this.rb.getString("upFolderAccessibleName"));
        UIManager.put("FileChooser.homeFolderToolTipText", this.rb.getString("homeFolderToolTipText"));
        UIManager.put("FileChooser.newFolderToolTipText", this.rb.getString("newFolderToolTipText"));
        UIManager.put("FileChooser.newFolderAccessibleName", this.rb.getString("newFolderAccessibleName"));
        UIManager.put("FileChooser.listViewButtonToolTipText", this.rb.getString("listViewButtonToolTipText"));
        UIManager.put("FileChooser.listViewButtonAccessibleName", this.rb.getString("listViewButtonAccessibleName"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", this.rb.getString("detailsViewButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", this.rb.getString("detailsViewButtonAccessibleName"));
        UIManager.put("FileChooser.cancelButtonToolTipText", this.rb.getString("cancelButtonToolTipText"));
        UIManager.put("FileChooser.openButtonToolTipText", this.rb.getString("openButtonToolTipText"));
        UIManager.put("FileChooser.saveButtonToolTipText", this.rb.getString("saveButtonToolTipText"));
        UIManager.put("FileChooser.newFolderErrorText", this.rb.getString("newFolderErrorText"));
        UIManager.put("FileChooser.openDialogTitleText", this.rb.getString("openDialogTitleText"));
        UIManager.put("FileChooser.saveDialogTitleText", this.rb.getString("saveDialogTitleText"));
        UIManager.put("FileChooser.other.newFolder", this.rb.getString("other.newFolder"));
        UIManager.put("FileChooser.other.newFolder.subsequent", this.rb.getString("other.newFolder.subsequent"));
        UIManager.put("FileChooser.win32.newFolder", this.rb.getString("win32.newFolder"));
        UIManager.put("FileChooser.win32.newFolder.subsequent", this.rb.getString("win32.newFolder.subsequent"));
        UIManager.put("FileChooser.cancelButtonText", this.rb.getString("cancelButtonText"));
        UIManager.put("FileChooser.directoryOpenButtonText", this.rb.getString("directoryOpenButtonText"));
        UIManager.put("FileChooser.helpButtonText", this.rb.getString("helpButtonText"));
        UIManager.put("FileChooser.openButtonText", this.rb.getString("openButtonText"));
        UIManager.put("FileChooser.saveButtonText", this.rb.getString("saveButtonText"));
        UIManager.put("FileChooser.fileNameHeaderText", this.rb.getString("treeName"));
        UIManager.put("FileChooser.fileSizeHeaderText", this.rb.getString("size"));
        UIManager.put("FileChooser.fileTypeHeaderText", this.rb.getString("type"));
        UIManager.put("FileChooser.fileDateHeaderText", this.rb.getString("modified"));
        UIManager.put("FileChooser.fileAttrHeaderText", this.rb.getString("attributes"));
        UIManager.put("OptionPane.yesButtonText", this.rb.getString("yesButtonText"));
        UIManager.put("OptionPane.noButtonText", this.rb.getString("noButtonText"));
        UIManager.put("OptionPane.cancelButtonText", this.rb.getString("cancel"));
        UIManager.put("OptionPane.okButtonText", this.rb.getString("okButtonText"));
        UIManager.put("OptionPane.errorIcon", new IconUIResource(new ImageIcon(this.getClass().getResource("icons/error.png"))));
        UIManager.put("OptionPane.informationIcon", new IconUIResource(new ImageIcon(this.getClass().getResource("icons/inform.png"))));
        UIManager.put("OptionPane.warningIcon", new IconUIResource(new ImageIcon(this.getClass().getResource("icons/warn.png"))));
        UIManager.put("OptionPane.questionIcon", new IconUIResource(new ImageIcon(this.getClass().getResource("icons/question.png"))));
        UIManager.put("Tree.collapsedIcon", new IconUIResource(new ImageIcon(this.getClass().getResource("icons/collapsedIcon.png"))));
        UIManager.put("Tree.expandedIcon", new IconUIResource(new ImageIcon(this.getClass().getResource("icons/expandedIcon.png"))));
        UIManager.put("Tree.leafIcon", new IconUIResource(new ImageIcon(this.getClass().getResource("icons/leafIcon.png"))));
        UIManager.put("Tree.closedIcon", new IconUIResource(new ImageIcon(this.getClass().getResource("icons/leafIcon.png"))));
        UIManager.put("Tree.openIcon", new IconUIResource(new ImageIcon(this.getClass().getResource("icons/leafIcon.png"))));
        MetalLookAndFeel.setCurrentTheme(this.theme);
    }
}

