/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui.plaf;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalProgressBarUI;
import povtree.gui.Helper;

public class ProgressBarUI
extends MetalProgressBarUI {
    private int radius = 4;
    private Color dark;
    private Color light;
    private Color bgr;

    public static ComponentUI createUI(JComponent jComponent) {
        return new ProgressBarUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(BorderFactory.createEmptyBorder(this.radius, this.radius * 2, this.radius, this.radius * 2));
        jComponent.setOpaque(false);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        int n3 = ((JProgressBar)jComponent).getValue();
        float f = (float)n / (float)((JProgressBar)jComponent).getMaximum();
        int n4 = (int)(f * (float)n3);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Paint paint = graphics2D.getPaint();
        this.bgr = jComponent.getBackground();
        this.dark = Helper.getDarker(this.bgr, 100);
        this.light = Helper.getLighter(this.bgr, 50);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.dark, 0.0f, n2, this.light, false);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRoundRect(0, 0, n, n2, n2 - this.radius, n2 - this.radius);
        this.dark = Helper.getDarker(this.bgr, 40);
        this.light = Helper.getLighter(this.bgr, 45);
        gradientPaint = new GradientPaint(0.0f, 0.0f, this.light, 0.0f, n2, this.dark, false);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRoundRect(2, 2, n - this.radius, n2 - this.radius, n2 - (this.radius + 2), n2 - (this.radius + 2));
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(2.0f, 2.0f, n - this.radius, n2 - this.radius, n2 - (this.radius + 2), n2 - (this.radius + 2));
        Area area = new Area(float_);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(n4, -1.0f, (float)n + 1.0f, (float)n2 + 1.0f);
        Area area2 = new Area(float_2);
        area.subtract(area2);
        gradientPaint = new GradientPaint(0.0f, 0.0f, this.dark.darker(), 0.0f, n2 / 2, jComponent.getBackground(), true);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(area);
        String string = ((JProgressBar)jComponent).getString();
        if (string != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics2D.setColor(Color.black);
            int n5 = n / 2 - (int)fontMetrics.getStringBounds(string, graphics2D).getWidth() / 2;
            int n6 = n2 - (int)fontMetrics.getStringBounds(string, graphics2D).getHeight() / 2 - 1;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            graphics2D.drawString(string, n5, n6);
        }
        graphics2D.setPaint(paint);
    }
}

