/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import povtree.gui.Helper;

public class RadioButtonUI
extends MetalButtonUI {
    protected static RadioButtonUI buttonUI;
    private int radius = 6;
    private Color bg = null;
    private Color darkBackground = null;
    private Color lightBackground = null;
    private Color darkForeground = null;
    private Color lightForeground = null;

    public static ComponentUI createUI(JComponent jComponent) {
        if (buttonUI == null) {
            buttonUI = new RadioButtonUI();
        }
        return buttonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 10));
        if (this.bg == null) {
            this.bg = jComponent.getBackground();
            this.darkBackground = Helper.getDarker(this.bg, 140);
            this.lightBackground = Helper.getLighter(this.bg, 50);
            this.darkForeground = Helper.getDarker(this.bg, 60);
            this.lightForeground = Helper.getLighter(this.bg, 50);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Dimension dimension = jComponent.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = dimension.height;
        GradientPaint gradientPaint = new GradientPaint(0.0f, n / 2 - this.radius - 1, this.darkBackground, 0.0f, n / 2 + this.radius + 1, this.lightBackground, false);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillOval(1, n / 2 - this.radius, this.radius * 2 + 2, this.radius * 2 + 2);
        gradientPaint = jComponent.hasFocus() ? new GradientPaint(2.0f, n / 2 - this.radius + 1, Helper.getDarker(this.lightForeground, 20), 2.0f, n / 2 + this.radius - 1, Helper.getDarker(this.darkForeground, 20), false) : new GradientPaint(2.0f, n / 2 - this.radius + 1, this.lightForeground, 2.0f, n / 2 + this.radius - 1, this.darkForeground, false);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillOval(2, n / 2 - this.radius + 1, this.radius * 2, this.radius * 2);
        if (buttonModel.isSelected()) {
            gradientPaint = new GradientPaint(4.0f, n / 2 - this.radius + 3, this.darkForeground, 4.0f, n / 2 - this.radius + 3 + 6, this.lightForeground, false);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillOval(4, n / 2 - this.radius + 3, this.radius * 2 - 4, this.radius * 2 - 4);
        }
        if (abstractButton.getText() != null) {
            String string = abstractButton.getText();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            TextLayout textLayout = new TextLayout(string, jComponent.getFont(), fontRenderContext);
            int n2 = (int)textLayout.getAscent();
            int n3 = n / 2 + n2 / 2 - 2;
            graphics.setColor(Color.black);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.drawString(string, this.radius * 2 + 5, n3 + 1);
        }
    }
}

