/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import povtree.gui.Helper;

public class SliderUI
extends BasicSliderUI {
    private int thumbRadius = 6;
    private boolean compact = false;
    private Color brightColor = null;
    private Color darkColor = null;
    private Color lightTrackColor = null;
    private Color bgrColor = null;

    public SliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public void setLightColor(Color color) {
        this.brightColor = color;
    }

    public void setDarkColor(Color color) {
        this.darkColor = color;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SliderUI((JSlider)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.bgrColor = jComponent.getBackground();
        if (this.darkColor == null) {
            this.darkColor = Helper.getDarker(jComponent.getBackground(), 100);
        }
        if (this.brightColor == null) {
            this.brightColor = Helper.getLighter(jComponent.getBackground(), 50);
        }
        this.lightTrackColor = Helper.getLighter(jComponent.getBackground(), 35);
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, this.thumbRadius * 2, 0, this.thumbRadius * 2));
        jComponent.setOpaque(false);
        ((JSlider)jComponent).setPaintTicks(false);
        ((JSlider)jComponent).setPaintLabels(false);
        if (this.compact) {
            jComponent.setPreferredSize(new Dimension(90, jComponent.getPreferredSize().height));
        }
    }

    public Dimension getThumbSize() {
        return new Dimension(this.thumbRadius * 2 + 1, this.thumbRadius * 2 + 1);
    }

    public void paintThumb(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle rectangle = this.thumbRect;
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.brightColor, 0.0f, this.thumbRadius * 2, this.darkColor, false);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillOval(rectangle.x, rectangle.y, this.thumbRadius * 2, this.thumbRadius * 2);
        if (this.slider.hasFocus()) {
            gradientPaint = new GradientPaint(0.0f, 0.0f, this.darkColor, 0.0f, this.thumbRadius * 2, this.brightColor, false);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillOval(rectangle.x + 2, rectangle.y + 2, this.thumbRadius * 2 - 4, this.thumbRadius * 2 - 4);
        }
    }

    public void paintFocus(Graphics graphics) {
    }

    public void paintTrack(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2, this.trackRect.x + this.trackRect.width, this.trackRect.y + this.trackRect.height / 2);
        graphics.setColor(Helper.getDarker(this.bgrColor, 65));
        graphics.drawLine(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2 - 1, this.trackRect.x + this.trackRect.width, this.trackRect.y + this.trackRect.height / 2 - 1);
        graphics.setColor(Helper.getDarker(this.bgrColor, 35));
        graphics.drawLine(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2 - 2, this.trackRect.x + this.trackRect.width, this.trackRect.y + this.trackRect.height / 2 - 2);
        graphics.setColor(this.lightTrackColor);
        graphics.drawLine(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2 + 1, this.trackRect.x + this.trackRect.width, this.trackRect.y + this.trackRect.height / 2 + 1);
        graphics.setColor(Helper.getDarker(this.lightTrackColor, 20));
        graphics.drawLine(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2 + 2, this.trackRect.x + this.trackRect.width, this.trackRect.y + this.trackRect.height / 2 + 2);
        graphics.setColor(Helper.getDarker(this.lightTrackColor, 35));
        graphics.drawLine(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2 + 3, this.trackRect.x + this.trackRect.width, this.trackRect.y + this.trackRect.height / 2 + 3);
    }
}

