/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTextFieldUI;
import javax.swing.text.JTextComponent;
import povtree.gui.Helper;

public class TextFieldUI
extends MetalTextFieldUI {
    private static int insetBorderY = 2;
    private static int insetBorderX = 5;
    private static int radius = 6;
    private Color lightColor;
    private Color darkColor;
    private static Color outlineColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new TextFieldUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        outlineColor = jComponent.getBackground().darker().darker();
        jComponent.setBorder(new TextFieldBorder());
        jComponent.setOpaque(false);
    }

    protected void paintSafely(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        JTextComponent jTextComponent = this.getComponent();
        graphics2D.setColor(jTextComponent.getBackground());
        this.darkColor = jTextComponent.getBackground();
        this.lightColor = Helper.getLighter(jTextComponent.getBackground(), 40);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.lightColor, 0.0f, jTextComponent.getHeight() / 2, this.darkColor, true);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRoundRect(0, 0, jTextComponent.getWidth() - 1, jTextComponent.getHeight() - 1, radius * 2, radius * 2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setColor(Color.black);
        super.paintSafely(graphics);
    }

    private static class TextFieldBorder
    extends AbstractBorder {
        private TextFieldBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics.getColor();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(outlineColor);
            graphics2D.drawRoundRect(n, n2, n3 - 1, n4 - 1, radius * 2, radius * 2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(insetBorderY, insetBorderX, insetBorderY, insetBorderX);
        }
    }
}

