/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import povtree.gui.Helper;
import povtree.gui.plaf.ButtonUI;

public class ToggleIconUI
extends MetalButtonUI {
    protected static ButtonUI buttonUI;
    private int buttonWidth;
    private int buttonHeight;
    private int textWidth;
    private int textHeight;
    private Color dark;
    private Color light;
    private Color bgr;
    private int radius = 4;

    public static ComponentUI createUI(JComponent jComponent) {
        ((JToggleButton)jComponent).setBorderPainted(false);
        if (buttonUI == null) {
            buttonUI = new ButtonUI();
        }
        return buttonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(BorderFactory.createEmptyBorder(this.radius, this.radius * 2, this.radius, this.radius * 2));
        jComponent.setOpaque(false);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        if (jComponent.hasFocus()) {
            this.paintBody(graphics, jComponent, true);
        } else {
            this.paintBody(graphics, jComponent, false);
        }
        if (buttonModel.isRollover() || buttonModel.isSelected()) {
            this.paintFocus(graphics, abstractButton, null, null, null);
        }
        if (abstractButton.getIcon() == null) {
            this.paintText(graphics, jComponent, jComponent.getBounds(), ((AbstractButton)jComponent).getText());
        } else {
            this.paintImage(graphics, abstractButton);
        }
    }

    public void paintBody(Graphics graphics, JComponent jComponent, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = jComponent.getSize();
        GradientPaint gradientPaint = null;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.buttonWidth = dimension.width;
        this.buttonHeight = dimension.height;
        Paint paint = graphics2D.getPaint();
        this.bgr = jComponent.getBackground();
        this.dark = Helper.getDarker(this.bgr, 100);
        graphics2D.setPaint(this.dark);
        graphics2D.fillRoundRect(0, 0, this.buttonWidth, this.buttonHeight, this.radius * 2, this.radius * 2);
        if (bl) {
            this.dark = Helper.getDarker(this.bgr, 45);
            this.light = Helper.getLighter(this.bgr, 45);
            gradientPaint = new GradientPaint(0.0f, 0.0f, this.light, 0.0f, this.buttonHeight, this.dark, false);
        } else {
            this.dark = Helper.getDarker(this.bgr, 10);
            this.light = Helper.getLighter(this.bgr, 20);
            gradientPaint = new GradientPaint(0.0f, 0.0f, this.light, 0.0f, this.buttonHeight, this.dark, false);
        }
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRoundRect(1, 1, this.buttonWidth - 2, this.buttonHeight - 2, (this.radius - 1) * 2, (this.radius - 1) * 2);
        graphics2D.setPaint(paint);
    }

    public void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        if (string == null || string != null && string.length() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, jComponent.getFont(), fontRenderContext);
        this.textWidth = (int)textLayout.getBounds().getWidth();
        this.textHeight = (int)textLayout.getAscent();
        int n = (int)(jComponent.getBounds().getWidth() - (double)this.textWidth) / 2;
        int n2 = this.buttonHeight / 2 + this.textHeight / 2 - 2;
        if (jComponent.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(jComponent.getBackground().darker());
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics.drawString(string, n, n2);
    }

    public void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = abstractButton.getSize();
        GradientPaint gradientPaint = null;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.buttonWidth = dimension.width;
        this.buttonHeight = dimension.height;
        Paint paint = graphics2D.getPaint();
        this.dark = Helper.getDarker(this.bgr, 45);
        this.light = Helper.getLighter(this.bgr, 45);
        gradientPaint = new GradientPaint(0.0f, 0.0f, this.dark, 0.0f, this.buttonHeight - 4, this.light, false);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRoundRect(2, 2, this.buttonWidth - 4, this.buttonHeight - 4, (this.radius - 1) * 2, (this.radius - 1) * 2);
        graphics2D.setPaint(paint);
    }

    public void paintImage(Graphics graphics, AbstractButton abstractButton) {
        Icon icon;
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isPressed() || buttonModel.isRollover() || buttonModel.isSelected()) {
            icon = abstractButton.getRolloverIcon();
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
        } else {
            icon = abstractButton.getIcon();
        }
        Dimension dimension = abstractButton.getSize();
        int n = (dimension.width - icon.getIconWidth()) / 2;
        int n2 = (dimension.height - icon.getIconHeight()) / 2;
        icon.paintIcon(abstractButton, graphics, n, n2);
    }
}

