/*
 * Decompiled with CFR 0.152.
 */
package povtree.objects;

import java.util.ArrayList;
import povtree.interfaces.Constants;
import povtree.interfaces.Names;
import povtree.objects3D.Leaf1;
import povtree.objects3D.Leaf10;
import povtree.objects3D.Leaf12a;
import povtree.objects3D.Leaf12b;
import povtree.objects3D.Leaf24;
import povtree.objects3D.Leaf3;
import povtree.objects3D.Leaf4;
import povtree.objects3D.Leaf4a;
import povtree.objects3D.Leaf6a;
import povtree.objects3D.Leaf6b;
import povtree.objects3D.LeafMesh;
import povtree.objects3D.LeafUv1;
import povtree.objects3D.LeafUv10;
import povtree.objects3D.LeafUv11;
import povtree.objects3D.LeafUv12;
import povtree.objects3D.LeafUv2;
import povtree.objects3D.LeafUv3;
import povtree.objects3D.LeafUv4;
import povtree.objects3D.LeafUv5;
import povtree.objects3D.LeafUv6;
import povtree.objects3D.LeafUv7;
import povtree.objects3D.LeafUv8;
import povtree.objects3D.LeafUv9;
import povtree.objects3D.TableLeaf;

public class Foliage
implements Names,
Constants {
    public boolean withFoliage = true;
    public String number;
    public String type;
    public String length;
    public String breadth;
    public String height;
    public String maxTilt;
    public String maxTurn;
    public String inclination;
    public String inclinationScope;
    public String turbulence;
    public String transition;
    public String transitionTurbulence;
    public String gloss;
    public String bottomR1;
    public String bottomG1;
    public String bottomB1;
    public String bottomR2;
    public String bottomG2;
    public String bottomB2;
    public String topR1;
    public String topG1;
    public String topB1;
    public String topR2;
    public String topG2;
    public String topB2;
    public String customMesh;
    public String filter;
    public String transparency;
    public String leafArrayDeclaration;
    public ArrayList leafArrayElements;

    public String toString() {
        Object object;
        String string = "//FOLIAGE" + Constants.EOL;
        string = string + "#include \"TOMLEAF.inc\"" + Constants.EOL;
        if (this.type == null) {
            this.type = "\"NONE\"";
        }
        if (this.type.startsWith("Mesh")) {
            if (this.type.equals("Mesh1")) {
                object = new Leaf1();
                string = string + ((LeafMesh)object).toString();
            } else if (this.type.equals("Mesh3")) {
                object = new Leaf3();
                string = string + ((LeafMesh)object).toString();
            } else if (this.type.equals("Mesh4")) {
                object = new Leaf4();
                string = string + ((LeafMesh)object).toString();
            } else if (this.type.equals("Mesh4a")) {
                object = new Leaf4a();
                string = string + ((LeafMesh)object).toString();
            } else if (this.type.equals("Mesh6a")) {
                object = new Leaf6a();
                string = string + ((LeafMesh)object).toString();
            } else if (this.type.equals("Mesh6b")) {
                object = new Leaf6b();
                string = string + ((LeafMesh)object).toString();
            } else if (this.type.equals("Mesh10")) {
                object = new Leaf10();
                string = string + ((LeafMesh)object).toString();
            } else if (this.type.equals("Mesh12a")) {
                object = new Leaf12a();
                string = string + ((LeafMesh)object).toString();
            } else if (this.type.equals("Mesh12b")) {
                object = new Leaf12b();
                string = string + ((LeafMesh)object).toString();
            } else if (this.type.equals("Mesh24")) {
                object = new Leaf24();
                string = string + ((LeafMesh)object).toString();
            }
        } else if (this.type.startsWith("CustomMesh") && this.customMesh != null && this.customMesh.length() != 0) {
            string = string + "#declare CustomMesh = mesh {" + Constants.EOL + this.customMesh + Constants.EOL + "};" + Constants.EOL;
        }
        string = this.type.startsWith("LeafUv") ? string + "#declare LEAF_TYPE=\"" + this.type + "\";" + Constants.EOL : string + "#declare LEAF_TYPE=" + this.type + ";" + Constants.EOL;
        string = string + "#declare LEAVES=" + this.number + "*BUNCHES;" + Constants.EOL;
        string = string + "#declare LEAF_LENGTH=" + this.length + ";" + Constants.EOL;
        string = string + "#declare LEAF_BREADTH=" + this.breadth + ";" + Constants.EOL;
        string = string + "#declare LEAF_HEIGHT=" + this.height + ";" + Constants.EOL;
        string = string + "#declare MAX_LEAF_TILT=" + this.maxTilt + ";" + Constants.EOL;
        string = string + "#declare MAX_LEAF_TURN=" + this.maxTurn + ";" + Constants.EOL;
        string = string + "#declare LEAF_INCLINATION=" + this.inclination + ";" + Constants.EOL;
        string = string + "#declare LEAF_INCLINATION_SCOPE=" + this.inclinationScope + ";" + Constants.EOL;
        object = "";
        if (this.filter != null && this.filter.length() != 0) {
            object = this.transparency != null && this.transparency.length() != 0 ? ", " + this.filter + ", " + this.transparency : ", " + this.filter;
        } else if (this.transparency != null && this.transparency.length() != 0) {
            object = ", 0, " + this.transparency;
        }
        string = string + "#declare BOTTOM_COLOR_1=<" + this.bottomR1 + ", " + this.bottomG1 + ", " + this.bottomB1 + (String)object + ">;" + Constants.EOL;
        string = string + "#declare BOTTOM_COLOR_2=<" + this.bottomR2 + ", " + this.bottomG2 + ", " + this.bottomB2 + (String)object + ">;" + Constants.EOL;
        string = string + "#declare TOP_COLOR_1=<" + this.topR1 + ", " + this.topG1 + ", " + this.topB1 + (String)object + ">;" + Constants.EOL;
        string = string + "#declare TOP_COLOR_2=<" + this.topR2 + ", " + this.topG2 + ", " + this.topB2 + (String)object + ">;" + Constants.EOL;
        string = string + "#declare COLOR_TURB=" + this.turbulence + ";" + Constants.EOL;
        string = string + "#declare TRANSITION_BOTTOM_TOP=" + this.transition + ";" + Constants.EOL;
        string = string + "#declare TRANSITION_TURB=" + this.transitionTurbulence + ";" + Constants.EOL;
        string = string + "#declare FOLIAGE_GLOSS=" + this.gloss + ";" + Constants.EOL;
        if (this.filter != null && this.filter.length() != 0) {
            string = string + "#declare FOLIAGE_FILTER=" + this.filter + ";" + Constants.EOL;
        }
        if (this.transparency != null && this.transparency.length() != 0) {
            string = string + "#declare FOLIAGE_TRANSPARENCY=" + this.transparency + ";" + Constants.EOL;
        }
        if (this.type.startsWith("LeafUv")) {
            string = string + this.leafArrayDeclaration + Constants.EOL;
            String string2 = null;
            String string3 = null;
            LeafMesh leafMesh = null;
            int n = 0;
            while (n < this.leafArrayElements.size()) {
                TableLeaf tableLeaf = (TableLeaf)this.leafArrayElements.get(n);
                string3 = tableLeaf.getLeafUvName();
                if (string3.equals("LeafUv1")) {
                    leafMesh = new LeafUv1();
                } else if (string3.equals("LeafUv2")) {
                    leafMesh = new LeafUv2();
                } else if (string3.equals("LeafUv3")) {
                    leafMesh = new LeafUv3();
                } else if (string3.equals("LeafUv4")) {
                    leafMesh = new LeafUv4();
                } else if (string3.equals("LeafUv5")) {
                    leafMesh = new LeafUv5();
                } else if (string3.equals("LeafUv6")) {
                    leafMesh = new LeafUv6();
                } else if (string3.equals("LeafUv7")) {
                    leafMesh = new LeafUv7();
                } else if (string3.equals("LeafUv8")) {
                    leafMesh = new LeafUv8();
                } else if (string3.equals("LeafUv9")) {
                    leafMesh = new LeafUv9();
                } else if (string3.equals("LeafUv10")) {
                    leafMesh = new LeafUv10();
                } else if (string3.equals("LeafUv11")) {
                    leafMesh = new LeafUv11();
                } else if (string3.equals("LeafUv12")) {
                    leafMesh = new LeafUv12();
                }
                if (tableLeaf.getLatitudinal() != null) {
                    leafMesh.setLatitudinal(tableLeaf.getLatitudinal());
                }
                if (tableLeaf.getLongitudinal() != null) {
                    leafMesh.setLongitudinal(tableLeaf.getLongitudinal());
                }
                leafMesh.buildLeaf();
                string = string + "#declare LeafArray[" + n + "] = mesh {" + Constants.EOL;
                string = string + leafMesh.toStringUv();
                string = string + "texture {" + Constants.EOL + "pigment{uv_mapping" + Constants.EOL + "image_map{" + tableLeaf.getImageType() + " \"" + tableLeaf.getImageName() + "\"" + " map_type 0} rotate z*90}" + Constants.EOL;
                if (tableLeaf.getBumpType() != null) {
                    string3 = tableLeaf.getBumpType().trim();
                    if (tableLeaf.getBumpName() != null) {
                        string2 = tableLeaf.getBumpName().trim();
                        string = string + "normal{bump_map{" + string3 + " \"" + string2 + "\" " + "map_type 0}";
                        if (tableLeaf.getBumpSize() != null) {
                            string = string + " bump_size " + tableLeaf.getBumpSize();
                        }
                        string = string + "}" + Constants.EOL;
                    }
                }
                string = string + "finish {diffuse 0.8} translate -z*0.5}};" + Constants.EOL;
                ++n;
            }
        }
        return string;
    }

    public Object clone() {
        Foliage foliage = new Foliage();
        foliage.number = this.number;
        foliage.type = this.type;
        foliage.length = this.length;
        foliage.breadth = this.breadth;
        foliage.height = this.height;
        foliage.maxTilt = this.maxTilt;
        foliage.maxTurn = this.maxTurn;
        foliage.inclination = this.inclination;
        foliage.inclinationScope = this.inclinationScope;
        foliage.turbulence = this.turbulence;
        foliage.transition = this.transition;
        foliage.transitionTurbulence = this.transitionTurbulence;
        foliage.gloss = this.gloss;
        foliage.bottomR1 = this.bottomR1;
        foliage.bottomG1 = this.bottomG1;
        foliage.bottomB1 = this.bottomB1;
        foliage.bottomR2 = this.bottomR2;
        foliage.bottomG2 = this.bottomG2;
        foliage.bottomB2 = this.bottomB2;
        foliage.topR1 = this.topR1;
        foliage.topG1 = this.topG1;
        foliage.topB1 = this.topB1;
        foliage.topR2 = this.topR2;
        foliage.topG2 = this.topG2;
        foliage.topB2 = this.topB2;
        foliage.customMesh = this.customMesh;
        foliage.filter = this.filter;
        foliage.transparency = this.transparency;
        foliage.leafArrayDeclaration = this.leafArrayDeclaration;
        if (this.leafArrayElements != null) {
            foliage.leafArrayElements = (ArrayList)this.leafArrayElements.clone();
        }
        return foliage;
    }
}

