/*
 * Decompiled with CFR 0.152.
 */
package povtree.objects3D;

import povtree.interfaces.Constants;
import povtree.interfaces.Transformable;
import povtree.objects3D.Coordinate;

public class Blob
implements Comparable,
Transformable {
    public Coordinate center;
    public float radius;
    public float strength;
    public boolean leaf = false;
    public boolean blossom = false;
    public boolean show = false;

    public Blob() {
        this.center = new Coordinate();
        this.radius = 1.0f;
        this.strength = 1.0f;
    }

    public Blob(Coordinate coordinate) {
        this.center = coordinate;
        this.radius = 1.0f;
        this.strength = 1.0f;
    }

    public Blob(Coordinate coordinate, float f, float f2) {
        this.center = coordinate;
        this.radius = f;
        this.strength = f2;
    }

    public Blob(Coordinate coordinate, float f, float f2, boolean bl) {
        this.center = coordinate;
        this.radius = f;
        this.strength = f2;
        this.leaf = bl;
    }

    public Blob(Coordinate coordinate, float f, float f2, boolean bl, boolean bl2) {
        this.center = coordinate;
        this.radius = f;
        this.strength = f2;
        this.leaf = bl;
        this.blossom = bl2;
    }

    public Blob(float f, float f2) {
        this.center = new Coordinate();
        this.radius = f;
        this.strength = f2;
    }

    public Blob(float f, float f2, float f3, float f4, float f5) {
        this.center = new Coordinate();
        this.center.x = f;
        this.center.y = f2;
        this.center.z = f3;
        this.radius = f4;
        this.strength = f5;
    }

    public void translate(float f, float f2, float f3) {
        this.center.translate(f, f2, f3);
    }

    public void scale(float f) {
        this.center.scale(f);
        this.radius *= f;
    }

    public void scale(float f, float f2, float f3) {
        this.center.scaleX(f);
        this.center.scaleY(f2);
        this.center.scaleZ(f3);
        this.radius *= f;
    }

    public void rotateX(float f) {
        this.center.rotateX(f);
    }

    public void rotateY(float f) {
        this.center.rotateY(f);
    }

    public void rotateZ(float f) {
        this.center.rotateZ(f);
    }

    public void rotate(float f, float f2, float f3) {
        this.center.rotateX(f);
        this.center.rotateY(f2);
        this.center.rotateZ(f3);
    }

    public void mirrorX() {
        this.center.x = -this.center.x;
    }

    public void mirrorY() {
        this.center.y = -this.center.y;
    }

    public void mirrorZ() {
        this.center.z = -this.center.z;
    }

    public Object clone() {
        Coordinate coordinate = (Coordinate)this.center.clone();
        return new Blob(coordinate, this.radius, this.strength, this.leaf, this.blossom);
    }

    public int compareTo(Object object) {
        float f = this.center.z;
        float f2 = ((Blob)object).center.z;
        if (f > f2) {
            return 1;
        }
        if (f < f2) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        String string = "x = " + this.center.x + Constants.EOL;
        string = string + "y = " + this.center.y + Constants.EOL;
        string = string + "z = " + this.center.z + Constants.EOL;
        string = string + "r = " + this.radius + Constants.EOL;
        return string;
    }
}

