/*
 * Decompiled with CFR 0.152.
 */
package povtree.objects3D;

import java.util.ArrayList;
import povtree.interfaces.Transformable;
import povtree.objects3D.Blob;

public class BlobArray
implements Cloneable,
Transformable {
    private ArrayList blobs = null;

    public BlobArray() {
        this.blobs = new ArrayList();
    }

    public BlobArray(int n) {
        this.blobs = new ArrayList(n);
    }

    public void add(Blob blob) {
        this.blobs.add(blob);
    }

    public ArrayList get() {
        return this.blobs;
    }

    public Blob get(int n) {
        return (Blob)this.blobs.get(n);
    }

    public int size() {
        return this.blobs.size();
    }

    public void remove(int n) {
        this.blobs.remove(n);
    }

    public void trimToSize() {
        this.blobs.trimToSize();
    }

    public void clear() {
        this.blobs.clear();
    }

    public void translate(float f, float f2, float f3) {
        int n = 0;
        while (n < this.blobs.size()) {
            Blob blob = (Blob)this.blobs.get(n);
            blob.translate(f, f2, f3);
            ++n;
        }
    }

    public void scale(float f) {
        int n = 0;
        while (n < this.blobs.size()) {
            Blob blob = (Blob)this.blobs.get(n);
            blob.scale(f);
            ++n;
        }
    }

    public void scale(float f, float f2, float f3) {
        int n = 0;
        while (n < this.blobs.size()) {
            Blob blob = (Blob)this.blobs.get(n);
            blob.scale(f, f2, f3);
            ++n;
        }
    }

    public void rotateX(float f) {
        int n = 0;
        while (n < this.blobs.size()) {
            Blob blob = (Blob)this.blobs.get(n);
            blob.rotateX(f);
            ++n;
        }
    }

    public void rotateY(float f) {
        int n = 0;
        while (n < this.blobs.size()) {
            Blob blob = (Blob)this.blobs.get(n);
            blob.rotateY(f);
            ++n;
        }
    }

    public void rotateZ(float f) {
        int n = 0;
        while (n < this.blobs.size()) {
            Blob blob = (Blob)this.blobs.get(n);
            blob.rotateZ(f);
            ++n;
        }
    }

    public void rotate(float f, float f2, float f3) {
        this.rotateX(f);
        this.rotateY(f2);
        this.rotateZ(f3);
    }

    public void mirrorX() {
        int n = 0;
        while (n < this.blobs.size()) {
            Blob blob = (Blob)this.blobs.get(n);
            blob.mirrorX();
            ++n;
        }
    }

    public void mirrorY() {
        int n = 0;
        while (n < this.blobs.size()) {
            Blob blob = (Blob)this.blobs.get(n);
            blob.mirrorY();
            ++n;
        }
    }

    public void mirrorZ() {
        int n = 0;
        while (n < this.blobs.size()) {
            Blob blob = (Blob)this.blobs.get(n);
            blob.mirrorZ();
            ++n;
        }
    }

    public Object clone() {
        BlobArray blobArray = null;
        if (this.blobs != null) {
            blobArray = new BlobArray(this.blobs.size());
            int n = 0;
            while (n < this.blobs.size()) {
                Blob blob = (Blob)((Blob)this.blobs.get(n)).clone();
                blobArray.add(blob);
                ++n;
            }
        }
        return blobArray;
    }
}

