/*
 * Decompiled with CFR 0.152.
 */
package povtree.objects3D;

import povtree.interfaces.Constants;
import povtree.interfaces.Transformable;

public class Coordinate
implements Constants,
Transformable,
Cloneable {
    public float x;
    public float y;
    public float z;

    public Coordinate() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Coordinate(float f) {
        this.x = f;
        this.y = f;
        this.z = f;
    }

    public Coordinate(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public void reset() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public void scale(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public void scale(float f, float f2, float f3) {
        this.x *= f;
        this.y *= f2;
        this.z *= f3;
    }

    public void scaleX(float f) {
        this.x *= f;
    }

    public void scaleY(float f) {
        this.y *= f;
    }

    public void scaleZ(float f) {
        this.z *= f;
    }

    public void translate(float f, float f2, float f3) {
        this.x += f;
        this.y += f2;
        this.z += f3;
    }

    public void translateX(float f) {
        this.x += f;
    }

    public void translateY(float f) {
        this.y += f;
    }

    public void translateZ(float f) {
        this.z += f;
    }

    public void rotateX(float f) {
        float f2 = (float)Math.cos(f *= (float)Math.PI / 180);
        float f3 = (float)Math.sin(f);
        float f4 = this.y * f2 - this.z * f3;
        float f5 = this.z * f2 + this.y * f3;
        this.y = f4;
        this.z = f5;
    }

    public void rotateY(float f) {
        float f2 = (float)Math.cos(f *= (float)Math.PI / 180);
        float f3 = (float)Math.sin(f);
        float f4 = this.x * f2 + this.z * f3;
        float f5 = -(this.x * f3) + this.z * f2;
        this.x = f4;
        this.z = f5;
    }

    public void rotateZ(float f) {
        float f2 = (float)Math.cos(f *= (float)Math.PI / 180);
        float f3 = (float)Math.sin(f);
        float f4 = this.x * f2 - this.y * f3;
        float f5 = this.y * f2 + this.x * f3;
        this.x = f4;
        this.y = f5;
    }

    public void rotate(float f, float f2, float f3) {
        this.rotateX(f);
        this.rotateY(f2);
        this.rotateZ(f3);
    }

    public void mirrorX() {
        this.x = -this.x;
    }

    public void mirrorY() {
        this.y = -this.y;
    }

    public void mirrorZ() {
        this.z = -this.z;
    }

    public Object clone() {
        return new Coordinate(this.x, this.y, this.z);
    }

    public boolean equals(Coordinate coordinate) {
        if (coordinate == null) {
            return false;
        }
        return this.x == coordinate.x && this.y == coordinate.y && this.z == coordinate.z;
    }
}

