/*
 * Decompiled with CFR 0.152.
 */
package povtree.objects3D;

import java.util.ArrayList;
import povtree.interfaces.Transformable;
import povtree.objects3D.Blob;
import povtree.objects3D.BlobArray;

public class DoubleBlobArray
implements Cloneable,
Transformable {
    private ArrayList array = null;

    public DoubleBlobArray() {
        this.array = new ArrayList();
    }

    public DoubleBlobArray(int n) {
        this.array = new ArrayList(n);
    }

    public void add(BlobArray blobArray) {
        this.array.add(blobArray);
    }

    public ArrayList get() {
        return this.array;
    }

    public BlobArray get(int n) {
        return (BlobArray)this.array.get(n);
    }

    public int size() {
        return this.array.size();
    }

    public void remove(int n) {
        this.array.remove(n);
    }

    public void trimToSize() {
        this.array.trimToSize();
    }

    public void clear() {
        this.array.clear();
    }

    public void translate(float f, float f2, float f3) {
        int n = 0;
        while (n < this.array.size()) {
            BlobArray blobArray = (BlobArray)this.array.get(n);
            blobArray.translate(f, f2, f3);
            ++n;
        }
    }

    public void scale(float f) {
        int n = 0;
        while (n < this.array.size()) {
            BlobArray blobArray = (BlobArray)this.array.get(n);
            blobArray.scale(f);
            ++n;
        }
    }

    public void scale(float f, float f2, float f3) {
        int n = 0;
        while (n < this.array.size()) {
            BlobArray blobArray = (BlobArray)this.array.get(n);
            blobArray.scale(f, f2, f3);
            ++n;
        }
    }

    public void rotateX(float f) {
        int n = 0;
        while (n < this.array.size()) {
            BlobArray blobArray = (BlobArray)this.array.get(n);
            blobArray.rotateX(f);
            ++n;
        }
    }

    public void rotateY(float f) {
        int n = 0;
        while (n < this.array.size()) {
            BlobArray blobArray = (BlobArray)this.array.get(n);
            blobArray.rotateY(f);
            ++n;
        }
    }

    public void rotateZ(float f) {
        int n = 0;
        while (n < this.array.size()) {
            BlobArray blobArray = (BlobArray)this.array.get(n);
            blobArray.rotateZ(f);
            ++n;
        }
    }

    public void rotate(float f, float f2, float f3) {
        this.rotateX(f);
        this.rotateY(f2);
        this.rotateZ(f3);
    }

    public void mirrorX() {
        int n = 0;
        while (n < this.array.size()) {
            BlobArray blobArray = (BlobArray)this.array.get(n);
            blobArray.mirrorX();
            ++n;
        }
    }

    public void mirrorY() {
        int n = 0;
        while (n < this.array.size()) {
            BlobArray blobArray = (BlobArray)this.array.get(n);
            blobArray.mirrorY();
            ++n;
        }
    }

    public void mirrorZ() {
        int n = 0;
        while (n < this.array.size()) {
            BlobArray blobArray = (BlobArray)this.array.get(n);
            blobArray.mirrorZ();
            ++n;
        }
    }

    public Blob getFirstBlob() {
        Blob blob = null;
        if (this.get() != null) {
            BlobArray blobArray = this.get(0);
            blob = blobArray.get(0);
        }
        return blob;
    }

    public Object clone() {
        DoubleBlobArray doubleBlobArray = null;
        if (this.array != null) {
            doubleBlobArray = new DoubleBlobArray(this.array.size());
            int n = 0;
            while (n < this.array.size()) {
                BlobArray blobArray = (BlobArray)((BlobArray)this.array.get(n)).clone();
                doubleBlobArray.add(blobArray);
                ++n;
            }
        }
        return doubleBlobArray;
    }
}

