/*
 * Decompiled with CFR 0.152.
 */
package povtree.objects3D;

import java.awt.Color;
import java.util.ArrayList;
import povtree.interfaces.Constants;
import povtree.interfaces.Leaf;
import povtree.objects3D.Triangle;

public class LeafMesh
implements Leaf,
Constants,
Comparable {
    public ArrayList triangles;
    public Color color;
    public String name;
    public int textureIndex;
    private float radius = 0.5f;
    private int longitudinal;
    private int latitudinal;

    public ArrayList getTriangles() {
        return this.triangles;
    }

    public float getRadius() {
        return this.radius;
    }

    public void translate(float f, float f2, float f3) {
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            triangle.c1.translate(f, f2, f3);
            triangle.c2.translate(f, f2, f3);
            triangle.c3.translate(f, f2, f3);
            ++n;
        }
    }

    public void scale(float f) {
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            triangle.c1.scale(f);
            triangle.c2.scale(f);
            triangle.c3.scale(f);
            ++n;
        }
        this.radius *= f;
    }

    public void scale(float f, float f2, float f3) {
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            triangle.c1.scale(f, f2, f3);
            triangle.c2.scale(f, f2, f3);
            triangle.c3.scale(f, f2, f3);
            ++n;
        }
        this.radius *= f;
    }

    public void rotate(float f, float f2, float f3) {
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            triangle.c1.rotate(f, f2, f3);
            triangle.c2.rotate(f, f2, f3);
            triangle.c3.rotate(f, f2, f3);
            ++n;
        }
    }

    public void rotateX(float f) {
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            triangle.c1.rotateX(f);
            triangle.c2.rotateX(f);
            triangle.c3.rotateX(f);
            ++n;
        }
    }

    public void rotateY(float f) {
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            triangle.c1.rotateY(f);
            triangle.c2.rotateY(f);
            triangle.c3.rotateY(f);
            ++n;
        }
    }

    public void rotateZ(float f) {
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            triangle.c1.rotateZ(f);
            triangle.c2.rotateZ(f);
            triangle.c3.rotateZ(f);
            ++n;
        }
    }

    public void mirrorX() {
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            triangle.c1.mirrorX();
            triangle.c2.mirrorX();
            triangle.c3.mirrorX();
            ++n;
        }
    }

    public void mirrorY() {
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            triangle.c1.mirrorY();
            triangle.c2.mirrorY();
            triangle.c3.mirrorY();
            ++n;
        }
    }

    public void mirrorZ() {
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            triangle.c1.mirrorZ();
            triangle.c2.mirrorZ();
            triangle.c3.mirrorZ();
            ++n;
        }
    }

    public Object clone() {
        LeafMesh leafMesh = new LeafMesh();
        leafMesh.triangles = new ArrayList();
        int n = 0;
        while (n < this.triangles.size()) {
            leafMesh.triangles.add(((Triangle)this.triangles.get(n)).clone());
            ++n;
        }
        leafMesh.radius = this.radius;
        if (this.name != null) {
            leafMesh.name = new String(this.name);
        }
        leafMesh.textureIndex = this.textureIndex;
        leafMesh.longitudinal = this.longitudinal;
        leafMesh.latitudinal = this.latitudinal;
        return leafMesh;
    }

    public int compareTo(Object object) {
        Triangle triangle = (Triangle)this.triangles.get(0);
        Triangle triangle2 = (Triangle)((LeafMesh)object).triangles.get(0);
        float f = triangle.c1.z;
        float f2 = triangle2.c1.z;
        if (f > f2) {
            return 1;
        }
        if (f < f2) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("#declare " + this.name + " = mesh {" + Constants.EOL);
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            stringBuffer.append("\ttriangle{<" + triangle.c1.x + ", " + triangle.c1.y + ", " + triangle.c1.z + ">, " + "<" + triangle.c2.x + ", " + triangle.c2.y + ", " + triangle.c2.z + ">, " + "<" + triangle.c3.x + ", " + triangle.c3.y + ", " + triangle.c3.z + ">}" + Constants.EOL);
            ++n;
        }
        stringBuffer.append("};" + Constants.EOL);
        return stringBuffer.toString();
    }

    public String toStringUv() {
        StringBuffer stringBuffer = new StringBuffer(100);
        float f = 1.0f / (float)this.latitudinal;
        float f2 = 1.0f / (float)this.longitudinal;
        int n = 0;
        while (n < this.longitudinal) {
            int n2 = 0;
            while (n2 < this.latitudinal) {
                int n3 = 0;
                while (n3 < 2) {
                    Triangle triangle = (Triangle)this.triangles.get(n * this.latitudinal * 2 + n2 * 2 + n3);
                    if (n3 == 0) {
                        stringBuffer.append("triangle{<" + triangle.c1.x + ", " + triangle.c1.y + ", " + triangle.c1.z + ">, " + "<" + triangle.c2.x + ", " + triangle.c2.y + ", " + triangle.c2.z + ">, " + "<" + triangle.c3.x + ", " + triangle.c3.y + ", " + triangle.c3.z + "> uv_vectors<" + f * (float)n2 + "," + f2 * (float)n + ">,<" + f * (float)n2 + "," + f2 * (float)(n + 1) + ">,<" + f * (float)(n2 + 1) + "," + f2 * (float)n + ">}" + Constants.EOL);
                    } else {
                        stringBuffer.append("triangle{<" + triangle.c1.x + ", " + triangle.c1.y + ", " + triangle.c1.z + ">, " + "<" + triangle.c2.x + ", " + triangle.c2.y + ", " + triangle.c2.z + ">, " + "<" + triangle.c3.x + ", " + triangle.c3.y + ", " + triangle.c3.z + "> uv_vectors<" + f * (float)n2 + "," + f2 * (float)(n + 1) + ">,<" + f * (float)(n2 + 1) + "," + f2 * (float)n + ">,<" + f * (float)(n2 + 1) + "," + f2 * (float)(n + 1) + ">}" + Constants.EOL);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public float getMinimumX() {
        float f = ((Triangle)this.triangles.get(0)).getMinimumX();
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            float f2 = triangle.getMinimumX();
            if (f2 < f) {
                f = f2;
            }
            ++n;
        }
        return f;
    }

    public float getMinimumY() {
        float f = ((Triangle)this.triangles.get(0)).getMinimumY();
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            float f2 = triangle.getMinimumY();
            if (f2 < f) {
                f = f2;
            }
            ++n;
        }
        return f;
    }

    public float getMinimumZ() {
        float f = ((Triangle)this.triangles.get(0)).getMinimumZ();
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            float f2 = triangle.getMinimumZ();
            if (f2 < f) {
                f = f2;
            }
            ++n;
        }
        return f;
    }

    public float getMaximumX() {
        float f = ((Triangle)this.triangles.get(0)).getMaximumX();
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            float f2 = triangle.getMaximumX();
            if (f2 > f) {
                f = f2;
            }
            ++n;
        }
        return f;
    }

    public float getMaximumY() {
        float f = ((Triangle)this.triangles.get(0)).getMaximumY();
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            float f2 = triangle.getMaximumY();
            if (f2 > f) {
                f = f2;
            }
            ++n;
        }
        return f;
    }

    public float getMaximumZ() {
        float f = ((Triangle)this.triangles.get(0)).getMaximumZ();
        int n = 0;
        while (n < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.get(n);
            float f2 = triangle.getMaximumZ();
            if (f2 > f) {
                f = f2;
            }
            ++n;
        }
        return f;
    }

    public void setLatitudinal(int n) {
        this.latitudinal = n;
    }

    public void setLongitudinal(int n) {
        this.longitudinal = n;
    }

    public int getLatitudinal() {
        return this.latitudinal;
    }

    public int getLongitudinal() {
        return this.longitudinal;
    }

    public void buildLeaf() {
    }

    public void setTextureIndex(int n) {
        this.textureIndex = n;
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }
}

