/*
 * Decompiled with CFR 0.152.
 */
package povtree.objects3D;

import java.util.ArrayList;
import povtree.interfaces.Transformable;
import povtree.objects3D.BlobArray;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.TripleBlobArray;

public class QuadroBlobArray
implements Cloneable,
Transformable {
    private ArrayList array = null;

    public QuadroBlobArray() {
        this.array = new ArrayList();
    }

    public QuadroBlobArray(int n) {
        this.array = new ArrayList(n);
    }

    public void add(TripleBlobArray tripleBlobArray) {
        this.array.add(tripleBlobArray);
    }

    public ArrayList get() {
        return this.array;
    }

    public TripleBlobArray get(int n) {
        return (TripleBlobArray)this.array.get(n);
    }

    public DoubleBlobArray get(int n, int n2) {
        return ((TripleBlobArray)this.array.get(n)).get(n2);
    }

    public BlobArray get(int n, int n2, int n3) {
        return ((TripleBlobArray)this.array.get(n)).get(n2).get(n3);
    }

    public int size() {
        return this.array.size();
    }

    public int size(int n) {
        return ((TripleBlobArray)this.array.get(n)).size();
    }

    public void trimToSize() {
        this.array.trimToSize();
    }

    public void clear() {
        this.array.clear();
    }

    public void translate(float f, float f2, float f3) {
        int n = 0;
        while (n < this.array.size()) {
            TripleBlobArray tripleBlobArray = (TripleBlobArray)this.array.get(n);
            tripleBlobArray.translate(f, f2, f3);
            ++n;
        }
    }

    public void scale(float f) {
        int n = 0;
        while (n < this.array.size()) {
            TripleBlobArray tripleBlobArray = (TripleBlobArray)this.array.get(n);
            tripleBlobArray.scale(f);
            ++n;
        }
    }

    public void scale(float f, float f2, float f3) {
        int n = 0;
        while (n < this.array.size()) {
            TripleBlobArray tripleBlobArray = (TripleBlobArray)this.array.get(n);
            tripleBlobArray.scale(f, f2, f3);
            ++n;
        }
    }

    public void rotateX(float f) {
        int n = 0;
        while (n < this.array.size()) {
            TripleBlobArray tripleBlobArray = (TripleBlobArray)this.array.get(n);
            tripleBlobArray.rotateX(f);
            ++n;
        }
    }

    public void rotateY(float f) {
        int n = 0;
        while (n < this.array.size()) {
            TripleBlobArray tripleBlobArray = (TripleBlobArray)this.array.get(n);
            tripleBlobArray.rotateY(f);
            ++n;
        }
    }

    public void rotateZ(float f) {
        int n = 0;
        while (n < this.array.size()) {
            TripleBlobArray tripleBlobArray = (TripleBlobArray)this.array.get(n);
            tripleBlobArray.rotateZ(f);
            ++n;
        }
    }

    public void rotate(float f, float f2, float f3) {
        this.rotateX(f);
        this.rotateY(f2);
        this.rotateZ(f3);
    }

    public void mirrorX() {
        int n = 0;
        while (n < this.array.size()) {
            TripleBlobArray tripleBlobArray = (TripleBlobArray)this.array.get(n);
            tripleBlobArray.mirrorX();
            ++n;
        }
    }

    public void mirrorY() {
        int n = 0;
        while (n < this.array.size()) {
            TripleBlobArray tripleBlobArray = (TripleBlobArray)this.array.get(n);
            tripleBlobArray.mirrorY();
            ++n;
        }
    }

    public void mirrorZ() {
        int n = 0;
        while (n < this.array.size()) {
            TripleBlobArray tripleBlobArray = (TripleBlobArray)this.array.get(n);
            tripleBlobArray.mirrorZ();
            ++n;
        }
    }

    public void remove(int n) {
        this.array.remove(n);
    }

    public Object clone() {
        QuadroBlobArray quadroBlobArray = null;
        if (this.array != null) {
            quadroBlobArray = new QuadroBlobArray(this.array.size());
            int n = 0;
            while (n < this.array.size()) {
                TripleBlobArray tripleBlobArray = (TripleBlobArray)((TripleBlobArray)this.array.get(n)).clone();
                quadroBlobArray.add(tripleBlobArray);
                ++n;
            }
        }
        return quadroBlobArray;
    }
}

