/*
 * Decompiled with CFR 0.152.
 */
package povtree.objects3D;

import java.util.ArrayList;
import povtree.interfaces.Transformable;
import povtree.objects3D.DoubleLeafArray;
import povtree.objects3D.LeafArray;
import povtree.objects3D.TripleLeafArray;

public class QuadroLeafArray
implements Cloneable,
Transformable {
    private ArrayList array = null;

    public QuadroLeafArray() {
        this.array = new ArrayList();
    }

    public QuadroLeafArray(int n) {
        this.array = new ArrayList(n);
    }

    public void add(TripleLeafArray tripleLeafArray) {
        this.array.add(tripleLeafArray);
    }

    public ArrayList get() {
        return this.array;
    }

    public TripleLeafArray get(int n) {
        return (TripleLeafArray)this.array.get(n);
    }

    public DoubleLeafArray get(int n, int n2) {
        return ((TripleLeafArray)this.array.get(n)).get(n2);
    }

    public LeafArray get(int n, int n2, int n3) {
        return ((TripleLeafArray)this.array.get(n)).get(n2).get(n3);
    }

    public int size() {
        return this.array.size();
    }

    public int size(int n) {
        return ((TripleLeafArray)this.array.get(n)).size();
    }

    public void trimToSize() {
        this.array.trimToSize();
    }

    public void clear() {
        this.array.clear();
    }

    public void translate(float f, float f2, float f3) {
        int n = 0;
        while (n < this.array.size()) {
            TripleLeafArray tripleLeafArray = (TripleLeafArray)this.array.get(n);
            tripleLeafArray.translate(f, f2, f3);
            ++n;
        }
    }

    public void scale(float f) {
        int n = 0;
        while (n < this.array.size()) {
            TripleLeafArray tripleLeafArray = (TripleLeafArray)this.array.get(n);
            tripleLeafArray.scale(f);
            ++n;
        }
    }

    public void scale(float f, float f2, float f3) {
        int n = 0;
        while (n < this.array.size()) {
            TripleLeafArray tripleLeafArray = (TripleLeafArray)this.array.get(n);
            tripleLeafArray.scale(f, f2, f3);
            ++n;
        }
    }

    public void rotateX(float f) {
        int n = 0;
        while (n < this.array.size()) {
            TripleLeafArray tripleLeafArray = (TripleLeafArray)this.array.get(n);
            tripleLeafArray.rotateX(f);
            ++n;
        }
    }

    public void rotateY(float f) {
        int n = 0;
        while (n < this.array.size()) {
            TripleLeafArray tripleLeafArray = (TripleLeafArray)this.array.get(n);
            tripleLeafArray.rotateY(f);
            ++n;
        }
    }

    public void rotateZ(float f) {
        int n = 0;
        while (n < this.array.size()) {
            TripleLeafArray tripleLeafArray = (TripleLeafArray)this.array.get(n);
            tripleLeafArray.rotateZ(f);
            ++n;
        }
    }

    public void rotate(float f, float f2, float f3) {
        this.rotateX(f);
        this.rotateY(f2);
        this.rotateZ(f3);
    }

    public void mirrorX() {
        int n = 0;
        while (n < this.array.size()) {
            TripleLeafArray tripleLeafArray = (TripleLeafArray)this.array.get(n);
            tripleLeafArray.mirrorX();
            ++n;
        }
    }

    public void mirrorY() {
        int n = 0;
        while (n < this.array.size()) {
            TripleLeafArray tripleLeafArray = (TripleLeafArray)this.array.get(n);
            tripleLeafArray.mirrorY();
            ++n;
        }
    }

    public void mirrorZ() {
        int n = 0;
        while (n < this.array.size()) {
            TripleLeafArray tripleLeafArray = (TripleLeafArray)this.array.get(n);
            tripleLeafArray.mirrorZ();
            ++n;
        }
    }

    public void remove(int n) {
        this.array.remove(n);
    }

    public Object clone() {
        QuadroLeafArray quadroLeafArray = null;
        if (this.array != null) {
            quadroLeafArray = new QuadroLeafArray(this.array.size());
            int n = 0;
            while (n < this.array.size()) {
                TripleLeafArray tripleLeafArray = (TripleLeafArray)((TripleLeafArray)this.array.get(n)).clone();
                quadroLeafArray.add(tripleLeafArray);
                ++n;
            }
        }
        return quadroLeafArray;
    }
}

