/*
 * Decompiled with CFR 0.152.
 */
package povtree.objects3D;

import java.util.ArrayList;
import povtree.interfaces.Transformable;
import povtree.objects3D.BlobArray;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.QuadroBlobArray;
import povtree.objects3D.TripleBlobArray;

public class QuintetBlobArray
implements Cloneable,
Transformable {
    private ArrayList array = null;

    public QuintetBlobArray() {
        this.array = new ArrayList();
    }

    public QuintetBlobArray(int n) {
        this.array = new ArrayList(n);
    }

    public void add(QuadroBlobArray quadroBlobArray) {
        this.array.add(quadroBlobArray);
    }

    public ArrayList get() {
        return this.array;
    }

    public QuadroBlobArray get(int n) {
        return (QuadroBlobArray)this.array.get(n);
    }

    public TripleBlobArray get(int n, int n2) {
        return ((QuadroBlobArray)this.array.get(n)).get(n2);
    }

    public DoubleBlobArray get(int n, int n2, int n3) {
        return ((QuadroBlobArray)this.array.get(n)).get(n2).get(n3);
    }

    public BlobArray get(int n, int n2, int n3, int n4) {
        return ((QuadroBlobArray)this.array.get(n)).get(n2).get(n3).get(n4);
    }

    public int size() {
        return this.array.size();
    }

    public int size(int n) {
        return ((QuadroBlobArray)this.array.get(n)).size();
    }

    public void trimToSize() {
        this.array.trimToSize();
    }

    public void clear() {
        this.array.clear();
    }

    public void translate(float f, float f2, float f3) {
        int n = 0;
        while (n < this.array.size()) {
            QuadroBlobArray quadroBlobArray = (QuadroBlobArray)this.array.get(n);
            quadroBlobArray.translate(f, f2, f3);
            ++n;
        }
    }

    public void scale(float f) {
        int n = 0;
        while (n < this.array.size()) {
            QuadroBlobArray quadroBlobArray = (QuadroBlobArray)this.array.get(n);
            quadroBlobArray.scale(f);
            ++n;
        }
    }

    public void scale(float f, float f2, float f3) {
        int n = 0;
        while (n < this.array.size()) {
            QuadroBlobArray quadroBlobArray = (QuadroBlobArray)this.array.get(n);
            quadroBlobArray.scale(f, f2, f3);
            ++n;
        }
    }

    public void rotateX(float f) {
        int n = 0;
        while (n < this.array.size()) {
            QuadroBlobArray quadroBlobArray = (QuadroBlobArray)this.array.get(n);
            quadroBlobArray.rotateX(f);
            ++n;
        }
    }

    public void rotateY(float f) {
        int n = 0;
        while (n < this.array.size()) {
            QuadroBlobArray quadroBlobArray = (QuadroBlobArray)this.array.get(n);
            quadroBlobArray.rotateY(f);
            ++n;
        }
    }

    public void rotateZ(float f) {
        int n = 0;
        while (n < this.array.size()) {
            QuadroBlobArray quadroBlobArray = (QuadroBlobArray)this.array.get(n);
            quadroBlobArray.rotateZ(f);
            ++n;
        }
    }

    public void rotate(float f, float f2, float f3) {
        this.rotateX(f);
        this.rotateY(f2);
        this.rotateZ(f3);
    }

    public void mirrorX() {
        int n = 0;
        while (n < this.array.size()) {
            QuadroBlobArray quadroBlobArray = (QuadroBlobArray)this.array.get(n);
            quadroBlobArray.mirrorX();
            ++n;
        }
    }

    public void mirrorY() {
        int n = 0;
        while (n < this.array.size()) {
            QuadroBlobArray quadroBlobArray = (QuadroBlobArray)this.array.get(n);
            quadroBlobArray.mirrorY();
            ++n;
        }
    }

    public void mirrorZ() {
        int n = 0;
        while (n < this.array.size()) {
            QuadroBlobArray quadroBlobArray = (QuadroBlobArray)this.array.get(n);
            quadroBlobArray.mirrorZ();
            ++n;
        }
    }

    public void remove(int n) {
        this.array.remove(n);
    }

    public Object clone() {
        QuintetBlobArray quintetBlobArray = null;
        if (this.array != null) {
            quintetBlobArray = new QuintetBlobArray(this.array.size());
            int n = 0;
            while (n < this.array.size()) {
                QuadroBlobArray quadroBlobArray = (QuadroBlobArray)((QuadroBlobArray)this.array.get(n)).clone();
                quintetBlobArray.add(quadroBlobArray);
                ++n;
            }
        }
        return quintetBlobArray;
    }
}

