/*
 * Decompiled with CFR 0.152.
 */
package povtree.objects3D;

import java.awt.Rectangle;
import java.util.ArrayList;
import povtree.interfaces.Constants;
import povtree.interfaces.Leaf;
import povtree.interfaces.Transformable;
import povtree.objects3D.Blob;
import povtree.objects3D.BlobArray;
import povtree.objects3D.Coordinate;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.DoubleLeafArray;
import povtree.objects3D.LeafArray;
import povtree.objects3D.QuadroBlobArray;
import povtree.objects3D.QuadroLeafArray;
import povtree.objects3D.QuintetBlobArray;
import povtree.objects3D.Triangle;
import povtree.objects3D.TripleBlobArray;
import povtree.objects3D.TripleLeafArray;

public class Tree3D
implements Constants {
    public String name;
    public float threshold;
    public float normalizer;
    public int ramiOrder;
    private DoubleBlobArray roots;
    private BlobArray trunk;
    private DoubleBlobArray branches;
    private TripleBlobArray twigs;
    private QuintetBlobArray rami;
    private Object foliage;
    private Object blossom;
    private ArrayList minMax;
    private Rectangle lastRectangle;
    public float meshScale;
    public boolean meshFoliageFlag;
    public boolean meshBlossomFlag;

    public void setRoot(DoubleBlobArray doubleBlobArray) {
        this.roots = doubleBlobArray;
    }

    public DoubleBlobArray getRoot() {
        return this.roots;
    }

    public void setTrunk(BlobArray blobArray) {
        this.trunk = blobArray;
    }

    public BlobArray getTrunk() {
        return this.trunk;
    }

    public void setBranches(DoubleBlobArray doubleBlobArray) {
        this.branches = doubleBlobArray;
    }

    public DoubleBlobArray getBranches() {
        return this.branches;
    }

    public void setTwigs(TripleBlobArray tripleBlobArray) {
        this.twigs = tripleBlobArray;
    }

    public TripleBlobArray getTwigs() {
        return this.twigs;
    }

    public void setRami(QuintetBlobArray quintetBlobArray) {
        this.rami = quintetBlobArray;
    }

    public QuintetBlobArray getRami() {
        return this.rami;
    }

    public void setFoliage(Object object) {
        this.foliage = object;
    }

    public Object getFoliage() {
        return this.foliage;
    }

    public void setBlossom(Object object) {
        this.blossom = object;
    }

    public Object getBlossom() {
        return this.blossom;
    }

    public Blob getFirstBlobInTrunk() {
        Blob blob = null;
        if (this.trunk != null && this.trunk.size() != 0) {
            blob = this.trunk.get(0);
        }
        return blob;
    }

    public ArrayList getMinMax() {
        int n;
        DoubleBlobArray doubleBlobArray;
        Blob blob;
        int n2;
        BlobArray blobArray;
        int n3;
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>(2);
        Coordinate coordinate = new Coordinate();
        Coordinate coordinate2 = new Coordinate();
        Coordinate coordinate3 = null;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.roots != null) {
            n3 = 0;
            while (n3 < this.roots.size()) {
                blobArray = this.roots.get(n3);
                n2 = 0;
                while (n2 < blobArray.size()) {
                    blob = blobArray.get(n2);
                    if (coordinate3 == null) {
                        coordinate3 = blob.center;
                        f = coordinate3.x;
                        f2 = coordinate3.y;
                        f3 = coordinate3.z;
                        f4 = f;
                        f5 = f2;
                        f6 = f3;
                    } else {
                        coordinate3 = blob.center;
                        if (coordinate3.x < f) {
                            f = coordinate3.x;
                        }
                        if (coordinate3.x > f4) {
                            f4 = coordinate3.x;
                        }
                        if (coordinate3.y < f2) {
                            f2 = coordinate3.y;
                        }
                        if (coordinate3.y > f5) {
                            f5 = coordinate3.y;
                        }
                        if (coordinate3.z < f3) {
                            f3 = coordinate3.z;
                        }
                        if (coordinate3.z > f6) {
                            f6 = coordinate3.z;
                        }
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        if (this.trunk != null) {
            n3 = 0;
            while (n3 < this.trunk.size()) {
                blob = this.trunk.get(n3);
                if (coordinate3 == null) {
                    coordinate3 = blob.center;
                    f = coordinate3.x;
                    f2 = coordinate3.y;
                    f3 = coordinate3.z;
                    f4 = f;
                    f5 = f2;
                    f6 = f3;
                } else {
                    coordinate3 = blob.center;
                    if (coordinate3.x < f) {
                        f = coordinate3.x;
                    }
                    if (coordinate3.x > f4) {
                        f4 = coordinate3.x;
                    }
                    if (coordinate3.y < f2) {
                        f2 = coordinate3.y;
                    }
                    if (coordinate3.y > f5) {
                        f5 = coordinate3.y;
                    }
                    if (coordinate3.z < f3) {
                        f3 = coordinate3.z;
                    }
                    if (coordinate3.z > f6) {
                        f6 = coordinate3.z;
                    }
                }
                ++n3;
            }
        }
        if (this.branches != null) {
            n3 = 0;
            while (n3 < this.branches.size()) {
                blobArray = this.branches.get(n3);
                n2 = 0;
                while (n2 < blobArray.size()) {
                    blob = blobArray.get(n2);
                    if (coordinate3 == null) {
                        coordinate3 = blob.center;
                        f = coordinate3.x;
                        f2 = coordinate3.y;
                        f3 = coordinate3.z;
                        f4 = f;
                        f5 = f2;
                        f6 = f3;
                    } else {
                        coordinate3 = blob.center;
                        if (coordinate3.x < f) {
                            f = coordinate3.x;
                        }
                        if (coordinate3.x > f4) {
                            f4 = coordinate3.x;
                        }
                        if (coordinate3.y < f2) {
                            f2 = coordinate3.y;
                        }
                        if (coordinate3.y > f5) {
                            f5 = coordinate3.y;
                        }
                        if (coordinate3.z < f3) {
                            f3 = coordinate3.z;
                        }
                        if (coordinate3.z > f6) {
                            f6 = coordinate3.z;
                        }
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        if (this.twigs != null) {
            n3 = 0;
            while (n3 < this.twigs.size()) {
                doubleBlobArray = this.twigs.get(n3);
                n2 = 0;
                while (n2 < doubleBlobArray.size()) {
                    blobArray = doubleBlobArray.get(n2);
                    n = 0;
                    while (n < blobArray.size()) {
                        blob = blobArray.get(n);
                        if (coordinate3 == null) {
                            coordinate3 = blob.center;
                            f = coordinate3.x;
                            f2 = coordinate3.y;
                            f3 = coordinate3.z;
                            f4 = f;
                            f5 = f2;
                            f6 = f3;
                        } else {
                            coordinate3 = blob.center;
                            if (coordinate3.x < f) {
                                f = coordinate3.x;
                            }
                            if (coordinate3.x > f4) {
                                f4 = coordinate3.x;
                            }
                            if (coordinate3.y < f2) {
                                f2 = coordinate3.y;
                            }
                            if (coordinate3.y > f5) {
                                f5 = coordinate3.y;
                            }
                            if (coordinate3.z < f3) {
                                f3 = coordinate3.z;
                            }
                            if (coordinate3.z > f6) {
                                f6 = coordinate3.z;
                            }
                        }
                        ++n;
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        if (this.rami != null) {
            n3 = 0;
            while (n3 < this.rami.size()) {
                QuadroBlobArray quadroBlobArray = this.rami.get(n3);
                n2 = 0;
                while (n2 < quadroBlobArray.size()) {
                    TripleBlobArray tripleBlobArray = quadroBlobArray.get(n2);
                    n = 0;
                    while (n < tripleBlobArray.size()) {
                        doubleBlobArray = tripleBlobArray.get(n);
                        int n4 = 0;
                        while (n4 < doubleBlobArray.size()) {
                            blobArray = doubleBlobArray.get(n4);
                            int n5 = 0;
                            while (n5 < blobArray.size()) {
                                blob = blobArray.get(n5);
                                if (coordinate3 == null) {
                                    coordinate3 = blob.center;
                                    f = coordinate3.x;
                                    f2 = coordinate3.y;
                                    f3 = coordinate3.z;
                                    f4 = f;
                                    f5 = f2;
                                    f6 = f3;
                                } else {
                                    coordinate3 = blob.center;
                                    if (coordinate3.x < f) {
                                        f = coordinate3.x;
                                    }
                                    if (coordinate3.x > f4) {
                                        f4 = coordinate3.x;
                                    }
                                    if (coordinate3.y < f2) {
                                        f2 = coordinate3.y;
                                    }
                                    if (coordinate3.y > f5) {
                                        f5 = coordinate3.y;
                                    }
                                    if (coordinate3.z < f3) {
                                        f3 = coordinate3.z;
                                    }
                                    if (coordinate3.z > f6) {
                                        f6 = coordinate3.z;
                                    }
                                }
                                ++n5;
                            }
                            ++n4;
                        }
                        ++n;
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        coordinate.set(f, f2, f3);
        coordinate2.set(f4, f5, f6);
        arrayList.add(coordinate);
        arrayList.add(coordinate2);
        return arrayList;
    }

    public Coordinate getMinimumCoordinate() {
        return (Coordinate)this.minMax.get(0);
    }

    public Coordinate getMaximumCoordinate() {
        return (Coordinate)this.minMax.get(1);
    }

    public void translateTree(float f, float f2, float f3) {
        if (this.roots != null && this.roots.size() != 0) {
            this.roots.translate(f, f2, f3);
        }
        if (this.trunk != null && this.trunk.size() != 0) {
            this.trunk.translate(f, f2, f3);
        }
        if (this.branches != null && this.branches.size() != 0) {
            this.branches.translate(f, f2, f3);
        }
        if (this.twigs != null && this.twigs.size() != 0) {
            this.twigs.translate(f, f2, f3);
        }
        if (this.rami != null && this.rami.size() != 0) {
            this.rami.translate(f, f2, f3);
        }
        if (this.foliage != null) {
            if (this.meshFoliageFlag) {
                ((QuadroLeafArray)this.foliage).translate(f, f2, f3);
            } else {
                ((QuadroBlobArray)this.foliage).translate(f, f2, f3);
            }
        }
        if (this.blossom != null) {
            if (this.meshBlossomFlag) {
                ((QuadroLeafArray)this.blossom).translate(f, f2, f3);
            } else {
                ((QuadroBlobArray)this.blossom).translate(f, f2, f3);
            }
        }
    }

    public void translateRoot(int n, float f, float f2, float f3) {
        BlobArray blobArray;
        if (this.roots != null && this.roots.size() != 0 && n < this.roots.size() && n >= 0 && (blobArray = this.roots.get(n)) != null) {
            blobArray.translate(f, f2, f3);
        }
    }

    public void translateTrunk(float f, float f2, float f3) {
        if (this.trunk != null && this.trunk.size() != 0) {
            this.trunk.translate(f, f2, f3);
        }
    }

    public void translateBranch(int n, float f, float f2, float f3) {
        if (this.branches != null && this.branches.size() != 0) {
            Cloneable cloneable;
            BlobArray blobArray = this.branches.get(n);
            if (blobArray != null) {
                blobArray.translate(f, f2, f3);
            }
            if (this.twigs != null && (cloneable = this.twigs.get(n)) != null) {
                ((DoubleBlobArray)cloneable).translate(f, f2, f3);
            }
            if (this.rami != null && (cloneable = this.rami.get(n)) != null) {
                ((QuadroBlobArray)cloneable).translate(f, f2, f3);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    cloneable = ((QuadroLeafArray)this.foliage).get(n);
                    if (cloneable != null) {
                        ((TripleLeafArray)cloneable).translate(f, f2, f3);
                    }
                } else {
                    cloneable = ((QuadroBlobArray)this.foliage).get(n);
                    if (cloneable != null) {
                        ((TripleBlobArray)cloneable).translate(f, f2, f3);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    cloneable = ((QuadroLeafArray)this.blossom).get(n);
                    if (cloneable != null) {
                        ((TripleLeafArray)cloneable).translate(f, f2, f3);
                    }
                } else {
                    cloneable = ((QuadroBlobArray)this.blossom).get(n);
                    if (cloneable != null) {
                        ((TripleBlobArray)cloneable).translate(f, f2, f3);
                    }
                }
            }
        }
    }

    public void translateTwig(int n, int n2, float f, float f2, float f3) {
        if (this.branches != null && this.branches.size() != 0 && this.twigs != null && this.twigs.size() != 0) {
            Cloneable cloneable;
            Cloneable cloneable2;
            DoubleBlobArray doubleBlobArray = this.twigs.get(n);
            if (doubleBlobArray != null) {
                cloneable2 = doubleBlobArray.get(n2);
                ((BlobArray)cloneable2).translate(f, f2, f3);
            }
            if (this.rami != null && (cloneable2 = this.rami.get(n)) != null) {
                cloneable = ((QuadroBlobArray)cloneable2).get(n2);
                ((TripleBlobArray)cloneable).translate(f, f2, f3);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    cloneable2 = ((QuadroLeafArray)this.foliage).get(n);
                    if (cloneable2 != null) {
                        cloneable = ((TripleLeafArray)cloneable2).get(n2);
                        ((DoubleLeafArray)cloneable).translate(f, f2, f3);
                    }
                } else {
                    cloneable2 = ((QuadroBlobArray)this.foliage).get(n);
                    if (cloneable2 != null) {
                        cloneable = ((TripleBlobArray)cloneable2).get(n2);
                        ((DoubleBlobArray)cloneable).translate(f, f2, f3);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    cloneable2 = ((QuadroLeafArray)this.blossom).get(n);
                    if (cloneable2 != null) {
                        cloneable = ((TripleLeafArray)cloneable2).get(n2);
                        ((DoubleLeafArray)cloneable).translate(f, f2, f3);
                    }
                } else {
                    cloneable2 = ((QuadroBlobArray)this.blossom).get(n);
                    if (cloneable2 != null) {
                        cloneable = ((TripleBlobArray)cloneable2).get(n2);
                        ((DoubleBlobArray)cloneable).translate(f, f2, f3);
                    }
                }
            }
        }
    }

    public void translateRami(int n, int n2, int n3, float f, float f2, float f3) {
        if (this.branches != null && this.branches.size() != 0 && this.twigs != null && this.twigs.size() != 0 && this.rami != null && this.rami.size() != 0) {
            Cloneable cloneable;
            Cloneable cloneable2;
            Cloneable cloneable3;
            QuadroBlobArray quadroBlobArray = this.rami.get(n);
            if (quadroBlobArray != null && (cloneable3 = quadroBlobArray.get(n2)) != null) {
                cloneable2 = ((TripleBlobArray)cloneable3).get(n3);
                ((DoubleBlobArray)cloneable2).translate(f, f2, f3);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    cloneable3 = ((QuadroLeafArray)this.foliage).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleLeafArray)cloneable3).get(n2)) != null) {
                        cloneable = ((DoubleLeafArray)cloneable2).get(n3);
                        ((LeafArray)cloneable).translate(f, f2, f3);
                    }
                } else {
                    cloneable3 = ((QuadroBlobArray)this.foliage).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n2)) != null) {
                        cloneable = ((DoubleBlobArray)cloneable2).get(n3);
                        ((BlobArray)cloneable).translate(f, f2, f3);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    cloneable3 = ((QuadroLeafArray)this.blossom).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleLeafArray)cloneable3).get(n2)) != null) {
                        cloneable = ((DoubleLeafArray)cloneable2).get(n3);
                        ((LeafArray)cloneable).translate(f, f2, f3);
                    }
                } else {
                    cloneable3 = ((QuadroBlobArray)this.blossom).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n2)) != null) {
                        cloneable = ((DoubleBlobArray)cloneable2).get(n3);
                        ((BlobArray)cloneable).translate(f, f2, f3);
                    }
                }
            }
        }
    }

    public void scaleRoot(int n, float f) {
        BlobArray blobArray;
        if (this.roots != null && this.roots.size() != 0 && (blobArray = this.roots.get(n)) != null) {
            Blob blob = blobArray.get(0);
            float f2 = blob.center.x;
            float f3 = blob.center.y;
            float f4 = blob.center.z;
            blobArray.translate(-f2, -f3, -f4);
            blobArray.scale(f);
            blobArray.translate(f2, f3, f4);
        }
    }

    public void scaleTrunk(float f) {
        if (this.trunk != null && this.trunk.size() != 0) {
            Blob blob = this.trunk.get(0);
            float f2 = blob.center.x;
            float f3 = blob.center.y;
            float f4 = blob.center.z;
            this.trunk.translate(-f2, -f3, -f4);
            this.trunk.scale(f);
            this.trunk.translate(f2, f3, f4);
        }
    }

    public void scaleBranch(int n, float f) {
        if (this.branches != null && this.branches.size() != 0) {
            Transformable transformable;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            BlobArray blobArray = this.branches.get(n);
            if (blobArray != null) {
                transformable = blobArray.get(0);
                f2 = ((Blob)transformable).center.x;
                f3 = ((Blob)transformable).center.y;
                f4 = ((Blob)transformable).center.z;
                blobArray.translate(-f2, -f3, -f4);
                blobArray.scale(f);
                blobArray.translate(f2, f3, f4);
            }
            if (this.twigs != null && (transformable = this.twigs.get(n)) != null) {
                ((DoubleBlobArray)transformable).translate(-f2, -f3, -f4);
                ((DoubleBlobArray)transformable).scale(f);
                ((DoubleBlobArray)transformable).translate(f2, f3, f4);
            }
            if (this.rami != null && (transformable = this.rami.get(n)) != null) {
                ((QuadroBlobArray)transformable).translate(-f2, -f3, -f4);
                ((QuadroBlobArray)transformable).scale(f);
                ((QuadroBlobArray)transformable).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    transformable = ((QuadroLeafArray)this.foliage).get(n);
                    if (transformable != null) {
                        ((TripleLeafArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleLeafArray)transformable).scale(f);
                        ((TripleLeafArray)transformable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.foliage).get(n);
                    if (transformable != null) {
                        ((TripleBlobArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleBlobArray)transformable).scale(f);
                        ((TripleBlobArray)transformable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    transformable = ((QuadroLeafArray)this.blossom).get(n);
                    if (transformable != null) {
                        ((TripleLeafArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleLeafArray)transformable).scale(f);
                        ((TripleLeafArray)transformable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.blossom).get(n);
                    if (transformable != null) {
                        ((TripleBlobArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleBlobArray)transformable).scale(f);
                        ((TripleBlobArray)transformable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void scaleTwig(int n, int n2, float f) {
        if (this.branches != null && this.branches.size() != 0 && this.twigs != null && this.twigs.size() != 0) {
            Cloneable cloneable;
            Transformable transformable;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            DoubleBlobArray doubleBlobArray = this.twigs.get(n);
            BlobArray blobArray = null;
            if (doubleBlobArray != null) {
                blobArray = doubleBlobArray.get(n2);
            }
            if (blobArray != null) {
                transformable = blobArray.get(0);
                f2 = ((Blob)transformable).center.x;
                f3 = ((Blob)transformable).center.y;
                f4 = ((Blob)transformable).center.z;
                blobArray.translate(-f2, -f3, -f4);
                blobArray.scale(f);
                blobArray.translate(f2, f3, f4);
            }
            if (this.rami != null && (transformable = this.rami.get(n)) != null && (cloneable = ((QuadroBlobArray)transformable).get(n2)) != null) {
                ((TripleBlobArray)cloneable).translate(-f2, -f3, -f4);
                ((TripleBlobArray)cloneable).scale(f);
                ((TripleBlobArray)cloneable).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    transformable = ((QuadroLeafArray)this.foliage).get(n);
                    if (transformable != null && (cloneable = ((TripleLeafArray)transformable).get(n2)) != null) {
                        ((DoubleLeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleLeafArray)cloneable).scale(f);
                        ((DoubleLeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.foliage).get(n);
                    if (transformable != null && (cloneable = ((TripleBlobArray)transformable).get(n2)) != null) {
                        ((DoubleBlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleBlobArray)cloneable).scale(f);
                        ((DoubleBlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    transformable = ((QuadroLeafArray)this.blossom).get(n);
                    if (transformable != null && (cloneable = ((TripleLeafArray)transformable).get(n2)) != null) {
                        ((DoubleLeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleLeafArray)cloneable).scale(f);
                        ((DoubleLeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.blossom).get(n);
                    if (transformable != null && (cloneable = ((TripleBlobArray)transformable).get(n2)) != null) {
                        ((DoubleBlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleBlobArray)cloneable).scale(f);
                        ((DoubleBlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void scaleRami(int n, int n2, int n3, float f) {
        if (this.branches != null && this.branches.size() != 0 && this.twigs != null && this.twigs.size() != 0 && this.rami != null && this.rami.size() != 0) {
            Cloneable cloneable;
            Cloneable cloneable2;
            Cloneable cloneable3;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            QuadroBlobArray quadroBlobArray = this.rami.get(n);
            if (quadroBlobArray != null && (cloneable3 = quadroBlobArray.get(n2)) != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n3)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(0)) != null) {
                Blob blob = ((BlobArray)cloneable).get(0);
                f2 = blob.center.x;
                f3 = blob.center.y;
                f4 = blob.center.z;
                ((DoubleBlobArray)cloneable2).translate(-f2, -f3, -f4);
                ((DoubleBlobArray)cloneable2).scale(f);
                ((DoubleBlobArray)cloneable2).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    cloneable3 = ((QuadroLeafArray)this.foliage).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleLeafArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleLeafArray)cloneable2).get(n3)) != null) {
                        ((LeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((LeafArray)cloneable).scale(f);
                        ((LeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    cloneable3 = ((QuadroBlobArray)this.foliage).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(n3)) != null) {
                        ((BlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((BlobArray)cloneable).scale(f);
                        ((BlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    cloneable3 = ((QuadroLeafArray)this.blossom).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleLeafArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleLeafArray)cloneable2).get(n3)) != null) {
                        ((LeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((LeafArray)cloneable).scale(f);
                        ((LeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    cloneable3 = ((QuadroBlobArray)this.blossom).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(n3)) != null) {
                        ((BlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((BlobArray)cloneable).scale(f);
                        ((BlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void rotateRootX(int n, float f) {
        BlobArray blobArray;
        if (this.roots != null && this.roots.size() != 0 && (blobArray = this.roots.get(n)) != null) {
            Blob blob = blobArray.get(0);
            float f2 = blob.center.x;
            float f3 = blob.center.y;
            float f4 = blob.center.z;
            blobArray.translate(-f2, -f3, -f4);
            blobArray.rotateX(f);
            blobArray.translate(f2, f3, f4);
        }
    }

    public void rotateRootY(int n, float f) {
        BlobArray blobArray;
        if (this.roots != null && this.roots.size() != 0 && (blobArray = this.roots.get(n)) != null) {
            Blob blob = blobArray.get(0);
            float f2 = blob.center.x;
            float f3 = blob.center.y;
            float f4 = blob.center.z;
            blobArray.translate(-f2, -f3, -f4);
            blobArray.rotateY(f);
            blobArray.translate(f2, f3, f4);
        }
    }

    public void rotateRootZ(int n, float f) {
        BlobArray blobArray;
        if (this.roots != null && this.roots.size() != 0 && (blobArray = this.roots.get(n)) != null) {
            Blob blob = blobArray.get(0);
            float f2 = blob.center.x;
            float f3 = blob.center.y;
            float f4 = blob.center.z;
            blobArray.translate(-f2, -f3, -f4);
            blobArray.rotateZ(f);
            blobArray.translate(f2, f3, f4);
        }
    }

    public void rotateTrunkX(float f) {
        if (this.trunk != null && this.trunk.size() != 0) {
            Blob blob = this.trunk.get(0);
            float f2 = blob.center.x;
            float f3 = blob.center.y;
            float f4 = blob.center.z;
            this.trunk.translate(-f2, -f3, -f4);
            this.trunk.rotateX(f);
            this.trunk.translate(f2, f3, f4);
        }
    }

    public void rotateTrunkY(float f) {
        if (this.trunk != null && this.trunk.size() != 0) {
            Blob blob = this.trunk.get(0);
            float f2 = blob.center.x;
            float f3 = blob.center.y;
            float f4 = blob.center.z;
            this.trunk.translate(-f2, -f3, -f4);
            this.trunk.rotateY(f);
            this.trunk.translate(f2, f3, f4);
        }
    }

    public void rotateTrunkZ(float f) {
        if (this.trunk != null && this.trunk.size() != 0) {
            Blob blob = this.trunk.get(0);
            float f2 = blob.center.x;
            float f3 = blob.center.y;
            float f4 = blob.center.z;
            this.trunk.translate(-f2, -f3, -f4);
            this.trunk.rotateZ(f);
            this.trunk.translate(f2, f3, f4);
        }
    }

    public void rotateBranchX(int n, float f) {
        if (this.branches != null && this.branches.size() != 0) {
            Transformable transformable;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            BlobArray blobArray = this.branches.get(n);
            if (blobArray != null) {
                transformable = blobArray.get(0);
                f2 = ((Blob)transformable).center.x;
                f3 = ((Blob)transformable).center.y;
                f4 = ((Blob)transformable).center.z;
                blobArray.translate(-f2, -f3, -f4);
                blobArray.rotateX(f);
                blobArray.translate(f2, f3, f4);
            }
            if (this.twigs != null && this.twigs.size() != 0 && (transformable = this.twigs.get(n)) != null) {
                ((DoubleBlobArray)transformable).translate(-f2, -f3, -f4);
                ((DoubleBlobArray)transformable).rotateX(f);
                ((DoubleBlobArray)transformable).translate(f2, f3, f4);
            }
            if (this.rami != null && this.rami.size() != 0 && (transformable = this.rami.get(n)) != null) {
                ((QuadroBlobArray)transformable).translate(-f2, -f3, -f4);
                ((QuadroBlobArray)transformable).rotateX(f);
                ((QuadroBlobArray)transformable).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    transformable = ((QuadroLeafArray)this.foliage).get(n);
                    if (transformable != null) {
                        ((TripleLeafArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleLeafArray)transformable).rotateX(f);
                        ((TripleLeafArray)transformable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.foliage).get(n);
                    if (transformable != null) {
                        ((TripleBlobArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleBlobArray)transformable).rotateX(f);
                        ((TripleBlobArray)transformable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    transformable = ((QuadroLeafArray)this.blossom).get(n);
                    if (transformable != null) {
                        ((TripleLeafArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleLeafArray)transformable).rotateX(f);
                        ((TripleLeafArray)transformable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.blossom).get(n);
                    if (transformable != null) {
                        ((TripleBlobArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleBlobArray)transformable).rotateX(f);
                        ((TripleBlobArray)transformable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void rotateBranchY(int n, float f) {
        if (this.branches != null && this.branches.size() != 0) {
            Transformable transformable;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            BlobArray blobArray = this.branches.get(n);
            if (blobArray != null) {
                transformable = blobArray.get(0);
                f2 = ((Blob)transformable).center.x;
                f3 = ((Blob)transformable).center.y;
                f4 = ((Blob)transformable).center.z;
                blobArray.translate(-f2, -f3, -f4);
                blobArray.rotateY(f);
                blobArray.translate(f2, f3, f4);
            }
            if (this.twigs != null && this.twigs.size() != 0 && (transformable = this.twigs.get(n)) != null) {
                ((DoubleBlobArray)transformable).translate(-f2, -f3, -f4);
                ((DoubleBlobArray)transformable).rotateY(f);
                ((DoubleBlobArray)transformable).translate(f2, f3, f4);
            }
            if (this.rami != null && this.rami.size() != 0 && (transformable = this.rami.get(n)) != null) {
                ((QuadroBlobArray)transformable).translate(-f2, -f3, -f4);
                ((QuadroBlobArray)transformable).rotateY(f);
                ((QuadroBlobArray)transformable).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    transformable = ((QuadroLeafArray)this.foliage).get(n);
                    if (transformable != null) {
                        ((TripleLeafArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleLeafArray)transformable).rotateY(f);
                        ((TripleLeafArray)transformable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.foliage).get(n);
                    if (transformable != null) {
                        ((TripleBlobArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleBlobArray)transformable).rotateY(f);
                        ((TripleBlobArray)transformable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    transformable = ((QuadroLeafArray)this.blossom).get(n);
                    if (transformable != null) {
                        ((TripleLeafArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleLeafArray)transformable).rotateY(f);
                        ((TripleLeafArray)transformable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.blossom).get(n);
                    if (transformable != null) {
                        ((TripleBlobArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleBlobArray)transformable).rotateY(f);
                        ((TripleBlobArray)transformable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void rotateBranchZ(int n, float f) {
        if (this.branches != null && this.branches.size() != 0) {
            Transformable transformable;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            BlobArray blobArray = this.branches.get(n);
            if (blobArray != null) {
                transformable = blobArray.get(0);
                f2 = ((Blob)transformable).center.x;
                f3 = ((Blob)transformable).center.y;
                f4 = ((Blob)transformable).center.z;
                blobArray.translate(-f2, -f3, -f4);
                blobArray.rotateZ(f);
                blobArray.translate(f2, f3, f4);
            }
            if (this.twigs != null && this.twigs.size() != 0 && (transformable = this.twigs.get(n)) != null) {
                ((DoubleBlobArray)transformable).translate(-f2, -f3, -f4);
                ((DoubleBlobArray)transformable).rotateZ(f);
                ((DoubleBlobArray)transformable).translate(f2, f3, f4);
            }
            if (this.rami != null && this.rami.size() != 0 && (transformable = this.rami.get(n)) != null) {
                ((QuadroBlobArray)transformable).translate(-f2, -f3, -f4);
                ((QuadroBlobArray)transformable).rotateZ(f);
                ((QuadroBlobArray)transformable).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    transformable = ((QuadroLeafArray)this.foliage).get(n);
                    if (transformable != null) {
                        ((TripleLeafArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleLeafArray)transformable).rotateZ(f);
                        ((TripleLeafArray)transformable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.foliage).get(n);
                    if (transformable != null) {
                        ((TripleBlobArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleBlobArray)transformable).rotateZ(f);
                        ((TripleBlobArray)transformable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    transformable = ((QuadroLeafArray)this.blossom).get(n);
                    if (transformable != null) {
                        ((TripleLeafArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleLeafArray)transformable).rotateZ(f);
                        ((TripleLeafArray)transformable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.blossom).get(n);
                    if (transformable != null) {
                        ((TripleBlobArray)transformable).translate(-f2, -f3, -f4);
                        ((TripleBlobArray)transformable).rotateZ(f);
                        ((TripleBlobArray)transformable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void rotateTwigX(int n, int n2, float f) {
        if (this.branches != null && this.branches.size() != 0 && this.twigs != null && this.twigs.size() != 0) {
            Cloneable cloneable;
            Transformable transformable;
            BlobArray blobArray;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            DoubleBlobArray doubleBlobArray = this.twigs.get(n);
            if (doubleBlobArray != null && (blobArray = doubleBlobArray.get(n2)) != null) {
                transformable = blobArray.get(0);
                f2 = ((Blob)transformable).center.x;
                f3 = ((Blob)transformable).center.y;
                f4 = ((Blob)transformable).center.z;
                blobArray.translate(-f2, -f3, -f4);
                blobArray.rotateX(f);
                blobArray.translate(f2, f3, f4);
            }
            if (this.rami != null && this.rami.size() != 0 && (transformable = this.rami.get(n)) != null && (cloneable = ((QuadroBlobArray)transformable).get(n2)) != null) {
                ((TripleBlobArray)cloneable).translate(-f2, -f3, -f4);
                ((TripleBlobArray)cloneable).rotateX(f);
                ((TripleBlobArray)cloneable).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    transformable = ((QuadroLeafArray)this.foliage).get(n);
                    if (transformable != null && (cloneable = ((TripleLeafArray)transformable).get(n2)) != null) {
                        ((DoubleLeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleLeafArray)cloneable).rotateX(f);
                        ((DoubleLeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.foliage).get(n);
                    if (transformable != null && (cloneable = ((TripleBlobArray)transformable).get(n2)) != null) {
                        ((DoubleBlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleBlobArray)cloneable).rotateX(f);
                        ((DoubleBlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    transformable = ((QuadroLeafArray)this.blossom).get(n);
                    if (transformable != null && (cloneable = ((TripleLeafArray)transformable).get(n2)) != null) {
                        ((DoubleLeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleLeafArray)cloneable).rotateX(f);
                        ((DoubleLeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.blossom).get(n);
                    if (transformable != null && (cloneable = ((TripleBlobArray)transformable).get(n2)) != null) {
                        ((DoubleBlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleBlobArray)cloneable).rotateX(f);
                        ((DoubleBlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void rotateTwigY(int n, int n2, float f) {
        if (this.branches != null && this.branches.size() != 0 && this.twigs != null && this.twigs.size() != 0) {
            Cloneable cloneable;
            Transformable transformable;
            BlobArray blobArray;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            DoubleBlobArray doubleBlobArray = this.twigs.get(n);
            if (doubleBlobArray != null && (blobArray = doubleBlobArray.get(n2)) != null) {
                transformable = blobArray.get(0);
                f2 = ((Blob)transformable).center.x;
                f3 = ((Blob)transformable).center.y;
                f4 = ((Blob)transformable).center.z;
                blobArray.translate(-f2, -f3, -f4);
                blobArray.rotateY(f);
                blobArray.translate(f2, f3, f4);
            }
            if (this.rami != null && this.rami.size() != 0 && (transformable = this.rami.get(n)) != null && (cloneable = ((QuadroBlobArray)transformable).get(n2)) != null) {
                ((TripleBlobArray)cloneable).translate(-f2, -f3, -f4);
                ((TripleBlobArray)cloneable).rotateY(f);
                ((TripleBlobArray)cloneable).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    transformable = ((QuadroLeafArray)this.foliage).get(n);
                    if (transformable != null && (cloneable = ((TripleLeafArray)transformable).get(n2)) != null) {
                        ((DoubleLeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleLeafArray)cloneable).rotateY(f);
                        ((DoubleLeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.foliage).get(n);
                    if (transformable != null && (cloneable = ((TripleBlobArray)transformable).get(n2)) != null) {
                        ((DoubleBlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleBlobArray)cloneable).rotateY(f);
                        ((DoubleBlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    transformable = ((QuadroLeafArray)this.blossom).get(n);
                    if (transformable != null && (cloneable = ((TripleLeafArray)transformable).get(n2)) != null) {
                        ((DoubleLeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleLeafArray)cloneable).rotateY(f);
                        ((DoubleLeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.blossom).get(n);
                    if (transformable != null && (cloneable = ((TripleBlobArray)transformable).get(n2)) != null) {
                        ((DoubleBlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleBlobArray)cloneable).rotateY(f);
                        ((DoubleBlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void rotateTwigZ(int n, int n2, float f) {
        if (this.branches != null && this.branches.size() != 0 && this.twigs != null && this.twigs.size() != 0) {
            Cloneable cloneable;
            Transformable transformable;
            BlobArray blobArray;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            DoubleBlobArray doubleBlobArray = this.twigs.get(n);
            if (doubleBlobArray != null && (blobArray = doubleBlobArray.get(n2)) != null) {
                transformable = blobArray.get(0);
                f2 = ((Blob)transformable).center.x;
                f3 = ((Blob)transformable).center.y;
                f4 = ((Blob)transformable).center.z;
                blobArray.translate(-f2, -f3, -f4);
                blobArray.rotateZ(f);
                blobArray.translate(f2, f3, f4);
            }
            if (this.rami != null && this.rami.size() != 0 && (transformable = this.rami.get(n)) != null && (cloneable = ((QuadroBlobArray)transformable).get(n2)) != null) {
                ((TripleBlobArray)cloneable).translate(-f2, -f3, -f4);
                ((TripleBlobArray)cloneable).rotateZ(f);
                ((TripleBlobArray)cloneable).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    transformable = ((QuadroLeafArray)this.foliage).get(n);
                    if (transformable != null && (cloneable = ((TripleLeafArray)transformable).get(n2)) != null) {
                        ((DoubleLeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleLeafArray)cloneable).rotateZ(f);
                        ((DoubleLeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.foliage).get(n);
                    if (transformable != null && (cloneable = ((TripleBlobArray)transformable).get(n2)) != null) {
                        ((DoubleBlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleBlobArray)cloneable).rotateZ(f);
                        ((DoubleBlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    transformable = ((QuadroLeafArray)this.blossom).get(n);
                    if (transformable != null && (cloneable = ((TripleLeafArray)transformable).get(n2)) != null) {
                        ((DoubleLeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleLeafArray)cloneable).rotateZ(f);
                        ((DoubleLeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    transformable = ((QuadroBlobArray)this.blossom).get(n);
                    if (transformable != null && (cloneable = ((TripleBlobArray)transformable).get(n2)) != null) {
                        ((DoubleBlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((DoubleBlobArray)cloneable).rotateZ(f);
                        ((DoubleBlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void rotateRamiX(int n, int n2, int n3, float f) {
        if (this.branches != null && this.branches.size() != 0 && this.twigs != null && this.twigs.size() != 0 && this.rami != null && this.rami.size() != 0) {
            Cloneable cloneable;
            Cloneable cloneable2;
            Cloneable cloneable3;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            QuadroBlobArray quadroBlobArray = this.rami.get(n);
            if (quadroBlobArray != null && (cloneable3 = quadroBlobArray.get(n2)) != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n3)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(0)) != null) {
                Blob blob = ((BlobArray)cloneable).get(0);
                f2 = blob.center.x;
                f3 = blob.center.y;
                f4 = blob.center.z;
                ((DoubleBlobArray)cloneable2).translate(-f2, -f3, -f4);
                ((DoubleBlobArray)cloneable2).rotateX(f);
                ((DoubleBlobArray)cloneable2).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    cloneable3 = ((QuadroLeafArray)this.foliage).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleLeafArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleLeafArray)cloneable2).get(n3)) != null) {
                        ((LeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((LeafArray)cloneable).rotateX(f);
                        ((LeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    cloneable3 = ((QuadroBlobArray)this.foliage).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(n3)) != null) {
                        ((BlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((BlobArray)cloneable).rotateX(f);
                        ((BlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    cloneable3 = ((QuadroLeafArray)this.blossom).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleLeafArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleLeafArray)cloneable2).get(n3)) != null) {
                        ((LeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((LeafArray)cloneable).rotateX(f);
                        ((LeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    cloneable3 = ((QuadroBlobArray)this.blossom).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(n3)) != null) {
                        ((BlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((BlobArray)cloneable).rotateX(f);
                        ((BlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void rotateRamiY(int n, int n2, int n3, float f) {
        if (this.branches != null && this.branches.size() != 0 && this.twigs != null && this.twigs.size() != 0 && this.rami != null && this.rami.size() != 0) {
            Cloneable cloneable;
            Cloneable cloneable2;
            Cloneable cloneable3;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            QuadroBlobArray quadroBlobArray = this.rami.get(n);
            if (quadroBlobArray != null && (cloneable3 = quadroBlobArray.get(n2)) != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n3)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(0)) != null) {
                Blob blob = ((BlobArray)cloneable).get(0);
                f2 = blob.center.x;
                f3 = blob.center.y;
                f4 = blob.center.z;
                ((DoubleBlobArray)cloneable2).translate(-f2, -f3, -f4);
                ((DoubleBlobArray)cloneable2).rotateY(f);
                ((DoubleBlobArray)cloneable2).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    cloneable3 = ((QuadroLeafArray)this.foliage).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleLeafArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleLeafArray)cloneable2).get(n3)) != null) {
                        ((LeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((LeafArray)cloneable).rotateY(f);
                        ((LeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    cloneable3 = ((QuadroBlobArray)this.foliage).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(n3)) != null) {
                        ((BlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((BlobArray)cloneable).rotateY(f);
                        ((BlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    cloneable3 = ((QuadroLeafArray)this.blossom).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleLeafArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleLeafArray)cloneable2).get(n3)) != null) {
                        ((LeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((LeafArray)cloneable).rotateY(f);
                        ((LeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    cloneable3 = ((QuadroBlobArray)this.blossom).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(n3)) != null) {
                        ((BlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((BlobArray)cloneable).rotateY(f);
                        ((BlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void rotateRamiZ(int n, int n2, int n3, float f) {
        if (this.branches != null && this.branches.size() != 0 && this.twigs != null && this.twigs.size() != 0 && this.rami != null && this.rami.size() != 0) {
            Cloneable cloneable;
            Cloneable cloneable2;
            Cloneable cloneable3;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            QuadroBlobArray quadroBlobArray = this.rami.get(n);
            if (quadroBlobArray != null && (cloneable3 = quadroBlobArray.get(n2)) != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n3)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(0)) != null) {
                Blob blob = ((BlobArray)cloneable).get(0);
                f2 = blob.center.x;
                f3 = blob.center.y;
                f4 = blob.center.z;
                ((DoubleBlobArray)cloneable2).translate(-f2, -f3, -f4);
                ((DoubleBlobArray)cloneable2).rotateZ(f);
                ((DoubleBlobArray)cloneable2).translate(f2, f3, f4);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    cloneable3 = ((QuadroLeafArray)this.foliage).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleLeafArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleLeafArray)cloneable2).get(n3)) != null) {
                        ((LeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((LeafArray)cloneable).rotateZ(f);
                        ((LeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    cloneable3 = ((QuadroBlobArray)this.foliage).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(n3)) != null) {
                        ((BlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((BlobArray)cloneable).rotateZ(f);
                        ((BlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    cloneable3 = ((QuadroLeafArray)this.blossom).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleLeafArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleLeafArray)cloneable2).get(n3)) != null) {
                        ((LeafArray)cloneable).translate(-f2, -f3, -f4);
                        ((LeafArray)cloneable).rotateZ(f);
                        ((LeafArray)cloneable).translate(f2, f3, f4);
                    }
                } else {
                    cloneable3 = ((QuadroBlobArray)this.blossom).get(n);
                    if (cloneable3 != null && (cloneable2 = ((TripleBlobArray)cloneable3).get(n2)) != null && (cloneable = ((DoubleBlobArray)cloneable2).get(n3)) != null) {
                        ((BlobArray)cloneable).translate(-f2, -f3, -f4);
                        ((BlobArray)cloneable).rotateZ(f);
                        ((BlobArray)cloneable).translate(f2, f3, f4);
                    }
                }
            }
        }
    }

    public void removeRoot(int n) {
        if (this.roots != null && this.roots.size() > 0) {
            this.roots.remove(n);
        }
    }

    public void removeTrunk() {
        if (this.trunk != null && this.trunk.size() > 0) {
            this.trunk.clear();
        }
    }

    public void removeBranch(int n) {
        if (this.branches != null && this.branches.size() > 0) {
            this.branches.remove(n);
            if (this.twigs != null && this.twigs.size() > 0) {
                this.twigs.remove(n);
            }
            if (this.rami != null && this.rami.size() > 0) {
                this.rami.remove(n);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    ((QuadroLeafArray)this.foliage).remove(n);
                } else {
                    ((QuadroBlobArray)this.foliage).remove(n);
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    ((QuadroLeafArray)this.blossom).remove(n);
                } else {
                    ((QuadroBlobArray)this.blossom).remove(n);
                }
            }
        }
    }

    public void removeTwig(int n, int n2) {
        if (this.branches != null && this.twigs != null && this.twigs.size() > 0) {
            Cloneable cloneable;
            DoubleBlobArray doubleBlobArray = this.twigs.get(n);
            if (doubleBlobArray != null && doubleBlobArray.size() > 0) {
                doubleBlobArray.remove(n2);
            }
            if (this.rami != null && (cloneable = this.rami.get(n)) != null && ((QuadroBlobArray)cloneable).size() > 0) {
                ((QuadroBlobArray)cloneable).remove(n2);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    cloneable = ((QuadroLeafArray)this.foliage).get(n);
                    if (cloneable != null) {
                        ((TripleLeafArray)cloneable).remove(n2);
                    }
                } else {
                    cloneable = ((QuadroBlobArray)this.foliage).get(n);
                    if (cloneable != null) {
                        ((TripleBlobArray)cloneable).remove(n2);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    cloneable = ((QuadroLeafArray)this.blossom).get(n);
                    if (cloneable != null) {
                        ((TripleLeafArray)cloneable).remove(n2);
                    }
                } else {
                    cloneable = ((QuadroBlobArray)this.blossom).get(n);
                    if (cloneable != null) {
                        ((TripleBlobArray)cloneable).remove(n2);
                    }
                }
            }
        }
    }

    public void removeRami(int n, int n2, int n3) {
        if (this.branches != null && this.twigs != null && this.rami != null && this.rami.size() > 0) {
            Cloneable cloneable;
            Cloneable cloneable2;
            QuadroBlobArray quadroBlobArray = this.rami.get(n);
            if (quadroBlobArray != null && quadroBlobArray.size() > 0 && (cloneable2 = quadroBlobArray.get(n2)) != null && ((TripleBlobArray)cloneable2).size() > 0) {
                ((TripleBlobArray)cloneable2).remove(n3);
            }
            if (this.foliage != null) {
                if (this.meshFoliageFlag) {
                    cloneable2 = ((QuadroLeafArray)this.foliage).get(n);
                    if (cloneable2 != null && (cloneable = ((TripleLeafArray)cloneable2).get(n2)) != null) {
                        ((DoubleLeafArray)cloneable).remove(n3);
                    }
                } else {
                    cloneable2 = ((QuadroBlobArray)this.foliage).get(n);
                    if (cloneable2 != null && (cloneable = ((TripleBlobArray)cloneable2).get(n2)) != null) {
                        ((DoubleBlobArray)cloneable).remove(n3);
                    }
                }
            }
            if (this.blossom != null) {
                if (this.meshBlossomFlag) {
                    cloneable2 = ((QuadroLeafArray)this.blossom).get(n);
                    if (cloneable2 != null && (cloneable = ((TripleLeafArray)cloneable2).get(n2)) != null) {
                        ((DoubleLeafArray)cloneable).remove(n3);
                    }
                } else {
                    cloneable2 = ((QuadroBlobArray)this.blossom).get(n);
                    if (cloneable2 != null && (cloneable = ((TripleBlobArray)cloneable2).get(n2)) != null) {
                        ((DoubleBlobArray)cloneable).remove(n3);
                    }
                }
            }
        }
    }

    public void scaleTree(float f) {
        if (this.roots != null && this.roots.size() != 0) {
            this.roots.scale(f);
        }
        if (this.trunk != null && this.trunk.size() != 0) {
            this.trunk.scale(f);
        }
        if (this.branches != null && this.branches.size() != 0) {
            this.branches.scale(f);
        }
        if (this.twigs != null && this.twigs.size() != 0) {
            this.twigs.scale(f);
        }
        if (this.rami != null && this.rami.size() != 0) {
            this.rami.scale(f);
        }
        if (this.foliage != null) {
            if (this.meshFoliageFlag) {
                ((QuadroLeafArray)this.foliage).scale(f);
            } else {
                ((QuadroBlobArray)this.foliage).scale(f);
            }
        }
        if (this.blossom != null) {
            if (this.meshBlossomFlag) {
                ((QuadroLeafArray)this.blossom).scale(f);
            } else {
                ((QuadroBlobArray)this.blossom).scale(f);
            }
        }
    }

    public void rotateTreeX(float f) {
        if (this.roots != null && this.roots.size() != 0) {
            this.roots.rotateX(f);
        }
        if (this.trunk != null && this.trunk.size() != 0) {
            this.trunk.rotateX(f);
        }
        if (this.branches != null && this.branches.size() != 0) {
            this.branches.rotateX(f);
        }
        if (this.twigs != null && this.twigs.size() != 0) {
            this.twigs.rotateX(f);
        }
        if (this.rami != null && this.rami.size() != 0) {
            this.rami.rotateX(f);
        }
        if (this.foliage != null) {
            if (this.meshFoliageFlag) {
                ((QuadroLeafArray)this.foliage).rotateX(f);
            } else {
                ((QuadroBlobArray)this.foliage).rotateX(f);
            }
        }
        if (this.blossom != null) {
            if (this.meshBlossomFlag) {
                ((QuadroLeafArray)this.blossom).rotateX(f);
            } else {
                ((QuadroBlobArray)this.blossom).rotateX(f);
            }
        }
    }

    public void rotateTreeY(float f) {
        if (this.roots != null && this.roots.size() != 0) {
            this.roots.rotateY(f);
        }
        if (this.trunk != null && this.trunk.size() != 0) {
            this.trunk.rotateY(f);
        }
        if (this.branches != null && this.branches.size() != 0) {
            this.branches.rotateY(f);
        }
        if (this.twigs != null && this.twigs.size() != 0) {
            this.twigs.rotateY(f);
        }
        if (this.rami != null && this.rami.size() != 0) {
            this.rami.rotateY(f);
        }
        if (this.foliage != null) {
            if (this.meshFoliageFlag) {
                ((QuadroLeafArray)this.foliage).rotateY(f);
            } else {
                ((QuadroBlobArray)this.foliage).rotateY(f);
            }
        }
        if (this.blossom != null) {
            if (this.meshBlossomFlag) {
                ((QuadroLeafArray)this.blossom).rotateY(f);
            } else {
                ((QuadroBlobArray)this.blossom).rotateY(f);
            }
        }
    }

    public void rotateTreeZ(float f) {
        if (this.roots != null && this.roots.size() != 0) {
            this.roots.rotateZ(f);
        }
        if (this.trunk != null && this.trunk.size() != 0) {
            this.trunk.rotateZ(f);
        }
        if (this.branches != null && this.branches.size() != 0) {
            this.branches.rotateZ(f);
        }
        if (this.twigs != null && this.twigs.size() != 0) {
            this.twigs.rotateZ(f);
        }
        if (this.rami != null && this.rami.size() != 0) {
            this.rami.rotateZ(f);
        }
        if (this.foliage != null) {
            if (this.meshFoliageFlag) {
                ((QuadroLeafArray)this.foliage).rotateZ(f);
            } else {
                ((QuadroBlobArray)this.foliage).rotateZ(f);
            }
        }
        if (this.blossom != null) {
            if (this.meshBlossomFlag) {
                ((QuadroLeafArray)this.blossom).rotateZ(f);
            } else {
                ((QuadroBlobArray)this.blossom).rotateZ(f);
            }
        }
    }

    public void unitScale() {
        this.minMax = this.getMinMax();
        Coordinate coordinate = this.getMinimumCoordinate();
        Coordinate coordinate2 = this.getMaximumCoordinate();
        float f = Math.abs(coordinate2.x - coordinate.x);
        float f2 = Math.abs(coordinate2.y - coordinate.y);
        float f3 = Math.abs(coordinate2.z - coordinate.z);
        float f4 = 1.0f;
        if (f >= f2 && f >= f3) {
            f4 = 1.0f / f;
        }
        if (f2 > f && f2 >= f3) {
            f4 = 1.0f / f2;
        }
        if (f3 > f && f3 > f2) {
            f4 = 1.0f / f3;
        }
        this.meshScale = 1.0f / f4;
        Blob blob = this.getFirstBlobInTrunk();
        if (blob != null) {
            Coordinate coordinate3 = (Coordinate)blob.center.clone();
            this.translateTree(-coordinate3.x, -coordinate3.y, -coordinate3.z);
            this.scaleTree(f4);
        } else {
            if (this.roots != null && this.roots.size() != 0) {
                blob = this.roots.getFirstBlob();
            }
            if (blob != null) {
                Coordinate coordinate4 = (Coordinate)blob.center.clone();
                this.translateTree(-coordinate4.x, -coordinate4.y, -coordinate4.z);
                this.scaleTree(f4);
            } else {
                this.translateTree(-coordinate.x, -coordinate.y, -coordinate.z);
                this.translateTree(-f / 2.0f, -f2, -f3 / 2.0f);
                this.scaleTree(f4);
            }
        }
    }

    public void center() {
        this.center(this.lastRectangle);
    }

    public void center(Rectangle rectangle) {
        float f;
        this.lastRectangle = rectangle;
        this.minMax = this.getMinMax();
        Coordinate coordinate = this.getMinimumCoordinate();
        Coordinate coordinate2 = this.getMaximumCoordinate();
        float f2 = Math.abs(coordinate2.x - coordinate.x);
        float f3 = Math.abs(coordinate2.y - coordinate.y);
        float f4 = rectangle.width - 40;
        float f5 = rectangle.height - 40;
        f2 = Math.abs(coordinate2.x - coordinate.x);
        if (f2 > (f3 = Math.abs(coordinate2.y - coordinate.y))) {
            f = f4 / f2;
            if (f3 * f > f5) {
                f = f5 / f3;
            }
        } else {
            f = f5 / f3;
            if (f2 * f > f4) {
                f = f4 / f2;
            }
        }
        this.translateTree(-coordinate.x, -coordinate.y, 0.0f);
        this.translateTree(-f2 / 2.0f, -f3 / 2.0f, 0.0f);
        this.scaleTree(f);
        this.translateTree(rectangle.width / 2, rectangle.height / 2, 0.0f);
    }

    public ArrayList getAllBlobs() {
        int n;
        LeafArray leafArray;
        int n2;
        DoubleLeafArray doubleLeafArray;
        TripleLeafArray tripleLeafArray;
        int n3;
        int n4;
        TripleBlobArray tripleBlobArray;
        int n5;
        DoubleBlobArray doubleBlobArray;
        Blob blob;
        int n6;
        BlobArray blobArray;
        int n7;
        ArrayList<Blob> arrayList = new ArrayList<Blob>(1000);
        if (this.roots != null && this.roots.size() != 0) {
            n7 = 0;
            while (n7 < this.roots.size()) {
                blobArray = this.roots.get(n7);
                n6 = 0;
                while (n6 < blobArray.size()) {
                    blob = blobArray.get(n6);
                    arrayList.add(blob);
                    ++n6;
                }
                ++n7;
            }
        }
        if (this.trunk != null && this.trunk.size() != 0) {
            n7 = 0;
            while (n7 < this.trunk.size()) {
                blob = this.trunk.get(n7);
                arrayList.add(blob);
                ++n7;
            }
        }
        if (this.branches != null && this.branches.size() != 0) {
            n7 = 0;
            while (n7 < this.branches.size()) {
                blobArray = this.branches.get(n7);
                n6 = 0;
                while (n6 < blobArray.size()) {
                    blob = blobArray.get(n6);
                    arrayList.add(blob);
                    ++n6;
                }
                ++n7;
            }
        }
        if (this.twigs != null && this.twigs.size() != 0) {
            n7 = 0;
            while (n7 < this.twigs.size()) {
                doubleBlobArray = this.twigs.get(n7);
                n6 = 0;
                while (n6 < doubleBlobArray.size()) {
                    blobArray = doubleBlobArray.get(n6);
                    n5 = 0;
                    while (n5 < blobArray.size()) {
                        blob = blobArray.get(n5);
                        arrayList.add(blob);
                        ++n5;
                    }
                    ++n6;
                }
                ++n7;
            }
        }
        if (this.rami != null && this.rami.size() != 0) {
            n7 = 0;
            while (n7 < this.rami.size()) {
                QuadroBlobArray quadroBlobArray = this.rami.get(n7);
                n6 = 0;
                while (n6 < quadroBlobArray.size()) {
                    tripleBlobArray = quadroBlobArray.get(n6);
                    n5 = 0;
                    while (n5 < tripleBlobArray.size()) {
                        doubleBlobArray = tripleBlobArray.get(n5);
                        n4 = 0;
                        while (n4 < doubleBlobArray.size()) {
                            blobArray = doubleBlobArray.get(n4);
                            n3 = 0;
                            while (n3 < blobArray.size()) {
                                blob = blobArray.get(n3);
                                arrayList.add(blob);
                                ++n3;
                            }
                            ++n4;
                        }
                        ++n5;
                    }
                    ++n6;
                }
                ++n7;
            }
        }
        if (this.foliage != null) {
            if (this.foliage instanceof QuadroBlobArray) {
                n7 = 0;
                while (n7 < ((QuadroBlobArray)this.foliage).size()) {
                    tripleBlobArray = ((QuadroBlobArray)this.foliage).get(n7);
                    n6 = 0;
                    while (n6 < tripleBlobArray.size()) {
                        doubleBlobArray = tripleBlobArray.get(n6);
                        n5 = 0;
                        while (n5 < doubleBlobArray.size()) {
                            blobArray = doubleBlobArray.get(n5);
                            n4 = 0;
                            while (n4 < blobArray.size()) {
                                blob = blobArray.get(n4);
                                arrayList.add(blob);
                                ++n4;
                            }
                            ++n5;
                        }
                        ++n6;
                    }
                    ++n7;
                }
            } else {
                Leaf leaf = null;
                ArrayList arrayList2 = null;
                Triangle triangle = null;
                n4 = 0;
                while (n4 < ((QuadroLeafArray)this.foliage).size()) {
                    tripleLeafArray = ((QuadroLeafArray)this.foliage).get(n4);
                    n3 = 0;
                    while (n3 < tripleLeafArray.size()) {
                        doubleLeafArray = tripleLeafArray.get(n3);
                        n2 = 0;
                        while (n2 < doubleLeafArray.size()) {
                            leafArray = doubleLeafArray.get(n2);
                            n = 0;
                            while (n < leafArray.size()) {
                                leaf = leafArray.get(n);
                                arrayList2 = leaf.getTriangles();
                                triangle = (Triangle)arrayList2.get(0);
                                blob = new Blob(triangle.c1, leaf.getRadius(), 0.0f, true);
                                arrayList.add(blob);
                                ++n;
                            }
                            ++n2;
                        }
                        ++n3;
                    }
                    ++n4;
                }
            }
        }
        if (this.blossom != null) {
            if (this.blossom instanceof QuadroBlobArray) {
                int n8 = 0;
                while (n8 < ((QuadroBlobArray)this.blossom).size()) {
                    tripleBlobArray = ((QuadroBlobArray)this.blossom).get(n8);
                    int n9 = 0;
                    while (n9 < tripleBlobArray.size()) {
                        doubleBlobArray = tripleBlobArray.get(n9);
                        int n10 = 0;
                        while (n10 < doubleBlobArray.size()) {
                            blobArray = doubleBlobArray.get(n10);
                            n4 = 0;
                            while (n4 < blobArray.size()) {
                                blob = blobArray.get(n4);
                                arrayList.add(blob);
                                ++n4;
                            }
                            ++n10;
                        }
                        ++n9;
                    }
                    ++n8;
                }
            } else {
                Leaf leaf = null;
                ArrayList arrayList3 = null;
                Triangle triangle = null;
                n4 = 0;
                while (n4 < ((QuadroLeafArray)this.blossom).size()) {
                    tripleLeafArray = ((QuadroLeafArray)this.blossom).get(n4);
                    n3 = 0;
                    while (n3 < tripleLeafArray.size()) {
                        doubleLeafArray = tripleLeafArray.get(n3);
                        n2 = 0;
                        while (n2 < doubleLeafArray.size()) {
                            leafArray = doubleLeafArray.get(n2);
                            n = 0;
                            while (n < leafArray.size()) {
                                leaf = leafArray.get(n);
                                arrayList3 = leaf.getTriangles();
                                triangle = (Triangle)arrayList3.get(0);
                                blob = new Blob(triangle.c1, leaf.getRadius(), 0.0f, false, true);
                                arrayList.add(blob);
                                ++n;
                            }
                            ++n2;
                        }
                        ++n3;
                    }
                    ++n4;
                }
            }
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public void joinElements() {
        DoubleBlobArray doubleBlobArray;
        int n;
        float f;
        float f2;
        float f3;
        Blob blob;
        BlobArray blobArray;
        Blob blob2;
        if (this.trunk != null && this.trunk.size() != 0 && this.branches != null && this.branches.size() != 0) {
            blob2 = this.trunk.get(this.trunk.size() - 1);
            blobArray = this.branches.get(this.branches.size() - 1);
            blob = blobArray.get(0);
            f3 = blob2.center.x - blob.center.x;
            f2 = blob2.center.y - blob.center.y;
            f = blob2.center.z - blob.center.z;
            this.translateBranch(this.branches.size() - 1, f3, f2, f);
        }
        if (this.branches != null && this.branches.size() != 0 && this.twigs != null && this.twigs.size() != 0) {
            n = 0;
            while (n < this.branches.size()) {
                blobArray = this.branches.get(n);
                blob2 = blobArray.get(blobArray.size() - 1);
                doubleBlobArray = this.twigs.get(n);
                blobArray = doubleBlobArray.get(doubleBlobArray.size() - 1);
                blob = blobArray.get(0);
                f3 = blob2.center.x - blob.center.x;
                f2 = blob2.center.y - blob.center.y;
                f = blob2.center.z - blob.center.z;
                this.translateTwig(n, doubleBlobArray.size() - 1, f3, f2, f);
                ++n;
            }
        }
        if (this.twigs != null && this.twigs.size() != 0 && this.rami != null && this.rami.size() != 0) {
            n = 0;
            while (n < this.twigs.size()) {
                doubleBlobArray = this.twigs.get(n);
                QuadroBlobArray quadroBlobArray = this.rami.get(n);
                int n2 = 0;
                while (n2 < doubleBlobArray.size()) {
                    blobArray = doubleBlobArray.get(n2);
                    blob2 = blobArray.get(blobArray.size() - 1);
                    TripleBlobArray tripleBlobArray = quadroBlobArray.get(n2);
                    DoubleBlobArray doubleBlobArray2 = tripleBlobArray.get(tripleBlobArray.size() - 1);
                    blobArray = doubleBlobArray2.get(0);
                    blob = blobArray.get(0);
                    f3 = blob2.center.x - blob.center.x;
                    f2 = blob2.center.y - blob.center.y;
                    f = blob2.center.z - blob.center.z;
                    this.translateRami(n, n2, tripleBlobArray.size() - 1, f3, f2, f);
                    ++n2;
                }
                ++n;
            }
        }
    }

    public ArrayList getLeavesArray() {
        ArrayList<Object> arrayList;
        block10: {
            arrayList = null;
            if (this.foliage == null) break block10;
            arrayList = new ArrayList<Object>(1000);
            TripleLeafArray tripleLeafArray = null;
            DoubleLeafArray doubleLeafArray = null;
            LeafArray leafArray = null;
            TripleBlobArray tripleBlobArray = null;
            DoubleBlobArray doubleBlobArray = null;
            BlobArray blobArray = null;
            if (this.meshFoliageFlag) {
                QuadroLeafArray quadroLeafArray = (QuadroLeafArray)this.foliage;
                int n = 0;
                while (n < quadroLeafArray.size()) {
                    tripleLeafArray = quadroLeafArray.get(n);
                    int n2 = 0;
                    while (n2 < tripleLeafArray.size()) {
                        doubleLeafArray = tripleLeafArray.get(n2);
                        int n3 = 0;
                        while (n3 < doubleLeafArray.size()) {
                            leafArray = doubleLeafArray.get(n3);
                            int n4 = 0;
                            while (n4 < leafArray.size()) {
                                arrayList.add(leafArray.get(n4).clone());
                                ++n4;
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else {
                QuadroBlobArray quadroBlobArray = (QuadroBlobArray)this.foliage;
                int n = 0;
                while (n < quadroBlobArray.size()) {
                    tripleBlobArray = quadroBlobArray.get(n);
                    int n5 = 0;
                    while (n5 < tripleBlobArray.size()) {
                        doubleBlobArray = tripleBlobArray.get(n5);
                        int n6 = 0;
                        while (n6 < doubleBlobArray.size()) {
                            blobArray = doubleBlobArray.get(n6);
                            int n7 = 0;
                            while (n7 < blobArray.size()) {
                                arrayList.add(blobArray.get(n7).clone());
                                ++n7;
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public ArrayList getBlossomsArray() {
        ArrayList<Object> arrayList;
        block10: {
            arrayList = null;
            if (this.blossom == null) break block10;
            arrayList = new ArrayList<Object>(1000);
            TripleLeafArray tripleLeafArray = null;
            DoubleLeafArray doubleLeafArray = null;
            LeafArray leafArray = null;
            TripleBlobArray tripleBlobArray = null;
            DoubleBlobArray doubleBlobArray = null;
            BlobArray blobArray = null;
            if (this.meshBlossomFlag) {
                QuadroLeafArray quadroLeafArray = (QuadroLeafArray)this.blossom;
                int n = 0;
                while (n < quadroLeafArray.size()) {
                    tripleLeafArray = quadroLeafArray.get(n);
                    int n2 = 0;
                    while (n2 < tripleLeafArray.size()) {
                        doubleLeafArray = tripleLeafArray.get(n2);
                        int n3 = 0;
                        while (n3 < doubleLeafArray.size()) {
                            leafArray = doubleLeafArray.get(n3);
                            int n4 = 0;
                            while (n4 < leafArray.size()) {
                                arrayList.add(leafArray.get(n4).clone());
                                ++n4;
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else {
                QuadroBlobArray quadroBlobArray = (QuadroBlobArray)this.blossom;
                int n = 0;
                while (n < quadroBlobArray.size()) {
                    tripleBlobArray = quadroBlobArray.get(n);
                    int n5 = 0;
                    while (n5 < tripleBlobArray.size()) {
                        doubleBlobArray = tripleBlobArray.get(n5);
                        int n6 = 0;
                        while (n6 < doubleBlobArray.size()) {
                            blobArray = doubleBlobArray.get(n6);
                            int n7 = 0;
                            while (n7 < blobArray.size()) {
                                arrayList.add(blobArray.get(n7).clone());
                                ++n7;
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    ++n;
                }
            }
        }
        return arrayList;
    }
}

