/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import povtree.interfaces.Constants;
import povtree.objects3D.Blob;
import povtree.objects3D.BlobArray;
import povtree.objects3D.DoubleBlobArray;
import povtree.povTreeGenerator.Parameters;

public class BranchGenerator
implements Constants {
    private Parameters p;
    private DoubleBlobArray branches;

    public BranchGenerator(Parameters parameters) {
        this.p = parameters;
    }

    public void checkThreadStatus() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public DoubleBlobArray generate() throws InterruptedException {
        if (this.p.branches == 0.0f || this.p.branchStrength <= 0.0f) {
            return null;
        }
        if (this.p.branchStrength > 0.0f && (double)this.p.branches >= 1.0) {
            this.branches = new DoubleBlobArray(10);
            BlobArray blobArray = null;
            float f = 1.0f;
            while ((double)f < 100.0) {
                float f2;
                float f3;
                this.checkThreadStatus();
                float f4 = 1.0f;
                blobArray = new BlobArray(50);
                if (this.p.twigs / this.p.branches > 1.0f) {
                    f3 = (this.p.twigs / this.p.branches - 1.0f) / (this.p.twigs / this.p.branches) * this.p.twigAreaAtBranch;
                    f2 = this.p.twigAreaAtBranch / (this.p.twigs / this.p.branches) * this.p.branchTip;
                } else {
                    f3 = this.p.twigAreaAtBranch;
                    f2 = 0.0f;
                }
                while (f4 <= (this.p.firstTwigAtBranch + f3 + f2 + this.p.branchTip * this.p.zwl * (1.0f - this.p.branchTaper)) / this.p.astl * this.p.bh) {
                    float f5;
                    Blob blob = new Blob(this.p.trunkRadius * 5.0f, this.p.trunkRadius * 10.0f);
                    float f6 = this.p.trunkRadius / 90.0f;
                    blob.scale(f6);
                    f6 = (this.p.firstTwigAtBranch + this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper) - f4 * this.p.branchTaper * this.p.astl / this.p.bh) / (this.p.firstTwigAtBranch + this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper));
                    blob.scale(f6);
                    f6 = (float)(1.0 + (double)(1.0f - this.p.branchBarkProfileTaperOff * f4 / (this.p.firstTwigAtBranch + this.p.twigAreaAtBranch + this.p.zl)) * ((double)(-this.p.barkProfile) * 0.9 * (double)this.p.branchBarkProfileChange));
                    float f7 = f5 = (float)(1.0 + (double)(1.0f - this.p.branchBarkProfileTaperOff * f4 / (this.p.firstTwigAtBranch + this.p.twigAreaAtBranch + this.p.zl)) * ((double)(-this.p.barkProfile) * 0.25 * (double)this.p.branchBarkProfileChange));
                    blob.scale(f5);
                    f6 = (this.p.bh - this.p.firstBranchAtTrunk * this.p.trunkTaper) / this.p.bh;
                    blob.scale(f6);
                    f6 = (this.p.bh - this.p.branchAreaAtTrunk * (f / 100.0f) * this.p.trunkTaper) / this.p.bh;
                    blob.scale(f6);
                    f6 = 1.0f / (this.p.astl / this.p.bh);
                    blob.scale(f6);
                    f6 = this.p.branchThicknessChange;
                    blob.scale(f6);
                    if (f4 > this.p.firstTwigAtBranch / this.p.astl * this.p.bh && this.p.twigAreaAtBranch >= 1.0f && this.p.branchTip == 0.0f) {
                        float f8 = this.p.twigs / this.p.branches > 1.0f ? (this.p.twigs / this.p.branches - 1.0f) / (this.p.twigs / this.p.branches) * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) : this.p.twigAreaAtBranch / this.p.astl * this.p.bh;
                        f6 = 1.0f - this.p.branchEndEqualizer * ((f4 - this.p.firstTwigAtBranch / this.p.astl * this.p.bh) / f8) * (1.0f - this.p.twigThicknessChange);
                        blob.scale(f6);
                    }
                    f6 = (float)(12347.3 * Math.sin(3.77 * (double)f4 * (double)f4 * 3.1415927410125732));
                    blob.rotateY(f6);
                    f6 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.123 * (double)this.p.branchSnagFrequency * (double)f4 / (double)this.p.bh)) * (double)((this.p.bh - f4) / this.p.bh) * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                    f5 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(4.789 * (double)this.p.branchSnagFrequency * (double)f4 / (double)this.p.bh)) * (double)((this.p.bh - f4) / this.p.bh) * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                    f7 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.456 * (double)this.p.branchSnagFrequency * (double)f4 / (double)this.p.bh)) * (double)((this.p.bh - f4) / this.p.bh) * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                    blob.translate(f6, f5, f7);
                    f6 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.456 * (double)this.p.branchCurveFrequency * (double)f4 / (double)this.p.bh)) * (double)((this.p.bh - f4) / this.p.bh) * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                    f5 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.123 * (double)this.p.branchCurveFrequency * (double)f4 / (double)this.p.bh)) * (double)((this.p.bh - f4) / this.p.bh) * (double)this.p.branchLongitudinalCurve * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                    f7 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(4.789 * (double)this.p.branchCurveFrequency * (double)f4 / (double)this.p.bh)) * (double)((this.p.bh - f4) / this.p.bh) * (double)this.p.horizontalBranchCurveSwitch * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                    blob.translate(f6, f5, f7);
                    f6 = (float)((double)this.p.abg * Math.sin((double)(this.p.extraNoiseSwitch * (float)Math.PI / 2.0f) * Math.sin(5.371 * (double)this.p.abfz * (double)f4 / (double)this.p.bh) + (double)(1.0f - this.p.extraNoiseSwitch) * 5.371 * (double)this.p.abfz * (double)f4 / (double)this.p.bh) * -1.0 * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                    f5 = f4;
                    f7 = (float)((double)this.p.abg * Math.sin((double)(this.p.extraNoiseSwitch * (float)Math.PI / 2.0f) * Math.sin(5.937 * (double)this.p.abfz * (double)f4 / (double)this.p.bh) + (double)(1.0f - this.p.extraNoiseSwitch) * 5.937 * (double)this.p.abfz * (double)f4 / (double)this.p.bh) * (double)this.p.horizontalBranchBendSwitch * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                    blob.translate(f6, f5, f7);
                    f6 = (float)((double)this.p.branchSpiral * Math.sin(f4 / this.p.bh * 1.5707964f));
                    blob.rotateY(f6);
                    f6 = (float)(1234.0 * Math.sin(4.77 * (double)f * 3.1415927410125732) * (double)this.p.branchTurnSwitch);
                    blob.rotateY(f6);
                    f6 = -90.0f;
                    blob.rotateZ(f6);
                    f6 = this.p.astl / this.p.bh * (1.0f - f / 100.0f * this.p.branchReduction);
                    blob.scale(f6);
                    f6 = (float)((double)(this.p.branchAngle + f / 100.0f * (90.0f - this.p.branchAngle) * this.p.branchAlignment) + (double)this.p.branchAngleScope * Math.sin(9.77 * (double)f * (double)f * 3.1415927410125732));
                    blob.rotateZ(f6);
                    f6 = (float)(1456.0 * Math.cos((double)this.p.branchRandom * 7.19 * (double)f * 3.1415927410125732) * (double)(1.0f - this.p.branchAlternateSwitch) + (double)(90.0f * this.p.branchAlternateSwitch) * Math.sin((f / (100.0f / this.p.branches) - 1.0f / (100.0f / this.p.branches)) * (float)Math.PI - 1.5707964f) + 90.0);
                    blob.rotateY(f6);
                    f6 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.123 * (double)this.p.trunkSnagFrequency * (double)(this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / (double)this.p.bh)) * (double)((this.p.bh - (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f)) / this.p.bh));
                    f5 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(4.789 * (double)this.p.trunkSnagFrequency * (double)(this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / (double)this.p.bh)) * (double)((this.p.bh - (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f)) / this.p.bh));
                    f7 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.456 * (double)this.p.trunkSnagFrequency * (double)(this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / (double)this.p.bh)) * (double)((this.p.bh - (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f)) / this.p.bh));
                    blob.translate(f6, f5, f7);
                    f6 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.456 * (double)this.p.trunkCurveFrequency * (double)(this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / (double)this.p.bh)) * (double)((this.p.bh - (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f)) / this.p.bh));
                    f5 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.123 * (double)this.p.trunkCurveFrequency * (double)(this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / (double)this.p.bh)) * (double)((this.p.bh - (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f)) / this.p.bh));
                    f7 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(4.789 * (double)this.p.trunkCurveFrequency * (double)(this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / (double)this.p.bh)) * (double)((this.p.bh - (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f)) / this.p.bh));
                    blob.translate(f6, f5, f7);
                    f6 = (float)((double)this.p.trunkBendX * Math.sin(1.5707963705062866 * Math.sin(5.371 * (double)this.p.trunkBendXFrequency * 1.5 * (double)(this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / (double)this.p.bh)));
                    f5 = this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f;
                    f7 = (float)((double)this.p.trunkBendZ * Math.sin(1.5707963705062866 * Math.sin(5.937 * (double)this.p.trunkBendZFrequency * 1.5 * (double)(this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / (double)this.p.bh)));
                    blob.translate(f6, f5, f7);
                    f6 = (float)((double)this.p.trunkSpiral * Math.sin((this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / (this.p.bh * 3.0f / 5.0f)));
                    blob.rotateY(f6);
                    blobArray.add(blob);
                    f4 = (float)((double)f4 + (double)(this.p.bh / this.p.branchStrength) / 300.0);
                }
                blobArray.trimToSize();
                this.branches.add(blobArray);
                f = (float)((double)f + 100.0 / (double)this.p.branches);
            }
        }
        this.branches.trimToSize();
        return this.branches;
    }
}

