/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import java.util.ArrayList;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import povtree.gui.PovtreeException;
import povtree.gui.Resources;
import povtree.interfaces.Constants;
import povtree.interfaces.Transformable;
import povtree.objects3D.Blob;
import povtree.objects3D.BlobArray;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.DoubleLeafArray;
import povtree.objects3D.Leaf1;
import povtree.objects3D.Leaf10;
import povtree.objects3D.Leaf12a;
import povtree.objects3D.Leaf12b;
import povtree.objects3D.Leaf24;
import povtree.objects3D.Leaf3;
import povtree.objects3D.Leaf4;
import povtree.objects3D.Leaf4a;
import povtree.objects3D.Leaf6a;
import povtree.objects3D.Leaf6b;
import povtree.objects3D.LeafArray;
import povtree.objects3D.LeafMesh;
import povtree.objects3D.LeafUv1;
import povtree.objects3D.LeafUv10;
import povtree.objects3D.LeafUv11;
import povtree.objects3D.LeafUv12;
import povtree.objects3D.LeafUv2;
import povtree.objects3D.LeafUv3;
import povtree.objects3D.LeafUv4;
import povtree.objects3D.LeafUv5;
import povtree.objects3D.LeafUv6;
import povtree.objects3D.LeafUv7;
import povtree.objects3D.LeafUv8;
import povtree.objects3D.LeafUv9;
import povtree.objects3D.QuadroBlobArray;
import povtree.objects3D.QuadroLeafArray;
import povtree.objects3D.TableLeaf;
import povtree.objects3D.Triangle;
import povtree.objects3D.TripleBlobArray;
import povtree.objects3D.TripleLeafArray;
import povtree.povTreeGenerator.Parameters;

public class FoliageGenerator
implements Constants {
    private Parameters p;
    private BlobArray bunchLeaves;
    private QuadroBlobArray leaves;
    private QuadroLeafArray leavesMesh;
    private Object result;
    private LeafArray bunchMesh;
    private boolean isMesh = false;
    private String leafType;
    private Resources resources = Resources.getInstance();
    private ResourceBundle messages = Resources.getMessagesBundle();

    public FoliageGenerator(Parameters parameters, boolean bl, String string) {
        this.p = parameters;
        this.isMesh = bl;
        this.leafType = string;
    }

    public void checkThreadStatus() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public void generateDeclarations() throws PovtreeException {
        float f = 1.0f;
        Blob blob = null;
        LeafMesh leafMesh = null;
        Random random = new Random();
        if (this.p.leafLength * this.p.leafHeight * this.p.leafBreadth > 0.0f && this.p.branches >= 1.0f && this.p.twigs >= 1.0f && this.p.leaves >= 1.0f && this.p.bunches >= 1.0f) {
            if (this.isMesh) {
                this.bunchMesh = new LeafArray(100);
            } else {
                this.bunchLeaves = new BlobArray(100);
            }
            if (this.p.leaves / this.p.bunches > 1.0f) {
                while ((double)f < 100.0) {
                    if (this.isMesh) {
                        if (this.leafType.equals("Mesh1")) {
                            leafMesh = new Leaf1();
                        } else if (this.leafType.equals("LeafUv")) {
                            TableLeaf tableLeaf;
                            String string;
                            ArrayList arrayList = this.p.leafUvType;
                            int n = 0;
                            if (arrayList != null && arrayList.size() > 1) {
                                n = random.nextInt(arrayList.size());
                            }
                            if ((string = (tableLeaf = (TableLeaf)arrayList.get(n)).getLeafUvName()).equals("LeafUv1")) {
                                leafMesh = new LeafUv1();
                            } else if (string.equals("LeafUv2")) {
                                leafMesh = new LeafUv2();
                            } else if (string.equals("LeafUv3")) {
                                leafMesh = new LeafUv3();
                            } else if (string.equals("LeafUv4")) {
                                leafMesh = new LeafUv4();
                            } else if (string.equals("LeafUv5")) {
                                leafMesh = new LeafUv5();
                            } else if (string.equals("LeafUv6")) {
                                leafMesh = new LeafUv6();
                            } else if (string.equals("LeafUv7")) {
                                leafMesh = new LeafUv7();
                            } else if (string.equals("LeafUv8")) {
                                leafMesh = new LeafUv8();
                            } else if (string.equals("LeafUv9")) {
                                leafMesh = new LeafUv9();
                            } else if (string.equals("LeafUv10")) {
                                leafMesh = new LeafUv10();
                            } else if (string.equals("LeafUv11")) {
                                leafMesh = new LeafUv11();
                            } else if (string.equals("LeafUv12")) {
                                leafMesh = new LeafUv12();
                            }
                            if (tableLeaf.getLatitudinal() != null) {
                                leafMesh.setLatitudinal(tableLeaf.getLatitudinal());
                            }
                            if (tableLeaf.getLongitudinal() != null) {
                                leafMesh.setLongitudinal(tableLeaf.getLongitudinal());
                            }
                            leafMesh.setTextureIndex(n);
                            leafMesh.buildLeaf();
                        } else if (this.leafType.equals("Mesh3")) {
                            leafMesh = new Leaf3();
                        } else if (this.leafType.equals("Mesh4")) {
                            leafMesh = new Leaf4();
                        } else if (this.leafType.equals("Mesh4a")) {
                            leafMesh = new Leaf4a();
                        } else if (this.leafType.equals("Mesh6a")) {
                            leafMesh = new Leaf6a();
                        } else if (this.leafType.equals("Mesh6b")) {
                            leafMesh = new Leaf6b();
                        } else if (this.leafType.equals("Mesh10")) {
                            leafMesh = new Leaf10();
                        } else if (this.leafType.equals("Mesh12a")) {
                            leafMesh = new Leaf12a();
                        } else if (this.leafType.equals("Mesh12b")) {
                            leafMesh = new Leaf12b();
                        } else if (this.leafType.equals("Mesh24")) {
                            leafMesh = new Leaf24();
                        } else if (this.leafType.equals("CustomMesh")) {
                            leafMesh = this.parseCustomMesh(this.p.customMesh);
                        }
                    } else {
                        blob = new Blob(0.5f, 1.0f);
                        blob.leaf = true;
                    }
                    float f2 = (float)((double)this.p.leafLength * (Math.sin(f * 5.73f * (float)Math.PI) + 4.0) / 4.0);
                    float f3 = (float)((double)this.p.leafHeight * (Math.sin(f * 3.16f * (float)Math.PI) + 4.0) / 4.0);
                    float f4 = (float)((double)this.p.leafBreadth * (Math.sin(f * 7.99f * (float)Math.PI) + 4.0) / 4.0);
                    if (this.isMesh) {
                        leafMesh.scale(f2, f3, f4);
                    } else {
                        blob.scale(f2, f3, f4);
                    }
                    f2 = (float)((double)this.p.maxLeafTilt * Math.sin(7.11f * f * (float)Math.PI));
                    f3 = 0.0f;
                    f4 = (float)((double)(-this.p.leafInclination) + (double)this.p.leafInclinationScope * Math.sin(7.31f * f * (float)Math.PI));
                    if (this.isMesh) {
                        leafMesh.rotate(f2, f3, f4);
                    } else {
                        blob.rotate(f2, f3, f4);
                    }
                    f2 = (float)((double)this.p.maxLeafTurn * Math.sin(7.17f * f * (float)Math.PI));
                    if (this.isMesh) {
                        leafMesh.rotateY(f2);
                    } else {
                        blob.rotateY(f2);
                    }
                    f2 = (float)((double)this.p.bunchMajorRadius + (double)this.p.bunchMinorRadius * (1.0 + Math.sin(Math.sin(18.598228f * f) * 3.1415927410125732 * (double)32.1f)) / 2.0);
                    if (this.isMesh) {
                        leafMesh.translate(f2, 0.0f, 0.0f);
                    } else {
                        blob.translate(f2, 0.0f, 0.0f);
                    }
                    if (this.p.rotationBunchFunnel > 0.0f) {
                        f2 = (float)((double)(-this.p.rotationBunchFunnel / 4.0f) * (1.0 + Math.sin(Math.sin(7.4455743f * f) * 3.1415927410125732 * (double)12.3f + 0.6283185482025146)));
                        if (this.isMesh) {
                            leafMesh.rotateZ(f2);
                        } else {
                            blob.rotateZ(f2);
                        }
                        f2 = (float)(777.0 * Math.sin(2.37f * f * (float)Math.PI));
                        if (this.isMesh) {
                            leafMesh.rotateX(f2);
                        } else {
                            blob.rotateX(f2);
                        }
                    } else {
                        f2 = (float)((double)(this.p.verticalBunchFunnel / 2.0f) * Math.sin(Math.sin(23.153538f * f) * 3.1415927410125732 * (double)12.3f + 1.0471975803375244));
                        if (this.isMesh) {
                            leafMesh.rotateZ(f2);
                        } else {
                            blob.rotateZ(f2);
                        }
                        f2 = (float)((double)(this.p.horizontalBunchFunnel / 2.0f) * Math.sin(Math.sin(7.4455743f * f) * 3.1415927410125732 * (double)12.3f + 0.6283185482025146));
                        if (this.isMesh) {
                            leafMesh.rotateY(f2);
                        } else {
                            blob.rotateY(f2);
                        }
                    }
                    f += 100.0f / this.p.leaves * this.p.bunches;
                    if (this.isMesh) {
                        this.bunchMesh.add(leafMesh);
                        continue;
                    }
                    this.bunchLeaves.add(blob);
                }
            } else {
                if (this.isMesh) {
                    if (this.leafType.equals("Mesh1")) {
                        leafMesh = new Leaf1();
                    } else if (this.leafType.equals("LeafUv")) {
                        TableLeaf tableLeaf;
                        String string;
                        ArrayList arrayList = this.p.leafUvType;
                        int n = 0;
                        if (arrayList != null && arrayList.size() > 1) {
                            n = random.nextInt(arrayList.size());
                        }
                        if ((string = (tableLeaf = (TableLeaf)arrayList.get(n)).getLeafUvName()).equals("LeafUv1")) {
                            leafMesh = new LeafUv1();
                        } else if (string.equals("LeafUv2")) {
                            leafMesh = new LeafUv2();
                        } else if (string.equals("LeafUv3")) {
                            leafMesh = new LeafUv3();
                        } else if (string.equals("LeafUv4")) {
                            leafMesh = new LeafUv4();
                        } else if (string.equals("LeafUv5")) {
                            leafMesh = new LeafUv5();
                        } else if (string.equals("LeafUv6")) {
                            leafMesh = new LeafUv6();
                        } else if (string.equals("LeafUv7")) {
                            leafMesh = new LeafUv7();
                        } else if (string.equals("LeafUv8")) {
                            leafMesh = new LeafUv8();
                        } else if (string.equals("LeafUv9")) {
                            leafMesh = new LeafUv9();
                        } else if (string.equals("LeafUv10")) {
                            leafMesh = new LeafUv10();
                        } else if (string.equals("LeafUv11")) {
                            leafMesh = new LeafUv11();
                        } else if (string.equals("LeafUv12")) {
                            leafMesh = new LeafUv12();
                        }
                        if (tableLeaf.getLatitudinal() != null) {
                            leafMesh.setLatitudinal(tableLeaf.getLatitudinal());
                        }
                        if (tableLeaf.getLongitudinal() != null) {
                            leafMesh.setLongitudinal(tableLeaf.getLongitudinal());
                        }
                        leafMesh.setTextureIndex(n);
                        leafMesh.buildLeaf();
                    } else if (this.leafType.equals("Mesh3")) {
                        leafMesh = new Leaf3();
                    } else if (this.leafType.equals("Mesh4")) {
                        leafMesh = new Leaf4();
                    } else if (this.leafType.equals("Mesh4a")) {
                        leafMesh = new Leaf4a();
                    } else if (this.leafType.equals("Mesh6a")) {
                        leafMesh = new Leaf6a();
                    } else if (this.leafType.equals("Mesh6b")) {
                        leafMesh = new Leaf6b();
                    } else if (this.leafType.equals("Mesh10")) {
                        leafMesh = new Leaf10();
                    } else if (this.leafType.equals("Mesh12a")) {
                        leafMesh = new Leaf12a();
                    } else if (this.leafType.equals("Mesh12b")) {
                        leafMesh = new Leaf12b();
                    } else if (this.leafType.equals("Mesh24")) {
                        leafMesh = new Leaf24();
                    } else if (this.leafType.equals("CustomMesh")) {
                        leafMesh = this.parseCustomMesh(this.p.customMesh);
                    }
                } else {
                    blob = new Blob(0.5f, 1.0f);
                    blob.leaf = true;
                }
                if (this.isMesh) {
                    leafMesh.scale(this.p.leafLength, this.p.leafHeight, this.p.leafBreadth);
                    leafMesh.rotate(this.p.maxLeafTilt, 0.0f, -this.p.leafInclination);
                    leafMesh.rotateY(this.p.maxLeafTurn);
                    leafMesh.translate(this.p.bunchMajorRadius + this.p.bunchMinorRadius, 0.0f, 0.0f);
                    this.bunchMesh.add(leafMesh);
                } else {
                    blob.scale(this.p.leafLength, this.p.leafHeight, this.p.leafBreadth);
                    blob.rotate(this.p.maxLeafTilt, 0.0f, -this.p.leafInclination);
                    blob.rotateY(this.p.maxLeafTurn);
                    blob.translate(this.p.bunchMajorRadius + this.p.bunchMinorRadius, 0.0f, 0.0f);
                    this.bunchLeaves.add(blob);
                }
            }
            if (this.isMesh) {
                this.bunchMesh.trimToSize();
            } else {
                this.bunchLeaves.trimToSize();
            }
        }
    }

    public Object generate() throws PovtreeException, InterruptedException {
        if (this.p.leafLength * this.p.leafHeight * this.p.leafBreadth > 0.0f && this.p.branches >= 1.0f && this.p.twigs >= 1.0f && this.p.leaves >= 1.0f && this.p.bunches >= 1.0f) {
            this.generateDeclarations();
            if (this.isMesh) {
                this.leavesMesh = new QuadroLeafArray(50);
            } else {
                this.leaves = new QuadroBlobArray(50);
            }
            float f = 1.0f;
            TripleBlobArray tripleBlobArray = null;
            TripleLeafArray tripleLeafArray = null;
            DoubleBlobArray doubleBlobArray = null;
            DoubleLeafArray doubleLeafArray = null;
            while (f < 100.0f) {
                this.checkThreadStatus();
                float f2 = 1.0f;
                if (this.isMesh) {
                    tripleLeafArray = new TripleLeafArray(50);
                } else {
                    tripleBlobArray = new TripleBlobArray(50);
                }
                while (f2 < this.p.bh) {
                    float f3 = 1.0f;
                    if (this.isMesh) {
                        doubleLeafArray = new DoubleLeafArray(50);
                    } else {
                        doubleBlobArray = new DoubleBlobArray(50);
                    }
                    while (f3 < this.p.zl) {
                        Transformable transformable = this.isMesh ? (Transformable)this.bunchMesh.clone() : (Transformable)this.bunchLeaves.clone();
                        float f4 = this.p.bunchDeformX;
                        float f5 = this.p.bunchDeformY;
                        float f6 = this.p.bunchDeformZ;
                        transformable.scale(f4, f5, f6);
                        float f7 = (float)Math.sin((float)Math.PI * (f3 * ((this.p.bunches / this.p.twigs + 1.0f) / (this.p.bunches / this.p.twigs)) / this.p.zl));
                        f4 = 1.0f + this.p.bunchArcAtTwigX * f7;
                        f5 = 1.0f + this.p.bunchArcAtTwigY * f7;
                        f6 = 1.0f + this.p.bunchArcAtTwigZ * f7;
                        transformable.scale(f4, f5, f6);
                        f7 = (float)Math.sin((float)Math.PI * (f2 * ((this.p.twigs / this.p.branches + 1.0f) / (this.p.twigs / this.p.branches)) / this.p.bh));
                        f4 = 1.0f + this.p.bunchArcAtBranchX * f7;
                        f5 = 1.0f + this.p.bunchArcAtBranchY * f7;
                        f6 = 1.0f + this.p.bunchArcAtBranchZ * f7;
                        transformable.scale(f4, f5, f6);
                        f4 = (float)(-1456.0 * Math.cos(this.p.branchRandom * 7.19f * f2 * (float)Math.PI) * (1.0 - (double)this.p.twigAlternateSwitch));
                        transformable.rotateX(f4);
                        f4 = (float)(-1234.0 * Math.sin(7.77f * f3 * (float)Math.PI) * (double)this.p.bunchTurnShift);
                        transformable.rotateX(f4);
                        f4 = (float)(-1234.0 * Math.sin(7.77f * f2 * (float)Math.PI) * (double)this.p.bunchTurnShift);
                        transformable.rotateX(f4);
                        f4 = (float)((double)(-this.p.branchSpiral) * Math.sin((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl) / this.p.bh * 1.5707964f));
                        transformable.rotateX(f4);
                        f4 = (float)(-1234.0 * Math.sin(this.p.twigRandom * 4.77f * f * (float)Math.PI) * (double)(1.0f - this.p.twigAlternateSwitch));
                        transformable.rotateX(f4);
                        f4 = (float)((double)(-this.p.branchSpiral) * Math.sin((this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh * 1.5707964f));
                        transformable.rotateX(f4);
                        f4 = (float)((double)(this.p.horizontalBunchAngleScope / 2.0f) * Math.sin(7.77 * (double)f3 * 3.1415927410125732));
                        transformable.rotateX(f4);
                        f7 = this.p.bunches / this.p.twigs > 1.0f ? -(this.p.verticalBunchAngle * (f3 * f3) / (this.p.zl * this.p.zl) * this.p.verticalBunchAlignment) : 0.0f;
                        f4 = (float)((double)(this.p.verticalBunchAngleScope / 2.0f) * Math.sin(9.77f * f3 * (float)Math.PI) + (double)(this.p.verticalBunchAngle + f7));
                        transformable.rotateZ(f4);
                        f7 = (double)(this.p.bunches / this.p.twigs) == 1.0 ? (float)((double)(this.p.horizontalBunchAngle - this.p.horizontalBunchAngle * (f2 * f2) / (this.p.bh * this.p.bh) * this.p.horizontalBunchAlignment) * ((double)(1.0f - this.p.bunchAlternateSwitch) + (double)this.p.bunchAlternateSwitch * Math.sin((f2 / (this.p.bh / this.p.twigs * this.p.branches) - 1.0f / (this.p.bh / this.p.twigs * this.p.branches)) * (float)Math.PI - 1.5707964f))) : (float)((double)(-(this.p.horizontalBunchAngle * (f3 * f3) / (this.p.zl * this.p.zl) * this.p.horizontalBunchAlignment)) * ((double)(1.0f - this.p.bunchAlternateSwitch) + (double)this.p.bunchAlternateSwitch * Math.sin((f3 / (this.p.zl / (this.p.bunches / this.p.twigs)) - 1.0f / (this.p.zl / (this.p.bunches / this.p.twigs))) * (float)Math.PI - 1.5707964f)));
                        f4 = f7;
                        transformable.rotateY(f4);
                        f4 = (float)(1234.0 * Math.sin(7.77f * f3 * (float)Math.PI) * (double)this.p.bunchTurnSwitch);
                        transformable.rotateX(f4);
                        f4 = (float)(1234.0 * Math.sin(7.77f * f2 * (float)Math.PI) * (double)this.p.bunchTurnSwitch);
                        transformable.rotateX(f4);
                        f4 = 1.0f - this.p.bunchTaperOffAtTree * f / 100.0f;
                        transformable.scale(f4);
                        f4 = 1.0f - this.p.bunchTaperOffAtTwig * f3 / this.p.zl;
                        transformable.scale(f4);
                        f4 = 1.0f - this.p.bunchTaperOffAtBranch * f2 / this.p.bh;
                        transformable.scale(f4);
                        f4 = 90.0f;
                        transformable.rotateZ(f4);
                        f4 = (float)(-1234.0 * Math.sin(4.77f * f2 * (float)Math.PI) * (double)this.p.twigTurnSwitch);
                        transformable.rotateY(f4);
                        f7 = (this.p.bh - (this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh * (this.p.zwl / this.p.bh) * this.p.twigCurveAdjustment * (1.0f - f / 100.0f * this.p.straightenTowardsTop) * (1.0f - f2 / this.p.bh * this.p.straightenTowardsBranchEnd);
                        f4 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.123 * (double)this.p.branchSnagFrequency * (double)this.p.zbfza * (double)((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / (double)this.p.bh)) * (double)f7);
                        f5 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(4.789 * (double)this.p.branchSnagFrequency * (double)this.p.zbfza * (double)((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / (double)this.p.bh)) * (double)f7);
                        f6 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.456 * (double)this.p.branchSnagFrequency * (double)this.p.zbfza * (double)((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / (double)this.p.bh)) * (double)f7);
                        transformable.translate(f4, f5, f6);
                        f7 = (this.p.bh - (this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh * (this.p.zwl / this.p.bh) * this.p.twigCurveAdjustment * (1.0f - f / 100.0f * this.p.straightenTowardsTop) * (1.0f - f2 / this.p.bh * this.p.straightenTowardsBranchEnd);
                        f4 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchCurveFrequency * this.p.zbfza * ((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh)) * (double)f7);
                        f5 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchCurveFrequency * this.p.zbfza * ((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh)) * (double)f7);
                        f6 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchCurveFrequency * this.p.zbfza * ((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh)) * (double)f7);
                        transformable.translate(f4, f5, f6);
                        f7 = this.p.zwl / this.p.bh;
                        f4 = (float)((double)this.p.abg * Math.sin((double)(this.p.extraNoiseSwitch * (float)Math.PI / 2.0f) * Math.sin(5.371f * this.p.abfz * this.p.zbfza * ((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh) + (double)((1.0f - this.p.extraNoiseSwitch) * 5.371f * this.p.abfz * this.p.zbfza * ((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh)) * (double)f7 * (double)this.p.twigCurveAdjustment * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop) * (double)(1.0f - f2 / this.p.bh * this.p.straightenTowardsBranchEnd));
                        f5 = (this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl) * f7;
                        f6 = (float)((double)this.p.abg * Math.sin(1.5707963705062866 * Math.sin(5.937 * (double)this.p.abfz * (double)this.p.zbfza * (double)((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / (double)this.p.bh)) * (double)this.p.horizontalBranchBendSwitch * (double)f7 * (double)this.p.twigCurveAdjustment * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop) * (double)(1.0f - f2 / this.p.bh * this.p.straightenTowardsBranchEnd));
                        transformable.translate(f4, f5, f6);
                        f4 = (float)((double)this.p.branchSpiral * Math.sin((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl) / this.p.bh * 1.5707964f));
                        transformable.rotateY(f4);
                        f4 = (float)(1234.0 * Math.sin(4.77f * f2 * (float)Math.PI) * (double)this.p.twigTurnSwitch);
                        transformable.rotateY(f4);
                        f4 = (this.p.firstTwigAtBranch + this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper) - this.p.firstTwigAtBranch * this.p.branchTaper * this.p.astl / this.p.bh) / (this.p.firstTwigAtBranch + this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper));
                        transformable.scale(f4);
                        f4 = (this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper) - f2 * this.p.branchTaper * this.p.twigAreaAtBranch / this.p.bh) / (this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper));
                        transformable.scale(f4);
                        f4 = this.p.bh / this.p.astl;
                        transformable.scale(f4);
                        f4 = -90.0f;
                        transformable.rotateZ(f4);
                        f4 = (float)((double)this.p.verticalTwigAngleScope * Math.sin(9.77f * f2 * f2 * (float)Math.PI) + (double)(this.p.verticalTwigAngle - this.p.verticalTwigAngle * (f2 * f2) / (this.p.bh * this.p.bh) * this.p.verticalTwigAlignment));
                        transformable.rotateZ(f4);
                        f4 = (float)(((double)this.p.horizontalTwigAngleScope * Math.sin(7.77f * f2 * f2 * (float)Math.PI) + (double)(this.p.horizontalTwigAngle - this.p.horizontalTwigAngle * (f2 * f2) / (this.p.bh * this.p.bh) * this.p.horizontalTwigAlignment)) * ((double)(1.0f - this.p.twigAlternateSwitch) + (double)this.p.twigAlternateSwitch * Math.sin((f2 / (this.p.bh / this.p.twigs * this.p.branches) - 1.0f / (this.p.bh / this.p.twigs * this.p.branches)) * (float)Math.PI - 1.5707964f)));
                        transformable.rotateY(f4);
                        f4 = (float)(1456.0 * Math.cos(this.p.branchRandom * 7.19f * f2 * (float)Math.PI) * (double)(1.0f - this.p.twigAlternateSwitch));
                        transformable.rotateX(f4);
                        f4 = 90.0f;
                        transformable.rotateZ(f4);
                        f4 = (float)(1234.0 * Math.sin(this.p.twigRandom * 4.77f * f * (float)Math.PI) * (double)(1.0f - this.p.twigAlternateSwitch));
                        transformable.rotateY(f4);
                        f4 = (float)(-1234.0 * Math.sin(4.77f * f * (float)Math.PI) * (double)this.p.branchTurnSwitch);
                        transformable.rotateY(f4);
                        f7 = (this.p.bh - (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh)) / this.p.bh * (1.0f - f / 100.0f * this.p.straightenTowardsTop);
                        f4 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchSnagFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7);
                        f5 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchSnagFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7);
                        f6 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchSnagFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7);
                        transformable.translate(f4, f5, f6);
                        f7 = (this.p.bh - (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh)) / this.p.bh;
                        f4 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchCurveFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7 * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                        f5 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchCurveFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7 * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop) * (double)this.p.branchLongitudinalCurve);
                        f6 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchCurveFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7 * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop) * (double)this.p.horizontalBranchCurveSwitch);
                        transformable.translate(f4, f5, f6);
                        f4 = (float)(-((double)this.p.abg * Math.sin((double)(this.p.extraNoiseSwitch * (float)Math.PI / 2.0f) * Math.sin(5.371f * this.p.abfz * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh) + (double)(1.0f - this.p.extraNoiseSwitch) * (5.371 * (double)this.p.abfz * (double)(this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / (double)this.p.bh))) * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                        f5 = this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh;
                        f6 = (float)((double)this.p.abg * Math.sin((double)(this.p.extraNoiseSwitch * (float)Math.PI / 2.0f) * Math.sin(5.937f * this.p.abfz * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh) + (1.0 - (double)this.p.extraNoiseSwitch) * (double)(5.937f * this.p.abfz * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)this.p.horizontalBranchBendSwitch * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                        transformable.translate(f4, f5, f6);
                        f4 = (float)((double)this.p.branchSpiral * Math.sin((this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh * 1.5707964f));
                        transformable.rotateY(f4);
                        f4 = (float)(1234.0 * Math.sin(4.77f * f * (float)Math.PI) * (double)this.p.branchTurnSwitch);
                        transformable.rotateY(f4);
                        f4 = -90.0f;
                        transformable.rotateZ(f4);
                        f4 = this.p.astl / this.p.bh * (1.0f - f / 100.0f * this.p.branchReduction);
                        transformable.scale(f4);
                        f4 = (float)((double)(this.p.branchAngle + f / 100.0f * (90.0f - this.p.branchAngle) * this.p.branchAlignment) + (double)this.p.branchAngleScope * Math.sin(9.77f * f * f * (float)Math.PI));
                        transformable.rotateZ(f4);
                        f4 = (float)(1456.0 * Math.cos(this.p.branchRandom * 7.19f * f * (float)Math.PI) * (double)(1.0f - this.p.branchAlternateSwitch) + (double)(90.0f * this.p.branchAlternateSwitch) * Math.sin((f / (100.0f / this.p.branches) - 1.0f / (100.0f / this.p.branches)) * (float)Math.PI - 1.5707964f) + 90.0);
                        transformable.rotateY(f4);
                        f7 = (this.p.bh - (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f)) / this.p.bh;
                        f4 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.trunkSnagFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f5 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.trunkSnagFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f6 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.trunkSnagFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        transformable.translate(f4, f5, f6);
                        f7 = (this.p.bh - (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f)) / this.p.bh;
                        f4 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.trunkCurveFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f5 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.trunkCurveFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f6 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.trunkCurveFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        transformable.translate(f4, f5, f6);
                        f4 = (float)((double)this.p.trunkBendX * Math.sin(1.5707963705062866 * Math.sin(5.371f * this.p.trunkBendXFrequency * 1.5f * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)));
                        f5 = this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f;
                        f6 = (float)((double)this.p.trunkBendZ * Math.sin(1.5707963705062866 * Math.sin(5.937f * this.p.trunkBendZFrequency * 1.5f * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)));
                        transformable.translate(f4, f5, f6);
                        f4 = (float)((double)this.p.trunkSpiral * Math.sin((this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / (this.p.bh * 3.0f / 5.0f)));
                        transformable.rotateY(f4);
                        f3 += this.p.zl / this.p.bunches * this.p.twigs;
                        if (this.isMesh) {
                            doubleLeafArray.add((LeafArray)((LeafArray)transformable).clone());
                            continue;
                        }
                        doubleBlobArray.add((BlobArray)((BlobArray)transformable).clone());
                    }
                    f2 += this.p.bh / this.p.twigs * this.p.branches;
                    if (this.isMesh) {
                        tripleLeafArray.add((DoubleLeafArray)doubleLeafArray.clone());
                        continue;
                    }
                    tripleBlobArray.add((DoubleBlobArray)doubleBlobArray.clone());
                }
                f += 100.0f / this.p.branches;
                if (this.isMesh) {
                    this.leavesMesh.add((TripleLeafArray)tripleLeafArray.clone());
                    continue;
                }
                this.leaves.add((TripleBlobArray)tripleBlobArray.clone());
            }
        }
        if (this.isMesh) {
            if (this.leavesMesh != null) {
                this.leavesMesh.trimToSize();
                this.result = this.leavesMesh;
            } else {
                this.result = null;
            }
        } else if (this.leaves != null) {
            this.leaves.trimToSize();
            this.result = this.leaves;
        } else {
            this.result = null;
        }
        return this.result;
    }

    public LeafMesh parseCustomMesh(String string) throws PovtreeException {
        LeafMesh leafMesh = new LeafMesh();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 != -1) {
            n3 = string.indexOf("triangle", n2);
            n2 = n3 + 1;
            if (n3 == -1) continue;
            ++n;
        }
        if (n == 0) {
            throw new PovtreeException(this.messages.getString("noTriangles"));
        }
        leafMesh.name = "CustomMesh";
        leafMesh.triangles = new ArrayList(n);
        n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n2 = string.indexOf("{", n3);
            String string2 = string.substring(n2 + 1, n3 = string.indexOf("}", n2));
            if (string2 != null && string2.length() != 0) {
                string2 = string2.replace('<', ' ');
                string2 = string2.replace('>', ' ');
                string2.trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                float[] fArray = new float[9];
                int n5 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    fArray[n5] = new Float(stringTokenizer.nextToken().trim()).floatValue();
                    ++n5;
                }
                Triangle triangle = new Triangle(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7], fArray[8]);
                leafMesh.triangles.add(triangle);
            }
            ++n4;
        }
        return leafMesh;
    }
}

