/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import java.util.ResourceBundle;
import povtree.gui.PovTree;
import povtree.gui.PovtreeException;
import povtree.gui.Resources;
import povtree.interfaces.Constants;
import povtree.interfaces.Generator;
import povtree.interfaces.Leaf;
import povtree.objects.Foliage;
import povtree.objects.Tree;
import povtree.objects3D.Blob;
import povtree.objects3D.Coordinate;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.DoubleLeafArray;
import povtree.objects3D.LeafArray;
import povtree.objects3D.QuadroBlobArray;
import povtree.objects3D.QuadroLeafArray;
import povtree.objects3D.QuintetBlobArray;
import povtree.objects3D.Tree3D;
import povtree.objects3D.Triangle;
import povtree.objects3D.TripleBlobArray;
import povtree.objects3D.TripleLeafArray;
import povtree.povTreeGenerator.Accuracy;
import povtree.povTreeGenerator.Parameters;
import povtree.povTreeGenerator.Statistics;

public class Mesh2Generator
implements Constants,
Generator {
    private Tree t;
    private Tree3D tree;
    private BufferedOutputStream bos;
    private Accuracy accuracy;
    private Parameters p;
    private ArrayList prev = null;
    private boolean start = false;
    private float uvX;
    private float uvY;
    private String imageType;
    private String imageName;
    private String bumpType;
    private String bumpName;
    private String bumpSize;
    private short VERTEX = 0;
    private short TRIANGLES = 1;
    private short UV = (short)2;
    private Statistics st = null;
    private boolean countBytes = false;
    private long numberOfBytes = 0L;
    private Resources resources = Resources.getInstance();
    private ResourceBundle messages = Resources.getMessagesBundle();
    private PovTree frame = null;

    public Mesh2Generator(Tree tree, Tree3D tree3D, BufferedOutputStream bufferedOutputStream, Accuracy accuracy, String string, String string2, String string3, String string4, String string5, boolean bl, PovTree povTree) throws NumberFormatException {
        this.t = tree;
        this.p = new Parameters(this.t);
        this.tree = tree3D;
        this.bos = bufferedOutputStream;
        this.accuracy = accuracy;
        this.imageType = string;
        this.imageName = string2;
        this.bumpType = string3;
        this.bumpName = string4;
        this.bumpSize = string5;
        this.st = new Statistics(this.tree, this.accuracy);
        this.countBytes = bl;
        this.frame = povTree;
    }

    public void checkThreadStatus() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public void generateMesh() throws PovtreeException, IOException, InterruptedException {
        QuintetBlobArray quintetBlobArray;
        TripleBlobArray tripleBlobArray;
        DoubleBlobArray doubleBlobArray;
        ArrayList arrayList;
        DoubleBlobArray doubleBlobArray2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        ArrayList arrayList2;
        int n6;
        Object object;
        QuadroLeafArray quadroLeafArray;
        String string = new String();
        this.declareTextures();
        if (this.t.getFoliageFlag()) {
            if (this.tree.getFoliage() instanceof QuadroBlobArray) {
                throw new PovtreeException(this.messages.getString("calculateMeshLeaves"));
            }
            quadroLeafArray = (QuadroLeafArray)this.tree.getFoliage();
            if (quadroLeafArray != null) {
                this.frame.updateStatus(0, "calculatingFoliage");
                if (this.t.getFoliage().type.startsWith("LeafUv")) {
                    ArrayList arrayList3 = this.t.getFoliage().leafArrayElements;
                    if (arrayList3 != null) {
                        this.generateUvLeaves(quadroLeafArray, arrayList3.size());
                    }
                } else {
                    this.generateLeaves(quadroLeafArray);
                }
                if (this.bos == null) {
                    this.frame.updateStatus(20, "calculatingBlossom");
                } else {
                    this.frame.updateStatus(20, "savingBlossom");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(20, "calculatingBlossom");
            } else {
                this.frame.updateStatus(20, "savingBlossom");
            }
        }
        if (this.t.getBlossomFlag()) {
            if (this.tree.getBlossom() instanceof QuadroBlobArray) {
                throw new PovtreeException(this.messages.getString("calculateMeshBlossom"));
            }
            quadroLeafArray = (QuadroLeafArray)this.tree.getBlossom();
            if (quadroLeafArray != null) {
                this.generateBlossom(quadroLeafArray);
                if (this.bos == null) {
                    this.frame.updateStatus(40, "calculatingRoots");
                } else {
                    this.frame.updateStatus(40, "savingRoots");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(40, "calculatingRoots");
            } else {
                this.frame.updateStatus(40, "savingRoots");
            }
        }
        long l = this.st.getNumberOfVertexes();
        if (this.t.getRootFlag() || this.t.getTrunkFlag() || this.t.getBranchesFlag() || this.t.getTwigsFlag() || this.t.getRamiFlag()) {
            string = "#declare WOOD = mesh2 {" + Constants.EOL + "vertex_vectors {" + Constants.EOL + l + "," + Constants.EOL;
            if (!this.countBytes) {
                this.bos.write(string.getBytes());
                this.bos.flush();
            } else {
                this.numberOfBytes += (long)string.length();
            }
        }
        if (this.t.getRootFlag()) {
            object = this.tree.getRoot();
            if (object != null) {
                n6 = 0;
                while (n6 < ((DoubleBlobArray)object).size()) {
                    this.checkThreadStatus();
                    arrayList2 = ((DoubleBlobArray)object).get(n6).get();
                    this.generateTreeElement(arrayList2, this.accuracy.rootRadial, this.accuracy.rootVertical, this.VERTEX, 0L);
                    ++n6;
                }
                if (this.bos == null) {
                    this.frame.updateStatus(50, "calculatingTrunk");
                } else {
                    this.frame.updateStatus(50, "savingTrunk");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(50, "calculatingTrunk");
            } else {
                this.frame.updateStatus(50, "savingTrunk");
            }
        }
        if (this.t.getTrunkFlag()) {
            object = this.tree.getTrunk().get();
            if (object != null && ((ArrayList)object).size() != 0) {
                this.generateTreeElement((ArrayList)object, this.accuracy.trunkRadial, this.accuracy.trunkVertical, this.VERTEX, 0L);
                if (this.bos == null) {
                    this.frame.updateStatus(60, "calculatingBranches");
                } else {
                    this.frame.updateStatus(60, "savingBranches");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(60, "calculatingBranches");
            } else {
                this.frame.updateStatus(60, "savingBranches");
            }
        }
        if (this.t.getBranchesFlag()) {
            object = this.tree.getBranches();
            if (object != null) {
                n6 = 0;
                while (n6 < ((DoubleBlobArray)object).size()) {
                    this.checkThreadStatus();
                    arrayList2 = ((DoubleBlobArray)object).get(n6).get();
                    this.generateTreeElement(arrayList2, this.accuracy.branchRadial, this.accuracy.branchVertical, this.VERTEX, 0L);
                    ++n6;
                }
                if (this.bos == null) {
                    this.frame.updateStatus(70, "calculatingTwigs");
                } else {
                    this.frame.updateStatus(70, "savingTwigs");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(70, "calculatingTwigs");
            } else {
                this.frame.updateStatus(70, "savingTwigs");
            }
        }
        if (this.t.getTwigsFlag()) {
            object = this.tree.getTwigs();
            if (object != null) {
                int n7 = 0;
                while (n7 < ((TripleBlobArray)object).size()) {
                    this.checkThreadStatus();
                    DoubleBlobArray doubleBlobArray3 = ((TripleBlobArray)object).get(n7);
                    int n8 = 0;
                    while (n8 < doubleBlobArray3.size()) {
                        arrayList2 = doubleBlobArray3.get(n8).get();
                        this.generateTreeElement(arrayList2, this.accuracy.twigRadial, this.accuracy.twigVertical, this.VERTEX, 0L);
                        ++n8;
                    }
                    ++n7;
                }
                if (this.bos == null) {
                    this.frame.updateStatus(80, "calculatingRami");
                } else {
                    this.frame.updateStatus(80, "savingRami");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(80, "calculatingRami");
            } else {
                this.frame.updateStatus(80, "savingRami");
            }
        }
        if (this.t.getRamiFlag()) {
            QuintetBlobArray quintetBlobArray2 = this.tree.getRami();
            if (quintetBlobArray2 != null) {
                n5 = 0;
                while (n5 < quintetBlobArray2.size()) {
                    this.checkThreadStatus();
                    object = quintetBlobArray2.get(n5);
                    n4 = 0;
                    while (n4 < ((QuadroBlobArray)object).size()) {
                        TripleBlobArray tripleBlobArray2 = ((QuadroBlobArray)object).get(n4);
                        n3 = 0;
                        while (n3 < tripleBlobArray2.size()) {
                            DoubleBlobArray doubleBlobArray4 = tripleBlobArray2.get(n3);
                            n2 = 0;
                            while (n2 < doubleBlobArray4.size()) {
                                arrayList2 = doubleBlobArray4.get(n2).get();
                                this.generateTreeElement(arrayList2, this.accuracy.ramiRadial, this.accuracy.ramiVertical, this.VERTEX, 0L);
                                ++n2;
                            }
                            ++n3;
                        }
                        ++n4;
                    }
                    ++n5;
                }
                this.frame.updateStatus(90, "transformingTree");
            } else {
                this.frame.updateStatus(90, "transformingTree");
            }
        }
        if (this.imageName != null && this.imageType != null) {
            object = new String("}" + Constants.EOL + "uv_vectors {" + Constants.EOL + l + "," + Constants.EOL);
            if (!this.countBytes) {
                this.bos.write(((String)object).getBytes());
                this.bos.flush();
            } else {
                this.numberOfBytes += (long)((String)object).length();
            }
            if (this.t.getRootFlag()) {
                DoubleBlobArray doubleBlobArray5 = this.tree.getRoot();
                if (doubleBlobArray5 != null) {
                    this.frame.updateStatus(0, "calculatingRoots");
                    int n9 = 0;
                    while (n9 < doubleBlobArray5.size()) {
                        this.checkThreadStatus();
                        arrayList2 = doubleBlobArray5.get(n9).get();
                        this.generateTreeElement(arrayList2, this.accuracy.rootRadial, this.accuracy.rootVertical, this.UV, 0L);
                        ++n9;
                    }
                    if (this.bos == null) {
                        this.frame.updateStatus(10, "calculatingTrunk");
                    } else {
                        this.frame.updateStatus(10, "savingTrunk");
                    }
                } else if (this.bos == null) {
                    this.frame.updateStatus(10, "calculatingTrunk");
                } else {
                    this.frame.updateStatus(10, "savingTrunk");
                }
            }
            if (this.t.getTrunkFlag()) {
                ArrayList arrayList4 = this.tree.getTrunk().get();
                if (arrayList4 != null && arrayList4.size() != 0) {
                    this.generateTreeElement(arrayList4, this.accuracy.trunkRadial, this.accuracy.trunkVertical, this.UV, 0L);
                    if (this.bos == null) {
                        this.frame.updateStatus(20, "calculatingBranches");
                    } else {
                        this.frame.updateStatus(20, "savingBranches");
                    }
                } else if (this.bos == null) {
                    this.frame.updateStatus(20, "calculatingBranches");
                } else {
                    this.frame.updateStatus(20, "savingBranches");
                }
            }
            if (this.t.getBranchesFlag()) {
                DoubleBlobArray doubleBlobArray6 = this.tree.getBranches();
                if (doubleBlobArray6 != null) {
                    int n10 = 0;
                    while (n10 < doubleBlobArray6.size()) {
                        this.checkThreadStatus();
                        arrayList2 = doubleBlobArray6.get(n10).get();
                        this.generateTreeElement(arrayList2, this.accuracy.branchRadial, this.accuracy.branchVertical, this.UV, 0L);
                        ++n10;
                    }
                    if (this.bos == null) {
                        this.frame.updateStatus(30, "calculatingTwigs");
                    } else {
                        this.frame.updateStatus(30, "savingTwigs");
                    }
                } else if (this.bos == null) {
                    this.frame.updateStatus(30, "calculatingTwigs");
                } else {
                    this.frame.updateStatus(30, "savingTwigs");
                }
            }
            if (this.t.getTwigsFlag()) {
                TripleBlobArray tripleBlobArray3 = this.tree.getTwigs();
                if (tripleBlobArray3 != null) {
                    int n11 = 0;
                    while (n11 < tripleBlobArray3.size()) {
                        this.checkThreadStatus();
                        DoubleBlobArray doubleBlobArray7 = tripleBlobArray3.get(n11);
                        n5 = 0;
                        while (n5 < doubleBlobArray7.size()) {
                            arrayList2 = doubleBlobArray7.get(n5).get();
                            this.generateTreeElement(arrayList2, this.accuracy.twigRadial, this.accuracy.twigVertical, this.UV, 0L);
                            ++n5;
                        }
                        ++n11;
                    }
                    if (this.bos == null) {
                        this.frame.updateStatus(40, "calculatingRami");
                    } else {
                        this.frame.updateStatus(40, "savingRami");
                    }
                } else if (this.bos == null) {
                    this.frame.updateStatus(40, "calculatingRami");
                } else {
                    this.frame.updateStatus(40, "savingRami");
                }
            }
            if (this.t.getRamiFlag()) {
                QuintetBlobArray quintetBlobArray3 = this.tree.getRami();
                if (quintetBlobArray3 != null) {
                    n4 = 0;
                    while (n4 < quintetBlobArray3.size()) {
                        this.checkThreadStatus();
                        QuadroBlobArray quadroBlobArray = quintetBlobArray3.get(n4);
                        n3 = 0;
                        while (n3 < quadroBlobArray.size()) {
                            TripleBlobArray tripleBlobArray4 = quadroBlobArray.get(n3);
                            n2 = 0;
                            while (n2 < tripleBlobArray4.size()) {
                                DoubleBlobArray doubleBlobArray8 = tripleBlobArray4.get(n2);
                                n = 0;
                                while (n < doubleBlobArray8.size()) {
                                    arrayList2 = doubleBlobArray8.get(n).get();
                                    this.generateTreeElement(arrayList2, this.accuracy.ramiRadial, this.accuracy.ramiVertical, this.UV, 0L);
                                    ++n;
                                }
                                ++n2;
                            }
                            ++n3;
                        }
                        ++n4;
                    }
                    this.frame.updateStatus(50, "transformingTree");
                } else {
                    this.frame.updateStatus(50, "transformingTree");
                }
            }
        }
        if (this.t.getRootFlag() || this.t.getTrunkFlag() || this.t.getBranchesFlag() || this.t.getTwigsFlag() || this.t.getRamiFlag()) {
            object = new String("}" + Constants.EOL + "face_indices {" + Constants.EOL + this.st.getNumberOfWoodTriangles() + "," + Constants.EOL);
            if (!this.countBytes) {
                this.bos.write(((String)object).getBytes());
                this.bos.flush();
            } else {
                this.numberOfBytes += (long)((String)object).length();
            }
        }
        long l2 = 0L;
        if (this.t.getRootFlag() && (doubleBlobArray2 = this.tree.getRoot()) != null) {
            long l3 = this.st.getNumberOfRootFaces();
            long l4 = l3 + (long)this.accuracy.rootRadial;
            n2 = 0;
            while (n2 < doubleBlobArray2.size()) {
                this.checkThreadStatus();
                arrayList2 = doubleBlobArray2.get(n2).get();
                l2 = l4 * (long)n2;
                this.generateTreeElement(arrayList2, this.accuracy.rootRadial, this.accuracy.rootVertical, this.TRIANGLES, l2);
                ++n2;
            }
            l2 += l4;
        }
        if (this.t.getTrunkFlag() && (arrayList = this.tree.getTrunk().get()) != null && arrayList.size() != 0) {
            this.checkThreadStatus();
            this.generateTreeElement(arrayList, this.accuracy.trunkRadial, this.accuracy.trunkVertical, this.TRIANGLES, l2);
            long l5 = this.st.getNumberOfTrunkFaces();
            l2 += l5 + (long)this.accuracy.trunkRadial;
        }
        if (this.t.getBranchesFlag() && (doubleBlobArray = this.tree.getBranches()) != null) {
            long l6 = this.st.getNumberOfBranchFaces();
            long l7 = l6 + (long)this.accuracy.branchRadial;
            n2 = 0;
            while (n2 < doubleBlobArray.size()) {
                this.checkThreadStatus();
                arrayList2 = doubleBlobArray.get(n2).get();
                l6 = l7 * (long)n2;
                this.generateTreeElement(arrayList2, this.accuracy.branchRadial, this.accuracy.branchVertical, this.TRIANGLES, l2 + l6);
                ++n2;
            }
            l2 += l6 + l7;
        }
        if (this.t.getTwigsFlag() && (tripleBlobArray = this.tree.getTwigs()) != null) {
            long l8 = this.st.getNumberOfTwigFaces();
            long l9 = l8 + (long)this.accuracy.twigRadial;
            n = 0;
            while (n < tripleBlobArray.size()) {
                this.checkThreadStatus();
                DoubleBlobArray doubleBlobArray9 = tripleBlobArray.get(n);
                int n12 = 0;
                while (n12 < doubleBlobArray9.size()) {
                    arrayList2 = doubleBlobArray9.get(n12).get();
                    l8 = l9 * (long)n12;
                    this.generateTreeElement(arrayList2, this.accuracy.twigRadial, this.accuracy.twigVertical, this.TRIANGLES, l2 + l8);
                    ++n12;
                }
                l2 += l8 + l9;
                ++n;
            }
        }
        if (this.t.getRamiFlag() && (quintetBlobArray = this.tree.getRami()) != null) {
            long l10 = this.st.getNumberOfRamiFaces();
            long l11 = l10 + (long)this.accuracy.ramiRadial;
            int n13 = 0;
            while (n13 < quintetBlobArray.size()) {
                this.checkThreadStatus();
                QuadroBlobArray quadroBlobArray = quintetBlobArray.get(n13);
                int n14 = 0;
                while (n14 < quadroBlobArray.size()) {
                    TripleBlobArray tripleBlobArray5 = quadroBlobArray.get(n14);
                    int n15 = 0;
                    while (n15 < tripleBlobArray5.size()) {
                        DoubleBlobArray doubleBlobArray10 = tripleBlobArray5.get(n15);
                        int n16 = 0;
                        while (n16 < doubleBlobArray10.size()) {
                            arrayList2 = doubleBlobArray10.get(n16).get();
                            l10 = l11 * (long)n16;
                            this.generateTreeElement(arrayList2, this.accuracy.ramiRadial, this.accuracy.ramiVertical, this.TRIANGLES, l2 + l10);
                            ++n16;
                        }
                        l2 += l10 + l11;
                        ++n15;
                    }
                    ++n14;
                }
                ++n13;
            }
        }
        if (this.t.getRootFlag() || this.t.getTrunkFlag() || this.t.getBranchesFlag() || this.t.getTwigsFlag() || this.t.getRamiFlag()) {
            string = "}" + Constants.EOL + "rotate z*180" + Constants.EOL + "rotate y*180" + Constants.EOL;
            if (!this.countBytes) {
                this.bos.write(string.getBytes());
                this.bos.flush();
            } else {
                this.numberOfBytes += (long)string.length();
            }
            if (this.imageName != null && this.imageType != null) {
                this.setUvTexture();
            } else {
                this.setTexture();
            }
            string = "}" + Constants.EOL;
            if (!this.countBytes) {
                this.bos.write(string.getBytes());
                this.bos.flush();
            } else {
                this.numberOfBytes += (long)string.length();
            }
        }
        boolean bl = false;
        boolean bl2 = this.t.getFoliageFlag();
        boolean bl3 = this.t.getBlossomFlag();
        if (this.t.getRootFlag() || this.t.getTrunkFlag() || this.t.getBranchesFlag() || this.t.getTwigsFlag() || this.t.getRamiFlag()) {
            bl = true;
        }
        if (bl && !bl2 && !bl3 || !bl && bl2 && !bl3 || !bl && !bl2 && bl3) {
            string = "#declare TREE = object {" + Constants.EOL;
            if (bl2) {
                string = string + "FOLIAGE" + Constants.EOL;
            }
            if (bl3) {
                string = string + "BLOSSOM" + Constants.EOL;
            }
            if (bl) {
                string = string + "WOOD" + Constants.EOL;
            }
            string = string + "}" + Constants.EOL;
        } else if (bl && bl2 && bl3 || bl && bl2 && !bl3 || bl && !bl2 && bl3 || !bl && bl2 && bl3) {
            string = "#declare TREE = union {" + Constants.EOL;
            if (bl2) {
                string = string + "object{FOLIAGE}" + Constants.EOL;
            }
            if (bl3) {
                string = string + "object{BLOSSOM}" + Constants.EOL;
            }
            if (bl) {
                string = string + "object{WOOD}" + Constants.EOL;
            }
            string = string + "}" + Constants.EOL;
        }
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        this.checkThreadStatus();
        if (this.bos == null) {
            this.frame.updateStatus(0, "statsDone");
        } else {
            this.frame.updateStatus(0, "savingDone");
        }
    }

    public void generateLeaves(QuadroLeafArray quadroLeafArray) throws IOException, InterruptedException {
        Triangle triangle;
        ArrayList arrayList;
        Leaf leaf;
        LeafArray leafArray;
        DoubleLeafArray doubleLeafArray;
        TripleLeafArray tripleLeafArray;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        String string = "#declare FOLIAGE = mesh2 {" + Constants.EOL + "vertex_vectors {" + Constants.EOL + this.st.getFoliageVertexes() + "," + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        int n = 0;
        while (n < quadroLeafArray.size()) {
            this.checkThreadStatus();
            tripleLeafArray = quadroLeafArray.get(n);
            if (tripleLeafArray != null) {
                int n2 = 0;
                while (n2 < tripleLeafArray.size()) {
                    doubleLeafArray = tripleLeafArray.get(n2);
                    if (doubleLeafArray != null) {
                        int n3 = 0;
                        while (n3 < doubleLeafArray.size()) {
                            leafArray = doubleLeafArray.get(n3);
                            if (leafArray != null) {
                                int n4 = 0;
                                while (n4 < leafArray.size()) {
                                    leaf = leafArray.get(n4);
                                    hashtable = new Hashtable();
                                    arrayList = leaf.getTriangles();
                                    int n5 = 0;
                                    while (n5 < arrayList.size()) {
                                        triangle = (Triangle)arrayList.get(n5);
                                        Coordinate coordinate = triangle.c1;
                                        String string2 = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "<" + coordinate.x + "," + coordinate.y + "," + coordinate.z + ">";
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        Coordinate coordinate2 = triangle.c2;
                                        string2 = String.valueOf(coordinate2.x) + String.valueOf(coordinate2.y) + String.valueOf(coordinate2.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "<" + coordinate2.x + "," + coordinate2.y + "," + coordinate2.z + ">";
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        Coordinate coordinate3 = triangle.c3;
                                        string2 = String.valueOf(coordinate3.x) + String.valueOf(coordinate3.y) + String.valueOf(coordinate3.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "<" + coordinate3.x + "," + coordinate3.y + "," + coordinate3.z + ">";
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        ++n5;
                                    }
                                    string = Constants.EOL;
                                    if (!this.countBytes) {
                                        this.bos.write(string.getBytes());
                                        this.bos.flush();
                                    } else {
                                        this.numberOfBytes += (long)string.length();
                                    }
                                    ++n4;
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        string = "}" + Constants.EOL + "face_indices {" + Constants.EOL + this.st.getFoliageTriangles() + "," + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        long l = this.st.getFoliageVertexes() / this.st.getNumberOfLeaves();
        long l2 = 0L;
        int n6 = 0;
        while (n6 < quadroLeafArray.size()) {
            this.checkThreadStatus();
            tripleLeafArray = quadroLeafArray.get(n6);
            if (tripleLeafArray != null) {
                int n7 = 0;
                while (n7 < tripleLeafArray.size()) {
                    doubleLeafArray = tripleLeafArray.get(n7);
                    if (doubleLeafArray != null) {
                        int n8 = 0;
                        while (n8 < doubleLeafArray.size()) {
                            leafArray = doubleLeafArray.get(n8);
                            if (leafArray != null) {
                                int n9 = 0;
                                while (n9 < leafArray.size()) {
                                    Object object;
                                    Object object2;
                                    leaf = leafArray.get(n9);
                                    arrayList = leaf.getTriangles();
                                    hashtable = new Hashtable();
                                    long l3 = 0L;
                                    int n10 = 0;
                                    while (n10 < arrayList.size()) {
                                        triangle = (Triangle)arrayList.get(n10);
                                        Coordinate coordinate = triangle.c1;
                                        object2 = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l3));
                                            ++l3;
                                        }
                                        object = triangle.c2;
                                        object2 = String.valueOf(((Coordinate)object).x) + String.valueOf(((Coordinate)object).y) + String.valueOf(((Coordinate)object).z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l3));
                                            ++l3;
                                        }
                                        Coordinate coordinate4 = triangle.c3;
                                        object2 = String.valueOf(coordinate4.x) + String.valueOf(coordinate4.y) + String.valueOf(coordinate4.z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l3));
                                            ++l3;
                                        }
                                        ++n10;
                                    }
                                    int n11 = 0;
                                    while (n11 < arrayList.size()) {
                                        triangle = (Triangle)arrayList.get(n11);
                                        object2 = triangle.c1;
                                        object = String.valueOf(((Coordinate)object2).x) + String.valueOf(((Coordinate)object2).y) + String.valueOf(((Coordinate)object2).z);
                                        long l4 = (Long)hashtable.get(object) + l2;
                                        Coordinate coordinate = triangle.c2;
                                        object = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        long l5 = (Long)hashtable.get(object) + l2;
                                        Coordinate coordinate5 = triangle.c3;
                                        object = String.valueOf(coordinate5.x) + String.valueOf(coordinate5.y) + String.valueOf(coordinate5.z);
                                        long l6 = (Long)hashtable.get(object) + l2;
                                        string = "<" + l4 + "," + l5 + "," + l6 + ">";
                                        if (!this.countBytes) {
                                            this.bos.write(string.getBytes());
                                            this.bos.flush();
                                        } else {
                                            this.numberOfBytes += (long)string.length();
                                        }
                                        ++n11;
                                    }
                                    string = Constants.EOL;
                                    if (!this.countBytes) {
                                        this.bos.write(string.getBytes());
                                        this.bos.flush();
                                    } else {
                                        this.numberOfBytes += (long)string.length();
                                    }
                                    l2 += l;
                                    ++n9;
                                }
                            }
                            ++n8;
                        }
                    }
                    ++n7;
                }
            }
            ++n6;
        }
        string = "}" + Constants.EOL + "rotate z*180" + Constants.EOL + "rotate y*180" + Constants.EOL + "texture{LAUB scale 1/" + this.tree.normalizer + "}" + Constants.EOL + "}" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
    }

    public void generateUvLeaves(QuadroLeafArray quadroLeafArray, int n) throws IOException, InterruptedException {
        int n2;
        int n3;
        Triangle triangle;
        ArrayList arrayList;
        Leaf leaf;
        LeafArray leafArray;
        DoubleLeafArray doubleLeafArray;
        int n4;
        TripleLeafArray tripleLeafArray;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Random random = new Random();
        String string = "#declare FOLIAGE = mesh2 {" + Constants.EOL + "vertex_vectors {" + Constants.EOL + this.st.getFoliageVertexes() + "," + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        int n5 = 0;
        while (n5 < quadroLeafArray.size()) {
            this.checkThreadStatus();
            tripleLeafArray = quadroLeafArray.get(n5);
            if (tripleLeafArray != null) {
                n4 = 0;
                while (n4 < tripleLeafArray.size()) {
                    doubleLeafArray = tripleLeafArray.get(n4);
                    if (doubleLeafArray != null) {
                        int n6 = 0;
                        while (n6 < doubleLeafArray.size()) {
                            leafArray = doubleLeafArray.get(n6);
                            if (leafArray != null) {
                                int n7 = 0;
                                while (n7 < leafArray.size()) {
                                    leaf = leafArray.get(n7);
                                    hashtable = new Hashtable();
                                    arrayList = leaf.getTriangles();
                                    int n8 = 0;
                                    while (n8 < arrayList.size()) {
                                        triangle = (Triangle)arrayList.get(n8);
                                        Coordinate coordinate = triangle.c1;
                                        String string2 = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "<" + coordinate.x + "," + coordinate.y + "," + coordinate.z + ">";
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        Coordinate coordinate2 = triangle.c2;
                                        string2 = String.valueOf(coordinate2.x) + String.valueOf(coordinate2.y) + String.valueOf(coordinate2.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "<" + coordinate2.x + "," + coordinate2.y + "," + coordinate2.z + ">";
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        Coordinate coordinate3 = triangle.c3;
                                        string2 = String.valueOf(coordinate3.x) + String.valueOf(coordinate3.y) + String.valueOf(coordinate3.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "<" + coordinate3.x + "," + coordinate3.y + "," + coordinate3.z + ">";
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        ++n8;
                                    }
                                    string = Constants.EOL;
                                    if (!this.countBytes) {
                                        this.bos.write(string.getBytes());
                                        this.bos.flush();
                                    } else {
                                        this.numberOfBytes += (long)string.length();
                                    }
                                    ++n7;
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n5;
        }
        string = "}" + Constants.EOL + "uv_vectors {4, <0,0><1,0><1,1><0,1>}" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        string = "texture_list {" + Constants.EOL + n + "," + Constants.EOL;
        n4 = 0;
        while (n4 < n) {
            string = string + "texture{LeafArray[" + n4 + "]}" + Constants.EOL;
            ++n4;
        }
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        string = "}" + Constants.EOL + "face_indices {" + Constants.EOL + this.st.getFoliageTriangles() + "," + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        long l = this.st.getFoliageVertexes() / this.st.getNumberOfLeaves();
        long l2 = 0L;
        int n9 = 0;
        while (n9 < quadroLeafArray.size()) {
            this.checkThreadStatus();
            tripleLeafArray = quadroLeafArray.get(n9);
            if (tripleLeafArray != null) {
                int n10 = 0;
                while (n10 < tripleLeafArray.size()) {
                    doubleLeafArray = tripleLeafArray.get(n10);
                    if (doubleLeafArray != null) {
                        int n11 = 0;
                        while (n11 < doubleLeafArray.size()) {
                            leafArray = doubleLeafArray.get(n11);
                            if (leafArray != null) {
                                n3 = 0;
                                while (n3 < leafArray.size()) {
                                    Object object;
                                    Object object2;
                                    n2 = 0;
                                    if (n > 1) {
                                        n2 = random.nextInt(n);
                                    }
                                    leaf = leafArray.get(n3);
                                    arrayList = leaf.getTriangles();
                                    hashtable = new Hashtable();
                                    long l3 = 0L;
                                    int n12 = 0;
                                    while (n12 < arrayList.size()) {
                                        triangle = (Triangle)arrayList.get(n12);
                                        Coordinate coordinate = triangle.c1;
                                        object2 = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l3));
                                            ++l3;
                                        }
                                        object = triangle.c2;
                                        object2 = String.valueOf(((Coordinate)object).x) + String.valueOf(((Coordinate)object).y) + String.valueOf(((Coordinate)object).z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l3));
                                            ++l3;
                                        }
                                        Coordinate coordinate4 = triangle.c3;
                                        object2 = String.valueOf(coordinate4.x) + String.valueOf(coordinate4.y) + String.valueOf(coordinate4.z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l3));
                                            ++l3;
                                        }
                                        ++n12;
                                    }
                                    int n13 = 0;
                                    while (n13 < arrayList.size()) {
                                        triangle = (Triangle)arrayList.get(n13);
                                        object2 = triangle.c1;
                                        object = String.valueOf(((Coordinate)object2).x) + String.valueOf(((Coordinate)object2).y) + String.valueOf(((Coordinate)object2).z);
                                        long l4 = (Long)hashtable.get(object) + l2;
                                        Coordinate coordinate = triangle.c2;
                                        object = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        long l5 = (Long)hashtable.get(object) + l2;
                                        Coordinate coordinate5 = triangle.c3;
                                        object = String.valueOf(coordinate5.x) + String.valueOf(coordinate5.y) + String.valueOf(coordinate5.z);
                                        long l6 = (Long)hashtable.get(object) + l2;
                                        string = "<" + l4 + "," + l5 + "," + l6 + ">," + n2 + "," + Constants.EOL;
                                        if (!this.countBytes) {
                                            this.bos.write(string.getBytes());
                                            this.bos.flush();
                                        } else {
                                            this.numberOfBytes += (long)string.length();
                                        }
                                        ++n13;
                                    }
                                    string = Constants.EOL;
                                    if (!this.countBytes) {
                                        this.bos.write(string.getBytes());
                                        this.bos.flush();
                                    } else {
                                        this.numberOfBytes += (long)string.length();
                                    }
                                    l2 += l;
                                    ++n3;
                                }
                            }
                            ++n11;
                        }
                    }
                    ++n10;
                }
            }
            ++n9;
        }
        string = "}" + Constants.EOL + "uv_indices {" + this.st.getFoliageTriangles() + "," + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        int n14 = 0;
        while (n14 < quadroLeafArray.size()) {
            this.checkThreadStatus();
            tripleLeafArray = quadroLeafArray.get(n14);
            if (tripleLeafArray != null) {
                int n15 = 0;
                while (n15 < tripleLeafArray.size()) {
                    doubleLeafArray = tripleLeafArray.get(n15);
                    if (doubleLeafArray != null) {
                        n3 = 0;
                        while (n3 < doubleLeafArray.size()) {
                            leafArray = doubleLeafArray.get(n3);
                            if (leafArray != null) {
                                n2 = 0;
                                while (n2 < leafArray.size()) {
                                    string = "<0,1,2><0,3,2>" + Constants.EOL;
                                    if (!this.countBytes) {
                                        this.bos.write(string.getBytes());
                                        this.bos.flush();
                                    } else {
                                        this.numberOfBytes += (long)string.length();
                                    }
                                    ++n2;
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n15;
                }
            }
            ++n14;
        }
        string = "}" + Constants.EOL + "rotate z*180" + Constants.EOL + "rotate y*180" + Constants.EOL + "texture{LAUB scale 1/" + this.tree.normalizer + "}" + Constants.EOL + "}" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
    }

    public void generateBlossom(QuadroLeafArray quadroLeafArray) throws IOException, InterruptedException {
        Triangle triangle;
        ArrayList arrayList;
        Leaf leaf;
        LeafArray leafArray;
        DoubleLeafArray doubleLeafArray;
        TripleLeafArray tripleLeafArray;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        String string = "#declare BLOSSOM = mesh2 {" + Constants.EOL + "vertex_vectors {" + Constants.EOL + this.st.getBlossomVertexes() + "," + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        int n = 0;
        while (n < quadroLeafArray.size()) {
            this.checkThreadStatus();
            tripleLeafArray = quadroLeafArray.get(n);
            if (tripleLeafArray != null) {
                int n2 = 0;
                while (n2 < tripleLeafArray.size()) {
                    doubleLeafArray = tripleLeafArray.get(n2);
                    if (doubleLeafArray != null) {
                        int n3 = 0;
                        while (n3 < doubleLeafArray.size()) {
                            leafArray = doubleLeafArray.get(n3);
                            if (leafArray != null) {
                                int n4 = 0;
                                while (n4 < leafArray.size()) {
                                    leaf = leafArray.get(n4);
                                    hashtable = new Hashtable();
                                    arrayList = leaf.getTriangles();
                                    int n5 = 0;
                                    while (n5 < arrayList.size()) {
                                        triangle = (Triangle)arrayList.get(n5);
                                        Coordinate coordinate = triangle.c1;
                                        String string2 = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "<" + coordinate.x + "," + coordinate.y + "," + coordinate.z + ">";
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        Coordinate coordinate2 = triangle.c2;
                                        string2 = String.valueOf(coordinate2.x) + String.valueOf(coordinate2.y) + String.valueOf(coordinate2.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "<" + coordinate2.x + "," + coordinate2.y + "," + coordinate2.z + ">";
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        Coordinate coordinate3 = triangle.c3;
                                        string2 = String.valueOf(coordinate3.x) + String.valueOf(coordinate3.y) + String.valueOf(coordinate3.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "<" + coordinate3.x + "," + coordinate3.y + "," + coordinate3.z + ">";
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        ++n5;
                                    }
                                    string = Constants.EOL;
                                    if (!this.countBytes) {
                                        this.bos.write(string.getBytes());
                                        this.bos.flush();
                                    } else {
                                        this.numberOfBytes += (long)string.length();
                                    }
                                    ++n4;
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        string = "}" + Constants.EOL + "face_indices {" + Constants.EOL + this.st.getBlossomTriangles() + "," + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        long l = this.st.getBlossomVertexes() / this.st.getNumberOfBlossoms();
        long l2 = 0L;
        int n6 = 0;
        while (n6 < quadroLeafArray.size()) {
            this.checkThreadStatus();
            tripleLeafArray = quadroLeafArray.get(n6);
            if (tripleLeafArray != null) {
                int n7 = 0;
                while (n7 < tripleLeafArray.size()) {
                    doubleLeafArray = tripleLeafArray.get(n7);
                    if (doubleLeafArray != null) {
                        int n8 = 0;
                        while (n8 < doubleLeafArray.size()) {
                            leafArray = doubleLeafArray.get(n8);
                            if (leafArray != null) {
                                int n9 = 0;
                                while (n9 < leafArray.size()) {
                                    Object object;
                                    Object object2;
                                    leaf = leafArray.get(n9);
                                    arrayList = leaf.getTriangles();
                                    hashtable = new Hashtable();
                                    long l3 = 0L;
                                    int n10 = 0;
                                    while (n10 < arrayList.size()) {
                                        triangle = (Triangle)arrayList.get(n10);
                                        Coordinate coordinate = triangle.c1;
                                        object2 = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l3));
                                            ++l3;
                                        }
                                        object = triangle.c2;
                                        object2 = String.valueOf(((Coordinate)object).x) + String.valueOf(((Coordinate)object).y) + String.valueOf(((Coordinate)object).z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l3));
                                            ++l3;
                                        }
                                        Coordinate coordinate4 = triangle.c3;
                                        object2 = String.valueOf(coordinate4.x) + String.valueOf(coordinate4.y) + String.valueOf(coordinate4.z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l3));
                                            ++l3;
                                        }
                                        ++n10;
                                    }
                                    int n11 = 0;
                                    while (n11 < arrayList.size()) {
                                        triangle = (Triangle)arrayList.get(n11);
                                        object2 = triangle.c1;
                                        object = String.valueOf(((Coordinate)object2).x) + String.valueOf(((Coordinate)object2).y) + String.valueOf(((Coordinate)object2).z);
                                        long l4 = (Long)hashtable.get(object) + l2;
                                        Coordinate coordinate = triangle.c2;
                                        object = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        long l5 = (Long)hashtable.get(object) + l2;
                                        Coordinate coordinate5 = triangle.c3;
                                        object = String.valueOf(coordinate5.x) + String.valueOf(coordinate5.y) + String.valueOf(coordinate5.z);
                                        long l6 = (Long)hashtable.get(object) + l2;
                                        string = "<" + l4 + "," + l5 + "," + l6 + ">";
                                        if (!this.countBytes) {
                                            this.bos.write(string.getBytes());
                                            this.bos.flush();
                                        } else {
                                            this.numberOfBytes += (long)string.length();
                                        }
                                        ++n11;
                                    }
                                    string = Constants.EOL;
                                    if (!this.countBytes) {
                                        this.bos.write(string.getBytes());
                                        this.bos.flush();
                                    } else {
                                        this.numberOfBytes += (long)string.length();
                                    }
                                    l2 += l;
                                    ++n9;
                                }
                            }
                            ++n8;
                        }
                    }
                    ++n7;
                }
            }
            ++n6;
        }
        string = "}" + Constants.EOL + "rotate z*180" + Constants.EOL + "rotate y*180" + Constants.EOL + "pigment{color rgb<" + this.p.blossomR + ", " + this.p.blossomG + ", " + this.p.blossomB + ">}" + Constants.EOL + "}" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
    }

    public void generateTreeElement(ArrayList arrayList, int n, int n2, short s, long l) throws IOException {
        int n3 = arrayList.size();
        this.prev = new ArrayList(n * 2);
        this.start = true;
        if (this.imageName != null && this.imageType != null) {
            this.uvX = n > 0 ? 1.0f / (float)n : 0.0f;
            this.uvY = n2 > 0 ? 1.0f / (float)(n3 / n2 + 1) : 0.0f;
        }
        int n4 = 0;
        while (n4 < n * 2) {
            this.prev.add(new Coordinate());
            ++n4;
        }
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        while (n6 < n3) {
            bl = n6 + n2 >= n3;
            Blob blob = (Blob)arrayList.get(n6);
            Blob blob2 = n6 + n2 < n3 ? (Blob)arrayList.get(n6 + n2) : (Blob)arrayList.get(n3 - 1);
            this.generateTreeSection(blob, blob2, n, n5, bl, s, l);
            ++n5;
            n6 += n2;
        }
    }

    public void generateTreeSection(Blob blob, Blob blob2, int n, int n2, boolean bl, short s, long l) throws IOException {
        Blob blob3 = (Blob)blob.clone();
        Blob blob4 = (Blob)blob2.clone();
        Blob blob5 = (Blob)blob2.clone();
        Coordinate coordinate = blob3.center;
        Coordinate coordinate2 = null;
        Coordinate coordinate3 = null;
        Coordinate coordinate4 = null;
        Coordinate coordinate5 = null;
        float f = (float)(360.0 / (double)n);
        String string = Constants.EOL;
        float f2 = this.getDistanceBetweenTwoBlobs(blob, blob2);
        float f3 = this.getAngleX(blob2.center.z, blob2.center.y);
        blob5.center.x -= blob3.center.x;
        blob5.center.y -= blob3.center.y;
        blob5.center.z -= blob3.center.z;
        blob5.rotateX(90.0f - f3);
        float f4 = this.getAngleZ(blob5.center.x, blob5.center.y);
        int n3 = 0;
        while (n3 < n) {
            if (this.start) {
                coordinate2 = new Coordinate();
                coordinate2.translateX(blob3.radius);
                coordinate2.rotateY(f * (float)n3);
                coordinate2.rotateZ(-90.0f - f4);
                coordinate2.rotateX(-90.0f - f3);
                coordinate2.mirrorZ();
                coordinate2.translate(coordinate.x, coordinate.y, coordinate.z);
            } else {
                coordinate2 = (Coordinate)this.prev.get(n3 * 2);
            }
            if (this.start) {
                coordinate5 = new Coordinate();
                coordinate5.translateX(blob3.radius);
                coordinate5.rotateY(f * (float)n3 + f);
                coordinate5.rotateZ(-90.0f - f4);
                coordinate5.rotateX(-90.0f - f3);
                coordinate5.mirrorZ();
                coordinate5.translate(coordinate.x, coordinate.y, coordinate.z);
            } else {
                coordinate5 = (Coordinate)this.prev.get(n3 * 2 + 1);
            }
            coordinate3 = new Coordinate();
            coordinate3.translate(blob4.radius, f2, 0.0f);
            coordinate3.rotateY(f * (float)n3);
            coordinate3.rotateZ(-90.0f - f4);
            coordinate3.rotateX(-90.0f - f3);
            coordinate3.mirrorZ();
            coordinate3.translate(coordinate.x, coordinate.y, coordinate.z);
            this.prev.set(n3 * 2, coordinate3.clone());
            coordinate4 = new Coordinate();
            coordinate4.translate(blob4.radius, f2, 0.0f);
            coordinate4.rotateY(f * (float)n3 + f);
            coordinate4.rotateZ(-90.0f - f4);
            coordinate4.rotateX(-90.0f - f3);
            coordinate4.mirrorZ();
            coordinate4.translate(coordinate.x, coordinate.y, coordinate.z);
            this.prev.set(n3 * 2 + 1, coordinate4.clone());
            if (bl && s == this.VERTEX) {
                string = string + "<" + coordinate3.x + ", " + coordinate3.y + ", " + coordinate3.z + ">";
            } else if (bl && s == this.UV) {
                float f5 = (float)n3 * this.uvX;
                float f6 = (float)(n2 + 1) * this.uvY;
                string = string + "<" + f5 + "," + f6 + ">";
            }
            this.saveFacet(coordinate2, n2, n3, s, n, l);
            ++n3;
        }
        if (this.start) {
            this.start = false;
        }
        if (bl && (s == this.VERTEX || s == this.UV)) {
            if (!this.countBytes) {
                this.bos.write(new String(string).getBytes());
                this.bos.flush();
            } else {
                this.numberOfBytes += (long)string.length();
            }
        }
        if (!this.countBytes) {
            this.bos.write(Constants.EOL.getBytes());
            this.bos.flush();
        } else {
            ++this.numberOfBytes;
        }
    }

    public void saveFacet(Coordinate coordinate, int n, int n2, short s, int n3, long l) throws IOException {
        String string = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        if (s == this.VERTEX) {
            string = "<" + coordinate.x + "," + coordinate.y + "," + coordinate.z + ">";
        } else if (s == this.TRIANGLES) {
            if (n2 == n3 - 1) {
                n7 = n3 * n + n2;
                n4 = n3 * n;
                n6 = n7 + n3;
                n5 = n4 + n3;
            } else {
                n7 = n3 * n + n2;
                n4 = n7 + 1;
                n6 = n7 + n3;
                n5 = n6 + 1;
            }
            string = "<" + ((long)n4 + l) + "," + ((long)n5 + l) + "," + ((long)n6 + l) + ">" + "<" + ((long)n4 + l) + "," + ((long)n6 + l) + "," + ((long)n7 + l) + ">";
        } else if (s == this.UV) {
            f = (float)n2 * this.uvX;
            f2 = (float)n * this.uvY;
            string = "<" + f + "," + f2 + ">";
        }
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
    }

    public void declareTextures() throws PovtreeException, IOException {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("#declare RINDE = texture {" + Constants.EOL);
        stringBuffer.append("\tpigment {" + Constants.EOL);
        stringBuffer.append("\t\tgranite" + Constants.EOL);
        stringBuffer.append("\t\tcubic_wave" + Constants.EOL);
        stringBuffer.append("\t\tcolor_map {" + Constants.EOL);
        stringBuffer.append("\t\t\t[0 color rgb <" + this.p.sunkenR + ", " + this.p.sunkenG + ", " + this.p.sunkenB + ">]" + Constants.EOL);
        stringBuffer.append("\t\t\t[0.35 color rgb <" + this.p.raisedR + ", " + this.p.raisedG + ", " + this.p.raisedB + ">]" + Constants.EOL);
        stringBuffer.append("\t\t\t[0.5 color rgb <" + this.p.raisedR + ", " + this.p.raisedG + ", " + this.p.raisedB + ">*2]" + Constants.EOL);
        stringBuffer.append("\t\t\t[0.65 color rgb <" + this.p.raisedR + ", " + this.p.raisedG + ", " + this.p.raisedB + ">]" + Constants.EOL);
        stringBuffer.append("\t\t\t[1 color rgb <" + this.p.sunkenR + ", " + this.p.sunkenG + ", " + this.p.sunkenB + ">]" + Constants.EOL);
        stringBuffer.append("\t\t}" + Constants.EOL);
        stringBuffer.append("\t\tscale <" + this.p.scarWidth + ", " + this.p.scarHeight + ", " + this.p.scarWidth + ">*3" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        if ((double)this.p.scarDepth > 0.0) {
            stringBuffer.append("\tnormal {" + Constants.EOL);
            stringBuffer.append("\t\tgranite " + this.p.scarDepth + "/5" + Constants.EOL);
            stringBuffer.append("\t\tscale <" + this.p.scarWidth + ", " + this.p.scarHeight + ", " + this.p.scarWidth + ">*3" + Constants.EOL);
            stringBuffer.append("\t}" + Constants.EOL);
        }
        stringBuffer.append("\tfinish {" + Constants.EOL);
        stringBuffer.append("\t\tphong " + this.p.scarDepth + "/5 phong_size 4" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        stringBuffer.append("}" + Constants.EOL);
        stringBuffer.append("#declare RINDE1 = texture {" + Constants.EOL);
        stringBuffer.append("\tpigment {" + Constants.EOL);
        stringBuffer.append("\t\tgranite" + Constants.EOL);
        stringBuffer.append("\t\tcubic_wave" + Constants.EOL);
        stringBuffer.append("\t\tcolor_map {" + Constants.EOL);
        stringBuffer.append("\t\t\t[0 color rgb <" + this.p.sunkenR + ", " + this.p.sunkenG + ", " + this.p.sunkenB + ">]" + Constants.EOL);
        float f = this.p.bottomR1 + this.p.bottomR2 + this.p.topR1 + this.p.topR2;
        float f2 = this.p.bottomG1 + this.p.bottomG2 + this.p.topG1 + this.p.topG2;
        float f3 = this.p.bottomB1 + this.p.bottomB2 + this.p.topB1 + this.p.topB2;
        stringBuffer.append("\t\t\t[0.35 color rgb <" + f + ", " + f2 + ", " + f3 + ">/4]" + Constants.EOL);
        stringBuffer.append("\t\t\t[0.50 color rgb <" + f + ", " + f2 + ", " + f3 + ">/2]" + Constants.EOL);
        stringBuffer.append("\t\t\t[0.65 color rgb <" + f + ", " + f2 + ", " + f3 + ">/4]" + Constants.EOL);
        stringBuffer.append("\t\t\t[1 color rgb <" + this.p.sunkenR + ", " + this.p.sunkenG + ", " + this.p.sunkenB + ">]" + Constants.EOL);
        stringBuffer.append("\t\t}" + Constants.EOL);
        stringBuffer.append("\t\tscale <" + this.p.scarWidth + ", " + this.p.scarHeight + ", " + this.p.scarWidth + ">*3" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        if ((double)this.p.scarDepth > 0.0) {
            stringBuffer.append("\tnormal {" + Constants.EOL);
            stringBuffer.append("\t\tgranite " + this.p.scarDepth + "/5" + Constants.EOL);
            stringBuffer.append("\t\tscale <" + this.p.scarWidth + ", " + this.p.scarHeight + ", " + this.p.scarWidth + ">*3" + Constants.EOL);
            stringBuffer.append("\t}" + Constants.EOL);
        }
        stringBuffer.append("\tfinish {" + Constants.EOL);
        stringBuffer.append("\t\tphong " + this.p.scarDepth + "/5 phong_size 4" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        stringBuffer.append("}" + Constants.EOL);
        stringBuffer.append("#declare BOZO1 = pigment {" + Constants.EOL);
        stringBuffer.append("\tbozo" + Constants.EOL);
        stringBuffer.append("\tcolor_map {" + Constants.EOL);
        stringBuffer.append("\t\t[0 color rgb");
        if (this.p.filter != 0.0f) {
            stringBuffer.append("f");
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append("t");
        }
        stringBuffer.append("<" + this.p.bottomR1 + ", " + this.p.bottomG1 + ", " + this.p.bottomB1);
        if (this.p.filter != 0.0f) {
            stringBuffer.append(", " + this.p.filter);
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append(", " + this.p.transparency);
        }
        stringBuffer.append(">]" + Constants.EOL);
        stringBuffer.append("\t\t[1 color rgb");
        if (this.p.filter != 0.0f) {
            stringBuffer.append("f");
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append("t");
        }
        stringBuffer.append("<" + this.p.bottomR2 + ", " + this.p.bottomG2 + ", " + this.p.bottomB2);
        if (this.p.filter != 0.0f) {
            stringBuffer.append(", " + this.p.filter);
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append(", " + this.p.transparency);
        }
        stringBuffer.append(">]" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        f = (float)((double)this.p.bh / (250.0 * ((double)this.p.turbulence + 0.1) * (double)this.p.bh));
        stringBuffer.append("\tscale " + f + Constants.EOL);
        stringBuffer.append("}" + Constants.EOL);
        stringBuffer.append("#declare BOZO2 = pigment {" + Constants.EOL);
        stringBuffer.append("\tbozo" + Constants.EOL);
        stringBuffer.append("\tcolor_map {" + Constants.EOL);
        stringBuffer.append("\t\t[0 color rgb");
        if (this.p.filter != 0.0f) {
            stringBuffer.append("f");
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append("t");
        }
        stringBuffer.append("<" + this.p.topR1 + ", " + this.p.topG1 + ", " + this.p.topB1);
        if (this.p.filter != 0.0f) {
            stringBuffer.append(", " + this.p.filter);
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append(", " + this.p.transparency);
        }
        stringBuffer.append(">]" + Constants.EOL);
        stringBuffer.append("\t\t[1 color rgb");
        if (this.p.filter != 0.0f) {
            stringBuffer.append("f");
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append("t");
        }
        stringBuffer.append("<" + this.p.topR2 + ", " + this.p.topG2 + ", " + this.p.topB2);
        if (this.p.filter != 0.0f) {
            stringBuffer.append(", " + this.p.filter);
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append(", " + this.p.transparency);
        }
        stringBuffer.append(">]" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        stringBuffer.append("\tscale " + f + Constants.EOL);
        stringBuffer.append("}" + Constants.EOL);
        stringBuffer.append("#declare LAUB = texture {" + Constants.EOL);
        stringBuffer.append("\tpigment {" + Constants.EOL);
        stringBuffer.append("\t\tgradient y" + Constants.EOL);
        stringBuffer.append("\t\tcubic_wave" + Constants.EOL);
        stringBuffer.append("\t\tturbulence " + this.p.transitionTurbulence + Constants.EOL);
        stringBuffer.append("\t\tomega " + this.p.transitionTurbulence + Constants.EOL);
        stringBuffer.append("\t\tpigment_map {" + Constants.EOL);
        stringBuffer.append("\t\t\t[" + this.p.transition + " BOZO1]" + Constants.EOL);
        stringBuffer.append("\t\t\t[1 BOZO2]" + Constants.EOL);
        stringBuffer.append("\t\t}" + Constants.EOL);
        stringBuffer.append("\t\tscale " + this.tree.normalizer + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        stringBuffer.append("\tfinish {" + Constants.EOL);
        stringBuffer.append("\t\tphong 0.4*" + this.p.gloss + " phong_size 20*" + this.p.gloss + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        stringBuffer.append("}" + Constants.EOL);
        if (this.t.getFoliageFlag()) {
            Foliage foliage = this.t.getFoliage();
            String string = foliage.type;
            if (string.startsWith("LeafUv")) {
                stringBuffer.append(foliage.leafArrayDeclaration + Constants.EOL);
                ArrayList arrayList = null;
                int n = 0;
                while (n < foliage.leafArrayElements.size()) {
                    arrayList = (ArrayList)foliage.leafArrayElements.get(n);
                    stringBuffer.append("#declare LeafArray[" + n + "] = texture {" + Constants.EOL + "\tuv_mapping" + Constants.EOL + "\tpigment{" + Constants.EOL + "\t\timage_map{" + Constants.EOL + "\t\t\t" + arrayList.get(0) + " \"" + arrayList.get(1) + "\"" + Constants.EOL + "\t\t\tmap_type 0" + Constants.EOL + "\t\t}" + Constants.EOL + "\t}" + Constants.EOL);
                    if (arrayList.get(3) != null) {
                        stringBuffer.append("\tnormal{bump_map{" + arrayList.get(2) + " \"" + arrayList.get(3) + "\" " + "map_type 0}");
                        if (arrayList.get(4) != null) {
                            stringBuffer.append(" bump_size " + arrayList.get(4));
                        }
                        stringBuffer.append("}" + Constants.EOL);
                    }
                    stringBuffer.append("\tfinish {diffuse 0.8}" + Constants.EOL + "};" + Constants.EOL);
                    ++n;
                }
            }
        }
        if (!this.countBytes) {
            this.bos.write(stringBuffer.toString().getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)stringBuffer.toString().length();
        }
    }

    public void setTexture() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("\ttexture {" + Constants.EOL);
        if ((double)this.p.scarHorizontalShrinking > 0.0) {
            stringBuffer.append("\t\tonion" + Constants.EOL);
            stringBuffer.append("\t\ttexture_map {" + Constants.EOL);
            float f = this.p.scarVerticalShrinking * this.tree.normalizer / this.p.scarHorizontalShrinking;
            stringBuffer.append("\t\t\t[0 RINDE scale <1/" + this.p.astl + ", 1/" + f + ", 1/" + this.p.astl + ">]" + Constants.EOL);
            stringBuffer.append("\t\t\t[" + this.p.scarHorizontalShrinking + " ");
            if ((double)this.p.foliageAtEnd == 1.0) {
                stringBuffer.append("RINDE1 ");
            } else {
                stringBuffer.append("RINDE ");
            }
            float f2 = 0.3f / this.p.astl;
            float f3 = 0.3f / (this.p.scarVerticalShrinking * this.tree.normalizer / this.p.scarHorizontalShrinking);
            stringBuffer.append("scale <" + f2 + ", " + f3 + ", " + f2 + ">]" + Constants.EOL);
            stringBuffer.append("\t\t\t[1 ");
            if ((double)this.p.foliageAtEnd == 1.0) {
                stringBuffer.append("LAUB ");
            } else {
                stringBuffer.append("RINDE ");
            }
            f2 = 0.1f / this.p.astl;
            f3 = 0.1f / (this.p.scarVerticalShrinking * this.tree.normalizer / this.p.scarHorizontalShrinking);
            stringBuffer.append("scale <" + f2 + ", " + f3 + ", " + f2 + ">]" + Constants.EOL);
            stringBuffer.append("\t\t}" + Constants.EOL);
            f2 = this.p.astl;
            f3 = this.p.scarVerticalShrinking * this.tree.normalizer / this.p.scarHorizontalShrinking;
            stringBuffer.append("\t\tscale <" + f2 + ", " + f3 + ", " + f2 + ">/" + this.tree.meshScale + Constants.EOL);
        } else {
            stringBuffer.append("\t\tRINDE" + Constants.EOL);
        }
        stringBuffer.append("\t}" + Constants.EOL);
        if (!this.countBytes) {
            this.bos.write(stringBuffer.toString().getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)stringBuffer.toString().length();
        }
    }

    public void setUvTexture() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("texture {" + Constants.EOL + "pigment {uv_mapping" + Constants.EOL + "image_map {" + Constants.EOL + this.imageType + " \"" + this.imageName.trim() + "\" map_type 0 interpolate 0" + Constants.EOL + "}" + Constants.EOL + "}");
        if (this.bumpName != null && this.bumpName.trim().length() != 0) {
            stringBuffer.append(Constants.EOL + "normal {uv_mapping" + Constants.EOL + "bump_map {" + Constants.EOL + this.bumpType + " \"" + this.bumpName.trim() + "\" map_type 0 interpolate 0 bump_size ");
            if (this.bumpSize != null && this.bumpSize.trim().length() != 0) {
                stringBuffer.append(this.bumpSize + Constants.EOL + "}" + Constants.EOL + "}");
            } else {
                stringBuffer.append("2" + Constants.EOL + "}" + Constants.EOL + "}");
            }
        }
        stringBuffer.append(Constants.EOL + "}" + Constants.EOL);
        if (!this.countBytes) {
            this.bos.write(stringBuffer.toString().getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)stringBuffer.toString().length();
        }
    }

    public float getDistanceBetweenTwoBlobs(Blob blob, Blob blob2) {
        float f = blob.center.x - blob2.center.x;
        float f2 = blob.center.y - blob2.center.y;
        float f3 = blob.center.z - blob2.center.z;
        return (float)Math.abs(Math.sqrt(f * f + f2 * f2 + f3 * f3));
    }

    public float getAngleZ(float f, float f2) {
        if (f2 > 0.0f) {
            return (float)Math.toDegrees(Math.atan2(f2, f));
        }
        return 360.0f + (float)Math.toDegrees(Math.atan2(f2, f));
    }

    public float getAngleX(float f, float f2) {
        float f3 = -f2;
        if (f3 > 0.0f) {
            return (float)Math.toDegrees(Math.atan2(f3, f));
        }
        return 360.0f + (float)Math.toDegrees(Math.atan2(f3, f));
    }

    public long getNumberOfKBytes() {
        return this.numberOfBytes / 1000L;
    }
}

