/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import povtree.gui.PovTree;
import povtree.gui.PovtreeException;
import povtree.gui.Resources;
import povtree.interfaces.Constants;
import povtree.interfaces.Generator;
import povtree.interfaces.Leaf;
import povtree.objects.Foliage;
import povtree.objects.Tree;
import povtree.objects3D.Blob;
import povtree.objects3D.Coordinate;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.DoubleLeafArray;
import povtree.objects3D.LeafArray;
import povtree.objects3D.QuadroBlobArray;
import povtree.objects3D.QuadroLeafArray;
import povtree.objects3D.QuintetBlobArray;
import povtree.objects3D.TableLeaf;
import povtree.objects3D.Tree3D;
import povtree.objects3D.Triangle;
import povtree.objects3D.TripleBlobArray;
import povtree.objects3D.TripleLeafArray;
import povtree.povTreeGenerator.Accuracy;
import povtree.povTreeGenerator.Parameters;

public class MeshGenerator
implements Constants,
Generator {
    private Tree t;
    private Tree3D tree;
    private BufferedOutputStream bos;
    private Accuracy accuracy;
    private Parameters p;
    private ArrayList prev = null;
    private boolean start = false;
    private float uvX;
    private float uvY;
    private String imageType;
    private String imageName;
    private String bumpType;
    private String bumpName;
    private String bumpSize;
    private boolean countBytes = false;
    private long numberOfBytes = 0L;
    private Resources resources = Resources.getInstance();
    private ResourceBundle messages = Resources.getMessagesBundle();
    private PovTree frame = null;

    public MeshGenerator(Tree tree, Tree3D tree3D, BufferedOutputStream bufferedOutputStream, Accuracy accuracy, String string, String string2, String string3, String string4, String string5, boolean bl, PovTree povTree) throws NumberFormatException {
        this.t = tree;
        this.p = new Parameters(this.t);
        this.tree = tree3D;
        this.bos = bufferedOutputStream;
        this.accuracy = accuracy;
        this.imageType = string;
        this.imageName = string2;
        this.bumpType = string3;
        this.bumpName = string4;
        this.bumpSize = string5;
        this.countBytes = bl;
        this.frame = povTree;
    }

    public void checkThreadStatus() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public void generateMesh() throws PovtreeException, IOException, InterruptedException {
        ArrayList arrayList;
        Cloneable cloneable;
        Cloneable cloneable2;
        String string = new String();
        this.declareTextures();
        if (this.t.getFoliageFlag()) {
            if (this.tree.getFoliage() instanceof QuadroBlobArray) {
                throw new PovtreeException(this.messages.getString("calculateMeshLeaves"));
            }
            cloneable2 = (QuadroLeafArray)this.tree.getFoliage();
            if (cloneable2 != null) {
                this.frame.updateStatus(0, "calculatingFoliage");
                if (this.t.getFoliage().type.startsWith("LeafUv")) {
                    cloneable = this.t.getFoliage().leafArrayElements;
                    if (cloneable != null) {
                        this.generateUvLeaves((QuadroLeafArray)cloneable2, ((ArrayList)cloneable).size());
                    }
                } else {
                    this.generateLeaves((QuadroLeafArray)cloneable2);
                }
                if (this.bos == null) {
                    this.frame.updateStatus(20, "calculatingBlossom");
                } else {
                    this.frame.updateStatus(20, "savingBlossom");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(20, "calculatingBlossom");
            } else {
                this.frame.updateStatus(20, "savingBlossom");
            }
        }
        if (this.t.getBlossomFlag()) {
            if (this.tree.getBlossom() instanceof QuadroBlobArray) {
                throw new PovtreeException(this.messages.getString("calculateMeshBlossom"));
            }
            cloneable2 = (QuadroLeafArray)this.tree.getBlossom();
            if (cloneable2 != null) {
                this.generateBlossom((QuadroLeafArray)cloneable2);
                if (this.bos == null) {
                    this.frame.updateStatus(40, "calculatingRoots");
                } else {
                    this.frame.updateStatus(40, "savingRoots");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(40, "calculatingRoots");
            } else {
                this.frame.updateStatus(40, "savingRoots");
            }
        }
        if (this.t.getRootFlag() || this.t.getTrunkFlag() || this.t.getBranchesFlag() || this.t.getTwigsFlag() || this.t.getRamiFlag()) {
            string = "#declare WOOD = mesh {" + Constants.EOL;
            if (!this.countBytes) {
                this.bos.write(string.getBytes());
                this.bos.flush();
            } else {
                this.numberOfBytes += (long)string.length();
            }
        }
        if (this.t.getRootFlag()) {
            cloneable2 = this.tree.getRoot();
            if (cloneable2 != null) {
                int n = 0;
                while (n < ((DoubleBlobArray)cloneable2).size()) {
                    this.checkThreadStatus();
                    arrayList = ((DoubleBlobArray)cloneable2).get(n).get();
                    this.generateTreeElement(arrayList, this.accuracy.rootRadial, this.accuracy.rootVertical);
                    ++n;
                }
                if (this.bos == null) {
                    this.frame.updateStatus(50, "calculatingTrunk");
                } else {
                    this.frame.updateStatus(50, "savingTrunk");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(50, "calculatingTrunk");
            } else {
                this.frame.updateStatus(50, "savingTrunk");
            }
        }
        if (this.t.getTrunkFlag()) {
            cloneable2 = this.tree.getTrunk().get();
            if (cloneable2 != null && ((ArrayList)cloneable2).size() != 0) {
                this.generateTreeElement((ArrayList)cloneable2, this.accuracy.trunkRadial, this.accuracy.trunkVertical);
                if (this.bos == null) {
                    this.frame.updateStatus(60, "calculatingBranches");
                } else {
                    this.frame.updateStatus(60, "savingBranches");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(60, "calculatingBranches");
            } else {
                this.frame.updateStatus(60, "savingBranches");
            }
        }
        if (this.t.getBranchesFlag()) {
            cloneable2 = this.tree.getBranches();
            if (cloneable2 != null) {
                int n = 0;
                while (n < ((DoubleBlobArray)cloneable2).size()) {
                    this.checkThreadStatus();
                    arrayList = ((DoubleBlobArray)cloneable2).get(n).get();
                    this.generateTreeElement(arrayList, this.accuracy.branchRadial, this.accuracy.branchVertical);
                    ++n;
                }
                if (this.bos == null) {
                    this.frame.updateStatus(70, "calculatingTwigs");
                } else {
                    this.frame.updateStatus(70, "savingTwigs");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(70, "calculatingTwigs");
            } else {
                this.frame.updateStatus(70, "savingTwigs");
            }
        }
        if (this.t.getTwigsFlag()) {
            cloneable2 = this.tree.getTwigs();
            if (cloneable2 != null) {
                int n = 0;
                while (n < ((TripleBlobArray)cloneable2).size()) {
                    this.checkThreadStatus();
                    cloneable = ((TripleBlobArray)cloneable2).get(n);
                    int n2 = 0;
                    while (n2 < ((DoubleBlobArray)cloneable).size()) {
                        arrayList = ((DoubleBlobArray)cloneable).get(n2).get();
                        this.generateTreeElement(arrayList, this.accuracy.twigRadial, this.accuracy.twigVertical);
                        ++n2;
                    }
                    ++n;
                }
                if (this.bos == null) {
                    this.frame.updateStatus(80, "calculatingRami");
                } else {
                    this.frame.updateStatus(80, "savingRami");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(80, "calculatingRami");
            } else {
                this.frame.updateStatus(80, "savingRami");
            }
        }
        if (this.t.getRamiFlag()) {
            QuintetBlobArray quintetBlobArray = this.tree.getRami();
            if (quintetBlobArray != null) {
                int n = 0;
                while (n < quintetBlobArray.size()) {
                    this.checkThreadStatus();
                    cloneable2 = quintetBlobArray.get(n);
                    int n3 = 0;
                    while (n3 < ((QuadroBlobArray)cloneable2).size()) {
                        cloneable = ((QuadroBlobArray)cloneable2).get(n3);
                        int n4 = 0;
                        while (n4 < ((TripleBlobArray)cloneable).size()) {
                            DoubleBlobArray doubleBlobArray = ((TripleBlobArray)cloneable).get(n4);
                            int n5 = 0;
                            while (n5 < doubleBlobArray.size()) {
                                arrayList = doubleBlobArray.get(n5).get();
                                this.generateTreeElement(arrayList, this.accuracy.ramiRadial, this.accuracy.ramiVertical);
                                ++n5;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n;
                }
                this.frame.updateStatus(90, "transformingTree");
            } else {
                this.frame.updateStatus(90, "transformingTree");
            }
        }
        if (this.t.getRootFlag() || this.t.getTrunkFlag() || this.t.getBranchesFlag() || this.t.getTwigsFlag() || this.t.getRamiFlag()) {
            string = "rotate z*180" + Constants.EOL + "rotate y*180" + Constants.EOL;
            if (!this.countBytes) {
                this.bos.write(string.getBytes());
                this.bos.flush();
            } else {
                this.numberOfBytes += (long)string.length();
            }
            if (this.imageName != null && this.imageType != null) {
                this.setUvTexture();
            } else {
                this.setTexture();
            }
            string = "}" + Constants.EOL;
            if (!this.countBytes) {
                this.bos.write(string.getBytes());
                this.bos.flush();
            } else {
                this.numberOfBytes += (long)string.length();
            }
        }
        boolean bl = false;
        boolean bl2 = this.t.getFoliageFlag();
        boolean bl3 = this.t.getBlossomFlag();
        if (this.t.getRootFlag() || this.t.getTrunkFlag() || this.t.getBranchesFlag() || this.t.getTwigsFlag() || this.t.getRamiFlag()) {
            bl = true;
        }
        if (bl && !bl2 && !bl3 || !bl && bl2 && !bl3 || !bl && !bl2 && bl3) {
            string = "#declare TREE = object {" + Constants.EOL;
            if (bl2) {
                string = string + "FOLIAGE" + Constants.EOL;
            }
            if (bl3) {
                string = string + "BLOSSOM" + Constants.EOL;
            }
            if (bl) {
                string = string + "WOOD" + Constants.EOL;
            }
            string = string + "}" + Constants.EOL;
        } else if (bl && bl2 && bl3 || bl && bl2 && !bl3 || bl && !bl2 && bl3 || !bl && bl2 && bl3) {
            string = "#declare TREE = union {" + Constants.EOL;
            if (bl2) {
                string = string + "object{FOLIAGE}" + Constants.EOL;
            }
            if (bl3) {
                string = string + "object{BLOSSOM}" + Constants.EOL;
            }
            if (bl) {
                string = string + "object{WOOD}" + Constants.EOL;
            }
            string = string + "}" + Constants.EOL;
        }
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        this.checkThreadStatus();
        if (this.bos == null) {
            this.frame.updateStatus(0, "statsDone");
        } else {
            this.frame.updateStatus(0, "savingDone");
        }
    }

    public void generateLeaves(QuadroLeafArray quadroLeafArray) throws IOException, InterruptedException {
        String string = "#declare FOLIAGE = mesh {" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        int n = 0;
        while (n < quadroLeafArray.size()) {
            this.checkThreadStatus();
            TripleLeafArray tripleLeafArray = quadroLeafArray.get(n);
            if (tripleLeafArray != null) {
                int n2 = 0;
                while (n2 < tripleLeafArray.size()) {
                    DoubleLeafArray doubleLeafArray = tripleLeafArray.get(n2);
                    if (doubleLeafArray != null) {
                        int n3 = 0;
                        while (n3 < doubleLeafArray.size()) {
                            LeafArray leafArray = doubleLeafArray.get(n3);
                            if (leafArray != null) {
                                int n4 = 0;
                                while (n4 < leafArray.size()) {
                                    Leaf leaf = leafArray.get(n4);
                                    ArrayList arrayList = leaf.getTriangles();
                                    int n5 = 0;
                                    while (n5 < arrayList.size()) {
                                        Triangle triangle = (Triangle)arrayList.get(n5);
                                        string = "triangle{<" + triangle.c1.x + ", " + triangle.c1.y + ", " + triangle.c1.z + ">, " + "<" + triangle.c2.x + ", " + triangle.c2.y + ", " + triangle.c2.z + ">, " + "<" + triangle.c3.x + ", " + triangle.c3.y + ", " + triangle.c3.z + ">}" + Constants.EOL;
                                        if (!this.countBytes) {
                                            this.bos.write(string.getBytes());
                                            this.bos.flush();
                                        } else {
                                            this.numberOfBytes += (long)string.length();
                                        }
                                        ++n5;
                                    }
                                    ++n4;
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        string = "rotate z*180" + Constants.EOL + "rotate y*180" + Constants.EOL + "texture{LAUB scale 1/" + this.tree.normalizer + "}" + Constants.EOL + "}" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
    }

    public void generateUvLeaves(QuadroLeafArray quadroLeafArray, int n) throws IOException, InterruptedException {
        String string = "#declare FOLIAGE = mesh {" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        int n2 = 0;
        while (n2 < quadroLeafArray.size()) {
            this.checkThreadStatus();
            TripleLeafArray tripleLeafArray = quadroLeafArray.get(n2);
            if (tripleLeafArray != null) {
                int n3 = 0;
                while (n3 < tripleLeafArray.size()) {
                    DoubleLeafArray doubleLeafArray = tripleLeafArray.get(n3);
                    if (doubleLeafArray != null) {
                        int n4 = 0;
                        while (n4 < doubleLeafArray.size()) {
                            LeafArray leafArray = doubleLeafArray.get(n4);
                            if (leafArray != null) {
                                int n5 = 0;
                                while (n5 < leafArray.size()) {
                                    Leaf leaf = leafArray.get(n5);
                                    int n6 = leaf.getTextureIndex();
                                    int n7 = leaf.getLongitudinal();
                                    int n8 = leaf.getLatitudinal();
                                    float f = 1.0f / (float)n8;
                                    float f2 = 1.0f / (float)n7;
                                    int n9 = 0;
                                    while (n9 < n7) {
                                        int n10 = 0;
                                        while (n10 < n8) {
                                            int n11 = 0;
                                            while (n11 < 2) {
                                                Triangle triangle = (Triangle)leaf.getTriangles().get(n9 * n8 * 2 + n10 * 2 + n11);
                                                string = n11 == 0 ? "triangle{<" + triangle.c1.x + ", " + triangle.c1.y + ", " + triangle.c1.z + ">, " + "<" + triangle.c2.x + ", " + triangle.c2.y + ", " + triangle.c2.z + ">, " + "<" + triangle.c3.x + ", " + triangle.c3.y + ", " + triangle.c3.z + "> uv_vectors<" + f * (float)n10 + "," + f2 * (float)n9 + ">,<" + f * (float)n10 + "," + f2 * (float)(n9 + 1) + ">,<" + f * (float)(n10 + 1) + "," + f2 * (float)n9 + "> texture{LeafArray[" + n6 + "]}}" + Constants.EOL : "triangle{<" + triangle.c1.x + ", " + triangle.c1.y + ", " + triangle.c1.z + ">, " + "<" + triangle.c2.x + ", " + triangle.c2.y + ", " + triangle.c2.z + ">, " + "<" + triangle.c3.x + ", " + triangle.c3.y + ", " + triangle.c3.z + "> uv_vectors<" + f * (float)n10 + "," + f2 * (float)(n9 + 1) + ">,<" + f * (float)(n10 + 1) + "," + f2 * (float)n9 + ">,<" + f * (float)(n10 + 1) + "," + f2 * (float)(n9 + 1) + "> texture{LeafArray[" + n6 + "]}}" + Constants.EOL;
                                                if (!this.countBytes) {
                                                    this.bos.write(string.getBytes());
                                                    this.bos.flush();
                                                } else {
                                                    this.numberOfBytes += (long)string.length();
                                                }
                                                ++n11;
                                            }
                                            ++n10;
                                        }
                                        ++n9;
                                    }
                                    ++n5;
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        string = "rotate z*180" + Constants.EOL + "rotate y*180" + Constants.EOL + "}" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
    }

    public void generateBlossom(QuadroLeafArray quadroLeafArray) throws IOException, InterruptedException {
        String string = "#declare BLOSSOM = mesh {" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        int n = 0;
        while (n < quadroLeafArray.size()) {
            this.checkThreadStatus();
            TripleLeafArray tripleLeafArray = quadroLeafArray.get(n);
            if (tripleLeafArray != null) {
                int n2 = 0;
                while (n2 < tripleLeafArray.size()) {
                    DoubleLeafArray doubleLeafArray = tripleLeafArray.get(n2);
                    if (doubleLeafArray != null) {
                        int n3 = 0;
                        while (n3 < doubleLeafArray.size()) {
                            LeafArray leafArray = doubleLeafArray.get(n3);
                            if (leafArray != null) {
                                int n4 = 0;
                                while (n4 < leafArray.size()) {
                                    Leaf leaf = leafArray.get(n4);
                                    ArrayList arrayList = leaf.getTriangles();
                                    int n5 = 0;
                                    while (n5 < arrayList.size()) {
                                        Triangle triangle = (Triangle)arrayList.get(n5);
                                        string = "triangle{<" + triangle.c1.x + ", " + triangle.c1.y + ", " + triangle.c1.z + ">, " + "<" + triangle.c2.x + ", " + triangle.c2.y + ", " + triangle.c2.z + ">, " + "<" + triangle.c3.x + ", " + triangle.c3.y + ", " + triangle.c3.z + ">}" + Constants.EOL;
                                        if (!this.countBytes) {
                                            this.bos.write(string.getBytes());
                                            this.bos.flush();
                                        } else {
                                            this.numberOfBytes += (long)string.length();
                                        }
                                        ++n5;
                                    }
                                    ++n4;
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        string = "rotate z*180" + Constants.EOL + "rotate y*180" + Constants.EOL + "pigment{color rgb<" + this.p.blossomR + ", " + this.p.blossomG + ", " + this.p.blossomB + ">}" + Constants.EOL + "}" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
    }

    public void generateTreeElement(ArrayList arrayList, int n, int n2) throws IOException {
        int n3 = arrayList.size();
        this.prev = new ArrayList(n * 2);
        this.start = true;
        if (this.imageName != null && this.imageType != null) {
            this.uvX = n > 0 ? 1.0f / (float)n : 0.0f;
            this.uvY = n2 > 0 ? 1.0f / (float)(n3 / n2 + 1) : 0.0f;
        }
        int n4 = 0;
        while (n4 < n * 2) {
            this.prev.add(new Coordinate());
            ++n4;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            Blob blob = (Blob)arrayList.get(n6);
            Blob blob2 = n6 + n2 < n3 ? (Blob)arrayList.get(n6 + n2) : (Blob)arrayList.get(n3 - 1);
            this.generateTreeSection(blob, blob2, n, n5);
            ++n5;
            n6 += n2;
        }
    }

    public void generateTreeSection(Blob blob, Blob blob2, int n, int n2) throws IOException {
        Blob blob3 = (Blob)blob.clone();
        Blob blob4 = (Blob)blob2.clone();
        Blob blob5 = (Blob)blob2.clone();
        Coordinate coordinate = blob3.center;
        Coordinate coordinate2 = null;
        Coordinate coordinate3 = null;
        Coordinate coordinate4 = null;
        Coordinate coordinate5 = null;
        float f = (float)(360.0 / (double)n);
        float f2 = this.getDistanceBetweenTwoBlobs(blob, blob2);
        float f3 = this.getAngleX(blob2.center.z, blob2.center.y);
        blob5.center.x -= blob3.center.x;
        blob5.center.y -= blob3.center.y;
        blob5.center.z -= blob3.center.z;
        blob5.rotateX(90.0f - f3);
        float f4 = this.getAngleZ(blob5.center.x, blob5.center.y);
        int n3 = 0;
        while (n3 < n) {
            if (this.start) {
                coordinate2 = new Coordinate();
                coordinate2.translateX(blob3.radius);
                coordinate2.rotateY(f * (float)n3);
                coordinate2.rotateZ(-90.0f - f4);
                coordinate2.rotateX(-90.0f - f3);
                coordinate2.mirrorZ();
                coordinate2.translate(coordinate.x, coordinate.y, coordinate.z);
            } else {
                coordinate2 = (Coordinate)this.prev.get(n3 * 2);
            }
            if (this.start) {
                coordinate5 = new Coordinate();
                coordinate5.translateX(blob3.radius);
                coordinate5.rotateY(f * (float)n3 + f);
                coordinate5.rotateZ(-90.0f - f4);
                coordinate5.rotateX(-90.0f - f3);
                coordinate5.mirrorZ();
                coordinate5.translate(coordinate.x, coordinate.y, coordinate.z);
            } else {
                coordinate5 = (Coordinate)this.prev.get(n3 * 2 + 1);
            }
            coordinate3 = new Coordinate();
            coordinate3.translate(blob4.radius, f2, 0.0f);
            coordinate3.rotateY(f * (float)n3);
            coordinate3.rotateZ(-90.0f - f4);
            coordinate3.rotateX(-90.0f - f3);
            coordinate3.mirrorZ();
            coordinate3.translate(coordinate.x, coordinate.y, coordinate.z);
            this.prev.set(n3 * 2, coordinate3.clone());
            coordinate4 = new Coordinate();
            coordinate4.translate(blob4.radius, f2, 0.0f);
            coordinate4.rotateY(f * (float)n3 + f);
            coordinate4.rotateZ(-90.0f - f4);
            coordinate4.rotateX(-90.0f - f3);
            coordinate4.mirrorZ();
            coordinate4.translate(coordinate.x, coordinate.y, coordinate.z);
            this.prev.set(n3 * 2 + 1, coordinate4.clone());
            this.saveFacet(coordinate2, coordinate3, coordinate4, coordinate5, n2, n3);
            ++n3;
        }
        if (this.start) {
            this.start = false;
        }
    }

    public void saveFacet(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4, int n, int n2) throws IOException {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        String string = "\ttriangle{<" + coordinate.x + ", " + coordinate.y + ", " + coordinate.z + ">, " + "<" + coordinate2.x + ", " + coordinate2.y + ", " + coordinate2.z + ">, " + "<" + coordinate3.x + ", " + coordinate3.y + ", " + coordinate3.z + ">";
        if (this.imageName != null && this.imageType != null) {
            f = (float)n2 * this.uvX;
            f2 = f + this.uvX;
            f3 = (float)n * this.uvY;
            f4 = f3 + this.uvY;
            string = string + " uv_vectors <" + f + ", " + f3 + ">, <" + f + ", " + f4 + ">, <" + f2 + ", " + f4 + ">}" + Constants.EOL;
        } else {
            string = string + "}" + Constants.EOL;
        }
        string = string + "\ttriangle{<" + coordinate.x + ", " + coordinate.y + ", " + coordinate.z + ">, " + "<" + coordinate3.x + ", " + coordinate3.y + ", " + coordinate3.z + ">, " + "<" + coordinate4.x + ", " + coordinate4.y + ", " + coordinate4.z + ">";
        string = this.imageName != null && this.imageType != null ? string + " uv_vectors <" + f + ", " + f3 + ">, <" + f2 + ", " + f4 + ">, <" + f2 + ", " + f3 + ">}" + Constants.EOL : string + "}" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
    }

    public void declareTextures() throws PovtreeException, IOException {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("#declare RINDE = texture {" + Constants.EOL);
        stringBuffer.append("\tpigment {" + Constants.EOL);
        stringBuffer.append("\t\tgranite" + Constants.EOL);
        stringBuffer.append("\t\tcubic_wave" + Constants.EOL);
        stringBuffer.append("\t\tcolor_map {" + Constants.EOL);
        stringBuffer.append("\t\t\t[0 color rgb <" + this.p.sunkenR + ", " + this.p.sunkenG + ", " + this.p.sunkenB + ">]" + Constants.EOL);
        stringBuffer.append("\t\t\t[0.35 color rgb <" + this.p.raisedR + ", " + this.p.raisedG + ", " + this.p.raisedB + ">]" + Constants.EOL);
        stringBuffer.append("\t\t\t[0.5 color rgb <" + this.p.raisedR + ", " + this.p.raisedG + ", " + this.p.raisedB + ">*2]" + Constants.EOL);
        stringBuffer.append("\t\t\t[0.65 color rgb <" + this.p.raisedR + ", " + this.p.raisedG + ", " + this.p.raisedB + ">]" + Constants.EOL);
        stringBuffer.append("\t\t\t[1 color rgb <" + this.p.sunkenR + ", " + this.p.sunkenG + ", " + this.p.sunkenB + ">]" + Constants.EOL);
        stringBuffer.append("\t\t}" + Constants.EOL);
        stringBuffer.append("\t\tscale <" + this.p.scarWidth + ", " + this.p.scarHeight + ", " + this.p.scarWidth + ">*3" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        if ((double)this.p.scarDepth > 0.0) {
            stringBuffer.append("\tnormal {" + Constants.EOL);
            stringBuffer.append("\t\tgranite " + this.p.scarDepth + "/5" + Constants.EOL);
            stringBuffer.append("\t\tscale <" + this.p.scarWidth + ", " + this.p.scarHeight + ", " + this.p.scarWidth + ">*3" + Constants.EOL);
            stringBuffer.append("\t}" + Constants.EOL);
        }
        stringBuffer.append("\tfinish {" + Constants.EOL);
        stringBuffer.append("\t\tphong " + this.p.scarDepth + "/5 phong_size 4" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        stringBuffer.append("}" + Constants.EOL);
        stringBuffer.append("#declare RINDE1 = texture {" + Constants.EOL);
        stringBuffer.append("\tpigment {" + Constants.EOL);
        stringBuffer.append("\t\tgranite" + Constants.EOL);
        stringBuffer.append("\t\tcubic_wave" + Constants.EOL);
        stringBuffer.append("\t\tcolor_map {" + Constants.EOL);
        stringBuffer.append("\t\t\t[0 color rgb <" + this.p.sunkenR + ", " + this.p.sunkenG + ", " + this.p.sunkenB + ">]" + Constants.EOL);
        float f = this.p.bottomR1 + this.p.bottomR2 + this.p.topR1 + this.p.topR2;
        float f2 = this.p.bottomG1 + this.p.bottomG2 + this.p.topG1 + this.p.topG2;
        float f3 = this.p.bottomB1 + this.p.bottomB2 + this.p.topB1 + this.p.topB2;
        stringBuffer.append("\t\t\t[0.35 color rgb <" + f + ", " + f2 + ", " + f3 + ">/4]" + Constants.EOL);
        stringBuffer.append("\t\t\t[0.50 color rgb <" + f + ", " + f2 + ", " + f3 + ">/2]" + Constants.EOL);
        stringBuffer.append("\t\t\t[0.65 color rgb <" + f + ", " + f2 + ", " + f3 + ">/4]" + Constants.EOL);
        stringBuffer.append("\t\t\t[1 color rgb <" + this.p.sunkenR + ", " + this.p.sunkenG + ", " + this.p.sunkenB + ">]" + Constants.EOL);
        stringBuffer.append("\t\t}" + Constants.EOL);
        stringBuffer.append("\t\tscale <" + this.p.scarWidth + ", " + this.p.scarHeight + ", " + this.p.scarWidth + ">*3" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        if ((double)this.p.scarDepth > 0.0) {
            stringBuffer.append("\tnormal {" + Constants.EOL);
            stringBuffer.append("\t\tgranite " + this.p.scarDepth + "/5" + Constants.EOL);
            stringBuffer.append("\t\tscale <" + this.p.scarWidth + ", " + this.p.scarHeight + ", " + this.p.scarWidth + ">*3" + Constants.EOL);
            stringBuffer.append("\t}" + Constants.EOL);
        }
        stringBuffer.append("\tfinish {" + Constants.EOL);
        stringBuffer.append("\t\tphong " + this.p.scarDepth + "/5 phong_size 4" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        stringBuffer.append("}" + Constants.EOL);
        stringBuffer.append("#declare BOZO1 = pigment {" + Constants.EOL);
        stringBuffer.append("\tbozo" + Constants.EOL);
        stringBuffer.append("\tcolor_map {" + Constants.EOL);
        stringBuffer.append("\t\t[0 color rgb");
        if (this.p.filter != 0.0f) {
            stringBuffer.append("f");
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append("t");
        }
        stringBuffer.append("<" + this.p.bottomR1 + ", " + this.p.bottomG1 + ", " + this.p.bottomB1);
        if (this.p.filter != 0.0f) {
            stringBuffer.append(", " + this.p.filter);
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append(", " + this.p.transparency);
        }
        stringBuffer.append(">]" + Constants.EOL);
        stringBuffer.append("\t\t[1 color rgb");
        if (this.p.filter != 0.0f) {
            stringBuffer.append("f");
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append("t");
        }
        stringBuffer.append("<" + this.p.bottomR2 + ", " + this.p.bottomG2 + ", " + this.p.bottomB2);
        if (this.p.filter != 0.0f) {
            stringBuffer.append(", " + this.p.filter);
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append(", " + this.p.transparency);
        }
        stringBuffer.append(">]" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        f = (float)((double)this.p.bh / (250.0 * ((double)this.p.turbulence + 0.1) * (double)this.p.bh));
        stringBuffer.append("\tscale " + f + Constants.EOL);
        stringBuffer.append("}" + Constants.EOL);
        stringBuffer.append("#declare BOZO2 = pigment {" + Constants.EOL);
        stringBuffer.append("\tbozo" + Constants.EOL);
        stringBuffer.append("\tcolor_map {" + Constants.EOL);
        stringBuffer.append("\t\t[0 color rgb");
        if (this.p.filter != 0.0f) {
            stringBuffer.append("f");
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append("t");
        }
        stringBuffer.append("<" + this.p.topR1 + ", " + this.p.topG1 + ", " + this.p.topB1);
        if (this.p.filter != 0.0f) {
            stringBuffer.append(", " + this.p.filter);
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append(", " + this.p.transparency);
        }
        stringBuffer.append(">]" + Constants.EOL);
        stringBuffer.append("\t\t[1 color rgb");
        if (this.p.filter != 0.0f) {
            stringBuffer.append("f");
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append("t");
        }
        stringBuffer.append("<" + this.p.topR2 + ", " + this.p.topG2 + ", " + this.p.topB2);
        if (this.p.filter != 0.0f) {
            stringBuffer.append(", " + this.p.filter);
        }
        if (this.p.transparency != 0.0f) {
            stringBuffer.append(", " + this.p.transparency);
        }
        stringBuffer.append(">]" + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        stringBuffer.append("\tscale " + f + Constants.EOL);
        stringBuffer.append("}" + Constants.EOL);
        stringBuffer.append("#declare LAUB = texture {" + Constants.EOL);
        stringBuffer.append("\tpigment {" + Constants.EOL);
        stringBuffer.append("\t\tgradient y" + Constants.EOL);
        stringBuffer.append("\t\tcubic_wave" + Constants.EOL);
        stringBuffer.append("\t\tturbulence " + this.p.transitionTurbulence + Constants.EOL);
        stringBuffer.append("\t\tomega " + this.p.transitionTurbulence + Constants.EOL);
        stringBuffer.append("\t\tpigment_map {" + Constants.EOL);
        stringBuffer.append("\t\t\t[" + this.p.transition + " BOZO1]" + Constants.EOL);
        stringBuffer.append("\t\t\t[1 BOZO2]" + Constants.EOL);
        stringBuffer.append("\t\t}" + Constants.EOL);
        stringBuffer.append("\t\tscale " + this.tree.normalizer + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        stringBuffer.append("\tfinish {" + Constants.EOL);
        stringBuffer.append("\t\tphong 0.4*" + this.p.gloss + " phong_size 20*" + this.p.gloss + Constants.EOL);
        stringBuffer.append("\t}" + Constants.EOL);
        stringBuffer.append("}" + Constants.EOL);
        if (this.t.getFoliageFlag()) {
            Foliage foliage = this.t.getFoliage();
            String string = foliage.type;
            if (string.startsWith("LeafUv")) {
                stringBuffer.append(foliage.leafArrayDeclaration + Constants.EOL);
                TableLeaf tableLeaf = null;
                if (foliage.leafArrayElements == null) {
                    throw new PovtreeException(this.messages.getString("noImageMap"));
                }
                int n = 0;
                while (n < foliage.leafArrayElements.size()) {
                    tableLeaf = (TableLeaf)foliage.leafArrayElements.get(n);
                    stringBuffer.append("#declare LeafArray[" + n + "] = texture {" + Constants.EOL + "uv_mapping" + Constants.EOL + "pigment{" + Constants.EOL + "image_map{" + Constants.EOL + tableLeaf.getImageType() + " \"" + tableLeaf.getImageName() + "\"" + Constants.EOL + "map_type 0" + Constants.EOL + "}  rotate z*90" + Constants.EOL + "}" + Constants.EOL);
                    if (tableLeaf.getBumpType() != null) {
                        stringBuffer.append("normal{bump_map{" + tableLeaf.getBumpType() + " \"" + tableLeaf.getBumpName() + "\" " + "map_type 0}");
                        if (tableLeaf.getBumpSize() != null) {
                            stringBuffer.append(" bump_size " + tableLeaf.getBumpSize());
                        }
                        stringBuffer.append("}" + Constants.EOL);
                    }
                    stringBuffer.append("finish {diffuse 0.8}  translate -z*0.5" + Constants.EOL + "};" + Constants.EOL);
                    ++n;
                }
            }
        }
        if (!this.countBytes) {
            this.bos.write(stringBuffer.toString().getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)stringBuffer.toString().length();
        }
    }

    public void setTexture() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("\ttexture {" + Constants.EOL);
        if ((double)this.p.scarHorizontalShrinking > 0.0) {
            stringBuffer.append("\t\tonion" + Constants.EOL);
            stringBuffer.append("\t\ttexture_map {" + Constants.EOL);
            float f = this.p.scarVerticalShrinking * this.tree.normalizer / this.p.scarHorizontalShrinking;
            stringBuffer.append("\t\t\t[0 RINDE scale <1/" + this.p.astl + ", 1/" + f + ", 1/" + this.p.astl + ">]" + Constants.EOL);
            stringBuffer.append("\t\t\t[" + this.p.scarHorizontalShrinking + " ");
            if ((double)this.p.foliageAtEnd == 1.0) {
                stringBuffer.append("RINDE1 ");
            } else {
                stringBuffer.append("RINDE ");
            }
            float f2 = 0.3f / this.p.astl;
            float f3 = 0.3f / (this.p.scarVerticalShrinking * this.tree.normalizer / this.p.scarHorizontalShrinking);
            stringBuffer.append("scale <" + f2 + ", " + f3 + ", " + f2 + ">]" + Constants.EOL);
            stringBuffer.append("\t\t\t[1 ");
            if ((double)this.p.foliageAtEnd == 1.0) {
                stringBuffer.append("LAUB ");
            } else {
                stringBuffer.append("RINDE ");
            }
            f2 = 0.1f / this.p.astl;
            f3 = 0.1f / (this.p.scarVerticalShrinking * this.tree.normalizer / this.p.scarHorizontalShrinking);
            stringBuffer.append("scale <" + f2 + ", " + f3 + ", " + f2 + ">]" + Constants.EOL);
            stringBuffer.append("\t\t}" + Constants.EOL);
            f2 = this.p.astl;
            f3 = this.p.scarVerticalShrinking * this.tree.normalizer / this.p.scarHorizontalShrinking;
            stringBuffer.append("\t\tscale <" + f2 + ", " + f3 + ", " + f2 + ">/" + this.tree.meshScale + Constants.EOL);
        } else {
            stringBuffer.append("\t\tRINDE" + Constants.EOL);
        }
        stringBuffer.append("\t}" + Constants.EOL);
        if (!this.countBytes) {
            this.bos.write(stringBuffer.toString().getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)stringBuffer.toString().length();
        }
    }

    public void setUvTexture() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("\ttexture {" + Constants.EOL + "\t\tpigment {uv_mapping" + Constants.EOL + "\t\t\timage_map {" + Constants.EOL + "\t\t\t\t" + this.imageType + " \"" + this.imageName.trim() + "\" map_type 0 interpolate 0" + Constants.EOL + "\t\t\t}" + Constants.EOL + "\t\t}");
        if (this.bumpName != null && this.bumpName.trim().length() != 0) {
            stringBuffer.append(Constants.EOL + "\t\tnormal {uv_mapping" + Constants.EOL + "\t\t\tbump_map {" + Constants.EOL + "\t\t\t\t" + this.bumpType + " \"" + this.bumpName.trim() + "\" map_type 0 interpolate 0 bump_size ");
            if (this.bumpSize != null && this.bumpSize.trim().length() != 0) {
                stringBuffer.append(this.bumpSize + Constants.EOL + "\t\t\t}" + Constants.EOL + "\t\t}");
            } else {
                stringBuffer.append("2" + Constants.EOL + "\t\t\t}" + Constants.EOL + "\t\t}");
            }
        }
        stringBuffer.append(Constants.EOL + "\t}" + Constants.EOL);
        if (!this.countBytes) {
            this.bos.write(stringBuffer.toString().getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)stringBuffer.toString().length();
        }
    }

    public float getDistanceBetweenTwoBlobs(Blob blob, Blob blob2) {
        float f = blob.center.x - blob2.center.x;
        float f2 = blob.center.y - blob2.center.y;
        float f3 = blob.center.z - blob2.center.z;
        return (float)Math.abs(Math.sqrt(f * f + f2 * f2 + f3 * f3));
    }

    public float getAngleZ(float f, float f2) {
        if (f2 > 0.0f) {
            return (float)Math.toDegrees(Math.atan2(f2, f));
        }
        return 360.0f + (float)Math.toDegrees(Math.atan2(f2, f));
    }

    public float getAngleX(float f, float f2) {
        float f3 = -f2;
        if (f3 > 0.0f) {
            return (float)Math.toDegrees(Math.atan2(f3, f));
        }
        return 360.0f + (float)Math.toDegrees(Math.atan2(f3, f));
    }

    public long getNumberOfKBytes() {
        return this.numberOfBytes / 1000L;
    }
}

