/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ResourceBundle;
import povtree.gui.PovTree;
import povtree.gui.PovtreeException;
import povtree.gui.Resources;
import povtree.interfaces.Constants;
import povtree.interfaces.Generator;
import povtree.interfaces.Leaf;
import povtree.objects.Tree;
import povtree.objects3D.Blob;
import povtree.objects3D.Coordinate;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.DoubleLeafArray;
import povtree.objects3D.LeafArray;
import povtree.objects3D.QuadroBlobArray;
import povtree.objects3D.QuadroLeafArray;
import povtree.objects3D.QuintetBlobArray;
import povtree.objects3D.Tree3D;
import povtree.objects3D.Triangle;
import povtree.objects3D.TripleBlobArray;
import povtree.objects3D.TripleLeafArray;
import povtree.povTreeGenerator.Accuracy;
import povtree.povTreeGenerator.Statistics;

public class ObjGenerator
implements Constants,
Generator {
    private Tree t;
    private Tree3D tree;
    private BufferedOutputStream bos;
    private Accuracy accuracy;
    private ArrayList prev = null;
    private boolean start = false;
    private short VERTEX = 0;
    private short TRIANGLES = 1;
    private Statistics st = null;
    private boolean countBytes = false;
    private long numberOfBytes = 0L;
    private Resources resources = Resources.getInstance();
    private ResourceBundle messages = Resources.getMessagesBundle();
    private PovTree frame = null;

    public ObjGenerator(Tree tree, Tree3D tree3D, BufferedOutputStream bufferedOutputStream, Accuracy accuracy, boolean bl, PovTree povTree) throws NumberFormatException {
        this.t = tree;
        this.tree = tree3D;
        this.bos = bufferedOutputStream;
        this.accuracy = accuracy;
        this.st = new Statistics(this.tree, this.accuracy);
        this.countBytes = bl;
        this.frame = povTree;
    }

    public void checkThreadStatus() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public void generateMesh() throws PovtreeException, IOException, InterruptedException {
        QuintetBlobArray quintetBlobArray;
        TripleBlobArray tripleBlobArray;
        DoubleBlobArray doubleBlobArray;
        ArrayList arrayList;
        DoubleBlobArray doubleBlobArray2;
        QuadroLeafArray quadroLeafArray;
        int n;
        ArrayList arrayList2;
        int n2;
        Cloneable cloneable;
        String string = new String();
        if (this.t.getFoliageFlag() && this.tree.getFoliage() instanceof QuadroBlobArray) {
            throw new PovtreeException(this.messages.getString("calculateMeshLeaves"));
        }
        if (this.t.getBlossomFlag() && this.tree.getBlossom() instanceof QuadroBlobArray) {
            throw new PovtreeException(this.messages.getString("calculateMeshBlossom"));
        }
        if (this.t.getRootFlag() || this.t.getTrunkFlag() || this.t.getBranchesFlag() || this.t.getTwigsFlag() || this.t.getRamiFlag() || this.t.getFoliageFlag()) {
            string = "# file generated by POV-Tree" + Constants.EOL + Constants.EOL;
            if (!this.countBytes) {
                this.bos.write(string.getBytes());
                this.bos.flush();
            } else {
                this.numberOfBytes += (long)string.length();
            }
        }
        if (this.t.getFoliageFlag()) {
            cloneable = (QuadroLeafArray)this.tree.getFoliage();
            if (cloneable != null) {
                this.frame.updateStatus(0, "calculatingFoliage");
                this.generateLeavesVertexes((QuadroLeafArray)cloneable);
                if (this.bos == null) {
                    this.frame.updateStatus(20, "calculatingBlossom");
                } else {
                    this.frame.updateStatus(20, "savingBlossom");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(20, "calculatingBlossom");
            } else {
                this.frame.updateStatus(20, "savingBlossom");
            }
        }
        if (this.t.getBlossomFlag()) {
            cloneable = (QuadroLeafArray)this.tree.getBlossom();
            if (cloneable != null) {
                this.generateLeavesVertexes((QuadroLeafArray)cloneable);
                if (this.bos == null) {
                    this.frame.updateStatus(40, "calculatingRoots");
                } else {
                    this.frame.updateStatus(40, "savingRoots");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(40, "calculatingRoots");
            } else {
                this.frame.updateStatus(40, "savingRoots");
            }
        }
        if (this.t.getRootFlag()) {
            cloneable = this.tree.getRoot();
            if (cloneable != null) {
                n2 = 0;
                while (n2 < ((DoubleBlobArray)cloneable).size()) {
                    this.checkThreadStatus();
                    arrayList2 = ((DoubleBlobArray)cloneable).get(n2).get();
                    this.generateTreeElement(arrayList2, this.accuracy.rootRadial, this.accuracy.rootVertical, this.VERTEX, 0L);
                    ++n2;
                }
                if (this.bos == null) {
                    this.frame.updateStatus(50, "calculatingTrunk");
                } else {
                    this.frame.updateStatus(50, "savingTrunk");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(50, "calculatingTrunk");
            } else {
                this.frame.updateStatus(50, "savingTrunk");
            }
        }
        if (this.t.getTrunkFlag()) {
            cloneable = this.tree.getTrunk().get();
            if (cloneable != null && ((ArrayList)cloneable).size() != 0) {
                this.generateTreeElement((ArrayList)cloneable, this.accuracy.trunkRadial, this.accuracy.trunkVertical, this.VERTEX, 0L);
                if (this.bos == null) {
                    this.frame.updateStatus(60, "calculatingBranches");
                } else {
                    this.frame.updateStatus(60, "savingBranches");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(60, "calculatingBranches");
            } else {
                this.frame.updateStatus(60, "savingBranches");
            }
        }
        if (this.t.getBranchesFlag()) {
            cloneable = this.tree.getBranches();
            if (cloneable != null) {
                n2 = 0;
                while (n2 < ((DoubleBlobArray)cloneable).size()) {
                    this.checkThreadStatus();
                    arrayList2 = ((DoubleBlobArray)cloneable).get(n2).get();
                    this.generateTreeElement(arrayList2, this.accuracy.branchRadial, this.accuracy.branchVertical, this.VERTEX, 0L);
                    ++n2;
                }
                if (this.bos == null) {
                    this.frame.updateStatus(70, "calculatingTwigs");
                } else {
                    this.frame.updateStatus(70, "savingTwigs");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(70, "calculatingTwigs");
            } else {
                this.frame.updateStatus(70, "savingTwigs");
            }
        }
        if (this.t.getTwigsFlag()) {
            cloneable = this.tree.getTwigs();
            if (cloneable != null) {
                int n3 = 0;
                while (n3 < ((TripleBlobArray)cloneable).size()) {
                    this.checkThreadStatus();
                    DoubleBlobArray doubleBlobArray3 = ((TripleBlobArray)cloneable).get(n3);
                    int n4 = 0;
                    while (n4 < doubleBlobArray3.size()) {
                        arrayList2 = doubleBlobArray3.get(n4).get();
                        this.generateTreeElement(arrayList2, this.accuracy.twigRadial, this.accuracy.twigVertical, this.VERTEX, 0L);
                        ++n4;
                    }
                    ++n3;
                }
                if (this.bos == null) {
                    this.frame.updateStatus(80, "calculatingRami");
                } else {
                    this.frame.updateStatus(80, "savingRami");
                }
            } else if (this.bos == null) {
                this.frame.updateStatus(80, "calculatingRami");
            } else {
                this.frame.updateStatus(80, "savingRami");
            }
        }
        if (this.t.getRamiFlag()) {
            QuintetBlobArray quintetBlobArray2 = this.tree.getRami();
            if (quintetBlobArray2 != null) {
                int n5 = 0;
                while (n5 < quintetBlobArray2.size()) {
                    this.checkThreadStatus();
                    cloneable = quintetBlobArray2.get(n5);
                    int n6 = 0;
                    while (n6 < ((QuadroBlobArray)cloneable).size()) {
                        TripleBlobArray tripleBlobArray2 = ((QuadroBlobArray)cloneable).get(n6);
                        int n7 = 0;
                        while (n7 < tripleBlobArray2.size()) {
                            DoubleBlobArray doubleBlobArray4 = tripleBlobArray2.get(n7);
                            n = 0;
                            while (n < doubleBlobArray4.size()) {
                                arrayList2 = doubleBlobArray4.get(n).get();
                                this.generateTreeElement(arrayList2, this.accuracy.ramiRadial, this.accuracy.ramiVertical, this.VERTEX, 0L);
                                ++n;
                            }
                            ++n7;
                        }
                        ++n6;
                    }
                    ++n5;
                }
                this.frame.updateStatus(90, "transformingTree");
            } else {
                this.frame.updateStatus(90, "transformingTree");
            }
        }
        string = "g" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        if (this.t.getFoliageFlag() && (cloneable = (QuadroLeafArray)this.tree.getFoliage()) != null) {
            this.checkThreadStatus();
            this.generateLeavesFaces((QuadroLeafArray)cloneable, 0L, this.st.getFoliageVertexes(), this.st.getNumberOfLeaves());
        }
        long l = this.st.getFoliageVertexes();
        string = "g" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        if (this.t.getBlossomFlag() && (quadroLeafArray = (QuadroLeafArray)this.tree.getBlossom()) != null) {
            this.checkThreadStatus();
            this.generateLeavesFaces(quadroLeafArray, l, this.st.getBlossomVertexes(), this.st.getNumberOfBlossoms());
        }
        l += this.st.getBlossomVertexes();
        string = "g" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        if (this.t.getRootFlag() && (doubleBlobArray2 = this.tree.getRoot()) != null) {
            long l2 = this.st.getNumberOfRootFaces();
            long l3 = l2 + (long)this.accuracy.rootRadial;
            n = 0;
            while (n < doubleBlobArray2.size()) {
                this.checkThreadStatus();
                arrayList2 = doubleBlobArray2.get(n).get();
                l2 = l3 * (long)n;
                this.generateTreeElement(arrayList2, this.accuracy.rootRadial, this.accuracy.rootVertical, this.TRIANGLES, l + l2);
                ++n;
            }
            l += l2 + l3;
        }
        string = "g" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        if (this.t.getTrunkFlag() && (arrayList = this.tree.getTrunk().get()) != null && arrayList.size() != 0) {
            this.checkThreadStatus();
            this.generateTreeElement(arrayList, this.accuracy.trunkRadial, this.accuracy.trunkVertical, this.TRIANGLES, l);
            long l4 = this.st.getNumberOfTrunkFaces();
            l += l4 + (long)this.accuracy.trunkRadial;
        }
        string = "g" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        if (this.t.getBranchesFlag() && (doubleBlobArray = this.tree.getBranches()) != null) {
            long l5 = this.st.getNumberOfBranchFaces();
            long l6 = l5 + (long)this.accuracy.branchRadial;
            n = 0;
            while (n < doubleBlobArray.size()) {
                this.checkThreadStatus();
                arrayList2 = doubleBlobArray.get(n).get();
                l5 = l6 * (long)n;
                this.generateTreeElement(arrayList2, this.accuracy.branchRadial, this.accuracy.branchVertical, this.TRIANGLES, l + l5);
                ++n;
            }
            l += l5 + l6;
        }
        string = "g" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        if (this.t.getTwigsFlag() && (tripleBlobArray = this.tree.getTwigs()) != null) {
            long l7 = this.st.getNumberOfTwigFaces();
            long l8 = l7 + (long)this.accuracy.twigRadial;
            int n8 = 0;
            while (n8 < tripleBlobArray.size()) {
                this.checkThreadStatus();
                DoubleBlobArray doubleBlobArray5 = tripleBlobArray.get(n8);
                int n9 = 0;
                while (n9 < doubleBlobArray5.size()) {
                    arrayList2 = doubleBlobArray5.get(n9).get();
                    l7 = l8 * (long)n9;
                    this.generateTreeElement(arrayList2, this.accuracy.twigRadial, this.accuracy.twigVertical, this.TRIANGLES, l + l7);
                    ++n9;
                }
                l += l7 + l8;
                ++n8;
            }
        }
        string = "g" + Constants.EOL;
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
        if (this.t.getRamiFlag() && (quintetBlobArray = this.tree.getRami()) != null) {
            long l9 = this.st.getNumberOfRamiFaces();
            long l10 = l9 + (long)this.accuracy.ramiRadial;
            int n10 = 0;
            while (n10 < quintetBlobArray.size()) {
                this.checkThreadStatus();
                QuadroBlobArray quadroBlobArray = quintetBlobArray.get(n10);
                int n11 = 0;
                while (n11 < quadroBlobArray.size()) {
                    TripleBlobArray tripleBlobArray3 = quadroBlobArray.get(n11);
                    int n12 = 0;
                    while (n12 < tripleBlobArray3.size()) {
                        DoubleBlobArray doubleBlobArray6 = tripleBlobArray3.get(n12);
                        int n13 = 0;
                        while (n13 < doubleBlobArray6.size()) {
                            arrayList2 = doubleBlobArray6.get(n13).get();
                            l9 = l10 * (long)n13;
                            this.generateTreeElement(arrayList2, this.accuracy.ramiRadial, this.accuracy.ramiVertical, this.TRIANGLES, l + l9);
                            ++n13;
                        }
                        l += l9 + l10;
                        ++n12;
                    }
                    ++n11;
                }
                ++n10;
            }
        }
        this.checkThreadStatus();
        if (this.bos == null) {
            this.frame.updateStatus(0, "statsDone");
        } else {
            this.frame.updateStatus(0, "savingDone");
        }
    }

    public void generateLeavesVertexes(QuadroLeafArray quadroLeafArray) throws IOException, InterruptedException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < quadroLeafArray.size()) {
            this.checkThreadStatus();
            TripleLeafArray tripleLeafArray = quadroLeafArray.get(n);
            if (tripleLeafArray != null) {
                int n2 = 0;
                while (n2 < tripleLeafArray.size()) {
                    DoubleLeafArray doubleLeafArray = tripleLeafArray.get(n2);
                    if (doubleLeafArray != null) {
                        int n3 = 0;
                        while (n3 < doubleLeafArray.size()) {
                            LeafArray leafArray = doubleLeafArray.get(n3);
                            if (leafArray != null) {
                                int n4 = 0;
                                while (n4 < leafArray.size()) {
                                    String string;
                                    Leaf leaf = leafArray.get(n4);
                                    hashtable = new Hashtable();
                                    ArrayList arrayList = leaf.getTriangles();
                                    int n5 = 0;
                                    while (n5 < arrayList.size()) {
                                        Triangle triangle = (Triangle)arrayList.get(n5);
                                        Coordinate coordinate = triangle.c1;
                                        String string2 = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "v " + coordinate.x + " " + coordinate.y + " " + coordinate.z + Constants.EOL;
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        Coordinate coordinate2 = triangle.c2;
                                        string2 = String.valueOf(coordinate2.x) + String.valueOf(coordinate2.y) + String.valueOf(coordinate2.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "v " + coordinate2.x + " " + coordinate2.y + " " + coordinate2.z + Constants.EOL;
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        Coordinate coordinate3 = triangle.c3;
                                        string2 = String.valueOf(coordinate3.x) + String.valueOf(coordinate3.y) + String.valueOf(coordinate3.z);
                                        if (hashtable.get(string2) == null) {
                                            hashtable.put(string2, "");
                                            string = "v " + coordinate3.x + " " + coordinate3.y + " " + coordinate3.z + Constants.EOL;
                                            if (!this.countBytes) {
                                                this.bos.write(string.getBytes());
                                                this.bos.flush();
                                            } else {
                                                this.numberOfBytes += (long)string.length();
                                            }
                                        }
                                        ++n5;
                                    }
                                    string = Constants.EOL;
                                    if (!this.countBytes) {
                                        this.bos.write(string.getBytes());
                                        this.bos.flush();
                                    } else {
                                        this.numberOfBytes += (long)string.length();
                                    }
                                    ++n4;
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void generateLeavesFaces(QuadroLeafArray quadroLeafArray, long l, long l2, long l3) throws IOException, InterruptedException {
        Hashtable<Object, Long> hashtable = new Hashtable<Object, Long>();
        long l4 = l2 / l3;
        long l5 = 0L;
        int n = 0;
        while (n < quadroLeafArray.size()) {
            this.checkThreadStatus();
            TripleLeafArray tripleLeafArray = quadroLeafArray.get(n);
            if (tripleLeafArray != null) {
                int n2 = 0;
                while (n2 < tripleLeafArray.size()) {
                    DoubleLeafArray doubleLeafArray = tripleLeafArray.get(n2);
                    if (doubleLeafArray != null) {
                        int n3 = 0;
                        while (n3 < doubleLeafArray.size()) {
                            LeafArray leafArray = doubleLeafArray.get(n3);
                            if (leafArray != null) {
                                int n4 = 0;
                                while (n4 < leafArray.size()) {
                                    String string;
                                    Object object;
                                    Object object2;
                                    Triangle triangle;
                                    Leaf leaf = leafArray.get(n4);
                                    ArrayList arrayList = leaf.getTriangles();
                                    hashtable = new Hashtable();
                                    long l6 = 0L;
                                    int n5 = 0;
                                    while (n5 < arrayList.size()) {
                                        triangle = (Triangle)arrayList.get(n5);
                                        Coordinate coordinate = triangle.c1;
                                        object2 = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l6));
                                            ++l6;
                                        }
                                        object = triangle.c2;
                                        object2 = String.valueOf(((Coordinate)object).x) + String.valueOf(((Coordinate)object).y) + String.valueOf(((Coordinate)object).z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l6));
                                            ++l6;
                                        }
                                        Coordinate coordinate2 = triangle.c3;
                                        object2 = String.valueOf(coordinate2.x) + String.valueOf(coordinate2.y) + String.valueOf(coordinate2.z);
                                        if (hashtable.get(object2) == null) {
                                            hashtable.put(object2, new Long(l6));
                                            ++l6;
                                        }
                                        ++n5;
                                    }
                                    int n6 = 0;
                                    while (n6 < arrayList.size()) {
                                        triangle = (Triangle)arrayList.get(n6);
                                        object2 = triangle.c1;
                                        object = String.valueOf(((Coordinate)object2).x) + String.valueOf(((Coordinate)object2).y) + String.valueOf(((Coordinate)object2).z);
                                        long l7 = (Long)hashtable.get(object) + l5;
                                        Coordinate coordinate = triangle.c2;
                                        object = String.valueOf(coordinate.x) + String.valueOf(coordinate.y) + String.valueOf(coordinate.z);
                                        long l8 = (Long)hashtable.get(object) + l5;
                                        Coordinate coordinate3 = triangle.c3;
                                        object = String.valueOf(coordinate3.x) + String.valueOf(coordinate3.y) + String.valueOf(coordinate3.z);
                                        long l9 = (Long)hashtable.get(object) + l5;
                                        string = "f " + (l7 + 1L + l) + " " + (l8 + 1L + l) + " " + (l9 + 1L + l) + Constants.EOL;
                                        if (!this.countBytes) {
                                            this.bos.write(string.getBytes());
                                            this.bos.flush();
                                        } else {
                                            this.numberOfBytes += (long)string.length();
                                        }
                                        ++n6;
                                    }
                                    string = Constants.EOL;
                                    if (!this.countBytes) {
                                        this.bos.write(string.getBytes());
                                        this.bos.flush();
                                    } else {
                                        this.numberOfBytes += (long)string.length();
                                    }
                                    l5 += l4;
                                    ++n4;
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void generateTreeElement(ArrayList arrayList, int n, int n2, short s, long l) throws IOException {
        int n3 = arrayList.size();
        this.prev = new ArrayList(n * 2);
        this.start = true;
        int n4 = 0;
        while (n4 < n * 2) {
            this.prev.add(new Coordinate());
            ++n4;
        }
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        while (n6 < n3) {
            bl = n6 + n2 >= n3;
            Blob blob = (Blob)arrayList.get(n6);
            Blob blob2 = n6 + n2 < n3 ? (Blob)arrayList.get(n6 + n2) : (Blob)arrayList.get(n3 - 1);
            this.generateTreeSection(blob, blob2, n, n5, bl, s, l);
            ++n5;
            n6 += n2;
        }
    }

    public void generateTreeSection(Blob blob, Blob blob2, int n, int n2, boolean bl, short s, long l) throws IOException {
        Blob blob3 = (Blob)blob.clone();
        Blob blob4 = (Blob)blob2.clone();
        Blob blob5 = (Blob)blob2.clone();
        Coordinate coordinate = blob3.center;
        Coordinate coordinate2 = null;
        Coordinate coordinate3 = null;
        Coordinate coordinate4 = null;
        Coordinate coordinate5 = null;
        float f = (float)(360.0 / (double)n);
        String string = Constants.EOL;
        float f2 = this.getDistanceBetweenTwoBlobs(blob, blob2);
        float f3 = this.getAngleX(blob2.center.z, blob2.center.y);
        blob5.center.x -= blob3.center.x;
        blob5.center.y -= blob3.center.y;
        blob5.center.z -= blob3.center.z;
        blob5.rotateX(90.0f - f3);
        float f4 = this.getAngleZ(blob5.center.x, blob5.center.y);
        int n3 = 0;
        while (n3 < n) {
            if (this.start) {
                coordinate2 = new Coordinate();
                coordinate2.translateX(blob3.radius);
                coordinate2.rotateY(f * (float)n3);
                coordinate2.rotateZ(-90.0f - f4);
                coordinate2.rotateX(-90.0f - f3);
                coordinate2.mirrorZ();
                coordinate2.translate(coordinate.x, coordinate.y, coordinate.z);
            } else {
                coordinate2 = (Coordinate)this.prev.get(n3 * 2);
            }
            if (this.start) {
                coordinate5 = new Coordinate();
                coordinate5.translateX(blob3.radius);
                coordinate5.rotateY(f * (float)n3 + f);
                coordinate5.rotateZ(-90.0f - f4);
                coordinate5.rotateX(-90.0f - f3);
                coordinate5.mirrorZ();
                coordinate5.translate(coordinate.x, coordinate.y, coordinate.z);
            } else {
                coordinate5 = (Coordinate)this.prev.get(n3 * 2 + 1);
            }
            coordinate3 = new Coordinate();
            coordinate3.translate(blob4.radius, f2, 0.0f);
            coordinate3.rotateY(f * (float)n3);
            coordinate3.rotateZ(-90.0f - f4);
            coordinate3.rotateX(-90.0f - f3);
            coordinate3.mirrorZ();
            coordinate3.translate(coordinate.x, coordinate.y, coordinate.z);
            this.prev.set(n3 * 2, coordinate3.clone());
            coordinate4 = new Coordinate();
            coordinate4.translate(blob4.radius, f2, 0.0f);
            coordinate4.rotateY(f * (float)n3 + f);
            coordinate4.rotateZ(-90.0f - f4);
            coordinate4.rotateX(-90.0f - f3);
            coordinate4.mirrorZ();
            coordinate4.translate(coordinate.x, coordinate.y, coordinate.z);
            this.prev.set(n3 * 2 + 1, coordinate4.clone());
            if (bl && s == this.VERTEX) {
                string = string + "v " + coordinate3.x + " " + coordinate3.y + " " + coordinate3.z + Constants.EOL;
            }
            this.saveFacet(coordinate2, n2, n3, s, n, l);
            ++n3;
        }
        if (this.start) {
            this.start = false;
        }
        if (bl && s == this.VERTEX) {
            if (!this.countBytes) {
                this.bos.write(new String(string).getBytes());
                this.bos.flush();
            } else {
                this.numberOfBytes += (long)string.length();
            }
        }
        if (!this.countBytes) {
            this.bos.write(Constants.EOL.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
    }

    public void saveFacet(Coordinate coordinate, int n, int n2, short s, int n3, long l) throws IOException {
        String string = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (s == this.VERTEX) {
            string = "v " + coordinate.x + " " + coordinate.y + " " + coordinate.z + Constants.EOL;
        } else {
            if (n2 == n3 - 1) {
                n7 = n3 * n + n2 + 1;
                n4 = n3 * n + 1;
                n6 = n7 + n3;
                n5 = n4 + n3;
            } else {
                n7 = n3 * n + n2 + 1;
                n4 = n7 + 1;
                n6 = n7 + n3;
                n5 = n6 + 1;
            }
            string = "f " + ((long)n4 + l) + " " + ((long)n5 + l) + " " + ((long)n6 + l) + " " + ((long)n7 + l) + Constants.EOL;
        }
        if (!this.countBytes) {
            this.bos.write(string.getBytes());
            this.bos.flush();
        } else {
            this.numberOfBytes += (long)string.length();
        }
    }

    public float getDistanceBetweenTwoBlobs(Blob blob, Blob blob2) {
        float f = blob.center.x - blob2.center.x;
        float f2 = blob.center.y - blob2.center.y;
        float f3 = blob.center.z - blob2.center.z;
        return (float)Math.abs(Math.sqrt(f * f + f2 * f2 + f3 * f3));
    }

    public float getAngleZ(float f, float f2) {
        if (f2 > 0.0f) {
            return (float)Math.toDegrees(Math.atan2(f2, f));
        }
        return 360.0f + (float)Math.toDegrees(Math.atan2(f2, f));
    }

    public float getAngleX(float f, float f2) {
        float f3 = -f2;
        if (f3 > 0.0f) {
            return (float)Math.toDegrees(Math.atan2(f3, f));
        }
        return 360.0f + (float)Math.toDegrees(Math.atan2(f3, f));
    }

    public long getNumberOfKBytes() {
        return this.numberOfBytes / 1000L;
    }
}

