/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import java.util.ArrayList;
import povtree.objects.Bark;
import povtree.objects.Blossom;
import povtree.objects.Branch;
import povtree.objects.Bunch;
import povtree.objects.Foliage;
import povtree.objects.Rami;
import povtree.objects.Root;
import povtree.objects.Tree;
import povtree.objects.Trunk;
import povtree.objects.Twig;

public class Parameters {
    public float branches;
    public float twigs;
    public float bunches;
    public float leaves;
    public float blossoms;
    public float roots;
    public float branchRandom;
    public float twigRandom;
    public float rootRandom;
    public float trunkRadius;
    public float trunkStrength;
    public float trunkBendX;
    public float trunkBendZ;
    public float trunkBendXFrequency;
    public float trunkBendZFrequency;
    public float trunkCurve;
    public float trunkCurveFrequency;
    public float trunkSnag;
    public float trunkSnagFrequency;
    public float trunkSpiral;
    public float trunkTaper;
    public float firstBranchAtTrunk;
    public float branchAreaAtTrunk;
    public float branchThicknessChange;
    public float branchStrength;
    public float branchBend;
    public float branchBendFrequency;
    public float horizontalBranchBendSwitch;
    public float extraNoiseSwitch;
    public float branchCurve;
    public float branchCurveFrequency;
    public float horizontalBranchCurveSwitch;
    public float branchLongitudinalCurve;
    public float branchSnag;
    public float branchSnagFrequency;
    public float branchReduction;
    public float branchTaper;
    public float branchEndEqualizer;
    public float branchTip;
    public float branchTurnSwitch;
    public float branchAlternateSwitch;
    public float branchSpiral;
    public float branchAngle;
    public float branchAngleScope;
    public float branchAlignment;
    public float straightenTowardsTop;
    public float firstTwigAtBranch;
    public float twigAreaAtBranch;
    public float twigStrength;
    public float twigThicknessChange;
    public float horizontalTwigAngle;
    public float verticalTwigAngle;
    public float horizontalTwigAngleScope;
    public float verticalTwigAngleScope;
    public float horizontalTwigAlignment;
    public float verticalTwigAlignment;
    public float twigTurnSwitch;
    public float twigAlternateSwitch;
    public float twigCurveAdjustment;
    public float twigCurveFrequencyAdjustment;
    public float twigTaper;
    public float twigTip;
    public float straightenTowardsBranchEnd;
    public float twigRamificationOrder;
    public float lastRamificationNumber;
    public float twigRamificationThicknessChange;
    public float twigRamificationCurveAdjustment;
    public float ramiCurveFrequencyAdjustment;
    public float twigRamificationStrength;
    public float firstBunchAtTwig;
    public float bunchAreaAtTwig;
    public float bunchMajorRadius;
    public float bunchMinorRadius;
    public float horizontalBunchFunnel;
    public float verticalBunchFunnel;
    public float rotationBunchFunnel;
    public float horizontalBunchAngle;
    public float verticalBunchAngle;
    public float horizontalBunchAngleScope;
    public float verticalBunchAngleScope;
    public float bunchTurnSwitch;
    public float bunchTurnShift;
    public float bunchAlternateSwitch;
    public float horizontalBunchAlignment;
    public float verticalBunchAlignment;
    public float bunchTaperOffAtTwig;
    public float bunchTaperOffAtBranch;
    public float bunchTaperOffAtTree;
    public float bunchArcAtTwigX;
    public float bunchArcAtTwigY;
    public float bunchArcAtTwigZ;
    public float bunchArcAtBranchX;
    public float bunchArcAtBranchY;
    public float bunchArcAtBranchZ;
    public float bunchDeformX;
    public float bunchDeformY;
    public float bunchDeformZ;
    public String leafType;
    public float bunchLeaves;
    public float leafLength;
    public float leafBreadth;
    public float leafHeight;
    public float maxLeafTilt;
    public float maxLeafTurn;
    public float leafInclination;
    public float leafInclinationScope;
    public float bottomR1;
    public float bottomG1;
    public float bottomB1;
    public float bottomR2;
    public float bottomG2;
    public float bottomB2;
    public float topR1;
    public float topG1;
    public float topB1;
    public float topR2;
    public float topG2;
    public float topB2;
    public float turbulence;
    public float transition;
    public float transitionTurbulence;
    public float gloss;
    public float filter;
    public float transparency;
    public String customMesh;
    public ArrayList leafUvType;
    public String blossomType;
    public float blossomLength;
    public float blossomWidth;
    public float blossomInclination;
    public float blossomR;
    public float blossomG;
    public float blossomB;
    public String customBlossomMesh;
    public float firstRootAtTrunk;
    public float rootLength;
    public float rootThicknessChange;
    public float rootStrength;
    public float rootBend;
    public float rootBendFrequency;
    public float rootCurve;
    public float rootCurveFrequency;
    public float rootSnag;
    public float rootSnagFrequency;
    public float rootTurnSwitch;
    public float rootAngle;
    public float rootAlignment;
    public float sunkenR;
    public float sunkenG;
    public float sunkenB;
    public float raisedR;
    public float raisedG;
    public float raisedB;
    public float palmTrunk;
    public float barkProfile;
    public float branchBarkProfileChange;
    public float branchBarkProfileTaperOff;
    public float rootBarkProfileChange;
    public float foliageAtEnd;
    public float scarWidth;
    public float scarHeight;
    public float scarDepth;
    public float scarHorizontalShrinking;
    public float scarVerticalShrinking;
    public float zl;
    public float zwl;
    public float astl;
    public float bh;
    public float aw;
    public float akk;
    public float abg;
    public float abfz;
    public float zbfza;
    public float rfza;
    public float unit1;

    public Parameters(Tree tree) throws NumberFormatException {
        Root root = tree.getRoot();
        Trunk trunk = tree.getTrunk();
        Branch branch = tree.getBranch();
        Twig twig = tree.getTwig();
        Rami rami = tree.getRami();
        Bunch bunch = tree.getBunch();
        Bark bark = tree.getBark();
        Foliage foliage = tree.getFoliage();
        Blossom blossom = tree.getBlossom();
        this.branches = this.getFloat(branch.number);
        this.twigs = this.getFloat(twig.number) * this.branches;
        this.bunches = this.getFloat(bunch.number) * this.twigs;
        this.leaves = this.getFloat(foliage.number) * this.bunches;
        this.blossoms = this.getFloat(blossom.number) * this.bunches;
        this.roots = this.getFloat(root.number);
        this.branchRandom = this.getFloat(branch.randomness);
        this.twigRandom = this.getFloat(twig.randomness);
        this.rootRandom = this.getFloat(root.randomness);
        this.trunkRadius = this.getFloat(trunk.radius);
        this.trunkStrength = this.getFloat(trunk.strength);
        this.trunkBendX = this.getFloat(trunk.bendValueX);
        this.trunkBendZ = this.getFloat(trunk.bendValueZ);
        this.trunkBendXFrequency = this.getFloat(trunk.bendFrequencyX);
        this.trunkBendZFrequency = this.getFloat(trunk.bendFrequencyZ);
        this.trunkCurve = this.getFloat(trunk.curveValue);
        this.trunkCurveFrequency = this.getFloat(trunk.curveFrequency);
        this.trunkSnag = this.getFloat(trunk.snagValue);
        this.trunkSnagFrequency = this.getFloat(trunk.snagFrequency);
        this.trunkSpiral = this.getFloat(trunk.spiral);
        this.trunkTaper = this.getFloat(trunk.taper);
        this.firstBranchAtTrunk = this.getFloat(branch.startAt);
        this.branchAreaAtTrunk = this.getFloat(branch.areaAtTrunk);
        this.branchThicknessChange = this.getFloat(branch.thicknessRatio);
        this.branchStrength = this.getFloat(branch.strength);
        this.branchBend = this.getFloat(branch.bendValue);
        this.branchBendFrequency = this.getFloat(branch.bendFrequency);
        this.horizontalBranchBendSwitch = this.getFloat(branch.horizontalBend);
        this.extraNoiseSwitch = this.getFloat(branch.extraNoise);
        this.branchCurve = this.getFloat(branch.curveValue);
        this.branchCurveFrequency = this.getFloat(branch.curveFrequency);
        this.horizontalBranchCurveSwitch = this.getFloat(branch.horizontalCurve);
        this.branchLongitudinalCurve = this.getFloat(branch.longitudinal);
        this.branchSnag = this.getFloat(branch.snagValue);
        this.branchSnagFrequency = this.getFloat(branch.snagFrequency);
        this.branchReduction = this.getFloat(branch.reduction);
        this.branchTaper = this.getFloat(branch.taper);
        this.branchEndEqualizer = this.getFloat(branch.endEqualizer);
        this.branchTip = this.getFloat(branch.tip);
        this.branchTurnSwitch = this.getFloat(branch.turn);
        this.branchAlternateSwitch = this.getFloat(branch.alternate);
        this.branchSpiral = this.getFloat(branch.spiral);
        this.branchAngle = this.getFloat(branch.angle);
        this.branchAngleScope = this.getFloat(branch.angleScope);
        this.branchAlignment = this.getFloat(branch.alignment);
        this.straightenTowardsTop = this.getFloat(branch.straightenTowardsTop);
        this.firstTwigAtBranch = this.getFloat(twig.startAt);
        this.twigAreaAtBranch = this.getFloat(twig.areaAtBranch);
        this.twigStrength = this.getFloat(twig.strength);
        this.twigThicknessChange = this.getFloat(twig.thicknessRatio);
        this.horizontalTwigAngle = this.getFloat(twig.horizontalAngle);
        this.verticalTwigAngle = this.getFloat(twig.verticalAngle);
        this.horizontalTwigAngleScope = this.getFloat(twig.horizontalAngleScope);
        this.verticalTwigAngleScope = this.getFloat(twig.verticalAngleScope);
        this.horizontalTwigAlignment = this.getFloat(twig.horizontalAlignment);
        this.verticalTwigAlignment = this.getFloat(twig.verticalAlignment);
        this.twigTurnSwitch = this.getFloat(twig.turn);
        this.twigAlternateSwitch = this.getFloat(twig.alternate);
        this.twigCurveAdjustment = this.getFloat(twig.curveValue);
        this.twigCurveFrequencyAdjustment = this.getFloat(twig.curveFrequency);
        this.twigTaper = this.getFloat(twig.taper);
        this.twigTip = this.getFloat(twig.tip);
        this.straightenTowardsBranchEnd = this.getFloat(twig.straightenTowardsBranch);
        this.twigRamificationOrder = this.getFloat(rami.ramiOrder);
        this.lastRamificationNumber = this.getFloat(rami.ramiNumber);
        this.twigRamificationThicknessChange = this.getFloat(rami.ramiThickness);
        this.twigRamificationCurveAdjustment = this.getFloat(rami.ramiCurveAdjustment);
        this.ramiCurveFrequencyAdjustment = this.getFloat(rami.ramiCurveFrequency);
        this.twigRamificationStrength = this.getFloat(rami.ramiStrength);
        this.firstBunchAtTwig = this.getFloat(bunch.startAt);
        this.bunchAreaAtTwig = this.getFloat(bunch.areaAtTwig);
        this.bunchMajorRadius = this.getFloat(bunch.majorRadius) + 1.0E-6f;
        this.bunchMinorRadius = this.getFloat(bunch.minorRadius) + 1.0E-6f;
        this.horizontalBunchFunnel = this.getFloat(bunch.funnelHorizontal);
        this.verticalBunchFunnel = this.getFloat(bunch.funnelVertical);
        this.rotationBunchFunnel = this.getFloat(bunch.funnelRotation);
        this.horizontalBunchAngle = this.getFloat(bunch.horizontalAngle);
        this.verticalBunchAngle = this.getFloat(bunch.verticalAngle);
        this.horizontalBunchAngleScope = this.getFloat(bunch.horizontalAngleScope);
        this.verticalBunchAngleScope = this.getFloat(bunch.verticalAngleScope);
        this.bunchTurnSwitch = this.getFloat(bunch.turn);
        this.bunchTurnShift = this.getFloat(bunch.turnShift);
        this.bunchAlternateSwitch = this.getFloat(bunch.alternate);
        this.horizontalBunchAlignment = this.getFloat(bunch.horizontalAlignment);
        this.verticalBunchAlignment = this.getFloat(bunch.verticalAlignment);
        this.bunchTaperOffAtTwig = this.getFloat(bunch.taperTwig);
        this.bunchTaperOffAtBranch = this.getFloat(bunch.taperBranch);
        this.bunchTaperOffAtTree = this.getFloat(bunch.taperTree);
        this.bunchArcAtTwigX = this.getFloat(bunch.twigX);
        this.bunchArcAtTwigY = this.getFloat(bunch.twigY);
        this.bunchArcAtTwigZ = this.getFloat(bunch.twigZ);
        this.bunchArcAtBranchX = this.getFloat(bunch.branchX);
        this.bunchArcAtBranchY = this.getFloat(bunch.branchY);
        this.bunchArcAtBranchZ = this.getFloat(bunch.branchZ);
        this.bunchDeformX = this.getFloat(bunch.deformX);
        this.bunchDeformY = this.getFloat(bunch.deformY);
        this.bunchDeformZ = this.getFloat(bunch.deformZ);
        this.leafType = foliage.type;
        this.leafLength = this.getFloat(foliage.length);
        this.leafBreadth = this.getFloat(foliage.breadth);
        this.leafHeight = this.getFloat(foliage.height);
        this.maxLeafTilt = this.getFloat(foliage.maxTilt);
        this.maxLeafTurn = this.getFloat(foliage.maxTurn);
        this.leafInclination = this.getFloat(foliage.inclination);
        this.leafInclinationScope = this.getFloat(foliage.inclinationScope);
        this.bottomR1 = this.getFloat(foliage.bottomR1);
        this.bottomG1 = this.getFloat(foliage.bottomG1);
        this.bottomB1 = this.getFloat(foliage.bottomB1);
        this.bottomR2 = this.getFloat(foliage.bottomR2);
        this.bottomG2 = this.getFloat(foliage.bottomG2);
        this.bottomB2 = this.getFloat(foliage.bottomB2);
        this.topR1 = this.getFloat(foliage.topR1);
        this.topG1 = this.getFloat(foliage.topG1);
        this.topB1 = this.getFloat(foliage.topB1);
        this.topR2 = this.getFloat(foliage.topR2);
        this.topG2 = this.getFloat(foliage.topG2);
        this.topB2 = this.getFloat(foliage.topB2);
        this.turbulence = this.getFloat(foliage.turbulence);
        this.transition = this.getFloat(foliage.transition);
        this.transitionTurbulence = this.getFloat(foliage.transitionTurbulence);
        this.gloss = this.getFloat(foliage.gloss);
        this.filter = this.getFloat(foliage.filter);
        this.transparency = this.getFloat(foliage.transparency);
        this.customMesh = foliage.customMesh;
        this.leafUvType = foliage.leafArrayElements;
        this.blossomType = blossom.name;
        this.blossomLength = this.getFloat(blossom.length);
        this.blossomWidth = this.getFloat(blossom.width);
        this.blossomInclination = this.getFloat(blossom.inclination);
        this.blossomR = this.getFloat(blossom.r);
        this.blossomG = this.getFloat(blossom.g);
        this.blossomB = this.getFloat(blossom.b);
        this.customBlossomMesh = blossom.customMesh;
        this.firstRootAtTrunk = this.getFloat(root.startAt);
        this.rootLength = this.getFloat(root.length);
        this.rootThicknessChange = this.getFloat(root.thicknessRatio);
        this.rootStrength = this.getFloat(root.strength);
        this.rootBend = this.getFloat(root.bendValue);
        this.rootBendFrequency = this.getFloat(root.bendFrequency);
        this.rootCurve = this.getFloat(root.curveValue);
        this.rootCurveFrequency = this.getFloat(root.curveFrequency);
        this.rootSnag = this.getFloat(root.snagValue);
        this.rootSnagFrequency = this.getFloat(root.snagFrequency);
        this.rootTurnSwitch = this.getFloat(root.turn);
        this.rootAngle = this.getFloat(root.angle);
        this.rootAlignment = this.getFloat(root.alignment);
        this.sunkenR = this.getFloat(bark.sunkenR);
        this.sunkenG = this.getFloat(bark.sunkenG);
        this.sunkenB = this.getFloat(bark.sunkenB);
        this.raisedR = this.getFloat(bark.raisedR);
        this.raisedG = this.getFloat(bark.raisedG);
        this.raisedB = this.getFloat(bark.raisedB);
        this.palmTrunk = this.getFloat(bark.palm);
        this.barkProfile = this.getFloat(bark.profile);
        this.branchBarkProfileChange = this.getFloat(bark.change);
        this.branchBarkProfileTaperOff = this.getFloat(bark.taper);
        this.rootBarkProfileChange = this.getFloat(bark.rootChange);
        this.foliageAtEnd = this.getFloat(bark.foliageAtEnd);
        this.scarWidth = this.getFloat(bark.width);
        this.scarHeight = this.getFloat(bark.height);
        this.scarDepth = this.getFloat(bark.depth);
        this.scarHorizontalShrinking = this.getFloat(bark.horizontalShrinking);
        this.scarVerticalShrinking = this.getFloat(bark.verticalShrinking);
        if (this.twigs > 0.0f) {
            if ((double)(this.bunches / this.twigs) > 1.0) {
                this.bunchAreaAtTwig = this.bunchAreaAtTwig * (this.bunches / this.twigs / (this.bunches / this.twigs - 1.0f)) + 1.0E-6f;
                this.horizontalBunchAlignment *= this.bunches / this.twigs / (this.bunches / this.twigs - 1.0f);
                this.verticalBunchAlignment *= this.bunches / this.twigs / (this.bunches / this.twigs - 1.0f);
            } else {
                this.bunchAreaAtTwig += 1.0E-6f;
            }
        } else {
            this.bunchAreaAtTwig += 1.0E-6f;
        }
        this.horizontalBunchAlignment *= this.horizontalBunchAlignment;
        this.verticalBunchAlignment *= this.verticalBunchAlignment;
        this.zl = this.firstBunchAtTwig + this.bunchAreaAtTwig + 1.1f;
        this.firstBunchAtTwig += 1.0E-6f;
        this.firstTwigAtBranch += 1.0E-6f;
        if (this.branches > 0.0f) {
            if ((double)(this.twigs / this.branches) > 1.0) {
                this.twigAreaAtBranch = this.twigAreaAtBranch * (this.twigs / this.branches / (this.twigs / this.branches - 1.0f)) + 1.0E-6f;
                this.horizontalTwigAlignment *= this.twigs / this.branches / (this.twigs / this.branches - 1.0f);
                this.verticalTwigAlignment *= this.twigs / this.branches / (this.twigs / this.branches - 1.0f);
            } else {
                this.twigAreaAtBranch += 1.0E-6f;
            }
        } else {
            this.twigAreaAtBranch += 1.0E-6f;
        }
        this.horizontalTwigAlignment *= this.horizontalTwigAlignment;
        this.verticalTwigAlignment *= this.verticalTwigAlignment;
        if (this.branches > 1.0f) {
            this.branchAreaAtTrunk *= this.branches / (this.branches - 1.0f);
        }
        this.branchAreaAtTrunk += 1.0E-6f;
        this.zwl = this.zl + this.bunchMajorRadius + this.bunchMinorRadius;
        this.astl = this.firstTwigAtBranch + this.twigAreaAtBranch + this.zwl;
        this.bh = this.firstBranchAtTrunk + this.branchAreaAtTrunk + this.astl;
        this.aw = this.branchCurve * this.bh / this.astl;
        this.akk = this.branchSnag * this.bh / this.astl;
        this.abg = this.branchBend * this.bh / this.astl;
        this.abfz = this.branchBendFrequency * 0.7f * (this.astl / (this.firstTwigAtBranch + this.twigAreaAtBranch + this.zwl * (1.0f - this.branchTaper)));
        this.zbfza = this.twigCurveFrequencyAdjustment * (this.zwl / (this.zl + (this.bunchMajorRadius + this.bunchMinorRadius) * (1.0f - this.bunchTaperOffAtTwig))) / (this.astl / (this.firstTwigAtBranch + this.twigAreaAtBranch + this.zwl * (1.0f - this.branchTaper)));
        this.rfza = this.ramiCurveFrequencyAdjustment / (this.zwl / (this.zl + (this.bunchMajorRadius + this.bunchMinorRadius) * (1.0f - this.bunchTaperOffAtTwig)));
        this.branchSnagFrequency *= 1.75f;
        this.branchCurveFrequency *= 1.6f;
        if (this.branches > 1.0f) {
            this.branchAlignment *= this.branches / (this.branches - 1.0f);
        }
        this.unit1 = this.firstBranchAtTrunk + this.branchAreaAtTrunk + (1.0f - this.branchReduction) * (this.firstTwigAtBranch + this.twigAreaAtBranch + (1.0f - this.branchTaper) * (this.firstBunchAtTwig + this.bunchAreaAtTwig + (this.bunchMajorRadius + this.bunchMinorRadius + this.leafLength) * (1.0f - this.bunchTaperOffAtTree) * (1.0f - this.bunchTaperOffAtBranch) * (1.0f - this.bunchTaperOffAtTwig)));
    }

    public float getFloat(String string) throws NumberFormatException {
        float f;
        try {
            f = string != null && string.length() != 0 ? new Float(string).floatValue() : 0.0f;
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(string);
        }
        return f;
    }
}

