/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import java.util.ArrayList;
import java.util.StringTokenizer;
import povtree.interfaces.Constants;
import povtree.interfaces.Names;
import povtree.objects.Bark;
import povtree.objects.Blossom;
import povtree.objects.Branch;
import povtree.objects.Bunch;
import povtree.objects.Foliage;
import povtree.objects.Rami;
import povtree.objects.Root;
import povtree.objects.Tree;
import povtree.objects.Trunk;
import povtree.objects.Twig;
import povtree.objects3D.TableLeaf;

public class Parser
implements Names,
Constants {
    private Tree tree = new Tree();

    public Parser(String string, String string2) throws Exception {
        int n;
        if (string.indexOf("ROOTS") == -1 && string.indexOf("BRANCHES") == -1 && string.indexOf("TWIGS") == -1 && string.indexOf("BUNCHES") == -1 && string.indexOf("LEAVES") == -1 && string.indexOf("BLOSSOMS") == -1) {
            throw new Exception();
        }
        String string3 = this.getValue(string, "TREE_NAME");
        if (string3 != null && string3.length() != 0) {
            this.tree.setName(string3);
        } else {
            this.tree.setName(string2);
        }
        string3 = this.getValue(string, "ROOTS");
        if (string3 != null && string3.length() != 0) {
            if (string3.equals("0")) {
                this.tree.setRootFlag(false);
            } else {
                this.tree.setRootFlag(true);
            }
        } else {
            this.tree.setRootFlag(false);
        }
        string3 = this.getValue(string, "TRUNK_STRENGTH");
        if (string3 != null && string3.length() != 0) {
            if (string3.equals("0")) {
                this.tree.setTrunkFlag(false);
            } else {
                this.tree.setTrunkFlag(true);
            }
        } else {
            this.tree.setTrunkFlag(false);
        }
        string3 = this.getValue(string, "BRANCHES");
        if (string3 != null && string3.length() != 0) {
            if (string3.equals("0")) {
                this.tree.setBranchesFlag(false);
            } else {
                this.tree.setBranchesFlag(true);
            }
        } else {
            this.tree.setBranchesFlag(false);
        }
        string3 = this.getValue(string, "TWIGS");
        if (string3 != null && string3.length() != 0) {
            n = string3.indexOf("*");
            if (n != -1) {
                if ((string3 = string3.substring(0, n)).equals("0")) {
                    this.tree.setTwigsFlag(false);
                } else {
                    this.tree.setTwigsFlag(true);
                }
            }
        } else {
            this.tree.setTwigsFlag(false);
        }
        if ((string3 = this.getValue(string, "BUNCHES")) != null && string3.length() != 0) {
            n = string3.indexOf("*");
            if (n != -1) {
                if ((string3 = string3.substring(0, n)).equals("0")) {
                    this.tree.setRamiFlag(false);
                } else {
                    this.tree.setRamiFlag(true);
                }
            }
        } else {
            this.tree.setRamiFlag(false);
        }
        if ((string3 = this.getValue(string, "LEAVES")) != null && string3.length() != 0) {
            n = string3.indexOf("*");
            if (n != -1) {
                if ((string3 = string3.substring(0, n)).equals("0")) {
                    this.tree.setFoliageFlag(false);
                } else {
                    this.tree.setFoliageFlag(true);
                }
            }
        } else {
            this.tree.setFoliageFlag(false);
        }
        if ((string3 = this.getValue(string, "BLOSSOMS")) != null && string3.length() != 0) {
            n = string3.indexOf("*");
            if (n != -1) {
                if ((string3 = string3.substring(0, n)).equals("0")) {
                    this.tree.setBlossomFlag(false);
                } else {
                    this.tree.setBlossomFlag(true);
                }
            }
        } else {
            this.tree.setBlossomFlag(false);
        }
        this.tree.setRoot(this.makeRoot(string));
        this.tree.setTrunk(this.makeTrunk(string));
        this.tree.setBranch(this.makeBranch(string));
        this.tree.setTwig(this.makeTwig(string));
        this.tree.setRami(this.makeRami(string));
        this.tree.setBunch(this.makeBunch(string));
        this.tree.setBark(this.makeBark(string));
        this.tree.setFoliage(this.makeFoliage(string));
        this.tree.setBlossom(this.makeBlossom(string));
    }

    public String getValue(String string, String string2) {
        String string3 = string;
        boolean bl = true;
        String string4 = new String();
        int n = string2.length();
        while (bl) {
            int n2 = string3.indexOf(string2);
            if (n2 != -1) {
                String string5 = string3.substring(n2);
                int n3 = string5.indexOf(";");
                if ((string5 = string5.substring(0 + n, n3)).indexOf(" ") == 0 || string5.indexOf(61) == 0) {
                    string5 = string5.replace('=', ' ');
                    string4 = string5.trim();
                    bl = false;
                    continue;
                }
                string3 = string3.substring(n2 + n);
                continue;
            }
            bl = false;
        }
        return string4.trim();
    }

    public ArrayList getTriplet(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        String string3 = this.getValue(string, string2);
        if (string3 != null && string3.length() != 0) {
            string3 = string3.replace('<', ' ');
            string3 = string3.replace('>', ' ');
            string3.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
        }
        return arrayList;
    }

    public void getTexture(TableLeaf tableLeaf, String string, Foliage foliage) {
        String string2;
        String string3;
        int n = 0;
        int n2 = string.indexOf("image_map");
        if (n2 != -1) {
            n2 = string.indexOf("{", n2);
            n = string.indexOf("\"", n2);
            string3 = string.substring(n2 + 1, n).trim();
            tableLeaf.setImageType(string3);
            n2 = string.indexOf("\"", n + 1);
            string2 = string.substring(n + 1, n2).trim();
            tableLeaf.setImageName(string2);
            n = n2;
            string = string.substring(n2 + 1);
        }
        if ((n2 = string.indexOf("bump_map")) != -1) {
            n2 = string.indexOf("{", n2);
            n = string.indexOf("\"", n2);
            string3 = string.substring(n2 + 1, n).trim();
            tableLeaf.setBumpType(string3);
            n2 = string.indexOf("\"", n + 1);
            string2 = string.substring(n + 1, n2).trim();
            tableLeaf.setBumpName(string2);
            n = n2;
            n2 = string.indexOf("bump_size", n2);
            if (n2 != -1) {
                n = string.indexOf("}", n2 + 1);
                tableLeaf.setBumpSize(string.substring(n2 + "bump_size".length() + 1, n).trim());
            }
        }
    }

    public Root makeRoot(String string) {
        Root root = new Root();
        root.number = this.getValue(string, "ROOTS");
        root.randomness = this.getValue(string, "ROOT_RANDOM");
        root.startAt = this.getValue(string, "FIRST_ROOT_AT_TRUNK");
        root.length = this.getValue(string, "ROOT_LENGTH");
        root.thicknessRatio = this.getValue(string, "ROOT_THICKNESS_CHANGE");
        root.strength = this.getValue(string, "ROOT_STRENGTH");
        root.bendValue = this.getValue(string, "ROOT_BEND");
        root.bendFrequency = this.getValue(string, "ROOT_BEND_FREQUENCY");
        root.curveValue = this.getValue(string, "ROOT_CURVE");
        root.curveFrequency = this.getValue(string, "ROOT_CURVE_FREQUENCY");
        root.snagValue = this.getValue(string, "ROOT_SNAG");
        root.snagFrequency = this.getValue(string, "ROOT_SNAG_FREQUENCY");
        root.angle = this.getValue(string, "ROOT_ANGLE");
        root.alignment = this.getValue(string, "ROOT_ALIGNMENT");
        root.turn = this.getValue(string, "ROOT_TURN_SWITCH");
        return root;
    }

    public Trunk makeTrunk(String string) {
        Trunk trunk = new Trunk();
        trunk.radius = this.getValue(string, "TRUNK_RADIUS");
        trunk.strength = this.getValue(string, "TRUNK_STRENGTH");
        trunk.bendValueX = this.getValue(string, "TRUNK_BEND_X");
        trunk.bendFrequencyX = this.getValue(string, "TRUNK_BEND_X_FREQUENCY");
        trunk.bendValueZ = this.getValue(string, "TRUNK_BEND_Z");
        trunk.bendFrequencyZ = this.getValue(string, "TRUNK_BEND_Z_FREQUENCY");
        trunk.curveValue = this.getValue(string, "TRUNK_CURVE");
        trunk.curveFrequency = this.getValue(string, "TRUNK_CURVE_FREQUENCY");
        trunk.snagValue = this.getValue(string, "TRUNK_SNAG");
        trunk.snagFrequency = this.getValue(string, "TRUNK_SNAG_FREQUENCY");
        trunk.spiral = this.getValue(string, "TRUNK_SPIRAL");
        trunk.taper = this.getValue(string, "TRUNK_TAPER");
        return trunk;
    }

    public Branch makeBranch(String string) {
        Branch branch = new Branch();
        branch.number = this.getValue(string, "BRANCHES");
        branch.randomness = this.getValue(string, "BRANCH_RANDOM");
        branch.startAt = this.getValue(string, "FIRST_BRANCH_AT_TRUNK");
        branch.areaAtTrunk = this.getValue(string, "BRANCH_AREA_AT_TRUNK");
        branch.thicknessRatio = this.getValue(string, "BRANCH_THICKNESS_CHANGE");
        branch.strength = this.getValue(string, "BRANCH_STRENGTH");
        branch.bendValue = this.getValue(string, "BRANCH_BEND");
        branch.bendFrequency = this.getValue(string, "BRANCH_BEND_FREQUENCY");
        branch.horizontalBend = this.getValue(string, "HORIZONTAL_BRANCH_BEND_SWITCH");
        branch.extraNoise = this.getValue(string, "EXTRA_NOISE_SWITCH");
        branch.curveValue = this.getValue(string, "BRANCH_CURVE");
        branch.curveFrequency = this.getValue(string, "BRANCH_CURVE_FREQUENCY");
        branch.horizontalCurve = this.getValue(string, "HORIZONTAL_BRANCH_CURVE_SWITCH");
        branch.longitudinal = this.getValue(string, "BRANCH_LONGITUDINAL_CURVE");
        branch.snagValue = this.getValue(string, "BRANCH_SNAG");
        branch.snagFrequency = this.getValue(string, "BRANCH_SNAG_FREQUENCY");
        branch.reduction = this.getValue(string, "BRANCH_REDUCTION");
        branch.taper = this.getValue(string, "BRANCH_TAPER");
        branch.endEqualizer = this.getValue(string, "BRANCH_END_EQUALIZER");
        branch.tip = this.getValue(string, "BRANCH_TIP");
        branch.turn = this.getValue(string, "BRANCH_TURN_SWITCH");
        branch.alternate = this.getValue(string, "BRANCH_ALTERNATE_SWITCH");
        branch.spiral = this.getValue(string, "BRANCH_SPIRAL");
        branch.angle = this.getValue(string, "BRANCH_ANGLE");
        branch.angleScope = this.getValue(string, "BRANCH_ANGLE_SCOPE");
        branch.alignment = this.getValue(string, "BRANCH_ALIGNMENT");
        branch.straightenTowardsTop = this.getValue(string, "STRAIGHTEN_TOWARDS_TOP");
        return branch;
    }

    public Twig makeTwig(String string) {
        Twig twig = new Twig();
        String string2 = this.getValue(string, "TWIGS");
        int n = string2.indexOf("*");
        twig.number = string2 = string2.substring(0, n);
        twig.randomness = this.getValue(string, "TWIG_RANDOM");
        twig.startAt = this.getValue(string, "FIRST_TWIG_AT_BRANCH");
        twig.areaAtBranch = this.getValue(string, "TWIG_AREA_AT_BRANCH");
        twig.thicknessRatio = this.getValue(string, "TWIG_THICKNESS_CHANGE");
        twig.strength = this.getValue(string, "TWIG_STRENGTH");
        twig.horizontalAngle = this.getValue(string, "HORIZONTAL_TWIG_ANGLE");
        twig.horizontalAngleScope = this.getValue(string, "HORIZONTAL_TWIG_ANGLE_SCOPE");
        twig.horizontalAlignment = this.getValue(string, "HORIZONTAL_TWIG_ALIGNMENT");
        twig.verticalAngle = this.getValue(string, "VERTICAL_TWIG_ANGLE");
        twig.verticalAngleScope = this.getValue(string, "VERTICAL_TWIG_ANGLE_SCOPE");
        twig.verticalAlignment = this.getValue(string, "VERTICAL_TWIG_ALIGNMENT");
        twig.turn = this.getValue(string, "TWIG_TURN_SWITCH");
        twig.alternate = this.getValue(string, "TWIG_ALTERNATE_SWITCH");
        twig.curveValue = this.getValue(string, "TWIG_CURVE_ADJUSTMENT");
        twig.curveFrequency = this.getValue(string, "TWIG_CURVE_FREQUENCY_ADJUSTMENT");
        twig.taper = this.getValue(string, "TWIG_TAPER");
        twig.tip = this.getValue(string, "TWIG_TIP");
        twig.straightenTowardsBranch = this.getValue(string, "STRAIGHTEN_TOWARDS_BRANCH_END");
        return twig;
    }

    public Rami makeRami(String string) {
        Rami rami = new Rami();
        rami.ramiOrder = this.getValue(string, "TWIG_RAMIFICATION_ORDER");
        rami.ramiNumber = this.getValue(string, "LAST_RAMIFICATION_NUMBER");
        rami.ramiThickness = this.getValue(string, "TWIG_RAMIFICATION_THICKNESS_CHANGE");
        rami.ramiCurveAdjustment = this.getValue(string, "TWIG_RAMIFICATION_CURVE_ADJUSTMENT");
        rami.ramiCurveFrequency = this.getValue(string, "RAMI_CURVE_FREQUENCY_ADJUSTMENT");
        rami.ramiStrength = this.getValue(string, "TWIG_RAMIFICATION_STRENGTH");
        return rami;
    }

    public Bunch makeBunch(String string) {
        Bunch bunch = new Bunch();
        String string2 = this.getValue(string, "BUNCHES");
        int n = string2.indexOf("*");
        bunch.number = string2 = string2.substring(0, n);
        bunch.startAt = this.getValue(string, "FIRST_BUNCH_AT_TWIG");
        bunch.areaAtTwig = this.getValue(string, "BUNCH_AREA_AT_TWIG");
        bunch.majorRadius = this.getValue(string, "BUNCH_MAJOR_RADIUS");
        bunch.minorRadius = this.getValue(string, "BUNCH_MINOR_RADIUS");
        bunch.funnelHorizontal = this.getValue(string, "HORIZONTAL_BUNCH_FUNNEL");
        bunch.funnelVertical = this.getValue(string, "VERTICAL_BUNCH_FUNNEL");
        bunch.funnelRotation = this.getValue(string, "ROTATION_BUNCH_FUNNEL");
        bunch.horizontalAngle = this.getValue(string, "HORIZONTAL_BUNCH_ANGLE");
        bunch.horizontalAngleScope = this.getValue(string, "HORIZONTAL_BUNCH_ANGLE_SCOPE");
        bunch.horizontalAlignment = this.getValue(string, "HORIZONTAL_BUNCH_ALIGNMENT");
        bunch.verticalAngle = this.getValue(string, "VERTICAL_BUNCH_ANGLE");
        bunch.verticalAngleScope = this.getValue(string, "VERTICAL_BUNCH_ANGLE_SCOPE");
        bunch.verticalAlignment = this.getValue(string, "VERTICAL_BUNCH_ALIGNMENT");
        bunch.turn = this.getValue(string, "BUNCH_TURN_SWITCH");
        bunch.turnShift = this.getValue(string, "BUNCH_TURN_SHIFT");
        bunch.alternate = this.getValue(string, "BUNCH_ALTERNATE_SWITCH");
        bunch.taperTree = this.getValue(string, "BUNCH_TAPER_OFF_AT_TREE");
        bunch.taperBranch = this.getValue(string, "BUNCH_TAPER_OFF_AT_BRANCH");
        bunch.taperTwig = this.getValue(string, "BUNCH_TAPER_OFF_AT_TWIG");
        ArrayList arrayList = this.getTriplet(string, "BUNCH_ARC_AT_TWIG");
        if (arrayList.size() == 3) {
            bunch.twigX = (String)arrayList.get(0);
            bunch.twigY = (String)arrayList.get(1);
            bunch.twigZ = (String)arrayList.get(2);
        }
        if ((arrayList = this.getTriplet(string, "BUNCH_ARC_AT_BRANCH")).size() == 3) {
            bunch.branchX = (String)arrayList.get(0);
            bunch.branchY = (String)arrayList.get(1);
            bunch.branchZ = (String)arrayList.get(2);
        }
        if ((arrayList = this.getTriplet(string, "BUNCH_DEFORM")).size() == 3) {
            bunch.deformX = (String)arrayList.get(0);
            bunch.deformY = (String)arrayList.get(1);
            bunch.deformZ = (String)arrayList.get(2);
        }
        return bunch;
    }

    public Bark makeBark(String string) {
        Bark bark = new Bark();
        ArrayList arrayList = this.getTriplet(string, "SUNKEN_TRUNK_COLOR");
        bark.sunkenR = (String)arrayList.get(0);
        bark.sunkenG = (String)arrayList.get(1);
        bark.sunkenB = (String)arrayList.get(2);
        arrayList = this.getTriplet(string, "RAISED_TRUNK_COLOR");
        bark.raisedR = (String)arrayList.get(0);
        bark.raisedG = (String)arrayList.get(1);
        bark.raisedB = (String)arrayList.get(2);
        bark.foliageAtEnd = this.getValue(string, "FOLIAGE_COLOR_AT_BRANCH_END");
        bark.width = this.getValue(string, "TRUNK_SCAR_WIDTH");
        bark.height = this.getValue(string, "TRUNK_SCAR_HEIGHT");
        bark.depth = this.getValue(string, "SCAR_DEPTH");
        bark.horizontalShrinking = this.getValue(string, "HORIZONTAL_SCAR_SHRINKING");
        bark.verticalShrinking = this.getValue(string, "VERTICAL_SCAR_SHRINKING");
        bark.profile = this.getValue(string, "BARK_PROFILE");
        bark.change = this.getValue(string, "BRANCH_BARK_PROFILE_CHANGE");
        bark.taper = this.getValue(string, "BRANCH_BARK_PROFILE_TAPER_OFF");
        bark.rootChange = this.getValue(string, "ROOT_BARK_PROFILE_CHANGE");
        bark.palm = this.getValue(string, "PALM_TRUNK");
        bark.imageType = this.getValue(string, "IMAGE_TYPE");
        bark.imageName = this.getValue(string, "IMAGE_NAME");
        bark.bumpType = this.getValue(string, "BUMP_TYPE");
        bark.bumpName = this.getValue(string, "BUMP_NAME");
        bark.bumpSize = this.getValue(string, "BUMP_SIZE");
        return bark;
    }

    public Foliage makeFoliage(String string) {
        int n;
        String string2;
        String string3;
        int n2;
        Foliage foliage = new Foliage();
        String string4 = this.getValue(string, "LEAVES");
        int n3 = string4.indexOf("*");
        foliage.number = string4 = string4.substring(0, n3);
        foliage.type = this.getValue(string, "LEAF_TYPE");
        foliage.type = foliage.type.replace('\"', ' ').trim();
        if (foliage.type.startsWith("CustomMesh")) {
            n2 = string.indexOf("mesh");
            if (n2 != -1) {
                int n4 = string.indexOf(";", n2);
                String string5 = string.substring((n2 = string.indexOf("{", n2)) + 1, n4 - 1);
                if (string5 != null && string5.length() != 0) {
                    foliage.customMesh = string5.trim();
                }
            }
        } else if (foliage.type.startsWith("LeafUv") && (n2 = string.indexOf("array")) != -1 && (string3 = (string2 = string.substring(n2)).substring((n2 = string2.indexOf("[")) + 1, n = string2.indexOf("]", n2))) != null && string3.length() != 0) {
            int n5 = new Integer(string3.trim());
            ArrayList<TableLeaf> arrayList = new ArrayList<TableLeaf>(n5);
            string3 = string2.substring(n);
            n = 0;
            int n6 = 0;
            while (n6 < n5) {
                TableLeaf tableLeaf = new TableLeaf();
                n2 = string2.indexOf("LeafUv", n);
                n = string2.indexOf("\"", n2 + 2);
                if (n2 != -1) {
                    if (n != -1) {
                        string3 = string2.substring(n2 + "LeafUv".length(), n);
                        tableLeaf.setIndex(new Integer(string3.trim()));
                        arrayList.add(tableLeaf);
                    } else {
                        string3 = string2.substring(n2);
                    }
                }
                ++n6;
            }
            int n7 = 0;
            while (n7 < n5) {
                n2 = string2.indexOf("LeafArray[", n);
                n = string2.indexOf("LeafArray[", n2 + 2);
                if (n2 != -1) {
                    string3 = n != -1 ? string2.substring(n2, n) : string2.substring(n2);
                    this.getTexture((TableLeaf)arrayList.get(n7), string3, foliage);
                }
                ++n7;
            }
            foliage.leafArrayElements = arrayList;
        }
        foliage.length = this.getValue(string, "LEAF_LENGTH");
        foliage.breadth = this.getValue(string, "LEAF_BREADTH");
        foliage.height = this.getValue(string, "LEAF_HEIGHT");
        foliage.maxTilt = this.getValue(string, "MAX_LEAF_TILT");
        foliage.maxTurn = this.getValue(string, "MAX_LEAF_TURN");
        foliage.inclination = this.getValue(string, "LEAF_INCLINATION");
        foliage.inclinationScope = this.getValue(string, "LEAF_INCLINATION_SCOPE");
        foliage.turbulence = this.getValue(string, "COLOR_TURB");
        foliage.transition = this.getValue(string, "TRANSITION_BOTTOM_TOP");
        foliage.transitionTurbulence = this.getValue(string, "TRANSITION_TURB");
        foliage.gloss = this.getValue(string, "FOLIAGE_GLOSS");
        String string6 = this.getValue(string, "FOLIAGE_FILTER");
        foliage.filter = string6 == null ? "0" : string6;
        string6 = this.getValue(string, "FOLIAGE_TRANSPARENCY");
        foliage.transparency = string6 == null ? "0" : string6;
        ArrayList arrayList = this.getTriplet(string, "BOTTOM_COLOR_1");
        foliage.bottomR1 = (String)arrayList.get(0);
        foliage.bottomG1 = (String)arrayList.get(1);
        foliage.bottomB1 = (String)arrayList.get(2);
        arrayList = this.getTriplet(string, "BOTTOM_COLOR_2");
        foliage.bottomR2 = (String)arrayList.get(0);
        foliage.bottomG2 = (String)arrayList.get(1);
        foliage.bottomB2 = (String)arrayList.get(2);
        arrayList = this.getTriplet(string, "TOP_COLOR_1");
        foliage.topR1 = (String)arrayList.get(0);
        foliage.topG1 = (String)arrayList.get(1);
        foliage.topB1 = (String)arrayList.get(2);
        arrayList = this.getTriplet(string, "TOP_COLOR_2");
        foliage.topR2 = (String)arrayList.get(0);
        foliage.topG2 = (String)arrayList.get(1);
        foliage.topB2 = (String)arrayList.get(2);
        return foliage;
    }

    public String getLeafUvTypeIndex(String string) {
        String string2 = null;
        int n = 0;
        while (n < Constants.leavesUv.length) {
            if (Constants.leavesUv[n].equals(string)) {
                string2 = String.valueOf(n);
                break;
            }
            ++n;
        }
        return string2;
    }

    public Blossom makeBlossom(String string) {
        Object object;
        int n;
        int n2;
        Blossom blossom = new Blossom();
        blossom.name = this.getValue(string, "BLOSSOM");
        if (blossom.name.equals("CustomMeshBlossom") && (n2 = string.indexOf("mesh")) != -1) {
            n = string.indexOf(";", n2);
            object = string.substring((n2 = string.indexOf("{", n2)) + 1, n - 1);
            if (object != null && ((String)object).length() != 0) {
                blossom.customMesh = ((String)object).trim();
            }
        }
        String string2 = this.getValue(string, "BLOSSOMS");
        n = string2.indexOf("*");
        blossom.number = string2 = string2.substring(0, n);
        blossom.length = this.getValue(string, "BLOSSOM_LENGTH");
        blossom.width = this.getValue(string, "BLOSSOM_WIDTH");
        blossom.inclination = this.getValue(string, "BLOSSOM_INCLINATION");
        object = this.getTriplet(string, "BLOSSOM_COLOR");
        blossom.r = (String)((ArrayList)object).get(0);
        blossom.g = (String)((ArrayList)object).get(1);
        blossom.b = (String)((ArrayList)object).get(2);
        return blossom;
    }

    public Tree getTree() {
        return this.tree;
    }
}

