/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import java.util.ResourceBundle;
import povtree.gui.PovTree;
import povtree.gui.PovtreeException;
import povtree.gui.Resources;
import povtree.interfaces.Constants;
import povtree.objects.Blossom;
import povtree.objects.Foliage;
import povtree.objects.Tree;
import povtree.objects3D.Tree3D;
import povtree.povTreeGenerator.BlossomGenerator;
import povtree.povTreeGenerator.BranchGenerator;
import povtree.povTreeGenerator.FoliageGenerator;
import povtree.povTreeGenerator.Parameters;
import povtree.povTreeGenerator.RamiGenerator;
import povtree.povTreeGenerator.RootGenerator;
import povtree.povTreeGenerator.TrunkGenerator;
import povtree.povTreeGenerator.TwigGenerator;

public class PovTreeGenerator
implements Constants {
    private Parameters p;
    private PovTree frame = null;
    private Resources resources = Resources.getInstance();
    private ResourceBundle messages = Resources.getMessagesBundle();

    public Tree3D makePreviewTree(Tree tree, boolean bl, boolean bl2, PovTree povTree) throws InterruptedException, NumberFormatException, PovtreeException {
        Constants constants;
        Object object;
        this.frame = povTree;
        Tree3D tree3D = new Tree3D();
        tree3D.meshFoliageFlag = bl;
        tree3D.meshBlossomFlag = bl2;
        this.p = new Parameters(tree);
        tree3D.name = tree.getName();
        tree3D.normalizer = this.p.unit1;
        tree3D.threshold = this.p.trunkRadius * 3.0f;
        tree3D.ramiOrder = (int)this.p.twigRamificationOrder;
        if (tree.getRootFlag()) {
            this.frame.updateStatus(0, "calculatingRoots");
            if (this.p.roots == 0.0f) {
                throw new PovtreeException(this.messages.getString("specifyRoots"));
            }
            object = new RootGenerator(this.p);
            tree3D.setRoot(((RootGenerator)object).generate());
            this.frame.updateStatus(10, "calculatingTrunk");
        } else {
            this.frame.updateStatus(10, "calculatingTrunk");
        }
        if (tree.getTrunkFlag()) {
            object = new TrunkGenerator(this.p);
            tree3D.setTrunk(((TrunkGenerator)object).generate());
            this.frame.updateStatus(20, "calculatingBranches");
        } else {
            this.frame.updateStatus(20, "calculatingBranches");
        }
        if (tree.getBranchesFlag()) {
            object = new BranchGenerator(this.p);
            tree3D.setBranches(((BranchGenerator)object).generate());
            this.frame.updateStatus(30, "calculatingTwigs");
        } else {
            this.frame.updateStatus(30, "calculatingTwigs");
        }
        if (tree.getTwigsFlag()) {
            object = new TwigGenerator(this.p);
            tree3D.setTwigs(((TwigGenerator)object).generate());
            this.frame.updateStatus(40, "calculatingRami");
        } else {
            this.frame.updateStatus(40, "calculatingRami");
        }
        if (tree.getRamiFlag()) {
            object = new RamiGenerator(this.p);
            tree3D.setRami(((RamiGenerator)object).generate());
            this.frame.updateStatus(50, "calculatingFoliage");
        } else {
            this.frame.updateStatus(50, "calculatingFoliage");
        }
        if (tree.getFoliageFlag()) {
            object = tree.getFoliage();
            if (((Foliage)object).type == null) {
                throw new PovtreeException(this.messages.getString("defineLeafType"));
            }
            if (((Foliage)object).type.equals("CustomMesh") && (this.p.customMesh == null || this.p.customMesh.length() == 0)) {
                throw new PovtreeException(this.messages.getString("enterCustomMesh"));
            }
            if (this.p.leaves == 0.0f) {
                throw new PovtreeException(this.messages.getString("specifyLeaves"));
            }
            if (this.p.leafLength == 0.0f) {
                throw new PovtreeException(this.messages.getString("leafLengthGreater"));
            }
            if (this.p.leafBreadth == 0.0f) {
                throw new PovtreeException(this.messages.getString("leafBreadthGreater"));
            }
            if (this.p.leafHeight == 0.0f) {
                throw new PovtreeException(this.messages.getString("leafHeightGreater"));
            }
            constants = new FoliageGenerator(this.p, bl, ((Foliage)object).type);
            tree3D.setFoliage(((FoliageGenerator)constants).generate());
            this.frame.updateStatus(60, "calculatingBlossom");
        } else {
            this.frame.updateStatus(60, "calculatingBlossom");
        }
        if (tree.getBlossomFlag()) {
            object = tree.getBlossom();
            if (((Blossom)object).name == null) {
                throw new PovtreeException(this.messages.getString("defineBlossomType"));
            }
            if (((Blossom)object).name.equals("CustomMeshBlossom") && (this.p.customBlossomMesh == null || this.p.customBlossomMesh.length() == 0)) {
                throw new PovtreeException(this.messages.getString("enterCustomMesh"));
            }
            if (this.p.blossoms == 0.0f) {
                throw new PovtreeException(this.messages.getString("specifyBlossoms"));
            }
            if (this.p.blossomLength == 0.0f) {
                throw new PovtreeException(this.messages.getString("blossomLengthGreater"));
            }
            if (this.p.blossomWidth == 0.0f) {
                throw new PovtreeException(this.messages.getString("blossomWidthGreater"));
            }
            constants = new BlossomGenerator(this.p, bl2, ((Blossom)object).name);
            tree3D.setBlossom(((BlossomGenerator)constants).generate());
            this.frame.updateStatus(70, "transformingTree");
        } else {
            this.frame.updateStatus(70, "transformingTree");
        }
        tree3D.rotateTreeZ(180.0f);
        tree3D.rotateTreeY(180.0f);
        tree3D.joinElements();
        this.frame.updateStatus(0, "previewDone");
        return tree3D;
    }
}

