/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import povtree.interfaces.Constants;
import povtree.interfaces.Transformable;
import povtree.objects3D.Blob;
import povtree.objects3D.BlobArray;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.QuadroBlobArray;
import povtree.objects3D.QuintetBlobArray;
import povtree.objects3D.TripleBlobArray;
import povtree.povTreeGenerator.Parameters;

public class RamiGenerator
implements Constants {
    private Parameters p;
    private BlobArray singleRami;
    private BlobArray ba;
    private DoubleBlobArray wholeRami;
    private QuintetBlobArray ramis;
    private TripleBlobArray bnch;
    private QuadroBlobArray twg;

    public RamiGenerator(Parameters parameters) {
        this.p = parameters;
    }

    public void checkThreadStatus() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public void generateDeclarations() {
        float f = 1.0f;
        if (this.p.branches > 0.0f && this.p.twigs > 0.0f && this.p.bunches > 0.0f && this.p.twigRamificationOrder > 0.0f && this.p.twigRamificationStrength > 0.0f) {
            float f2;
            float f3;
            float f4;
            float f5;
            Transformable transformable;
            this.singleRami = new BlobArray(100);
            while (f < this.p.bh) {
                transformable = new Blob(this.p.trunkRadius * 5.0f, this.p.trunkRadius * 10.0f);
                f5 = this.p.trunkRadius / 90.0f;
                ((Blob)transformable).scale(f5);
                f5 = (this.p.bh - f) / this.p.bh;
                ((Blob)transformable).scale(f5);
                f5 = this.p.branchThicknessChange;
                ((Blob)transformable).scale(f5);
                f5 = this.p.bh / (this.p.bunchMajorRadius + this.p.bunchMinorRadius + this.p.leafLength);
                ((Blob)transformable).scale(f5);
                f5 = this.p.twigThicknessChange;
                ((Blob)transformable).scale(f5);
                f5 = this.p.twigRamificationThicknessChange;
                ((Blob)transformable).scale(f5);
                f5 = (this.p.bh - this.p.firstBranchAtTrunk * this.p.trunkTaper) / this.p.bh;
                ((Blob)transformable).scale(f5);
                f5 = (this.p.zwl - this.p.firstBunchAtTwig) / this.p.zwl;
                ((Blob)transformable).scale(f5);
                f5 = (this.p.astl - this.p.firstTwigAtBranch) / this.p.astl;
                ((Blob)transformable).scale(f5);
                if (this.p.bunchTaperOffAtBranch < 0.0f) {
                    f5 = 1.0f / (1.0f - this.p.bunchTaperOffAtBranch * (this.p.firstTwigAtBranch + this.p.twigAreaAtBranch) / this.p.astl);
                    ((Blob)transformable).scale(f5);
                }
                if (this.p.bunchTaperOffAtTree < 0.0f) {
                    f5 = 1.0f / (1.0f - this.p.bunchTaperOffAtTree * (this.p.firstBranchAtTrunk + this.p.branchAreaAtTrunk) / this.p.bh);
                    ((Blob)transformable).scale(f5);
                }
                if (this.p.bunchTaperOffAtTwig < 1.0f) {
                    f5 = 1.0f / (1.0f - (this.p.bunchTaperOffAtTwig - 1.0f) * (this.p.firstBunchAtTwig + this.p.bunchAreaAtTwig) / this.p.zwl);
                    ((Blob)transformable).scale(f5);
                }
                f5 = 1.0f / this.p.bunchDeformX;
                f4 = 1.0f / this.p.bunchDeformY;
                f3 = 1.0f / this.p.bunchDeformZ;
                ((Blob)transformable).scale(f4);
                f5 = 1.0f / (1.0f + this.p.bunchArcAtTwigX);
                f4 = 1.0f / (1.0f + this.p.bunchArcAtTwigY);
                f3 = 1.0f / (1.0f + this.p.bunchArcAtTwigZ);
                ((Blob)transformable).scale(f4);
                f5 = 1.0f / (1.0f + this.p.bunchArcAtBranchX);
                f4 = 1.0f / (1.0f + this.p.bunchArcAtBranchY);
                f3 = 1.0f / (1.0f + this.p.bunchArcAtBranchZ);
                ((Blob)transformable).scale(f4);
                f2 = (this.p.bh - f) / this.p.bh * this.p.twigCurveAdjustment * this.p.twigRamificationCurveAdjustment;
                f5 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                f4 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                f3 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                ((Blob)transformable).translate(f5, f4, f3);
                f5 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                f4 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                f3 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                ((Blob)transformable).translate(f5, f4, f3);
                f2 = this.p.twigCurveAdjustment * this.p.twigRamificationCurveAdjustment;
                f5 = (float)((double)this.p.abg * Math.sin(1.5707963705062866 * Math.sin(5.371f * this.p.abfz * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                f4 = f;
                f3 = (float)((double)this.p.abg * Math.sin(1.5707963705062866 * Math.sin(5.937f * this.p.abfz * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                ((Blob)transformable).translate(f5, f4, f3);
                f5 = (float)((double)this.p.branchSpiral * Math.sin(f / this.p.bh * 1.5707964f));
                ((Blob)transformable).rotateY(f5);
                this.singleRami.add((Blob)transformable);
                f = (float)((double)f + (double)(this.p.bh / this.p.twigRamificationStrength) / 200.0);
            }
            this.singleRami.trimToSize();
            if (this.p.twigRamificationOrder == 1.0f) {
                this.wholeRami = new DoubleBlobArray(1);
                transformable = (BlobArray)this.singleRami.clone();
                this.wholeRami.add((BlobArray)transformable);
            } else if (this.p.twigRamificationOrder == 2.0f) {
                this.wholeRami = new DoubleBlobArray(20);
                f = this.p.bh / (this.p.lastRamificationNumber + 1.0f);
                this.wholeRami.add((BlobArray)this.singleRami.clone());
                while (f < this.p.bh) {
                    this.ba = (BlobArray)this.singleRami.clone();
                    f5 = 1.0f - f / this.p.bh;
                    this.ba.scale(f5);
                    f5 = (float)((double)1234.567f * Math.sin(f * 4.56f * (float)Math.PI));
                    this.ba.rotateY(f5);
                    if (this.p.rotationBunchFunnel > 0.0f) {
                        f5 = -(this.p.rotationBunchFunnel / 2.0f) * (1.0f - f * f / (this.p.bh * this.p.bh)) * ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) / ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) - 1.0f));
                        this.ba.rotateZ(f5);
                        f5 = (float)(777.0 * Math.sin(2.37f * f * (float)Math.PI));
                        this.ba.rotateY(f5);
                    } else {
                        f2 = Math.sin(f * (float)Math.PI / 2.0f) < 0.0 ? -((float)(1.0 + Math.sin(f * (float)Math.PI / 2.0f))) : (float)(1.0 - Math.sin(f * (float)Math.PI / 2.0f));
                        f5 = (float)((double)(this.p.verticalBunchFunnel / 2.0f * (1.0f - f * f / (this.p.bh * this.p.bh))) * (Math.sin(f * (float)Math.PI / 2.0f) + (double)f2) * (double)((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) / ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) - 1.0f)));
                        this.ba.rotateZ(f5);
                        f2 = Math.sin(f * (float)Math.PI) < 0.0 ? -((float)(1.0 + Math.sin(f * (float)Math.PI))) : (float)(1.0 - Math.sin(f * (float)Math.PI));
                        f5 = (float)((double)(this.p.horizontalBunchFunnel / 2.0f * (1.0f - f * f / (this.p.bh * this.p.bh))) * (Math.sin(f * (float)Math.PI) + (double)f2) * (double)((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) / ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) - 1.0f)));
                        this.ba.rotateX(f5);
                    }
                    f2 = (this.p.bh - f) / this.p.bh * this.p.twigCurveAdjustment * this.p.twigRamificationCurveAdjustment;
                    f5 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                    f4 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                    f3 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                    this.ba.translate(f5, f4, f3);
                    f5 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                    f4 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                    f3 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                    this.ba.translate(f5, f4, f3);
                    f2 = this.p.twigCurveAdjustment * this.p.twigRamificationCurveAdjustment;
                    f5 = (float)((double)this.p.abg * Math.sin(1.5707963705062866 * Math.sin(5.371f * this.p.abfz * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                    f4 = f;
                    f3 = (float)((double)this.p.abg * Math.sin(1.5707963705062866 * Math.sin(5.937f * this.p.abfz * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                    this.ba.translate(f5, f4, f3);
                    f5 = (float)((double)this.p.branchSpiral * Math.sin(f / this.p.bh * 1.5707964f));
                    this.ba.rotateY(f5);
                    this.wholeRami.add(this.ba);
                    f += this.p.bh / (this.p.lastRamificationNumber + 1.0f);
                }
                this.wholeRami.trimToSize();
            } else if (this.p.twigRamificationOrder == 3.0f) {
                this.wholeRami = new DoubleBlobArray(20);
                float f6 = this.p.bh / (this.p.lastRamificationNumber + 1.0f);
                this.ba = (BlobArray)this.singleRami.clone();
                this.wholeRami.add(this.ba);
                while (f6 < this.p.bh) {
                    f = this.p.bh / (this.p.lastRamificationNumber + 1.0f);
                    BlobArray blobArray = (BlobArray)this.singleRami.clone();
                    transformable = new DoubleBlobArray();
                    ((DoubleBlobArray)transformable).add(blobArray);
                    while (f < this.p.bh) {
                        BlobArray blobArray2 = (BlobArray)this.singleRami.clone();
                        f5 = 1.0f - f / this.p.bh;
                        blobArray2.scale(f5);
                        f5 = (float)((double)1234.567f * Math.sin(f * 4.56f * (float)Math.PI));
                        blobArray2.rotateY(f5);
                        if (this.p.rotationBunchFunnel > 0.0f) {
                            f5 = -(this.p.rotationBunchFunnel / 2.0f) * (1.0f - f * f / (this.p.bh * this.p.bh)) * ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) / ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) - 1.0f));
                            blobArray2.rotateZ(f5);
                            f5 = (float)(777.0 * Math.sin(2.37f * f * (float)Math.PI));
                            blobArray2.rotateY(f5);
                        } else {
                            f2 = Math.sin(f * (float)Math.PI / 2.0f) < 0.0 ? -((float)(1.0 + Math.sin(f * (float)Math.PI / 2.0f))) : (float)(1.0 - Math.sin(f * (float)Math.PI / 2.0f));
                            f5 = (float)((double)(this.p.verticalBunchFunnel / 2.0f * (1.0f - f * f / (this.p.bh * this.p.bh))) * (Math.sin(f * (float)Math.PI / 2.0f) + (double)f2) * (double)((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) / ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) - 1.0f)));
                            blobArray2.rotateZ(f5);
                            f2 = Math.sin(f * (float)Math.PI) < 0.0 ? -((float)(1.0 + Math.sin(f * (float)Math.PI))) : (float)(1.0 - Math.sin(f * (float)Math.PI));
                            f5 = (float)((double)(this.p.horizontalBunchFunnel / 2.0f * (1.0f - f * f / (this.p.bh * this.p.bh))) * (Math.sin(f * (float)Math.PI) + (double)f2) * (double)((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) / ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) - 1.0f)));
                            blobArray2.rotateX(f5);
                        }
                        f5 = (float)((double)-1234.567f * Math.sin(f6 * 4.56f * (float)Math.PI) + 180.0);
                        blobArray2.rotateY(f5);
                        f2 = (this.p.bh - f) / this.p.bh * this.p.twigCurveAdjustment * this.p.twigRamificationCurveAdjustment;
                        f5 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                        f4 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                        f3 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                        blobArray2.translate(f5, f4, f3);
                        f5 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                        f4 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                        f3 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                        blobArray2.translate(f5, f4, f3);
                        f2 = this.p.twigCurveAdjustment * this.p.twigRamificationCurveAdjustment;
                        f5 = (float)((double)this.p.abg * Math.sin(1.5707963705062866 * Math.sin(5.371f * this.p.abfz * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                        f4 = f;
                        f3 = (float)((double)this.p.abg * Math.sin(1.5707963705062866 * Math.sin(5.937f * this.p.abfz * this.p.zbfza * this.p.rfza * f / this.p.bh)) * (double)f2);
                        blobArray2.translate(f5, f4, f3);
                        f5 = (float)((double)this.p.branchSpiral * Math.sin(f / this.p.bh * 1.5707964f));
                        blobArray2.rotateY(f5);
                        ((DoubleBlobArray)transformable).add(blobArray2);
                        f += this.p.bh / (this.p.lastRamificationNumber + 1.0f);
                    }
                    f5 = 1.0f - f6 / this.p.bh;
                    ((DoubleBlobArray)transformable).scale(f5);
                    f5 = (float)((double)1234.567f * Math.sin(f6 * 4.56f * (float)Math.PI));
                    ((DoubleBlobArray)transformable).rotateY(f5);
                    if (this.p.rotationBunchFunnel > 0.0f) {
                        f5 = -(this.p.rotationBunchFunnel / 2.0f) * (1.0f - f6 * f6 / (this.p.bh * this.p.bh)) * ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) / ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) - 1.0f));
                        ((DoubleBlobArray)transformable).rotateZ(f5);
                        f5 = (float)(777.0 * Math.sin(2.37f * f6 * (float)Math.PI));
                        ((DoubleBlobArray)transformable).rotateY(f5);
                    } else {
                        f2 = Math.sin(f6 * (float)Math.PI / 2.0f) < 0.0 ? (float)(-(1.0 + Math.sin(f6 * (float)Math.PI / 2.0f))) : (float)(1.0 - Math.sin(f6 * (float)Math.PI / 2.0f));
                        f5 = (float)((double)(this.p.verticalBunchFunnel / 2.0f * (1.0f - f6 * f6 / (this.p.bh * this.p.bh))) * (Math.sin(f6 * (float)Math.PI / 2.0f) + (double)f2) * (double)((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) / ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) - 1.0f)));
                        ((DoubleBlobArray)transformable).rotateZ(f5);
                        f2 = Math.sin(f6 * (float)Math.PI) < 0.0 ? (float)(-(1.0 + Math.sin(f6 * (float)Math.PI))) : (float)(1.0 - Math.sin(f6 * (float)Math.PI));
                        f5 = (float)((double)(this.p.horizontalBunchFunnel / 2.0f * (1.0f - f6 * f6 / (this.p.bh * this.p.bh))) * (Math.sin(f6 * (float)Math.PI) + (double)f2) * (double)((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) / ((this.p.lastRamificationNumber + 1.0f) * (this.p.lastRamificationNumber + 1.0f) - 1.0f)));
                        ((DoubleBlobArray)transformable).rotateX(f5);
                    }
                    f2 = (this.p.bh - f6) / this.p.bh * this.p.twigCurveAdjustment * this.p.twigRamificationCurveAdjustment;
                    f5 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f6 / this.p.bh)) * (double)f2);
                    f4 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f6 / this.p.bh)) * (double)f2);
                    f3 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchSnagFrequency * this.p.zbfza * this.p.rfza * f6 / this.p.bh)) * (double)f2);
                    ((DoubleBlobArray)transformable).translate(f5, f4, f3);
                    f5 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f6 / this.p.bh)) * (double)f2);
                    f4 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f6 / this.p.bh)) * (double)f2);
                    f3 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchCurveFrequency * this.p.zbfza * this.p.rfza * f6 / this.p.bh)) * (double)f2);
                    ((DoubleBlobArray)transformable).translate(f5, f4, f3);
                    f2 = this.p.twigCurveAdjustment * this.p.twigRamificationCurveAdjustment;
                    f5 = (float)((double)this.p.abg * Math.sin(1.5707963705062866 * Math.sin(5.371f * this.p.abfz * this.p.zbfza * this.p.rfza * f6 / this.p.bh)) * (double)f2);
                    f4 = f6;
                    f3 = (float)((double)this.p.abg * Math.sin(1.5707963705062866 * Math.sin(5.937f * this.p.abfz * this.p.zbfza * this.p.rfza * f6 / this.p.bh)) * (double)f2);
                    ((DoubleBlobArray)transformable).translate(f5, f4, f3);
                    f5 = (float)((double)this.p.branchSpiral * Math.sin(f6 / this.p.bh * 1.5707964f));
                    ((DoubleBlobArray)transformable).rotateY(f5);
                    int n = 0;
                    while (n < ((DoubleBlobArray)transformable).size()) {
                        this.wholeRami.add(((DoubleBlobArray)transformable).get(n));
                        ++n;
                    }
                    f6 += this.p.bh / (this.p.lastRamificationNumber + 1.0f);
                }
                this.wholeRami.trimToSize();
            }
        }
    }

    public QuintetBlobArray generate() throws InterruptedException {
        if (this.p.branches >= 1.0f && this.p.twigs >= 1.0f && this.p.bunches >= 1.0f && this.p.twigRamificationOrder > 0.0f && this.p.twigRamificationStrength > 0.0f) {
            this.generateDeclarations();
            this.ramis = new QuintetBlobArray(10);
            float f = 1.0f;
            while (f < 100.0f) {
                this.checkThreadStatus();
                float f2 = 1.0f;
                this.twg = new QuadroBlobArray(20);
                while (f2 < this.p.bh) {
                    float f3 = 1.0f;
                    this.bnch = new TripleBlobArray(10);
                    while (f3 < this.p.zl) {
                        DoubleBlobArray doubleBlobArray = (DoubleBlobArray)this.wholeRami.clone();
                        float f4 = (this.p.bunchMajorRadius + this.p.bunchMinorRadius + this.p.leafLength) / this.p.bh;
                        doubleBlobArray.scale(f4);
                        f4 = -90.0f;
                        doubleBlobArray.rotateZ(f4);
                        f4 = this.p.bunchDeformX;
                        float f5 = this.p.bunchDeformY;
                        float f6 = this.p.bunchDeformZ;
                        doubleBlobArray.scale(f4, f5, f6);
                        float f7 = (float)Math.sin((float)Math.PI * (f3 * ((this.p.bunches / this.p.twigs + 1.0f) / (this.p.bunches / this.p.twigs)) / this.p.zl));
                        f4 = 1.0f + this.p.bunchArcAtTwigX * f7;
                        f5 = 1.0f + this.p.bunchArcAtTwigY * f7;
                        f6 = 1.0f + this.p.bunchArcAtTwigZ * f7;
                        doubleBlobArray.scale(f4, f5, f6);
                        f7 = (float)Math.sin((float)Math.PI * (f2 * ((this.p.twigs / this.p.branches + 1.0f) / (this.p.twigs / this.p.branches)) / this.p.bh));
                        f4 = 1.0f + this.p.bunchArcAtBranchX * f7;
                        f5 = 1.0f + this.p.bunchArcAtBranchY * f7;
                        f6 = 1.0f + this.p.bunchArcAtBranchZ * f7;
                        doubleBlobArray.scale(f4, f5, f6);
                        f4 = (float)(-1456.0 * Math.cos(this.p.branchRandom * 7.19f * f2 * (float)Math.PI) * (1.0 - (double)this.p.twigAlternateSwitch));
                        doubleBlobArray.rotateX(f4);
                        f4 = (float)(-1234.0 * Math.sin(7.77f * f3 * (float)Math.PI) * (double)this.p.bunchTurnShift);
                        doubleBlobArray.rotateX(f4);
                        f4 = (float)(-1234.0 * Math.sin(7.77f * f2 * (float)Math.PI) * (double)this.p.bunchTurnShift);
                        doubleBlobArray.rotateX(f4);
                        f4 = (float)((double)(-this.p.branchSpiral) * Math.sin((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl) / this.p.bh * 1.5707964f));
                        doubleBlobArray.rotateX(f4);
                        f4 = (float)(-1234.0 * Math.sin(this.p.twigRandom * 4.77f * f * (float)Math.PI) * (double)(1.0f - this.p.twigAlternateSwitch));
                        doubleBlobArray.rotateX(f4);
                        f4 = (float)((double)(-this.p.branchSpiral) * Math.sin((this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh * 1.5707964f));
                        doubleBlobArray.rotateX(f4);
                        f4 = (float)((double)(this.p.horizontalBunchAngleScope / 2.0f) * Math.sin(7.77 * (double)f3 * 3.1415927410125732));
                        doubleBlobArray.rotateY(f4);
                        f7 = this.p.bunches / this.p.twigs > 1.0f ? -(this.p.verticalBunchAngle * (f3 * f3) / (this.p.zl * this.p.zl) * this.p.verticalBunchAlignment) : 0.0f;
                        f4 = (float)((double)(this.p.verticalBunchAngleScope / 2.0f) * Math.sin(9.77f * f3 * (float)Math.PI) + (double)(this.p.verticalBunchAngle + f7));
                        doubleBlobArray.rotateZ(f4);
                        f7 = (double)(this.p.bunches / this.p.twigs) == 1.0 ? (float)((double)(this.p.horizontalBunchAngle - this.p.horizontalBunchAngle * (f2 * f2) / (this.p.bh * this.p.bh) * this.p.horizontalBunchAlignment) * ((double)(1.0f - this.p.bunchAlternateSwitch) + (double)this.p.bunchAlternateSwitch * Math.sin((f2 / (this.p.bh / this.p.twigs * this.p.branches) - 1.0f / (this.p.bh / this.p.twigs * this.p.branches)) * (float)Math.PI - 1.5707964f))) : (float)((double)(-(this.p.horizontalBunchAngle * (f3 * f3) / (this.p.zl * this.p.zl) * this.p.horizontalBunchAlignment)) * ((double)(1.0f - this.p.bunchAlternateSwitch) + (double)this.p.bunchAlternateSwitch * Math.sin((f3 / (this.p.zl / (this.p.bunches / this.p.twigs)) - 1.0f / (this.p.zl / (this.p.bunches / this.p.twigs))) * (float)Math.PI - 1.5707964f)));
                        f4 = f7;
                        doubleBlobArray.rotateY(f4);
                        f4 = (float)(1234.0 * Math.sin(7.77f * f3 * (float)Math.PI) * (double)this.p.bunchTurnSwitch);
                        doubleBlobArray.rotateX(f4);
                        f4 = (float)(1234.0 * Math.sin(7.77f * f2 * (float)Math.PI) * (double)this.p.bunchTurnSwitch);
                        doubleBlobArray.rotateX(f4);
                        f4 = 1.0f - this.p.bunchTaperOffAtTree * f / 100.0f;
                        doubleBlobArray.scale(f4);
                        f4 = 1.0f - this.p.bunchTaperOffAtTwig * f3 / this.p.zl;
                        doubleBlobArray.scale(f4);
                        f4 = 1.0f - this.p.bunchTaperOffAtBranch * f2 / this.p.bh;
                        doubleBlobArray.scale(f4);
                        f4 = 90.0f;
                        doubleBlobArray.rotateZ(f4);
                        f4 = (float)(-1234.0 * Math.sin(4.77f * f2 * (float)Math.PI) * (double)this.p.twigTurnSwitch);
                        doubleBlobArray.rotateY(f4);
                        f7 = (this.p.bh - (this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh * (this.p.zwl / this.p.bh) * this.p.twigCurveAdjustment * (1.0f - f / 100.0f * this.p.straightenTowardsTop) * (1.0f - f2 / this.p.bh * this.p.straightenTowardsBranchEnd);
                        f4 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.123 * (double)this.p.branchSnagFrequency * (double)this.p.zbfza * (double)((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / (double)this.p.bh)) * (double)f7);
                        f5 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(4.789 * (double)this.p.branchSnagFrequency * (double)this.p.zbfza * (double)((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / (double)this.p.bh)) * (double)f7);
                        f6 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.456 * (double)this.p.branchSnagFrequency * (double)this.p.zbfza * (double)((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / (double)this.p.bh)) * (double)f7);
                        doubleBlobArray.translate(f4, f5, f6);
                        f7 = (this.p.bh - (this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh * (this.p.zwl / this.p.bh) * this.p.twigCurveAdjustment * (1.0f - f / 100.0f * this.p.straightenTowardsTop) * (1.0f - f2 / this.p.bh * this.p.straightenTowardsBranchEnd);
                        f4 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchCurveFrequency * this.p.zbfza * ((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh)) * (double)f7);
                        f5 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchCurveFrequency * this.p.zbfza * ((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh)) * (double)f7);
                        f6 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchCurveFrequency * this.p.zbfza * ((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh)) * (double)f7);
                        doubleBlobArray.translate(f4, f5, f6);
                        f7 = this.p.zwl / this.p.bh;
                        f4 = (float)((double)this.p.abg * Math.sin((double)(this.p.extraNoiseSwitch * (float)Math.PI / 2.0f) * Math.sin(5.371f * this.p.abfz * this.p.zbfza * ((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh) + (double)((1.0f - this.p.extraNoiseSwitch) * 5.371f * this.p.abfz * this.p.zbfza * ((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / this.p.bh)) * (double)f7 * (double)this.p.twigCurveAdjustment * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop) * (double)(1.0f - f2 / this.p.bh * this.p.straightenTowardsBranchEnd));
                        f5 = (this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl) * f7;
                        f6 = (float)((double)this.p.abg * Math.sin(1.5707963705062866 * Math.sin(5.937 * (double)this.p.abfz * (double)this.p.zbfza * (double)((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl)) / (double)this.p.bh)) * (double)this.p.horizontalBranchBendSwitch * (double)f7 * (double)this.p.twigCurveAdjustment * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop) * (double)(1.0f - f2 / this.p.bh * this.p.straightenTowardsBranchEnd));
                        doubleBlobArray.translate(f4, f5, f6);
                        f4 = (float)((double)this.p.branchSpiral * Math.sin((this.p.firstBunchAtTwig + (this.p.zl - this.p.firstBunchAtTwig) / this.p.zl * f3) * (this.p.bh / this.p.zwl) / this.p.bh * 1.5707964f));
                        doubleBlobArray.rotateY(f4);
                        f4 = (float)(1234.0 * Math.sin(4.77f * f2 * (float)Math.PI) * (double)this.p.twigTurnSwitch);
                        doubleBlobArray.rotateY(f4);
                        f4 = (this.p.firstTwigAtBranch + this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper) - this.p.firstTwigAtBranch * this.p.branchTaper * this.p.astl / this.p.bh) / (this.p.firstTwigAtBranch + this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper));
                        doubleBlobArray.scale(f4);
                        f4 = (this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper) - f2 * this.p.branchTaper * this.p.twigAreaAtBranch / this.p.bh) / (this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper));
                        doubleBlobArray.scale(f4);
                        f4 = this.p.bh / this.p.astl;
                        doubleBlobArray.scale(f4);
                        f4 = -90.0f;
                        doubleBlobArray.rotateZ(f4);
                        f4 = (float)((double)this.p.verticalTwigAngleScope * Math.sin(9.77f * f2 * f2 * (float)Math.PI) + (double)(this.p.verticalTwigAngle - this.p.verticalTwigAngle * (f2 * f2) / (this.p.bh * this.p.bh) * this.p.verticalTwigAlignment));
                        doubleBlobArray.rotateZ(f4);
                        f4 = (float)(((double)this.p.horizontalTwigAngleScope * Math.sin(7.77f * f2 * f2 * (float)Math.PI) + (double)(this.p.horizontalTwigAngle - this.p.horizontalTwigAngle * (f2 * f2) / (this.p.bh * this.p.bh) * this.p.horizontalTwigAlignment)) * ((double)(1.0f - this.p.twigAlternateSwitch) + (double)this.p.twigAlternateSwitch * Math.sin((f2 / (this.p.bh / this.p.twigs * this.p.branches) - 1.0f / (this.p.bh / this.p.twigs * this.p.branches)) * (float)Math.PI - 1.5707964f)));
                        doubleBlobArray.rotateY(f4);
                        f4 = (float)(1456.0 * Math.cos(this.p.branchRandom * 7.19f * f2 * (float)Math.PI) * (double)(1.0f - this.p.twigAlternateSwitch));
                        doubleBlobArray.rotateX(f4);
                        f4 = 90.0f;
                        doubleBlobArray.rotateZ(f4);
                        f4 = (float)(1234.0 * Math.sin(this.p.twigRandom * 4.77f * f * (float)Math.PI) * (double)(1.0f - this.p.twigAlternateSwitch));
                        doubleBlobArray.rotateY(f4);
                        f4 = (float)(-1234.0 * Math.sin(4.77f * f * (float)Math.PI) * (double)this.p.branchTurnSwitch);
                        doubleBlobArray.rotateY(f4);
                        f7 = (this.p.bh - (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh)) / this.p.bh * (1.0f - f / 100.0f * this.p.straightenTowardsTop);
                        f4 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchSnagFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7);
                        f5 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchSnagFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7);
                        f6 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchSnagFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7);
                        doubleBlobArray.translate(f4, f5, f6);
                        f7 = (this.p.bh - (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh)) / this.p.bh;
                        f4 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchCurveFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7 * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                        f5 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchCurveFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7 * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop) * (double)this.p.branchLongitudinalCurve);
                        f6 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchCurveFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)f7 * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop) * (double)this.p.horizontalBranchCurveSwitch);
                        doubleBlobArray.translate(f4, f5, f6);
                        f4 = (float)(-((double)this.p.abg * Math.sin((double)(this.p.extraNoiseSwitch * (float)Math.PI / 2.0f) * Math.sin(5.371f * this.p.abfz * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh) + (double)((1.0f - this.p.extraNoiseSwitch) * (5.371f * this.p.abfz * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)))) * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                        f5 = this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh;
                        f6 = (float)((double)this.p.abg * Math.sin((double)(this.p.extraNoiseSwitch * (float)Math.PI / 2.0f) * Math.sin(5.937f * this.p.abfz * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh) + (1.0 - (double)this.p.extraNoiseSwitch) * (double)(5.937f * this.p.abfz * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)this.p.horizontalBranchBendSwitch * (double)(1.0f - f / 100.0f * this.p.straightenTowardsTop));
                        doubleBlobArray.translate(f4, f5, f6);
                        f4 = (float)((double)this.p.branchSpiral * Math.sin((this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f2 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh * 1.5707964f));
                        doubleBlobArray.rotateY(f4);
                        f4 = (float)(1234.0 * Math.sin(4.77f * f * (float)Math.PI) * (double)this.p.branchTurnSwitch);
                        doubleBlobArray.rotateY(f4);
                        f4 = -90.0f;
                        doubleBlobArray.rotateZ(f4);
                        f4 = this.p.astl / this.p.bh * (1.0f - f / 100.0f * this.p.branchReduction);
                        doubleBlobArray.scale(f4);
                        f4 = (float)((double)(this.p.branchAngle + f / 100.0f * (90.0f - this.p.branchAngle) * this.p.branchAlignment) + (double)this.p.branchAngleScope * Math.sin(9.77f * f * f * (float)Math.PI));
                        doubleBlobArray.rotateZ(f4);
                        f4 = (float)(1456.0 * Math.cos(this.p.branchRandom * 7.19f * f * (float)Math.PI) * (double)(1.0f - this.p.branchAlternateSwitch) + (double)(90.0f * this.p.branchAlternateSwitch) * Math.sin((f / (100.0f / this.p.branches) - 1.0f / (100.0f / this.p.branches)) * (float)Math.PI - 1.5707964f) + 90.0);
                        doubleBlobArray.rotateY(f4);
                        f7 = (this.p.bh - (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f)) / this.p.bh;
                        f4 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.trunkSnagFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f5 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.trunkSnagFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f6 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.trunkSnagFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        doubleBlobArray.translate(f4, f5, f6);
                        f7 = (this.p.bh - (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f)) / this.p.bh;
                        f4 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.trunkCurveFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f5 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.trunkCurveFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f6 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.trunkCurveFrequency * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        doubleBlobArray.translate(f4, f5, f6);
                        f4 = (float)((double)this.p.trunkBendX * Math.sin(1.5707963705062866 * Math.sin(5.371f * this.p.trunkBendXFrequency * 1.5f * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)));
                        f5 = this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f;
                        f6 = (float)((double)this.p.trunkBendZ * Math.sin(1.5707963705062866 * Math.sin(5.937f * this.p.trunkBendZFrequency * 1.5f * (this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)));
                        doubleBlobArray.translate(f4, f5, f6);
                        f4 = (float)((double)this.p.trunkSpiral * Math.sin((this.p.firstBranchAtTrunk + f * this.p.branchAreaAtTrunk / 100.0f) / (this.p.bh * 3.0f / 5.0f)));
                        doubleBlobArray.rotateY(f4);
                        f3 += this.p.zl / this.p.bunches * this.p.twigs;
                        this.bnch.add(doubleBlobArray);
                    }
                    f2 += this.p.bh / this.p.twigs * this.p.branches;
                    this.bnch.trimToSize();
                    this.twg.add(this.bnch);
                }
                f += 100.0f / this.p.branches;
                this.twg.trimToSize();
                this.ramis.add(this.twg);
            }
            this.ramis.trimToSize();
        }
        return this.ramis;
    }
}

