/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import povtree.interfaces.Constants;
import povtree.objects3D.Blob;
import povtree.objects3D.BlobArray;
import povtree.objects3D.DoubleBlobArray;
import povtree.povTreeGenerator.Parameters;

public class RootGenerator
implements Constants {
    private Parameters p;
    private DoubleBlobArray roots;

    public RootGenerator(Parameters parameters) {
        this.p = parameters;
    }

    public void checkThreadStatus() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public DoubleBlobArray generate() throws InterruptedException {
        if (this.p.rootStrength > 0.0f && this.p.roots >= 1.0f) {
            this.roots = new DoubleBlobArray(10);
            float f = 1.0f;
            while (f < 100.0f) {
                this.checkThreadStatus();
                float f2 = 1.0f;
                BlobArray blobArray = new BlobArray(100);
                while (f2 < this.p.bh) {
                    float f3;
                    Blob blob = new Blob(this.p.trunkRadius * 5.0f, this.p.trunkRadius * 10.0f);
                    float f4 = (this.p.bh - f2) / this.p.bh;
                    blob.scale(f4);
                    f4 = this.p.trunkRadius / 90.0f;
                    blob.scale(f4);
                    f4 = this.p.rootThicknessChange;
                    blob.scale(f4);
                    f4 = this.p.bh / this.p.rootLength;
                    blob.scale(f4);
                    f4 = 1.0f - this.p.barkProfile * 0.9f * this.p.rootBarkProfileChange;
                    float f5 = f3 = 1.0f + this.p.barkProfile * 0.25f * this.p.rootBarkProfileChange;
                    blob.scale(f3);
                    f4 = (float)(12347.2998046875 * Math.sin(3.77f * f2 * (float)Math.PI));
                    blob.rotateY(f4);
                    f4 = (float)((double)this.p.rootSnag * Math.sin(1.5707963705062866 * Math.sin(5.789f * this.p.rootSnagFrequency * f2 / this.p.bh)) * (double)((this.p.bh - f2) / this.p.bh));
                    f3 = (float)((double)this.p.rootSnag * Math.sin(1.5707963705062866 * Math.sin(4.4321f * this.p.rootSnagFrequency * f2 / this.p.bh)) * (double)((this.p.bh - f2) / this.p.bh));
                    f5 = (float)((double)this.p.rootSnag * Math.sin(1.5707963705062866 * Math.sin(5.0f * this.p.rootSnagFrequency * f2 / this.p.bh)) * (double)((this.p.bh - f2) / this.p.bh));
                    blob.translate(f4, f3, f5);
                    f4 = (float)((double)this.p.rootCurve * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.rootCurveFrequency * f2 / this.p.bh)) * (double)((this.p.bh - f2) / this.p.bh));
                    f3 = (float)((double)this.p.rootCurve * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.rootCurveFrequency * f2 / this.p.bh)) * (double)((this.p.bh - f2) / this.p.bh));
                    f5 = (float)((double)this.p.rootCurve * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.rootCurveFrequency * f2 / this.p.bh)) * (double)((this.p.bh - f2) / this.p.bh));
                    blob.translate(f4, f3, f5);
                    f4 = (float)((double)this.p.rootBend * Math.sin(1.5707963705062866 * Math.sin(5.371f * this.p.rootBendFrequency * f2 / this.p.bh)));
                    f3 = f2;
                    f5 = (float)((double)this.p.rootBend * Math.sin(1.5707963705062866 * Math.sin(5.937f * this.p.rootBendFrequency * f2 / this.p.bh)));
                    blob.translate(f4, f3, f5);
                    f4 = (float)(1234.77294921875 * Math.sin(4.77f * f * (float)Math.PI) * (double)this.p.rootTurnSwitch);
                    blob.rotateY(f4);
                    f4 = -90.0f;
                    blob.rotateZ(f4);
                    f4 = 180.0f;
                    blob.rotateY(f4);
                    f4 = this.p.rootLength / this.p.bh;
                    blob.scale(f4);
                    f4 = this.p.rootAngle + f / 100.0f * this.p.rootAlignment * (90.0f - this.p.rootAngle);
                    blob.rotateZ(f4);
                    f4 = (float)((double)1456.371f * Math.sin(this.p.rootRandom * 71.19f * f * (float)Math.PI) + 180.0);
                    blob.rotateY(f4);
                    f4 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.trunkSnagFrequency * (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f) / this.p.bh)) * (double)((this.p.bh - (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f)) / this.p.bh));
                    f3 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.trunkSnagFrequency * (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f) / this.p.bh)) * (double)((this.p.bh - (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f)) / this.p.bh));
                    f5 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.trunkSnagFrequency * (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f) / this.p.bh)) * (double)((this.p.bh - (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f)) / this.p.bh));
                    blob.translate(f4, f3, f5);
                    f4 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.trunkCurveFrequency * (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f) / this.p.bh)) * (double)((this.p.bh - (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f)) / this.p.bh));
                    f3 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.trunkCurveFrequency * (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f) / this.p.bh)) * (double)((this.p.bh - (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f)) / this.p.bh));
                    f5 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.trunkCurveFrequency * (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f) / this.p.bh)) * (double)((this.p.bh - (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f)) / this.p.bh));
                    blob.translate(f4, f3, f5);
                    f4 = (float)((double)this.p.trunkBendX * Math.sin(1.5707963705062866 * Math.sin(5.371f * this.p.trunkBendXFrequency * 1.5f * (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f) / this.p.bh)));
                    f3 = this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f;
                    f5 = (float)((double)this.p.trunkBendZ * Math.sin(1.5707963705062866 * Math.sin(5.937f * this.p.trunkBendZFrequency * 1.5f * (this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f) / this.p.bh)));
                    blob.translate(f4, f3, f5);
                    f4 = (float)((double)this.p.trunkSpiral * Math.sin((this.p.firstRootAtTrunk - this.p.firstRootAtTrunk * f / 100.0f) / (this.p.bh * 3.0f / 5.0f)));
                    blob.rotateY(f4);
                    blobArray.add(blob);
                    f2 += this.p.bh / 150.0f / this.p.rootStrength;
                }
                blobArray.trimToSize();
                this.roots.add(blobArray);
                f += 100.0f / this.p.roots;
            }
        }
        if (this.roots != null) {
            this.roots.trimToSize();
        }
        return this.roots;
    }
}

