/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import java.util.ArrayList;
import java.util.Hashtable;
import povtree.interfaces.Leaf;
import povtree.objects3D.BlobArray;
import povtree.objects3D.Coordinate;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.DoubleLeafArray;
import povtree.objects3D.LeafArray;
import povtree.objects3D.QuadroBlobArray;
import povtree.objects3D.QuadroLeafArray;
import povtree.objects3D.QuintetBlobArray;
import povtree.objects3D.Tree3D;
import povtree.objects3D.Triangle;
import povtree.objects3D.TripleBlobArray;
import povtree.objects3D.TripleLeafArray;
import povtree.povTreeGenerator.Accuracy;

public class Statistics {
    private Tree3D t3D;
    private Accuracy accuracy;

    public Statistics(Tree3D tree3D, Accuracy accuracy) {
        this.t3D = tree3D;
        this.accuracy = accuracy;
    }

    public long getNumberOfTriangles() {
        long l = 0L;
        if (this.t3D == null) {
            return 0L;
        }
        l += this.getRootTriangles();
        l += this.getTrunkTriangles();
        l += this.getBranchTriangles();
        l += this.getTwigTriangles();
        l += this.getRamiTriangles();
        l += this.getFoliageTriangles();
        return l += this.getBlossomTriangles();
    }

    public long getNumberOfWoodTriangles() {
        long l = 0L;
        if (this.t3D == null) {
            return 0L;
        }
        l += this.getRootTriangles();
        l += this.getTrunkTriangles();
        l += this.getBranchTriangles();
        l += this.getTwigTriangles();
        return l += this.getRamiTriangles();
    }

    public long getNumberOfVertexes() {
        long l = 0L;
        if (this.t3D == null) {
            return 0L;
        }
        l += this.getRootVertexes();
        l += this.getTrunkVertexes();
        l += this.getBranchVertexes();
        l += this.getTwigVertexes();
        return l += this.getRamiVertexes();
    }

    public long getFaceLength(long l) {
        long l2 = 0L;
        l2 = l > 0L && l < 100L ? 10L : (l >= 100L && l < 1000L ? 13L : (l >= 1000L && l < 10000L ? 16L : (l >= 10000L && l < 100000L ? 19L : (l >= 100000L && l < 1000000L ? 22L : 25L))));
        return l2;
    }

    public long getRootTriangles() {
        long l = 0L;
        DoubleBlobArray doubleBlobArray = this.t3D.getRoot();
        if (doubleBlobArray != null) {
            int n = 0;
            while (n < doubleBlobArray.size()) {
                ArrayList arrayList = doubleBlobArray.get(n).get();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    int n3 = 0;
                    while (n3 < this.accuracy.rootRadial) {
                        l += 2L;
                        ++n3;
                    }
                    n2 += this.accuracy.rootVertical;
                }
                ++n;
            }
        }
        return l;
    }

    public long getRootVertexes() {
        long l = 0L;
        if (this.t3D.getRoot() != null) {
            l = (this.getRootTriangles() / 2L / this.getNumberOfRoots() + (long)this.accuracy.rootRadial) * this.getNumberOfRoots();
        }
        return l;
    }

    public long getTrunkTriangles() {
        ArrayList arrayList;
        long l = 0L;
        BlobArray blobArray = this.t3D.getTrunk();
        if (blobArray != null && (arrayList = blobArray.get()) != null) {
            int n = 0;
            while (n < arrayList.size()) {
                int n2 = 0;
                while (n2 < this.accuracy.trunkRadial) {
                    l += 2L;
                    ++n2;
                }
                n += this.accuracy.trunkVertical;
            }
        }
        return l;
    }

    public long getTrunkVertexes() {
        long l = this.getTrunkTriangles() / 2L;
        if (l == 0L) {
            return 0L;
        }
        l = l == (long)this.accuracy.trunkRadial ? (l *= 2L) : (l += (long)this.accuracy.trunkRadial);
        return l;
    }

    public long getBranchTriangles() {
        long l = 0L;
        DoubleBlobArray doubleBlobArray = this.t3D.getBranches();
        if (doubleBlobArray != null) {
            int n = 0;
            while (n < doubleBlobArray.size()) {
                ArrayList arrayList = doubleBlobArray.get(n).get();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    int n3 = 0;
                    while (n3 < this.accuracy.branchRadial) {
                        l += 2L;
                        ++n3;
                    }
                    n2 += this.accuracy.branchVertical;
                }
                ++n;
            }
        }
        return l;
    }

    public long getBranchVertexes() {
        long l = 0L;
        if (this.t3D.getBranches() != null) {
            l = (this.getBranchTriangles() / 2L / this.getNumberOfBranches() + (long)this.accuracy.branchRadial) * this.getNumberOfBranches();
        }
        return l;
    }

    public long getTwigTriangles() {
        long l = 0L;
        TripleBlobArray tripleBlobArray = this.t3D.getTwigs();
        if (tripleBlobArray != null) {
            int n = 0;
            while (n < tripleBlobArray.size()) {
                DoubleBlobArray doubleBlobArray = tripleBlobArray.get(n);
                int n2 = 0;
                while (n2 < doubleBlobArray.size()) {
                    ArrayList arrayList = doubleBlobArray.get(n2).get();
                    int n3 = 0;
                    while (n3 < arrayList.size()) {
                        int n4 = 0;
                        while (n4 < this.accuracy.twigRadial) {
                            l += 2L;
                            ++n4;
                        }
                        n3 += this.accuracy.twigVertical;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return l;
    }

    public long getTwigVertexes() {
        long l = 0L;
        if (this.t3D.getTwigs() != null) {
            l = (this.getTwigTriangles() / 2L / this.getNumberOfTwigs() + (long)this.accuracy.twigRadial) * this.getNumberOfTwigs();
        }
        return l;
    }

    public long getRamiTriangles() {
        long l = 0L;
        QuintetBlobArray quintetBlobArray = this.t3D.getRami();
        if (quintetBlobArray != null) {
            int n = 0;
            while (n < quintetBlobArray.size()) {
                QuadroBlobArray quadroBlobArray = quintetBlobArray.get(n);
                int n2 = 0;
                while (n2 < quadroBlobArray.size()) {
                    TripleBlobArray tripleBlobArray = quadroBlobArray.get(n2);
                    int n3 = 0;
                    while (n3 < tripleBlobArray.size()) {
                        DoubleBlobArray doubleBlobArray = tripleBlobArray.get(n3);
                        int n4 = 0;
                        while (n4 < doubleBlobArray.size()) {
                            ArrayList arrayList = doubleBlobArray.get(n4).get();
                            int n5 = 0;
                            while (n5 < arrayList.size()) {
                                int n6 = 0;
                                while (n6 < this.accuracy.ramiRadial) {
                                    l += 2L;
                                    ++n6;
                                }
                                n5 += this.accuracy.ramiVertical;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return l;
    }

    public long getRamiVertexes() {
        long l = 0L;
        if (this.t3D.getRami() != null) {
            l = (this.getRamiTriangles() / 2L / this.getNumberOfRamis() + (long)this.accuracy.ramiRadial) * this.getNumberOfRamis();
        }
        return l;
    }

    public long getFoliageTriangles() {
        long l = 0L;
        if (this.t3D.getFoliage() != null && this.t3D.getFoliage() instanceof QuadroLeafArray) {
            QuadroLeafArray quadroLeafArray = (QuadroLeafArray)this.t3D.getFoliage();
            int n = 0;
            while (n < quadroLeafArray.size()) {
                TripleLeafArray tripleLeafArray = quadroLeafArray.get(n);
                if (tripleLeafArray != null) {
                    int n2 = 0;
                    while (n2 < tripleLeafArray.size()) {
                        DoubleLeafArray doubleLeafArray = tripleLeafArray.get(n2);
                        if (doubleLeafArray != null) {
                            int n3 = 0;
                            while (n3 < doubleLeafArray.size()) {
                                LeafArray leafArray = doubleLeafArray.get(n3);
                                if (leafArray != null) {
                                    int n4 = 0;
                                    while (n4 < leafArray.size()) {
                                        Leaf leaf = leafArray.get(n4);
                                        ArrayList arrayList = leaf.getTriangles();
                                        int n5 = 0;
                                        while (n5 < arrayList.size()) {
                                            ++l;
                                            ++n5;
                                        }
                                        ++n4;
                                    }
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return l;
    }

    public long getNumberOfLeaves() {
        long l = 0L;
        if (this.t3D.getFoliage() != null && this.t3D.getFoliage() instanceof QuadroLeafArray) {
            QuadroLeafArray quadroLeafArray = (QuadroLeafArray)this.t3D.getFoliage();
            int n = 0;
            while (n < quadroLeafArray.size()) {
                TripleLeafArray tripleLeafArray = quadroLeafArray.get(n);
                if (tripleLeafArray != null) {
                    int n2 = 0;
                    while (n2 < tripleLeafArray.size()) {
                        DoubleLeafArray doubleLeafArray = tripleLeafArray.get(n2);
                        if (doubleLeafArray != null) {
                            int n3 = 0;
                            while (n3 < doubleLeafArray.size()) {
                                LeafArray leafArray = doubleLeafArray.get(n3);
                                if (leafArray != null) {
                                    int n4 = 0;
                                    while (n4 < leafArray.size()) {
                                        ++l;
                                        ++n4;
                                    }
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return l;
    }

    public long getFoliageVertexes() {
        LeafArray leafArray;
        DoubleLeafArray doubleLeafArray;
        TripleLeafArray tripleLeafArray;
        QuadroLeafArray quadroLeafArray;
        long l = 0L;
        if (this.t3D.getFoliage() != null && this.t3D.getFoliage() instanceof QuadroLeafArray && (quadroLeafArray = (QuadroLeafArray)this.t3D.getFoliage()) != null && (tripleLeafArray = quadroLeafArray.get(0)) != null && (doubleLeafArray = tripleLeafArray.get(0)) != null && (leafArray = doubleLeafArray.get(0)) != null) {
            Leaf leaf = leafArray.get(0);
            ArrayList arrayList = leaf.getTriangles();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n = 0;
            while (n < arrayList.size()) {
                Triangle triangle = (Triangle)arrayList.get(n);
                Coordinate coordinate = triangle.c1;
                String string = String.valueOf(coordinate.x) + String.valueOf(coordinate.x) + String.valueOf(coordinate.x);
                if (hashtable.get(string) == null) {
                    hashtable.put(string, "");
                }
                Coordinate coordinate2 = triangle.c2;
                string = String.valueOf(coordinate2.x) + String.valueOf(coordinate2.x) + String.valueOf(coordinate2.x);
                if (hashtable.get(string) == null) {
                    hashtable.put(string, "");
                }
                Coordinate coordinate3 = triangle.c3;
                string = String.valueOf(coordinate3.x) + String.valueOf(coordinate3.x) + String.valueOf(coordinate3.x);
                if (hashtable.get(string) == null) {
                    hashtable.put(string, "");
                }
                ++n;
            }
            l = this.getNumberOfLeaves() * (long)hashtable.size();
        }
        return l;
    }

    public long getBlossomTriangles() {
        long l = 0L;
        if (this.t3D.getBlossom() != null && this.t3D.getBlossom() instanceof QuadroLeafArray) {
            QuadroLeafArray quadroLeafArray = (QuadroLeafArray)this.t3D.getBlossom();
            int n = 0;
            while (n < quadroLeafArray.size()) {
                TripleLeafArray tripleLeafArray = quadroLeafArray.get(n);
                if (tripleLeafArray != null) {
                    int n2 = 0;
                    while (n2 < tripleLeafArray.size()) {
                        DoubleLeafArray doubleLeafArray = tripleLeafArray.get(n2);
                        if (doubleLeafArray != null) {
                            int n3 = 0;
                            while (n3 < doubleLeafArray.size()) {
                                LeafArray leafArray = doubleLeafArray.get(n3);
                                if (leafArray != null) {
                                    int n4 = 0;
                                    while (n4 < leafArray.size()) {
                                        Leaf leaf = leafArray.get(n4);
                                        ArrayList arrayList = leaf.getTriangles();
                                        int n5 = 0;
                                        while (n5 < arrayList.size()) {
                                            ++l;
                                            ++n5;
                                        }
                                        ++n4;
                                    }
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return l;
    }

    public long getNumberOfBlossoms() {
        long l = 0L;
        if (this.t3D.getBlossom() != null && this.t3D.getBlossom() instanceof QuadroLeafArray) {
            QuadroLeafArray quadroLeafArray = (QuadroLeafArray)this.t3D.getBlossom();
            int n = 0;
            while (n < quadroLeafArray.size()) {
                TripleLeafArray tripleLeafArray = quadroLeafArray.get(n);
                if (tripleLeafArray != null) {
                    int n2 = 0;
                    while (n2 < tripleLeafArray.size()) {
                        DoubleLeafArray doubleLeafArray = tripleLeafArray.get(n2);
                        if (doubleLeafArray != null) {
                            int n3 = 0;
                            while (n3 < doubleLeafArray.size()) {
                                LeafArray leafArray = doubleLeafArray.get(n3);
                                if (leafArray != null) {
                                    int n4 = 0;
                                    while (n4 < leafArray.size()) {
                                        ++l;
                                        ++n4;
                                    }
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return l;
    }

    public long getBlossomVertexes() {
        LeafArray leafArray;
        DoubleLeafArray doubleLeafArray;
        TripleLeafArray tripleLeafArray;
        QuadroLeafArray quadroLeafArray;
        long l = 0L;
        if (this.t3D.getBlossom() != null && this.t3D.getBlossom() instanceof QuadroLeafArray && (quadroLeafArray = (QuadroLeafArray)this.t3D.getBlossom()) != null && (tripleLeafArray = quadroLeafArray.get(0)) != null && (doubleLeafArray = tripleLeafArray.get(0)) != null && (leafArray = doubleLeafArray.get(0)) != null) {
            Leaf leaf = leafArray.get(0);
            ArrayList arrayList = leaf.getTriangles();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n = 0;
            while (n < arrayList.size()) {
                Triangle triangle = (Triangle)arrayList.get(n);
                Coordinate coordinate = triangle.c1;
                String string = String.valueOf(coordinate.x) + String.valueOf(coordinate.x) + String.valueOf(coordinate.x);
                if (hashtable.get(string) == null) {
                    hashtable.put(string, "");
                }
                Coordinate coordinate2 = triangle.c2;
                string = String.valueOf(coordinate2.x) + String.valueOf(coordinate2.x) + String.valueOf(coordinate2.x);
                if (hashtable.get(string) == null) {
                    hashtable.put(string, "");
                }
                Coordinate coordinate3 = triangle.c3;
                string = String.valueOf(coordinate3.x) + String.valueOf(coordinate3.x) + String.valueOf(coordinate3.x);
                if (hashtable.get(string) == null) {
                    hashtable.put(string, "");
                }
                ++n;
            }
            l = this.getNumberOfBlossoms() * (long)hashtable.size();
        }
        return l;
    }

    public long getNumberOfRoots() {
        if (this.t3D.getRoot() != null) {
            return this.t3D.getRoot().size();
        }
        return 0L;
    }

    public long getNumberOfBranches() {
        if (this.t3D.getBranches() != null) {
            return this.t3D.getBranches().size();
        }
        return 0L;
    }

    public long getNumberOfTwigs() {
        long l = 0L;
        if (this.t3D.getTwigs() != null) {
            TripleBlobArray tripleBlobArray = this.t3D.getTwigs();
            long l2 = tripleBlobArray.size();
            int n = 0;
            while ((long)n < l2) {
                DoubleBlobArray doubleBlobArray = tripleBlobArray.get(n);
                int n2 = 0;
                while (n2 < doubleBlobArray.size()) {
                    ++l;
                    ++n2;
                }
                ++n;
            }
            return l;
        }
        return 0L;
    }

    public long getNumberOfRamis() {
        long l = 0L;
        if (this.t3D.getRami() != null) {
            QuintetBlobArray quintetBlobArray = this.t3D.getRami();
            int n = 0;
            while (n < quintetBlobArray.size()) {
                QuadroBlobArray quadroBlobArray = quintetBlobArray.get(n);
                int n2 = 0;
                while (n2 < quadroBlobArray.size()) {
                    TripleBlobArray tripleBlobArray = quadroBlobArray.get(n2);
                    int n3 = 0;
                    while (n3 < tripleBlobArray.size()) {
                        DoubleBlobArray doubleBlobArray = tripleBlobArray.get(n3);
                        int n4 = 0;
                        while (n4 < doubleBlobArray.size()) {
                            ++l;
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return l;
        }
        return 0L;
    }

    public long getNumberOfRootFaces() {
        if (this.t3D.getRoot() != null) {
            return this.getRootTriangles() / 2L / this.getNumberOfRoots();
        }
        return 0L;
    }

    public long getNumberOfTrunkFaces() {
        if (this.t3D.getTrunk() != null) {
            return this.getTrunkTriangles() / 2L;
        }
        return 0L;
    }

    public long getNumberOfBranchFaces() {
        if (this.t3D.getBranches() != null) {
            return this.getBranchTriangles() / 2L / this.getNumberOfBranches();
        }
        return 0L;
    }

    public long getNumberOfTwigFaces() {
        if (this.t3D.getTwigs() != null) {
            return this.getTwigTriangles() / 2L / this.getNumberOfTwigs();
        }
        return 0L;
    }

    public long getNumberOfRamiFaces() {
        if (this.t3D.getRami() != null) {
            return this.getRamiTriangles() / 2L / this.getNumberOfRamis();
        }
        return 0L;
    }
}

