/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import povtree.interfaces.Constants;
import povtree.objects3D.Blob;
import povtree.objects3D.BlobArray;
import povtree.povTreeGenerator.Parameters;

public class TrunkGenerator
implements Constants {
    private Parameters p;
    private BlobArray trunk;

    public TrunkGenerator(Parameters parameters) {
        this.p = parameters;
    }

    public BlobArray generate() {
        if (this.p.trunkStrength <= 0.0f) {
            return null;
        }
        if (this.p.trunkStrength > 0.0f) {
            float f;
            float f2;
            this.trunk = new BlobArray(300);
            float f3 = 1.0f;
            float f4 = this.p.trunkRadius;
            if (this.p.branches >= 1.0f) {
                float f5 = this.p.branches;
                f2 = (f5 - 1.0f) / f5;
                f = f2 * this.p.branchAreaAtTrunk;
            } else {
                f = this.p.branchAreaAtTrunk;
            }
            while (f3 <= this.p.firstBranchAtTrunk + f) {
                float f6;
                float f7;
                Blob blob = new Blob(f4 * 5.0f, f4 * 10.0f);
                float f8 = f4 / 90.0f;
                blob.scale(f8);
                f8 = (this.p.bh - f3 * this.p.trunkTaper) / this.p.bh;
                blob.scale(f8);
                if (this.p.palmTrunk == 0.0f) {
                    f8 = 1.0f - this.p.barkProfile * 0.9f;
                    f6 = f7 = 1.0f + this.p.barkProfile * 0.25f;
                    blob.scale(f7);
                    f8 = (float)((double)20.3f * Math.sin(3.12f * f3 * (float)Math.PI));
                    blob.rotateZ(f8);
                    f8 = (float)(12347.2998046875 * Math.sin(3.77f * f3 * (float)Math.PI));
                    blob.rotateY(f8);
                } else {
                    f8 = 1.0f;
                    f7 = 1.0f - this.p.palmTrunk * 0.9f;
                    f6 = 1.0f + this.p.palmTrunk * 0.5f;
                    blob.scale(f8);
                    f8 = 35.0f;
                    f7 = (float)(12347.2998046875 * Math.sin(4.77f * f3 * (float)Math.PI));
                    f6 = 0.0f;
                    blob.rotate(f8, f7, f6);
                }
                if (f3 > this.p.firstBranchAtTrunk) {
                    f8 = 1.0f - (f3 - this.p.firstBranchAtTrunk) / this.p.branchAreaAtTrunk * this.p.branchReduction;
                    blob.scale(f8);
                    f8 = 1.0f - (f3 - this.p.firstBranchAtTrunk) / f * (1.0f - this.p.branchThicknessChange);
                    blob.scale(f8);
                }
                f2 = (this.p.bh - f3) / this.p.bh;
                f8 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.trunkSnagFrequency * f3 / this.p.bh)) * (double)f2);
                f7 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.trunkSnagFrequency * f3 / this.p.bh)) * (double)f2);
                f6 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.trunkSnagFrequency * f3 / this.p.bh)) * (double)f2);
                blob.translate(f8, f7, f6);
                f8 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.trunkCurveFrequency * f3 / this.p.bh)) * (double)f2);
                f7 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.trunkCurveFrequency * f3 / this.p.bh)) * (double)f2);
                f6 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.trunkCurveFrequency * f3 / this.p.bh)) * (double)f2);
                blob.translate(f8, f7, f6);
                f8 = (float)((double)this.p.trunkBendX * Math.sin(1.5707963705062866 * Math.sin((double)(5.371f * this.p.trunkBendXFrequency) * 1.5 * (double)f3 / (double)this.p.bh)));
                f7 = f3;
                f6 = (float)((double)this.p.trunkBendZ * Math.sin(1.5707963705062866 * Math.sin((double)(5.937f * this.p.trunkBendZFrequency) * 1.5 * (double)f3 / (double)this.p.bh)));
                blob.translate(f8, f7, f6);
                f8 = (float)((double)this.p.trunkSpiral * Math.sin(f3 / (this.p.bh * 3.0f / 5.0f)));
                blob.rotateY(f8);
                this.trunk.add(blob);
                f3 += this.p.bh / this.p.trunkStrength / 1000.0f;
            }
        }
        this.trunk.trimToSize();
        return this.trunk;
    }
}

