/*
 * Decompiled with CFR 0.152.
 */
package povtree.povTreeGenerator;

import povtree.interfaces.Constants;
import povtree.objects3D.Blob;
import povtree.objects3D.BlobArray;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.TripleBlobArray;
import povtree.povTreeGenerator.Parameters;

public class TwigGenerator
implements Constants {
    private Parameters p;
    private TripleBlobArray twigs;
    private DoubleBlobArray v1;

    public TwigGenerator(Parameters parameters) {
        this.p = parameters;
    }

    public void checkThreadStatus() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public TripleBlobArray generate() throws InterruptedException {
        if (this.p.branches == 0.0f || this.p.twigs == 0.0f || this.p.twigStrength <= 0.0f) {
            return null;
        }
        if (this.p.twigStrength > 0.0f && this.p.branches >= 1.0f && this.p.twigs >= 1.0f) {
            float f;
            float f2;
            this.twigs = new TripleBlobArray(100);
            BlobArray blobArray = null;
            float f3 = 1.0f;
            if (this.p.bunches / this.p.twigs > 1.0f) {
                f2 = (this.p.bunches / this.p.twigs - 1.0f) / (this.p.bunches / this.p.twigs) * this.p.bunchAreaAtTwig;
                f = this.p.bunchAreaAtTwig / (this.p.bunches / this.p.twigs) * this.p.twigTip;
            } else {
                f2 = this.p.bunchAreaAtTwig;
                f = 0.0f;
            }
            while (f3 < 100.0f) {
                this.checkThreadStatus();
                float f4 = 1.0f;
                this.v1 = new DoubleBlobArray(50);
                while (f4 < this.p.bh) {
                    float f5 = 1.0f;
                    blobArray = new BlobArray(100);
                    while (f5 <= (this.p.firstBunchAtTwig + f2 + f + this.p.twigTip * (this.p.bunchMajorRadius + this.p.bunchMinorRadius) * (1.0f - this.p.bunchTaperOffAtTwig)) / this.p.zwl * this.p.bh) {
                        Blob blob = new Blob(this.p.trunkRadius * 5.0f, this.p.trunkRadius * 10.0f);
                        float f6 = this.p.trunkRadius / 90.0f;
                        blob.scale(f6);
                        f6 = (this.p.firstBunchAtTwig + this.p.bunchAreaAtTwig + (this.p.bunchMajorRadius + this.p.bunchMinorRadius) * (1.0f - this.p.bunchTaperOffAtTwig) - f5 * this.p.twigTaper * this.p.zwl / this.p.bh) / (this.p.firstBunchAtTwig + this.p.bunchAreaAtTwig + (this.p.bunchMajorRadius + this.p.bunchMinorRadius) * (1.0f - this.p.bunchTaperOffAtTwig));
                        blob.scale(f6);
                        f6 = (this.p.bh - this.p.branchAreaAtTrunk * (f3 / 100.0f) * this.p.trunkTaper) / this.p.bh;
                        blob.scale(f6);
                        f6 = (this.p.bh - this.p.firstBranchAtTrunk * this.p.trunkTaper) / this.p.bh;
                        blob.scale(f6);
                        f6 = this.p.bh / this.p.astl;
                        blob.scale(f6);
                        f6 = this.p.astl / this.p.zwl;
                        blob.scale(f6);
                        f6 = this.p.twigThicknessChange * this.p.branchThicknessChange;
                        blob.scale(f6);
                        float f7 = (this.p.bh - f5) / this.p.bh * this.p.twigCurveAdjustment * (1.0f - f3 / 100.0f * this.p.straightenTowardsTop) * (1.0f - f4 / this.p.bh * this.p.straightenTowardsBranchEnd);
                        f6 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchSnagFrequency * this.p.zbfza * f5 / this.p.bh)) * (double)f7);
                        float f8 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchSnagFrequency * this.p.zbfza * f5 / this.p.bh)) * (double)f7);
                        float f9 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchSnagFrequency * this.p.zbfza * f5 / this.p.bh)) * (double)f7);
                        blob.translate(f6, f8, f9);
                        f6 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchCurveFrequency * this.p.zbfza * f5 / this.p.bh)) * (double)f7);
                        f8 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchCurveFrequency * this.p.zbfza * f5 / this.p.bh)) * (double)f7);
                        f9 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchCurveFrequency * this.p.zbfza * f5 / this.p.bh)) * (double)f7);
                        blob.translate(f6, f8, f9);
                        f6 = (float)((double)this.p.abg * Math.sin((double)(f7 * (float)Math.PI / 2.0f) * Math.sin(5.371f * this.p.abfz * this.p.zbfza * f5 / this.p.bh) + (double)((1.0f - this.p.extraNoiseSwitch) * 5.371f * this.p.abfz * this.p.zbfza * f5 / this.p.bh)) * (double)this.p.twigCurveAdjustment * (double)(1.0f - f3 / 100.0f * this.p.straightenTowardsTop) * (double)(1.0f - f4 / this.p.bh * this.p.straightenTowardsBranchEnd));
                        f8 = f5;
                        f9 = (float)((double)this.p.abg * Math.sin(1.5707963705062866 * Math.sin(5.937f * this.p.abfz * this.p.zbfza * f5 / this.p.bh)) * (double)this.p.horizontalBranchBendSwitch * (double)this.p.twigCurveAdjustment * (double)(1.0f - f3 / 100.0f * this.p.straightenTowardsTop) * (double)(1.0f - f4 / this.p.bh * this.p.straightenTowardsBranchEnd));
                        blob.translate(f6, f8, f9);
                        f6 = (float)((double)this.p.branchSpiral * Math.sin(f5 / this.p.bh * 1.5707964f));
                        blob.rotateY(f6);
                        f6 = (this.p.firstTwigAtBranch + this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper) - this.p.firstTwigAtBranch * this.p.branchTaper * this.p.astl / this.p.bh) / (this.p.firstTwigAtBranch + this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper));
                        blob.scale(f6);
                        f6 = (float)(((double)this.p.twigAreaAtBranch + (double)this.p.zwl * (1.0 - (double)this.p.branchTaper) - (double)(f4 * this.p.branchTaper * this.p.twigAreaAtBranch / this.p.bh)) / (double)(this.p.twigAreaAtBranch + this.p.zwl * (1.0f - this.p.branchTaper)));
                        blob.scale(f6);
                        f6 = (float)(1234.0 * Math.sin(4.77f * f4 * (float)Math.PI) * (double)this.p.twigTurnSwitch);
                        blob.rotateY(f6);
                        f6 = -90.0f;
                        blob.rotateZ(f6);
                        f6 = this.p.zwl / this.p.bh;
                        blob.scale(f6);
                        f6 = this.p.bh / this.p.astl;
                        blob.scale(f6);
                        f6 = (float)((double)this.p.verticalTwigAngleScope * Math.sin(9.77f * f4 * f4 * (float)Math.PI) + (double)this.p.verticalTwigAngle - (double)(this.p.verticalTwigAngle * (f4 * f4) / (this.p.bh * this.p.bh) * this.p.verticalTwigAlignment));
                        blob.rotateZ(f6);
                        f6 = (float)((double)this.p.horizontalTwigAngleScope * Math.sin(7.77f * f4 * f4 * (float)Math.PI) + (double)(this.p.horizontalTwigAngle - this.p.horizontalTwigAngle * (f4 * f4) / (this.p.bh * this.p.bh) * this.p.horizontalTwigAlignment) * ((double)(1.0f - this.p.twigAlternateSwitch) + (double)this.p.twigAlternateSwitch * Math.sin((f4 / (this.p.bh / this.p.twigs * this.p.branches) - 1.0f / (this.p.bh / this.p.twigs * this.p.branches)) * (float)Math.PI - 1.5707964f)));
                        blob.rotateY(f6);
                        f6 = (float)(1456.0 * Math.cos(this.p.branchRandom * 7.19f * f4 * (float)Math.PI) * (double)(1.0f - this.p.twigAlternateSwitch));
                        blob.rotateX(f6);
                        f6 = 90.0f;
                        blob.rotateZ(f6);
                        f6 = (float)(1234.0 * Math.sin(this.p.twigRandom * 4.77f * f3 * (float)Math.PI) * (double)(1.0f - this.p.twigAlternateSwitch));
                        blob.rotateY(f6);
                        f6 = (float)(-1234.0 * Math.sin(4.77f * f3 * (float)Math.PI) * (double)this.p.branchTurnSwitch);
                        blob.rotateY(f6);
                        f7 = (this.p.bh - (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh)) / this.p.bh * (1.0f - f3 / 100.0f * this.p.straightenTowardsTop);
                        f6 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchSnagFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)this.p.branchTurnSwitch);
                        f8 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchSnagFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)this.p.branchTurnSwitch);
                        f9 = (float)((double)this.p.akk * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchSnagFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)this.p.branchTurnSwitch);
                        blob.translate(f6, f8, f9);
                        f6 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.branchCurveFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)this.p.branchTurnSwitch);
                        f8 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.branchCurveFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)this.p.branchLongitudinalCurve * (double)this.p.branchTurnSwitch);
                        f9 = (float)((double)this.p.aw * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.branchCurveFrequency * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh)) * (double)this.p.horizontalBranchCurveSwitch * (double)this.p.branchTurnSwitch);
                        blob.translate(f6, f8, f9);
                        f6 = (float)((double)this.p.abg * Math.sin((double)(this.p.extraNoiseSwitch * (float)Math.PI / 2.0f) * Math.sin(5.371f * this.p.abfz * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh) + (double)((1.0f - this.p.extraNoiseSwitch) * (5.371f * this.p.abfz * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh))) * -1.0 * (double)(1.0f - f3 / 100.0f * this.p.straightenTowardsTop));
                        f8 = this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh;
                        f9 = (float)((double)this.p.abg * Math.sin((double)(this.p.extraNoiseSwitch * (float)Math.PI / 2.0f) * Math.sin(5.937f * this.p.abfz * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh) + (double)((1.0f - this.p.extraNoiseSwitch) * (5.937f * this.p.abfz * (this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh))) * (double)this.p.horizontalBranchBendSwitch * (double)(1.0f - f3 / 100.0f * this.p.straightenTowardsTop));
                        blob.translate(f6, f8, f9);
                        f6 = (float)((double)this.p.branchSpiral * Math.sin((this.p.firstTwigAtBranch / this.p.astl * this.p.bh + f4 * (this.p.twigAreaAtBranch / this.p.astl * this.p.bh) / this.p.bh) / this.p.bh * 1.5707964f));
                        blob.rotateY(f6);
                        f6 = (float)(1234.0 * Math.sin(4.77f * f3 * (float)Math.PI) * (double)this.p.branchTurnSwitch);
                        blob.rotateY(f6);
                        f6 = -90.0f;
                        blob.rotateZ(f6);
                        f6 = this.p.astl / this.p.bh * (1.0f - f3 / 100.0f * this.p.branchReduction);
                        blob.scale(f6);
                        f6 = (float)((double)(this.p.branchAngle + f3 / 100.0f * (90.0f - this.p.branchAngle) * this.p.branchAlignment) + (double)this.p.branchAngleScope * Math.sin(9.77f * f3 * f3 * (float)Math.PI));
                        blob.rotateZ(f6);
                        f6 = (float)(1456.0 * Math.cos(this.p.branchRandom * 7.19f * f3 * (float)Math.PI) * (double)(1.0f - this.p.branchAlternateSwitch) + (double)(90.0f * this.p.branchAlternateSwitch) * Math.sin((f3 / (100.0f / this.p.branches) - 1.0f / (100.0f / this.p.branches)) * (float)Math.PI - 1.5707964f) + 90.0);
                        blob.rotateY(f6);
                        f7 = (this.p.bh - (this.p.firstBranchAtTrunk + f3 * this.p.branchAreaAtTrunk / 100.0f)) / this.p.bh;
                        f6 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.trunkSnagFrequency * (this.p.firstBranchAtTrunk + f3 * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f8 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.trunkSnagFrequency * (this.p.firstBranchAtTrunk + f3 * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f9 = (float)((double)this.p.trunkSnag * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.trunkSnagFrequency * (this.p.firstBranchAtTrunk + f3 * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        blob.translate(f6, f8, f9);
                        f6 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.456f * this.p.trunkCurveFrequency * (this.p.firstBranchAtTrunk + f3 * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f8 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(5.123f * this.p.trunkCurveFrequency * (this.p.firstBranchAtTrunk + f3 * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        f9 = (float)((double)this.p.trunkCurve * Math.sin(1.5707963705062866 * Math.sin(4.789f * this.p.trunkCurveFrequency * (this.p.firstBranchAtTrunk + f3 * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)) * (double)f7);
                        blob.translate(f6, f8, f9);
                        f6 = (float)((double)this.p.trunkBendX * Math.sin(1.5707963705062866 * Math.sin(5.371f * this.p.trunkBendXFrequency * 1.5f * (this.p.firstBranchAtTrunk + f3 * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)));
                        f8 = this.p.firstBranchAtTrunk + f3 * this.p.branchAreaAtTrunk / 100.0f;
                        f9 = (float)((double)this.p.trunkBendZ * Math.sin(1.5707963705062866 * Math.sin(5.937f * this.p.trunkBendZFrequency * 1.5f * (this.p.firstBranchAtTrunk + f3 * this.p.branchAreaAtTrunk / 100.0f) / this.p.bh)));
                        blob.translate(f6, f8, f9);
                        f6 = (float)((double)this.p.trunkSpiral * Math.sin((this.p.firstBranchAtTrunk + f3 * this.p.branchAreaAtTrunk / 100.0f) / (this.p.bh * 3.0f / 5.0f)));
                        blob.rotateY(f6);
                        blobArray.add(blob);
                        f5 += this.p.bh / 200.0f / this.p.twigStrength;
                    }
                    f4 += this.p.bh / this.p.twigs * this.p.branches;
                    blobArray.trimToSize();
                    this.v1.add(blobArray);
                }
                f3 += 100.0f / this.p.branches;
                this.v1.trimToSize();
                this.twigs.add(this.v1);
            }
        }
        this.twigs.trimToSize();
        return this.twigs;
    }
}

