//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Persistence of Vision 3.1 Include File   XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// File: TOMTREE.inc                        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Version: 1.5                             XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Desc: BAUMGENERATOR FR POVRAY           XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Date: MARCH 2000                         XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Auth: TOM AUST                           XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Modified by GENA OBUKHOV                 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Date: MAY 2004                           XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

#declare BUNCH_MAJOR_RADIUS=BUNCH_MAJOR_RADIUS+0.000001;
#declare BUNCH_MINOR_RADIUS=BUNCH_MINOR_RADIUS+0.000001;
#if (TWIGS>0)
	#if (BUNCHES/TWIGS>1)
		#declare BUNCH_AREA_AT_TWIG=BUNCH_AREA_AT_TWIG*((BUNCHES/TWIGS)/((BUNCHES/TWIGS)-1))+0.000001;
		#declare HORIZONTAL_BUNCH_ALIGNMENT=HORIZONTAL_BUNCH_ALIGNMENT*((BUNCHES/TWIGS)/((BUNCHES/TWIGS)-1));
		#declare VERTICAL_BUNCH_ALIGNMENT=VERTICAL_BUNCH_ALIGNMENT*((BUNCHES/TWIGS)/((BUNCHES/TWIGS)-1));
	
	#else                                                              
	
		#declare BUNCH_AREA_AT_TWIG=BUNCH_AREA_AT_TWIG+0.000001;
	#end
#else
	#declare BUNCH_AREA_AT_TWIG=BUNCH_AREA_AT_TWIG+0.000001;
#end
#declare HORIZONTAL_BUNCH_ALIGNMENT=HORIZONTAL_BUNCH_ALIGNMENT*HORIZONTAL_BUNCH_ALIGNMENT;
#declare VERTICAL_BUNCH_ALIGNMENT=VERTICAL_BUNCH_ALIGNMENT*VERTICAL_BUNCH_ALIGNMENT;
#declare ZL=FIRST_BUNCH_AT_TWIG+BUNCH_AREA_AT_TWIG+1.1;
#declare FIRST_BUNCH_AT_TWIG=FIRST_BUNCH_AT_TWIG+0.000001;
#declare FIRST_TWIG_AT_BRANCH=FIRST_TWIG_AT_BRANCH+0.000001;
#if (BRANCHES>0) 
#if (TWIGS/BRANCHES>1) 
	#declare TWIG_AREA_AT_BRANCH=TWIG_AREA_AT_BRANCH*((TWIGS/BRANCHES)/((TWIGS/BRANCHES)-1))+0.000001;
	#declare HORIZONTAL_TWIG_ALIGNMENT=HORIZONTAL_TWIG_ALIGNMENT*((TWIGS/BRANCHES)/((TWIGS/BRANCHES)-1));
	#declare VERTICAL_TWIG_ALIGNMENT=VERTICAL_TWIG_ALIGNMENT*((TWIGS/BRANCHES)/((TWIGS/BRANCHES)-1)); 
#else
	#declare TWIG_AREA_AT_BRANCH=TWIG_AREA_AT_BRANCH+0.000001;
#end 
#else
	#declare TWIG_AREA_AT_BRANCH=TWIG_AREA_AT_BRANCH+0.000001;
#end
#declare HORIZONTAL_TWIG_ALIGNMENT=HORIZONTAL_TWIG_ALIGNMENT*HORIZONTAL_TWIG_ALIGNMENT;
#declare VERTICAL_TWIG_ALIGNMENT=VERTICAL_TWIG_ALIGNMENT*VERTICAL_TWIG_ALIGNMENT;
#if (BRANCHES>1)
	#declare BRANCH_AREA_AT_TRUNK=BRANCH_AREA_AT_TRUNK*(BRANCHES/(BRANCHES-1))+0.000001; 
#else
	#declare BRANCH_AREA_AT_TRUNK=BRANCH_AREA_AT_TRUNK+0.000001; 
#end
#declare ZW_L=ZL+BUNCH_MAJOR_RADIUS+BUNCH_MINOR_RADIUS;
#declare AST_L=(FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L); 
#declare BH=(FIRST_BRANCH_AT_TRUNK+BRANCH_AREA_AT_TRUNK+AST_L);
#declare AW=BRANCH_CURVE*BH/AST_L;
#declare A_KK=BRANCH_SNAG*BH/AST_L; 
#declare A_BG=BRANCH_BEND*BH/AST_L;
#declare ABFZ=BRANCH_BEND_FREQUENCY*.7*(AST_L/(FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER)));
#declare ZBFZA=TWIG_CURVE_FREQUENCY_ADJUSTMENT*(ZW_L/(ZL+(BUNCH_MAJOR_RADIUS+BUNCH_MINOR_RADIUS)*(1-BUNCH_TAPER_OFF_AT_TWIG)))/(AST_L/(FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER)));
#declare RFZA=RAMI_CURVE_FREQUENCY_ADJUSTMENT/(ZW_L/(ZL+(BUNCH_MAJOR_RADIUS+BUNCH_MINOR_RADIUS)*(1-BUNCH_TAPER_OFF_AT_TWIG)));
#declare BRANCH_SNAG_FREQUENCY=BRANCH_SNAG_FREQUENCY*1.75;
#declare BRANCH_CURVE_FREQUENCY=BRANCH_CURVE_FREQUENCY*1.6;
#if (BRANCHES>1)
	#declare BRANCH_ALIGNMENT=BRANCH_ALIGNMENT*(BRANCHES/(BRANCHES-1)); 
#end 
#declare UNIT_1=FIRST_BRANCH_AT_TRUNK+BRANCH_AREA_AT_TRUNK+(1-BRANCH_REDUCTION)*(FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+(1-BRANCH_TAPER)*(FIRST_BUNCH_AT_TWIG+BUNCH_AREA_AT_TWIG+(BUNCH_MAJOR_RADIUS+BUNCH_MINOR_RADIUS+LEAF_LENGTH)*(1-BUNCH_TAPER_OFF_AT_TREE)*(1-BUNCH_TAPER_OFF_AT_BRANCH)*(1-BUNCH_TAPER_OFF_AT_TWIG)));

#declare RINDE = texture {
	pigment {
		granite
		cubic_wave
		color_map {  
			[0 color rgb SUNKEN_TRUNK_COLOR]
			[0.35 color rgb RAISED_TRUNK_COLOR]
			[.5 color rgb RAISED_TRUNK_COLOR*2]
			[0.65 color rgb RAISED_TRUNK_COLOR]
			[1 color rgb SUNKEN_TRUNK_COLOR]
		}
		scale <TRUNK_SCAR_WIDTH, TRUNK_SCAR_HEIGHT, TRUNK_SCAR_WIDTH> * 3 
	} 
	#if (SCAR_DEPTH>0)
		normal {
			granite SCAR_DEPTH / 5
			scale <TRUNK_SCAR_WIDTH, TRUNK_SCAR_HEIGHT, TRUNK_SCAR_WIDTH> * 3
		}
	#end
	finish {
		phong SCAR_DEPTH / 5 phong_size 4 
	}         
}          

#declare RINDE1 = texture {
	pigment {
		granite
		cubic_wave
		color_map {  
			[0 color rgb SUNKEN_TRUNK_COLOR]
			[0.35 color rgbft (BOTTOM_COLOR_1 + BOTTOM_COLOR_2 + TOP_COLOR_1 + TOP_COLOR_2) / 4]
			[.5 color rgbft (BOTTOM_COLOR_1 + BOTTOM_COLOR_2 + TOP_COLOR_1 + TOP_COLOR_2) / 2]
			[0.65 color rgbft (BOTTOM_COLOR_1 + BOTTOM_COLOR_2 + TOP_COLOR_1 + TOP_COLOR_2) / 4]
			[1 color rgb SUNKEN_TRUNK_COLOR]
		}
		scale <TRUNK_SCAR_WIDTH, TRUNK_SCAR_HEIGHT, TRUNK_SCAR_WIDTH> * 3
	} 
	#if (SCAR_DEPTH > 0)
		normal {
			granite SCAR_DEPTH / 5
			scale <TRUNK_SCAR_WIDTH, TRUNK_SCAR_HEIGHT, TRUNK_SCAR_WIDTH> * 3
		}
	#end
	finish {
		phong SCAR_DEPTH / 5 phong_size 4 
	} 
} 

#declare BOZO1 = pigment {
	bozo
	color_map {
		[0 color rgbft BOTTOM_COLOR_1]
		[1 color rgbft BOTTOM_COLOR_2]
	}
	scale BH / (250 * (COLOR_TURB + .1) * BH)		
}   

#declare BOZO2 = pigment {
	bozo
	color_map {
		[0 color rgbft TOP_COLOR_1]
		[1 color rgbft TOP_COLOR_2]
	}
	scale BH / (250 * (COLOR_TURB + .1) * BH)	
}

#declare LAUB = texture {
	pigment { 	
		gradient y 
		cubic_wave 
		turbulence TRANSITION_TURB
		omega TRANSITION_TURB
		pigment_map {
			[TRANSITION_BOTTOM_TOP BOZO1]
			[1 BOZO2]
		}
		scale UNIT_1		
	}
	finish { 
		phong 0.4 * FOLIAGE_GLOSS
		phong_size 20 * FOLIAGE_GLOSS
	}      
}

#declare BARK_TEXTURE = texture {
	pigment {
		gradient x
		color_map {
			[0.0 0.3 color rgb SUNKEN_TRUNK_COLOR*2 color rgb RAISED_TRUNK_COLOR*2]
			[0.3 1.0 color rgb RAISED_TRUNK_COLOR*2 color rgb SUNKEN_TRUNK_COLOR*2]
		}
	}
	translate -x*0.5
	scale TRUNK_RADIUS*5
}

// prepare ramification   
   
#if (BRANCHES >= 1 & TWIGS >= 1 & BUNCHES >= 1 & TWIG_RAMIFICATION_ORDER > 0 & TWIG_RAMIFICATION_STRENGTH > 0)
	#declare TWIGGI = blob {
		threshold TRUNK_RADIUS*3
		#declare A=1;
		#while (A<BH) 
			#local TRANS = transform { 
				scale TRUNK_RADIUS / 90	
				scale (BH-A)/BH		
				scale BRANCH_THICKNESS_CHANGE   
				scale BH/(BUNCH_MAJOR_RADIUS+BUNCH_MINOR_RADIUS+LEAF_LENGTH) 
				scale TWIG_THICKNESS_CHANGE	
				scale TWIG_RAMIFICATION_THICKNESS_CHANGE 
				scale (BH-FIRST_BRANCH_AT_TRUNK*TRUNK_TAPER)/BH	
				scale (ZW_L-FIRST_BUNCH_AT_TWIG)/ZW_L   
				scale (AST_L-FIRST_TWIG_AT_BRANCH)/AST_L  
				#if (BUNCH_TAPER_OFF_AT_BRANCH<0) 
					scale 1/(1-BUNCH_TAPER_OFF_AT_BRANCH*(FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH)/AST_L) 
				#end 
				#if (BUNCH_TAPER_OFF_AT_TREE<0) 
					scale 1/(1-BUNCH_TAPER_OFF_AT_TREE*(FIRST_BRANCH_AT_TRUNK+BRANCH_AREA_AT_TRUNK)/BH)  
				#end
	 			#if (BUNCH_TAPER_OFF_AT_TWIG<1) 
					scale 1/(1-(BUNCH_TAPER_OFF_AT_TWIG-1)*(FIRST_BUNCH_AT_TWIG+BUNCH_AREA_AT_TWIG)/ZW_L)  
				#end 
	 			scale 1/BUNCH_DEFORM    
				scale 1/(1+BUNCH_ARC_AT_TWIG)   
				scale 1/(1+BUNCH_ARC_AT_BRANCH)    
				translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*A/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*A/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*A/BH))>*((BH-A)/BH)*TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT
				translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*A/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*A/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*A/BH))>*((BH-A)/BH)*TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT
	  			translate <A_BG*sin(pi/2*sin(5.371*ABFZ*ZBFZA*RFZA*A/BH)),A,A_BG*sin(pi/2*sin(5.937*ABFZ*ZBFZA*RFZA*A/BH))>*<TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT,1,TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT>
	  			rotate <0,BRANCH_SPIRAL*sin(A/BH*(pi/2)),0>
			}
			sphere {
				<0,0,0>, TRUNK_RADIUS * 5, TRUNK_RADIUS * 10 
				transform{TRANS}
			}			
  			#declare A=A+BH/TWIG_RAMIFICATION_STRENGTH/200;
		#end
	}
#end

#if (BRANCHES >= 1 & TWIGS >= 1 & BUNCHES >= 1 & TWIG_RAMIFICATION_ORDER = 1 & TWIG_RAMIFICATION_STRENGTH > 0)
	#declare REISIG = object {
		TWIGGI 
		bounded_by{cylinder{<0, 0, 0>, <0, BH, 0>, BH}}
	}                              
#end   
   
#if (BRANCHES >= 1 & TWIGS >= 1 & BUNCHES >= 1 & TWIG_RAMIFICATION_ORDER = 2 & TWIG_RAMIFICATION_STRENGTH > 0 & LAST_RAMIFICATION_NUMBER > 0)
	#declare REISIG = union {
		object{TWIGGI}
		#declare A = BH / (LAST_RAMIFICATION_NUMBER + 1);
		#while (A < BH) 
			#local TRANS = transform {  
				scale 1-A/BH
				rotate <0,1234.567*sin(A*4.56*pi),0>  
				#if (ROTATION_BUNCH_FUNNEL>0)
					rotate <0,0,-(ROTATION_BUNCH_FUNNEL/2)*(1-(A*A)/(BH*BH))>*(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))/(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))-1))
					rotate <0,777*sin(2.37*A*pi),0>
				#else
					rotate <0,0,VERTICAL_BUNCH_FUNNEL/2*(1-(A*A)/(BH*BH))*(sin(A*pi/2) #if (sin(A*pi/2)<0) -(1+sin(A*pi/2)) #else +(1-sin(A*pi/2)) #end)>*(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))/(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))-1))
					rotate <HORIZONTAL_BUNCH_FUNNEL/2*(1-(A*A)/(BH*BH))*(sin(A*pi) #if (sin(A*pi)<0) -(1+sin(A*pi)) #else +(1-sin(A*pi)) #end),0,0>*(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))/(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))-1))			
				#end		
				translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*A/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*A/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*A/BH))>*((BH-A)/BH)*TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT
				translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*A/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*A/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*A/BH))>*((BH-A)/BH)*TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT
	  			translate <A_BG*sin(pi/2*sin(5.371*ABFZ*ZBFZA*RFZA*A/BH)),A,A_BG*sin(pi/2*sin(5.937*ABFZ*ZBFZA*RFZA*A/BH))>*<TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT,1,TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT>
	  			rotate <0,BRANCH_SPIRAL*sin(A/BH*(pi/2)),0>
			}
			object {
				TWIGGI
				transform{TRANS}
			}    
			#declare A=A+BH/(LAST_RAMIFICATION_NUMBER+1);
		#end	
		bounded_by{cylinder{<0,0,0>,<0,BH,0>,BH}}
	}
#end  
  
#if (BRANCHES >= 1 & TWIGS >= 1 & BUNCHES >= 1 & TWIG_RAMIFICATION_ORDER = 3 & TWIG_RAMIFICATION_STRENGTH > 0 & LAST_RAMIFICATION_NUMBER > 0)
	#declare REISIG = union {  
		object{TWIGGI}		
		#declare B=BH/(LAST_RAMIFICATION_NUMBER+1);
		#while (B<BH)	
  			union {
				object{TWIGGI}		
				#declare A=BH/(LAST_RAMIFICATION_NUMBER+1);
				#while (A<BH)
					#local TRANS = transform{
						scale 1-A/BH
						rotate <0,1234.567*sin(A*4.56*pi),0>			
						#if (ROTATION_BUNCH_FUNNEL>0)
							rotate <0,0,-ROTATION_BUNCH_FUNNEL/2*(1-(A)/(BH))>*((LAST_RAMIFICATION_NUMBER+1)/LAST_RAMIFICATION_NUMBER)
							rotate <0,777*sin(2.37*A*pi),0>
						#else
							rotate <0,0,VERTICAL_BUNCH_FUNNEL/2*(1-(A)/(BH))*(sin(A*pi/2) #if (sin(A*pi/2)<0) -(1+sin(A*pi/2)) #else +(1-sin(A*pi/2)) #end)>*((LAST_RAMIFICATION_NUMBER+1)/LAST_RAMIFICATION_NUMBER)
							rotate <HORIZONTAL_BUNCH_FUNNEL/2*(1-(A)/(BH))*(sin(A*pi) #if (sin(A*pi)<0) -(1+sin(A*pi)) #else +(1-sin(A*pi)) #end),0,0>*((LAST_RAMIFICATION_NUMBER+1)/LAST_RAMIFICATION_NUMBER)
						#end
						rotate <0,-1234.567*sin(B*4.56*pi)+180,0>			
						translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*A/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*A/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*A/BH))>*((BH-A)/BH)*TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT
						translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*A/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*A/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*A/BH))>*((BH-A)/BH)*TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT
		  				translate <A_BG*sin(pi/2*sin(5.371*ABFZ*ZBFZA*RFZA*A/BH)),A,A_BG*sin(pi/2*sin(5.937*ABFZ*ZBFZA*RFZA*A/BH))>*<TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT,1,TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT>
		  				rotate <0,BRANCH_SPIRAL*sin(A/BH*(pi/2)),0>
					}
					object {
						TWIGGI
						transform{TRANS}
					}    
					#declare A=A+BH/(LAST_RAMIFICATION_NUMBER+1);
				#end
				scale 1-B/BH
				rotate <0,1234.567*sin(B*4.56*pi),0>
				#if (ROTATION_BUNCH_FUNNEL>0)
					rotate <0,0,-ROTATION_BUNCH_FUNNEL/2*(1-(B*B)/(BH*BH))>*(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))/(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))-1))
					rotate <0,777*sin(2.37*B*pi),0> 
				#else
					rotate <0,0,VERTICAL_BUNCH_FUNNEL/2*(1-(B*B)/(BH*BH))*(sin(B*pi/2) #if (sin(B*pi/2)<0) -(1+sin(B*pi/2)) #else +(1-sin(B*pi/2)) #end)>*(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))/(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))-1))
					rotate <HORIZONTAL_BUNCH_FUNNEL/2*(1-(B*B)/(BH*BH))*(sin(B*pi) #if (sin(B*pi)<0) -(1+sin(B*pi)) #else +(1-sin(B*pi)) #end),0,0>*(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))/(((LAST_RAMIFICATION_NUMBER+1)*(LAST_RAMIFICATION_NUMBER+1))-1))		
				#end		
				translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*B/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*B/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*ZBFZA*RFZA*B/BH))>*((BH-B)/BH)*TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT
				translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*B/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*B/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*ZBFZA*RFZA*B/BH))>*((BH-B)/BH)*TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT
	  			translate <A_BG*sin(pi/2*sin(5.371*ABFZ*ZBFZA*RFZA*B/BH)),B,A_BG*sin(pi/2*sin(5.937*ABFZ*ZBFZA*RFZA*B/BH))>*<TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT,1,TWIG_CURVE_ADJUSTMENT*TWIG_RAMIFICATION_CURVE_ADJUSTMENT>
	  			rotate <0,BRANCH_SPIRAL*sin(B/BH*(pi/2)),0> 
  			}
  			#declare B=B+BH/(LAST_RAMIFICATION_NUMBER+1);
		#end      	     		
		bounded_by{sphere{<0,0,0>,BH}}  
	}
#end
  

#declare TREE = union {  	 

	// make leaves
               
	#if (LEAF_LENGTH*LEAF_HEIGHT*LEAF_BREADTH > 0 & BRANCHES>=1 & TWIGS>=1 & LEAVES>=1 & BUNCHES>=1)  
		#ifdef (LeafArray)
			#declare arraySize = dimension_size(LeafArray, 1);
			#declare randomNum = seed(10); 
		#end
		#if (LEAVES / BUNCHES > 1)
			#declare STAUDE = union { 
				#declare A=1; 
				#while (A<100)
					#local TRANS = transform{
						scale <LEAF_LENGTH*(sin(A*5.73*pi)+4)/4,LEAF_HEIGHT*(sin(A*3.16*pi)+4)/4,LEAF_BREADTH*(sin(A*7.99*pi)+4)/4>
						rotate <MAX_LEAF_TILT*sin(7.11*A*pi),0,-LEAF_INCLINATION+LEAF_INCLINATION_SCOPE*sin(7.31*A*pi)>
						rotate <0,MAX_LEAF_TURN*sin(7.17*A*pi),0>
						translate <BUNCH_MAJOR_RADIUS+(BUNCH_MINOR_RADIUS*(1+sin(sin(pi*5.92*A)*pi*32.1))/2),0,0>
						#if (ROTATION_BUNCH_FUNNEL>0)
							rotate <0,0,-ROTATION_BUNCH_FUNNEL/4*(1+sin(sin(pi*2.37*A)*pi*12.3+pi/5))>
							rotate <777*sin(2.37*A*pi),0,0>
						#else
							rotate <0,0,VERTICAL_BUNCH_FUNNEL/2*sin(sin(pi*7.73*A)*pi*12.3+pi/3)>
							rotate <0,HORIZONTAL_BUNCH_FUNNEL/2*sin(sin(pi*2.37*A)*pi*12.3+pi/5),0>
						#end
					}
					object {
						#ifdef (LeafArray)
							LeafArray[rand(randomNum) * arraySize]
						#else
							LEAF_TYPE
						#end 
						transform{TRANS}
					}
					#declare A=A+100/LEAVES*BUNCHES;
				#end
			}
		#else         
			#local TRANS = transform{ 
				scale <LEAF_LENGTH,LEAF_HEIGHT,LEAF_BREADTH>
				rotate <MAX_LEAF_TILT,0,-LEAF_INCLINATION>
				rotate <0,MAX_LEAF_TURN,0>
				translate <BUNCH_MAJOR_RADIUS+(BUNCH_MINOR_RADIUS),0,0>
			}
			#declare STAUDE = object {
				#ifdef (LeafArray)
					LeafArray[rand(randomNum) * arraySize]
				#else
					LEAF_TYPE
				#end
				transform{TRANS}
			}
		#end    
	
		union {
			#declare B=1;
			#while (B<100)
				#declare A=1;
				#while (A<BH) 
					#declare C=1;
					#while (C<ZL)
						#local TRANS = transform{ 
							scale BUNCH_DEFORM
							scale (1+BUNCH_ARC_AT_TWIG*sin(pi*(C*((BUNCHES/TWIGS+1)/(BUNCHES/TWIGS))/ZL)))
							scale (1+BUNCH_ARC_AT_BRANCH*sin(pi*(A*((TWIGS/BRANCHES+1)/(TWIGS/BRANCHES))/BH)))
							rotate <-1456*cos(BRANCH_RANDOM*7.19*A*pi)*(1-TWIG_ALTERNATE_SWITCH),0,0>
							rotate <-1234*sin(7.77*C*pi),0,0>*BUNCH_TURN_SHIFT
							rotate <-1234*sin(7.77*A*pi),0,0>*BUNCH_TURN_SHIFT
							rotate <-BRANCH_SPIRAL*sin(((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH*(pi/2)),0,0>
							rotate <-1234*sin(TWIG_RANDOM*4.77*B*pi),0,0>*(1-TWIG_ALTERNATE_SWITCH)
							rotate <-BRANCH_SPIRAL*sin((FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH*(pi/2)),0,0>
							rotate <0,(HORIZONTAL_BUNCH_ANGLE_SCOPE/2)*sin(7.77*C*pi),0>
							rotate <0,0,VERTICAL_BUNCH_ANGLE_SCOPE/2*sin(9.77*C*pi)>+<0,0,(VERTICAL_BUNCH_ANGLE #if (BUNCHES/TWIGS>1) -(VERTICAL_BUNCH_ANGLE*(C*C)/(ZL*ZL)*VERTICAL_BUNCH_ALIGNMENT) #end )>
							rotate <0, #if (BUNCHES/TWIGS=1) (HORIZONTAL_BUNCH_ANGLE-(HORIZONTAL_BUNCH_ANGLE*(A*A)/(BH*BH)*HORIZONTAL_BUNCH_ALIGNMENT))*((1-BUNCH_ALTERNATE_SWITCH)+(BUNCH_ALTERNATE_SWITCH*sin((A/(BH/TWIGS*BRANCHES)-1/(BH/TWIGS*BRANCHES))*pi-pi/2))) #else -(HORIZONTAL_BUNCH_ANGLE*(C*C)/(ZL*ZL)*HORIZONTAL_BUNCH_ALIGNMENT)*((1-BUNCH_ALTERNATE_SWITCH)+BUNCH_ALTERNATE_SWITCH*sin((C/(ZL/(BUNCHES/TWIGS))-1/(ZL/(BUNCHES/TWIGS)))*pi-pi/2)) #end ,0>
							rotate <1234*sin(7.77*C*pi),0,0>*BUNCH_TURN_SWITCH
							rotate <1234*sin(7.77*A*pi),0,0>*BUNCH_TURN_SWITCH
							scale (1-BUNCH_TAPER_OFF_AT_TREE*B/100)
							scale (1-BUNCH_TAPER_OFF_AT_TWIG*(C)/(ZL))
							scale (1-BUNCH_TAPER_OFF_AT_BRANCH*(A)/(BH))
							rotate <0,0,90>
							rotate <0,-1234*sin(4.77*A*pi),0>*TWIG_TURN_SWITCH
							translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH))>*((BH-((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L)))/BH)*(ZW_L/BH)*TWIG_CURVE_ADJUSTMENT*(1-B/100*STRAIGHTEN_TOWARDS_TOP)*(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)
							translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH))>*((BH-((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L)))/BH)*(ZW_L/BH)*TWIG_CURVE_ADJUSTMENT*(1-B/100*STRAIGHTEN_TOWARDS_TOP)*(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)
							translate <A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.371*ABFZ*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)+(1-EXTRA_NOISE_SWITCH)*5.371*ABFZ*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH),((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L)),A_BG*sin(pi/2*sin(5.937*ABFZ*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH))>*(ZW_L/BH)*<1,1,HORIZONTAL_BRANCH_BEND_SWITCH>*<TWIG_CURVE_ADJUSTMENT,1,TWIG_CURVE_ADJUSTMENT>*<1-B/100*STRAIGHTEN_TOWARDS_TOP,1,1-B/100*STRAIGHTEN_TOWARDS_TOP>*<(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END),1,(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)>
							rotate <0,BRANCH_SPIRAL*sin(((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH*(pi/2)),0>
							rotate <0,1234*sin(4.77*A*pi),0>*TWIG_TURN_SWITCH
							scale ((FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))-FIRST_TWIG_AT_BRANCH*BRANCH_TAPER*AST_L/BH)/(FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))				
							scale ((TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))-A*BRANCH_TAPER*TWIG_AREA_AT_BRANCH/BH)/(TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))	
							scale BH/AST_L
							rotate <0,0,-90>
							rotate <0,0,VERTICAL_TWIG_ANGLE_SCOPE*sin(9.77*A*A*pi)>+<0,0,(VERTICAL_TWIG_ANGLE-(VERTICAL_TWIG_ANGLE*(A*A)/(BH*BH)*VERTICAL_TWIG_ALIGNMENT))>
							rotate <0,HORIZONTAL_TWIG_ANGLE_SCOPE*sin(7.77*A*A*pi),0>+<0,(HORIZONTAL_TWIG_ANGLE-(HORIZONTAL_TWIG_ANGLE*(A*A)/(BH*BH)*HORIZONTAL_TWIG_ALIGNMENT)),0>*((1-TWIG_ALTERNATE_SWITCH)+(TWIG_ALTERNATE_SWITCH*sin((A/(BH/TWIGS*BRANCHES)-1/(BH/TWIGS*BRANCHES))*pi-pi/2)))			
							rotate <1456*cos(BRANCH_RANDOM*7.19*A*pi)*(1-TWIG_ALTERNATE_SWITCH),0,0>
							rotate <0,0,90>
							rotate <0,1234*sin(TWIG_RANDOM*4.77*B*pi),0>*(1-TWIG_ALTERNATE_SWITCH)
	      					rotate <0,-1234*sin(4.77*B*pi),0>*BRANCH_TURN_SWITCH
	      					translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*((BH-(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)))/BH)*(1-B/100*STRAIGHTEN_TOWARDS_TOP)
	  						translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*((BH-(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)))/BH)*<1,BRANCH_LONGITUDINAL_CURVE,HORIZONTAL_BRANCH_CURVE_SWITCH>*(1-B/100*STRAIGHTEN_TOWARDS_TOP)
	      					translate <A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.371*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)+(1-EXTRA_NOISE_SWITCH)*(5.371*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)),A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.937*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)+(1-EXTRA_NOISE_SWITCH)*(5.937*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*<-1,1,HORIZONTAL_BRANCH_BEND_SWITCH>*<1-B/100*STRAIGHTEN_TOWARDS_TOP,1,1-B/100*STRAIGHTEN_TOWARDS_TOP>
	      					rotate <0,BRANCH_SPIRAL*sin((FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH*(pi/2)),0>
							rotate <0,1234*sin(4.77*B*pi),0>*BRANCH_TURN_SWITCH
							rotate <0,0,-90>
							scale (AST_L/BH)*(1-B/100*BRANCH_REDUCTION)
							rotate <0,0,BRANCH_ANGLE+((B/100)*((90-BRANCH_ANGLE)))*BRANCH_ALIGNMENT>+<0,0,BRANCH_ANGLE_SCOPE*sin(9.77*B*B*pi)>
							rotate <0,1456*cos(BRANCH_RANDOM*7.19*B*pi)*(1-BRANCH_ALTERNATE_SWITCH)+90*BRANCH_ALTERNATE_SWITCH*sin((B/(100/BRANCHES)-1/(100/BRANCHES))*pi-pi/2)+90,0>
							translate <TRUNK_SNAG*sin(pi/2*sin(5.123*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(4.789*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(5.456*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>*((BH-(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)))/BH)
							translate <TRUNK_CURVE*sin(pi/2*sin(5.456*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(5.123*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(4.789*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>*((BH-(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)))/BH)			
							translate <TRUNK_BEND_X*sin(pi/2*sin(5.371*TRUNK_BEND_X_FREQUENCY*1.5*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)),TRUNK_BEND_Z*sin(pi/2*sin(5.937*TRUNK_BEND_Z_FREQUENCY*1.5*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>
							rotate <0,TRUNK_SPIRAL*sin((FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/(BH*3/5)),0>	
						}
						object {
							STAUDE
							transform{TRANS}
						}
						#declare C=C+ZL/BUNCHES*TWIGS;
					#end
					#declare A=A+BH/TWIGS*BRANCHES;
				#end
				#declare B=B+100/BRANCHES;
			#end
			texture{LAUB}
		}
	#end	
	
	// make blossom
	     
	#if (BLOSSOM_LENGTH * BLOSSOM_WIDTH > 0 & BRANCHES >= 1 & TWIGS >= 1 & BLOSSOMS >= 1 & BUNCHES >= 1)
		#if(BLOSSOMS / BUNCHES > 1)
			#declare B_STAUDE = union { 
				#declare A=1;
				#while (A<100)   
					#local TRANS = transform {
						scale <BLOSSOM_LENGTH*(sin(A*5.73*pi)+4)/4,BLOSSOM_WIDTH*(sin(A*3.16*pi)+4)/4,BLOSSOM_WIDTH*(sin(A*7.99*pi)+4)/4>
						rotate <MAX_LEAF_TILT*sin(7.11*A*pi),0,BLOSSOM_INCLINATION*(1+sin(9.33*A*pi))/2>
						rotate <0,MAX_LEAF_TURN*sin(7.17*A*pi),0>
						translate <BUNCH_MAJOR_RADIUS+(BUNCH_MINOR_RADIUS),0,0>
						#if (ROTATION_BUNCH_FUNNEL>0)
							rotate <0,0,-ROTATION_BUNCH_FUNNEL/4*(1+sin(sin(2.37*A*pi)*pi*12.3+pi/5))>
							rotate <777*sin(2.37*A*pi),0,0>
						#else
							rotate <0,0,VERTICAL_BUNCH_FUNNEL/2*sin(sin(7.73*A*pi)*pi*12.3+pi/3)>
							rotate <0,HORIZONTAL_BUNCH_FUNNEL/2*sin(sin(2.37*A*pi)*pi*12.3+pi/5),0>
						#end
					}
					object {
						BLOSSOM
						transform{TRANS}
						pigment{color rgb BLOSSOM_COLOR}
					}
					#declare A=A+100/BLOSSOMS*BUNCHES;
				#end
			}
		#else
			#local TRANS = transform {
				scale <BLOSSOM_LENGTH,BLOSSOM_WIDTH,BLOSSOM_WIDTH>
				rotate <MAX_LEAF_TILT,0,BLOSSOM_INCLINATION>
				rotate <0,MAX_LEAF_TURN,0>
				translate <BUNCH_MAJOR_RADIUS+(BUNCH_MINOR_RADIUS),0,0>
			}
			#declare B_STAUDE = object {
				BLOSSOM
				transform{TRANS}
				pigment{color rgb BLOSSOM_COLOR}
			}
		#end
	
		union {
			#declare A=1;
			#while (A < BH) 
				#declare B=1;
				#while (B < 100)
					#declare C=1;
					#while (C < ZL)
						#local TRANS = transform {
							scale BUNCH_DEFORM
							scale (1+BUNCH_ARC_AT_TWIG*sin(pi*(C*((BUNCHES/TWIGS+1)/(BUNCHES/TWIGS))/ZL)))
							scale (1+BUNCH_ARC_AT_BRANCH*sin(pi*(A*((TWIGS/BRANCHES+1)/(TWIGS/BRANCHES))/BH)))
							rotate <-1456*cos(BRANCH_RANDOM*7.19*A*pi)*(1-TWIG_ALTERNATE_SWITCH),0,0>
							rotate <-1234*sin(7.77*C*pi),0,0>*BUNCH_TURN_SHIFT
							rotate <-1234*sin(7.77*A*pi),0,0>*BUNCH_TURN_SHIFT
							rotate <-BRANCH_SPIRAL*sin(((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH*(pi/2)),0,0>
							rotate <-1234*sin(TWIG_RANDOM*4.77*B*pi),0,0>*(1-TWIG_ALTERNATE_SWITCH)
							rotate <-BRANCH_SPIRAL*sin((FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH*(pi/2)),0,0>
							rotate <0,HORIZONTAL_BUNCH_ANGLE_SCOPE/2*sin(7.77*C*pi),0>
							rotate <0,0,VERTICAL_BUNCH_ANGLE_SCOPE/2*sin(9.77*C*pi)>+<0,0,(VERTICAL_BUNCH_ANGLE #if (BUNCHES/TWIGS>1) -(VERTICAL_BUNCH_ANGLE*(C*C)/(ZL*ZL)*VERTICAL_BUNCH_ALIGNMENT) #end )>
							rotate <0, #if (BUNCHES/TWIGS=1) (HORIZONTAL_BUNCH_ANGLE-(HORIZONTAL_BUNCH_ANGLE*(A*A)/(BH*BH)*HORIZONTAL_BUNCH_ALIGNMENT))*((1-BUNCH_ALTERNATE_SWITCH)+(BUNCH_ALTERNATE_SWITCH*sin((A/(BH/TWIGS*BRANCHES)-1/(BH/TWIGS*BRANCHES))*pi-pi/2))) #else -(HORIZONTAL_BUNCH_ANGLE*(C*C)/(ZL*ZL)*HORIZONTAL_BUNCH_ALIGNMENT)*((1-BUNCH_ALTERNATE_SWITCH)+BUNCH_ALTERNATE_SWITCH*sin((C/(ZL/(BUNCHES/TWIGS))-1/(ZL/(BUNCHES/TWIGS)))*pi-pi/2)) #end ,0>
							rotate <1234*sin(7.77*C*pi),0,0>*BUNCH_TURN_SWITCH
							rotate <1234*sin(7.77*A*pi),0,0>*BUNCH_TURN_SWITCH
							scale (1-BUNCH_TAPER_OFF_AT_TREE*B/100)
							scale (1-BUNCH_TAPER_OFF_AT_TWIG*(C)/(ZL))
							scale (1-BUNCH_TAPER_OFF_AT_BRANCH*(A)/(BH))
							rotate <0,0,90>
							rotate <0,-1234*sin(4.77*A*pi),0>*TWIG_TURN_SWITCH
							translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH))>*((BH-((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L)))/BH)*(ZW_L/BH)*TWIG_CURVE_ADJUSTMENT*(1-B/100*STRAIGHTEN_TOWARDS_TOP)*(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)
							translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH))>*((BH-((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L)))/BH)*(ZW_L/BH)*TWIG_CURVE_ADJUSTMENT*(1-B/100*STRAIGHTEN_TOWARDS_TOP)*(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)
							translate <A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.371*ABFZ*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)+(1-EXTRA_NOISE_SWITCH)*5.371*ABFZ*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH),((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L)),A_BG*sin(pi/2*sin(5.937*ABFZ*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH))>*(ZW_L/BH)*<1,1,HORIZONTAL_BRANCH_BEND_SWITCH>*<TWIG_CURVE_ADJUSTMENT,1,TWIG_CURVE_ADJUSTMENT>*<1-B/100*STRAIGHTEN_TOWARDS_TOP,1,1-B/100*STRAIGHTEN_TOWARDS_TOP>*<(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END),1,(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)>
							rotate <0,BRANCH_SPIRAL*sin(((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH*(pi/2)),0>
							rotate <0,1234*sin(4.77*A*pi),0>*TWIG_TURN_SWITCH
							scale ((FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))-FIRST_TWIG_AT_BRANCH*BRANCH_TAPER*AST_L/BH)/(FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))				
							scale ((TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))-A*BRANCH_TAPER*TWIG_AREA_AT_BRANCH/BH)/(TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))	
        					scale BH/AST_L
							rotate <0,0,-90>
							rotate <0,0,VERTICAL_TWIG_ANGLE_SCOPE*sin(9.77*A*A*pi)>+<0,0,(VERTICAL_TWIG_ANGLE-(VERTICAL_TWIG_ANGLE*(A*A)/(BH*BH)*VERTICAL_TWIG_ALIGNMENT))>
							rotate <0,HORIZONTAL_TWIG_ANGLE_SCOPE*sin(7.77*A*A*pi),0>+<0,(HORIZONTAL_TWIG_ANGLE-(HORIZONTAL_TWIG_ANGLE*(A*A)/(BH*BH)*HORIZONTAL_TWIG_ALIGNMENT)),0>*((1-TWIG_ALTERNATE_SWITCH)+(TWIG_ALTERNATE_SWITCH*sin((A/(BH/TWIGS*BRANCHES)-1/(BH/TWIGS*BRANCHES))*pi-pi/2)))
							rotate <1456*cos(BRANCH_RANDOM*7.19*A*pi)*(1-TWIG_ALTERNATE_SWITCH),0,0>			
							rotate <0,0,90>
							rotate <0,1234*sin(TWIG_RANDOM*4.77*B*pi),0>*(1-TWIG_ALTERNATE_SWITCH)
	      					rotate <0,-1234*sin(4.77*B*pi),0>*BRANCH_TURN_SWITCH
	      					translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*((BH-(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)))/BH)*(1-B/100*STRAIGHTEN_TOWARDS_TOP)
	  						translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*((BH-(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)))/BH)*<1,BRANCH_LONGITUDINAL_CURVE,HORIZONTAL_BRANCH_CURVE_SWITCH>*(1-B/100*STRAIGHTEN_TOWARDS_TOP)
	      					translate <A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.371*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)+(1-EXTRA_NOISE_SWITCH)*(5.371*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)),A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.937*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)+(1-EXTRA_NOISE_SWITCH)*(5.937*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*<-1,1,HORIZONTAL_BRANCH_BEND_SWITCH>*<1-B/100*STRAIGHTEN_TOWARDS_TOP,1,1-B/100*STRAIGHTEN_TOWARDS_TOP>
	      					rotate <0,BRANCH_SPIRAL*sin((FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH*(pi/2)),0>
							rotate <0,1234*sin(4.77*B*pi),0>*BRANCH_TURN_SWITCH
							rotate <0,0,-90>
							scale (AST_L/BH)*(1-B/100*BRANCH_REDUCTION)
							rotate <0,0,BRANCH_ANGLE+((B/100)*((90-BRANCH_ANGLE)))*BRANCH_ALIGNMENT>+<0,0,BRANCH_ANGLE_SCOPE*sin(9.77*B*B*pi)>
							rotate <0,1456*cos(BRANCH_RANDOM*7.19*B*pi)*(1-BRANCH_ALTERNATE_SWITCH)+90*BRANCH_ALTERNATE_SWITCH*sin((B/(100/BRANCHES)-1/(100/BRANCHES))*pi-pi/2)+90,0>
							translate <TRUNK_SNAG*sin(pi/2*sin(5.123*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(4.789*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(5.456*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>*((BH-(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)))/BH)
							translate <TRUNK_CURVE*sin(pi/2*sin(5.456*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(5.123*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(4.789*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>*((BH-(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)))/BH)			
							translate <TRUNK_BEND_X*sin(pi/2*sin(5.371*TRUNK_BEND_X_FREQUENCY*1.5*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)),TRUNK_BEND_Z*sin(pi/2*sin(5.937*TRUNK_BEND_Z_FREQUENCY*1.5*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>
							rotate <0,TRUNK_SPIRAL*sin((FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/(BH*3/5)),0>	
						}
						object {
							B_STAUDE
							transform{TRANS}
						}
						#declare C=C+ZL/BUNCHES*TWIGS;
					#end
					#declare B=B+100/BRANCHES;
				#end
				#declare A=A+BH/TWIGS*BRANCHES;
			#end
		}
	#end
    
    // make ramification
    
	#if (BRANCHES>=1 & TWIGS>=1 & BUNCHES>=1 & TWIG_RAMIFICATION_ORDER>0)
		union {
			#declare B=1;
			#while (B<100)
				#declare A=1;
				#while (A<BH) 
					#declare C=1;
					#while (C<ZL)
						#local TRANS = transform{
							scale (BUNCH_MAJOR_RADIUS+BUNCH_MINOR_RADIUS+LEAF_LENGTH)/BH 
							rotate <0,0,-90> 
							scale BUNCH_DEFORM     
							scale (1+BUNCH_ARC_AT_TWIG*sin(pi*(C*((BUNCHES/TWIGS+1)/(BUNCHES/TWIGS))/ZL)))  
							scale (1+BUNCH_ARC_AT_BRANCH*sin(pi*(A*((TWIGS/BRANCHES+1)/(TWIGS/BRANCHES))/BH))) 
							rotate <-1456*cos(BRANCH_RANDOM*7.19*A*pi)*(1-TWIG_ALTERNATE_SWITCH),0,0> 
							rotate <-1234*sin(7.77*C*pi),0,0>*BUNCH_TURN_SHIFT  
							rotate <-1234*sin(7.77*A*pi),0,0>*BUNCH_TURN_SHIFT  
							rotate <-BRANCH_SPIRAL*sin(((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH*(pi/2)),0,0>
							rotate <-1234*sin(TWIG_RANDOM*4.77*B*pi),0,0>*(1-TWIG_ALTERNATE_SWITCH) 
							rotate <-BRANCH_SPIRAL*sin((FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH*(pi/2)),0,0>
							rotate <0,HORIZONTAL_BUNCH_ANGLE_SCOPE/2*sin(7.77*C*pi),0> 
							rotate <0,0,VERTICAL_BUNCH_ANGLE_SCOPE/2*sin(9.77*C*pi)>+<0,0,(VERTICAL_BUNCH_ANGLE #if (BUNCHES/TWIGS>1) -(VERTICAL_BUNCH_ANGLE*(C*C)/(ZL*ZL)*VERTICAL_BUNCH_ALIGNMENT) #end )>
							rotate <0, #if (BUNCHES/TWIGS=1) (HORIZONTAL_BUNCH_ANGLE-(HORIZONTAL_BUNCH_ANGLE*(A*A)/(BH*BH)*HORIZONTAL_BUNCH_ALIGNMENT))*((1-BUNCH_ALTERNATE_SWITCH)+(BUNCH_ALTERNATE_SWITCH*sin((A/(BH/TWIGS*BRANCHES)-1/(BH/TWIGS*BRANCHES))*pi-pi/2))) #else -(HORIZONTAL_BUNCH_ANGLE*(C*C)/(ZL*ZL)*HORIZONTAL_BUNCH_ALIGNMENT)*((1-BUNCH_ALTERNATE_SWITCH)+BUNCH_ALTERNATE_SWITCH*sin((C/(ZL/(BUNCHES/TWIGS))-1/(ZL/(BUNCHES/TWIGS)))*pi-pi/2)) #end ,0>
							rotate <1234*sin(7.77*C*pi),0,0>*BUNCH_TURN_SWITCH 
							rotate <1234*sin(7.77*A*pi),0,0>*BUNCH_TURN_SWITCH
							scale (1-BUNCH_TAPER_OFF_AT_TREE*B/100) 
							scale (1-BUNCH_TAPER_OFF_AT_TWIG*(C)/(ZL))    
							scale (1-BUNCH_TAPER_OFF_AT_BRANCH*(A)/(BH)) 
							rotate <0,0,90>       
							rotate <0,-1234*sin(4.77*A*pi),0>*TWIG_TURN_SWITCH
							translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH))>*((BH-((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L)))/BH)*(ZW_L/BH)*TWIG_CURVE_ADJUSTMENT*(1-B/100*STRAIGHTEN_TOWARDS_TOP)*(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)
							translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH))>*((BH-((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L)))/BH)*(ZW_L/BH)*TWIG_CURVE_ADJUSTMENT*(1-B/100*STRAIGHTEN_TOWARDS_TOP)*(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)
							translate <A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.371*ABFZ*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH)+(1-EXTRA_NOISE_SWITCH)*5.371*ABFZ*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH),((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L)),A_BG*sin(pi/2*sin(5.937*ABFZ*ZBFZA*((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH))>*<1,1,HORIZONTAL_BRANCH_BEND_SWITCH>*(ZW_L/BH)*<TWIG_CURVE_ADJUSTMENT,1,TWIG_CURVE_ADJUSTMENT>*<1-B/100*STRAIGHTEN_TOWARDS_TOP,1,1-B/100*STRAIGHTEN_TOWARDS_TOP>*<(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END),1,(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)>
							rotate <0,BRANCH_SPIRAL*sin(((FIRST_BUNCH_AT_TWIG+((ZL-FIRST_BUNCH_AT_TWIG)/ZL*C))*(BH/ZW_L))/BH*(pi/2)),0>
							rotate <0,1234*sin(4.77*A*pi),0>*TWIG_TURN_SWITCH
							scale ((FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))-FIRST_TWIG_AT_BRANCH*BRANCH_TAPER*AST_L/BH)/(FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))				
							scale ((TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))-A*BRANCH_TAPER*TWIG_AREA_AT_BRANCH/BH)/(TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))	
							scale BH/AST_L                  
							rotate <0,0,-90>                
							rotate <0,0,VERTICAL_TWIG_ANGLE_SCOPE*sin(9.77*A*A*pi)>+<0,0,(VERTICAL_TWIG_ANGLE-(VERTICAL_TWIG_ANGLE*(A*A)/(BH*BH)*VERTICAL_TWIG_ALIGNMENT))>
							rotate <0,HORIZONTAL_TWIG_ANGLE_SCOPE*sin(7.77*A*A*pi),0>+<0,(HORIZONTAL_TWIG_ANGLE-(HORIZONTAL_TWIG_ANGLE*(A*A)/(BH*BH)*HORIZONTAL_TWIG_ALIGNMENT)),0>*((1-TWIG_ALTERNATE_SWITCH)+(TWIG_ALTERNATE_SWITCH*sin((A/(BH/TWIGS*BRANCHES)-1/(BH/TWIGS*BRANCHES))*pi-pi/2)))		
							rotate <1456*cos(BRANCH_RANDOM*7.19*A*pi)*(1-TWIG_ALTERNATE_SWITCH),0,0>
							rotate <0,0,90>
							rotate <0,1234*sin(TWIG_RANDOM*4.77*B*pi),0>*(1-TWIG_ALTERNATE_SWITCH) 
							rotate <0,-1234*sin(4.77*B*pi),0>*BRANCH_TURN_SWITCH  
	      					translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*((BH-(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)))/BH)*(1-B/100*STRAIGHTEN_TOWARDS_TOP)
	      					translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*((BH-(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)))/BH)*<1,BRANCH_LONGITUDINAL_CURVE,HORIZONTAL_BRANCH_CURVE_SWITCH>*(1-B/100*STRAIGHTEN_TOWARDS_TOP)
	  						translate <A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.371*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)+(1-EXTRA_NOISE_SWITCH)*(5.371*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)),A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.937*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)+(1-EXTRA_NOISE_SWITCH)*(5.937*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*<-1,1,HORIZONTAL_BRANCH_BEND_SWITCH>*<1-B/100*STRAIGHTEN_TOWARDS_TOP,1,1-B/100*STRAIGHTEN_TOWARDS_TOP>
	      					rotate <0,BRANCH_SPIRAL*sin((FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH*(pi/2)),0>
	      					rotate <0,1234*sin(4.77*B*pi),0>*BRANCH_TURN_SWITCH 
	      					rotate <0,0,-90>
							scale (AST_L/BH)*(1-B/100*BRANCH_REDUCTION)
							rotate <0,0,BRANCH_ANGLE+((B/100)*((90-BRANCH_ANGLE)))*BRANCH_ALIGNMENT>+<0,0,BRANCH_ANGLE_SCOPE*sin(9.77*B*B*pi)>
							rotate <0,1456*cos(BRANCH_RANDOM*7.19*B*pi)*(1-BRANCH_ALTERNATE_SWITCH)+90*BRANCH_ALTERNATE_SWITCH*sin((B/(100/BRANCHES)-1/(100/BRANCHES))*pi-pi/2)+90,0>
							translate <TRUNK_SNAG*sin(pi/2*sin(5.123*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(4.789*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(5.456*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>*((BH-(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)))/BH)
							translate <TRUNK_CURVE*sin(pi/2*sin(5.456*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(5.123*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(4.789*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>*((BH-(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)))/BH)			
							translate <TRUNK_BEND_X*sin(pi/2*sin(5.371*TRUNK_BEND_X_FREQUENCY*1.5*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)),TRUNK_BEND_Z*sin(pi/2*sin(5.937*TRUNK_BEND_Z_FREQUENCY*1.5*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>
							rotate <0,TRUNK_SPIRAL*sin((FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/(BH*3/5)),0>	
						}			
						object {
							REISIG
							transform{TRANS}
						}
						#declare C=C+ZL/BUNCHES*TWIGS;
					#end
					#declare A=A+BH/TWIGS*BRANCHES;
				#end
				#declare B=B+100/BRANCHES;
			#end	  
		}
	#end  
	          
	// root + trunk + branches + twigs
	
  	blob {
		threshold TRUNK_RADIUS*3 
		
		// make trunk
			
		#if (TRUNK_STRENGTH > 0)
			#declare A=1;    
			
			#while (A<=(FIRST_BRANCH_AT_TRUNK+ #if (BRANCHES>=1) ((BRANCHES-1)/BRANCHES)* #end BRANCH_AREA_AT_TRUNK))
				#local TRANS = transform{
					 scale TRUNK_RADIUS/90
					scale (BH-A*TRUNK_TAPER)/BH
					#if (PALM_TRUNK=0)
						scale <1 - BARK_PROFILE*.9, 1 + BARK_PROFILE*.25, 1 + BARK_PROFILE*.25>
						rotate z*20.3*sin(3.12*A*pi)
						rotate y*12347.3*sin(3.77*A*pi)   
					#else 
						scale <1, 1-PALM_TRUNK*.9, 1+PALM_TRUNK*.5> 
						rotate <35, 12347.3*sin(4.77*A*pi), 0>
					#end
					#if (A>FIRST_BRANCH_AT_TRUNK)
						scale (1-(A-FIRST_BRANCH_AT_TRUNK)/BRANCH_AREA_AT_TRUNK*BRANCH_REDUCTION)
						scale 1-((A-FIRST_BRANCH_AT_TRUNK)/( #if (BRANCHES>1) ((BRANCHES-1)/BRANCHES)* #end BRANCH_AREA_AT_TRUNK))*(1-BRANCH_THICKNESS_CHANGE)
					#end
					translate <TRUNK_SNAG*sin(pi/2*sin(5.123*TRUNK_SNAG_FREQUENCY*A/BH)),TRUNK_SNAG*sin(pi/2*sin(4.789*TRUNK_SNAG_FREQUENCY*A/BH)),TRUNK_SNAG*sin(pi/2*sin(5.456*TRUNK_SNAG_FREQUENCY*A/BH))>*((BH-A)/BH)
					translate <TRUNK_CURVE*sin(pi/2*sin(5.456*TRUNK_CURVE_FREQUENCY*A/BH)),TRUNK_CURVE*sin(pi/2*sin(5.123*TRUNK_CURVE_FREQUENCY*A/BH)),TRUNK_CURVE*sin(pi/2*sin(4.789*TRUNK_CURVE_FREQUENCY*A/BH))>*((BH-A)/BH)
					translate <TRUNK_BEND_X*sin(pi/2*sin(5.371*TRUNK_BEND_X_FREQUENCY*1.5*A/BH)),A,TRUNK_BEND_Z*sin(pi/2*sin(5.937*TRUNK_BEND_Z_FREQUENCY*1.5*A/BH))>
					rotate <0,TRUNK_SPIRAL*sin(A/(BH*3/5)),0>
				}
				sphere {
					<0, 0, 0>, TRUNK_RADIUS*5, TRUNK_RADIUS*10 
					transform{TRANS}  
				}			
    			#declare A=A+BH/TRUNK_STRENGTH/1000;
			#end
		#else
			sphere{<0,0,0>,TRUNK_RADIUS*.01,TRUNK_RADIUS*10}
		#end   
		
		// make branches
		      
		#if (BRANCH_STRENGTH > 0 & BRANCHES >= 1) 
			#declare B=1;
			#while (B<100)
				#declare A=1;	
					
				#while (A<=(FIRST_TWIG_AT_BRANCH + #if (TWIGS/BRANCHES>1) ((TWIGS/BRANCHES-1)/(TWIGS/BRANCHES))* #end TWIG_AREA_AT_BRANCH+ #if (TWIGS/BRANCHES>1) (TWIG_AREA_AT_BRANCH/(TWIGS/BRANCHES))*BRANCH_TIP+ #end BRANCH_TIP*ZW_L*(1-BRANCH_TAPER))/AST_L*BH)      
      			    #local TRANS = transform{
      			    	scale TRUNK_RADIUS/90
						scale ((FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))-A*BRANCH_TAPER*AST_L/BH)/(FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))				
						scale <1,1,1>+(1-BRANCH_BARK_PROFILE_TAPER_OFF*A/(FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZL))*<-BARK_PROFILE*.9,BARK_PROFILE*.25,BARK_PROFILE*.25>*BRANCH_BARK_PROFILE_CHANGE
						scale (BH-FIRST_BRANCH_AT_TRUNK*TRUNK_TAPER)/BH					
						scale (BH-((BRANCH_AREA_AT_TRUNK)*(B/100))*TRUNK_TAPER)/BH
						scale 1/(AST_L/BH)
						scale BRANCH_THICKNESS_CHANGE 
						#if (A>FIRST_TWIG_AT_BRANCH/AST_L*BH & TWIG_AREA_AT_BRANCH>=1 & BRANCH_TIP=0)
							scale (1-BRANCH_END_EQUALIZER*((A-FIRST_TWIG_AT_BRANCH/AST_L*BH)/( #if (TWIGS/BRANCHES>1) ((TWIGS/BRANCHES-1)/(TWIGS/BRANCHES))* #end (TWIG_AREA_AT_BRANCH/AST_L*BH)))*(1-TWIG_THICKNESS_CHANGE))
						#end
						rotate <0,12347.3*sin(3.77*A*A*pi),0>
						translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*A/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*A/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*A/BH))>*((BH-A)/BH)*(1-B/100*STRAIGHTEN_TOWARDS_TOP)        
						translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*A/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*A/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*A/BH))>*((BH-A)/BH)*<1,BRANCH_LONGITUDINAL_CURVE,HORIZONTAL_BRANCH_CURVE_SWITCH>*(1-B/100*STRAIGHTEN_TOWARDS_TOP)   
						translate <A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.371*ABFZ*A/BH)+(1-EXTRA_NOISE_SWITCH)*5.371*ABFZ*A/BH),A,A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.937*ABFZ*A/BH)+(1-EXTRA_NOISE_SWITCH)*5.937*ABFZ*A/BH)>*<-1,1,HORIZONTAL_BRANCH_BEND_SWITCH>*<1-B/100*STRAIGHTEN_TOWARDS_TOP,1,1-B/100*STRAIGHTEN_TOWARDS_TOP>
						rotate <0,BRANCH_SPIRAL*sin(A/BH*(pi/2)),0>
						rotate <0,1234*sin(4.77*B*pi),0>*BRANCH_TURN_SWITCH 									
						rotate <0,0,-90>
						scale (AST_L/BH)*(1-B/100*BRANCH_REDUCTION)
						rotate <0,0,BRANCH_ANGLE+((B/100)*((90-BRANCH_ANGLE)))*BRANCH_ALIGNMENT>+<0,0,BRANCH_ANGLE_SCOPE*sin(9.77*B*B*pi)>
						rotate <0,1456*cos(BRANCH_RANDOM*7.19*B*pi)*(1-BRANCH_ALTERNATE_SWITCH)+90*BRANCH_ALTERNATE_SWITCH*sin((B/(100/BRANCHES)-1/(100/BRANCHES))*pi-pi/2)+90,0>
						translate <TRUNK_SNAG*sin(pi/2*sin(5.123*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(4.789*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(5.456*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>*((BH-(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)))/BH)
						translate <TRUNK_CURVE*sin(pi/2*sin(5.456*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(5.123*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(4.789*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>*((BH-(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)))/BH)					
						translate <TRUNK_BEND_X*sin(pi/2*sin(5.371*TRUNK_BEND_X_FREQUENCY*1.5*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)),TRUNK_BEND_Z*sin(pi/2*sin(5.937*TRUNK_BEND_Z_FREQUENCY*1.5*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>
						rotate <0,TRUNK_SPIRAL*sin((FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/(BH*3/5)),0>
      			    }
      			    sphere {
						<0,0,0>, TRUNK_RADIUS*5, TRUNK_RADIUS*10
						transform{TRANS}  
					}
      					#declare A=A+BH/BRANCH_STRENGTH/300;
				#end 
				#declare B=B+100/BRANCHES;
			#end		                              
		#end 
                 
        // make twigs
        
		#if (TWIG_STRENGTH>0 & BRANCHES>=1 & TWIGS>=1)				
			#declare B=1;
			#while (B<100)
				#declare A=1;
				#while (A<BH) 
					#declare C=1;
					#while (C<=(FIRST_BUNCH_AT_TWIG+ #if (BUNCHES/TWIGS>1) ((BUNCHES/TWIGS-1)/(BUNCHES/TWIGS))* #end BUNCH_AREA_AT_TWIG #if (BUNCHES/TWIGS>1) +(BUNCH_AREA_AT_TWIG/(BUNCHES/TWIGS))*TWIG_TIP #end +TWIG_TIP*(BUNCH_MAJOR_RADIUS+BUNCH_MINOR_RADIUS)*(1-BUNCH_TAPER_OFF_AT_TWIG))/ZW_L*BH)
						#local TRANS = transform{
							scale TRUNK_RADIUS/90
							scale ((FIRST_BUNCH_AT_TWIG+BUNCH_AREA_AT_TWIG+(BUNCH_MAJOR_RADIUS+BUNCH_MINOR_RADIUS)*(1-BUNCH_TAPER_OFF_AT_TWIG))-C*TWIG_TAPER*ZW_L/BH)/((FIRST_BUNCH_AT_TWIG+BUNCH_AREA_AT_TWIG+(BUNCH_MAJOR_RADIUS+BUNCH_MINOR_RADIUS)*(1-BUNCH_TAPER_OFF_AT_TWIG)))
							scale (BH-((BRANCH_AREA_AT_TRUNK)*(B/100))*TRUNK_TAPER)/BH 
							scale (BH-FIRST_BRANCH_AT_TRUNK*TRUNK_TAPER)/BH
							scale BH/AST_L
							scale AST_L/ZW_L
							scale TWIG_THICKNESS_CHANGE*BRANCH_THICKNESS_CHANGE
							translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*ZBFZA*C/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*ZBFZA*C/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*ZBFZA*C/BH))>*((BH-C)/BH)*TWIG_CURVE_ADJUSTMENT*(1-B/100*STRAIGHTEN_TOWARDS_TOP)*(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)
							translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*ZBFZA*C/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*ZBFZA*C/BH)),1*AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*ZBFZA*C/BH))>*((BH-C)/BH)*TWIG_CURVE_ADJUSTMENT*(1-B/100*STRAIGHTEN_TOWARDS_TOP)*(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)
	      					translate <A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.371*ABFZ*ZBFZA*C/BH)+(1-EXTRA_NOISE_SWITCH)*5.371*ABFZ*ZBFZA*C/BH),C,A_BG*sin(pi/2*sin(5.937*ABFZ*ZBFZA*C/BH))>*<1,1,HORIZONTAL_BRANCH_BEND_SWITCH>*<TWIG_CURVE_ADJUSTMENT,1,TWIG_CURVE_ADJUSTMENT>*<1-B/100*STRAIGHTEN_TOWARDS_TOP,1,1-B/100*STRAIGHTEN_TOWARDS_TOP>*<(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END),1,(1-A/BH*STRAIGHTEN_TOWARDS_BRANCH_END)>
	        				rotate <0,BRANCH_SPIRAL*sin(C/BH*(pi/2)),0>
							scale ((FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))-FIRST_TWIG_AT_BRANCH*BRANCH_TAPER*AST_L/BH)/(FIRST_TWIG_AT_BRANCH+TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))				
							scale ((TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))-A*BRANCH_TAPER*TWIG_AREA_AT_BRANCH/BH)/(TWIG_AREA_AT_BRANCH+ZW_L*(1-BRANCH_TAPER))				
	        				rotate <0,1234*sin(4.77*A*pi),0>*TWIG_TURN_SWITCH
							rotate <0,0,-90>
							scale ZW_L/BH					
							scale BH/AST_L
							rotate <0,0,VERTICAL_TWIG_ANGLE_SCOPE*sin(9.77*A*A*pi)>+<0,0,(VERTICAL_TWIG_ANGLE-(VERTICAL_TWIG_ANGLE*(A*A)/(BH*BH)*VERTICAL_TWIG_ALIGNMENT))>
							rotate <0,HORIZONTAL_TWIG_ANGLE_SCOPE*sin(7.77*A*A*pi),0>+<0,(HORIZONTAL_TWIG_ANGLE-(HORIZONTAL_TWIG_ANGLE*(A*A)/(BH*BH)*HORIZONTAL_TWIG_ALIGNMENT)),0>*((1-TWIG_ALTERNATE_SWITCH)+(TWIG_ALTERNATE_SWITCH*sin((A/(BH/TWIGS*BRANCHES)-1/(BH/TWIGS*BRANCHES))*pi-pi/2)))
							rotate <1456*cos(BRANCH_RANDOM*7.19*A*pi)*(1-TWIG_ALTERNATE_SWITCH),0,0>			
							rotate <0,0,90>	
							rotate <0,1234*sin(TWIG_RANDOM*4.77*B*pi),0>*(1-TWIG_ALTERNATE_SWITCH)					
			    			rotate <0,-1234*sin(4.77*B*pi),0>*BRANCH_TURN_SWITCH
							translate <A_KK*sin(pi/2*sin(5.123*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),A_KK*sin(pi/2*sin(4.789*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),A_KK*sin(pi/2*sin(5.456*BRANCH_SNAG_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*((BH-(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)))/BH)*(1-B/100*STRAIGHTEN_TOWARDS_TOP)	      
			  				translate <AW*sin(pi/2*sin(5.456*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),AW*sin(pi/2*sin(5.123*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),AW*sin(pi/2*sin(4.789*BRANCH_CURVE_FREQUENCY*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*((BH-(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)))/BH)*<1,BRANCH_LONGITUDINAL_CURVE,HORIZONTAL_BRANCH_CURVE_SWITCH>*(1-B/100*STRAIGHTEN_TOWARDS_TOP)	
							translate <A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.371*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)+(1-EXTRA_NOISE_SWITCH)*(5.371*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)),(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH)),A_BG*sin(EXTRA_NOISE_SWITCH*pi/2*sin(5.937*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH)+(1-EXTRA_NOISE_SWITCH)*(5.937*ABFZ*(FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH))>*<-1,1,HORIZONTAL_BRANCH_BEND_SWITCH>*<1-B/100*STRAIGHTEN_TOWARDS_TOP,1,1-B/100*STRAIGHTEN_TOWARDS_TOP>
							rotate <0,BRANCH_SPIRAL*sin((FIRST_TWIG_AT_BRANCH/AST_L*BH+(A*(TWIG_AREA_AT_BRANCH/AST_L*BH)/BH))/BH*(pi/2)),0>
							rotate <0,1234*sin(4.77*B*pi),0>*BRANCH_TURN_SWITCH
							rotate <0,0,-90>
							scale (AST_L/BH)*(1-B/100*BRANCH_REDUCTION)
							rotate <0,0,BRANCH_ANGLE+((B/100)*((90-BRANCH_ANGLE)))*BRANCH_ALIGNMENT>+<0,0,BRANCH_ANGLE_SCOPE*sin(9.77*B*B*pi)>
							rotate <0,1456*cos(BRANCH_RANDOM*7.19*B*pi)*(1-BRANCH_ALTERNATE_SWITCH)+90*BRANCH_ALTERNATE_SWITCH*sin((B/(100/BRANCHES)-1/(100/BRANCHES))*pi-pi/2)+90,0>
							translate <TRUNK_SNAG*sin(pi/2*sin(5.123*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(4.789*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(5.456*TRUNK_SNAG_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>*((BH-(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)))/BH)
							translate <TRUNK_CURVE*sin(pi/2*sin(5.456*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(5.123*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(4.789*TRUNK_CURVE_FREQUENCY*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>*((BH-(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)))/BH)			
							translate <TRUNK_BEND_X*sin(pi/2*sin(5.371*TRUNK_BEND_X_FREQUENCY*1.5*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH)),(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100)),TRUNK_BEND_Z*sin(pi/2*sin(5.937*TRUNK_BEND_Z_FREQUENCY*1.5*(FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/BH))>
							rotate <0,TRUNK_SPIRAL*sin((FIRST_BRANCH_AT_TRUNK+(B*BRANCH_AREA_AT_TRUNK/100))/(BH*3/5)),0>
						}
						sphere {
							<0,0,0>,TRUNK_RADIUS*5,TRUNK_RADIUS*10 
							transform{TRANS}
						}
						#declare C=C+BH/200/TWIG_STRENGTH;
					#end 
					#declare A=A+BH/TWIGS*BRANCHES;
				#end  
				#declare B=B+100/BRANCHES;
			#end
		#end       
		     
		// make root
		
		#if (ROOT_STRENGTH>0 & ROOTS>=1)
			#declare B=1;
			#while (B<100)
				#declare A=1;
				#while (A<BH)
					#local TRANS = transform{
						scale (BH-A)/BH
						scale TRUNK_RADIUS/90
						scale ROOT_THICKNESS_CHANGE 
						scale BH/ROOT_LENGTH
						scale <1,1,1>+<-BARK_PROFILE*.9,BARK_PROFILE*.25,BARK_PROFILE*.25>*ROOT_BARK_PROFILE_CHANGE
						rotate <0,12347.3*sin(3.77*A*pi),0>
						translate <ROOT_SNAG*sin(pi/2*sin(5.789*ROOT_SNAG_FREQUENCY*A/BH)),ROOT_SNAG*sin(pi/2*sin(4.4321*ROOT_SNAG_FREQUENCY*A/BH)),ROOT_SNAG*sin(pi/2*sin(5*ROOT_SNAG_FREQUENCY*A/BH))>*((BH-A)/BH)
						translate <ROOT_CURVE*sin(pi/2*sin(5.123*ROOT_CURVE_FREQUENCY*A/BH)),ROOT_CURVE*sin(pi/2*sin(4.789*ROOT_CURVE_FREQUENCY*A/BH)),ROOT_CURVE*sin(pi/2*sin(5.456*ROOT_CURVE_FREQUENCY*A/BH))>*((BH-A)/BH)
						translate <ROOT_BEND*sin(pi/2*sin(5.371*ROOT_BEND_FREQUENCY*A/BH)),A,ROOT_BEND*sin(pi/2*sin(5.937*ROOT_BEND_FREQUENCY*A/BH))> 
						rotate <0,1234.773*sin(4.77*B*pi),0>*ROOT_TURN_SWITCH
						rotate <0,0,-90>
						rotate <0,180,0>					
						scale ROOT_LENGTH/BH 					
						rotate <0,0,ROOT_ANGLE+((B/100)*ROOT_ALIGNMENT*((90-ROOT_ANGLE)))>
						rotate <0,1456.371*sin(ROOT_RANDOM*71.19*B*pi)+180,0>
						translate <TRUNK_SNAG*sin(pi/2*sin(5.123*TRUNK_SNAG_FREQUENCY*(FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(4.789*TRUNK_SNAG_FREQUENCY*(FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100))/BH)),TRUNK_SNAG*sin(pi/2*sin(5.456*TRUNK_SNAG_FREQUENCY*(FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100))/BH))>*((BH-(FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100)))/BH)
						translate <TRUNK_CURVE*sin(pi/2*sin(5.456*TRUNK_CURVE_FREQUENCY*(FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(5.123*TRUNK_CURVE_FREQUENCY*(FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100))/BH)),TRUNK_CURVE*sin(pi/2*sin(4.789*TRUNK_CURVE_FREQUENCY*(FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100))/BH))>*((BH-(FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100)))/BH)				
						translate <TRUNK_BEND_X*sin(pi/2*sin(5.371*TRUNK_BEND_X_FREQUENCY*1.5*(FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100))/BH)),(FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100)),TRUNK_BEND_Z*sin(pi/2*sin(5.937*TRUNK_BEND_Z_FREQUENCY*1.5*(FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100))/BH))>
						rotate <0,TRUNK_SPIRAL*sin((FIRST_ROOT_AT_TRUNK-(FIRST_ROOT_AT_TRUNK*B/100))/(BH*3/5)),0>	
					}		
					sphere {
						<0,0,0>,TRUNK_RADIUS*5,TRUNK_RADIUS*10 
						transform{TRANS}
					}
					#declare A=A+BH/150/ROOT_STRENGTH;					
				#end 
				#declare B=B+100/ROOTS;
			#end
		#end   
		
		  
	}       
	      
	texture { 
		#if (HORIZONTAL_SCAR_SHRINKING>0)
			onion
			texture_map {
				[0 RINDE scale 1/(<AST_L,VERTICAL_SCAR_SHRINKING*UNIT_1/HORIZONTAL_SCAR_SHRINKING,AST_L>)]
				[HORIZONTAL_SCAR_SHRINKING #if (FOLIAGE_COLOR_AT_BRANCH_END=1) RINDE1 #else RINDE #end scale .3/(<AST_L,VERTICAL_SCAR_SHRINKING*UNIT_1/HORIZONTAL_SCAR_SHRINKING,AST_L>)]
				[1 #if (FOLIAGE_COLOR_AT_BRANCH_END=1) LAUB #else RINDE #end scale .1/(<AST_L,VERTICAL_SCAR_SHRINKING*UNIT_1/HORIZONTAL_SCAR_SHRINKING,AST_L>)]
			}
			scale <AST_L,VERTICAL_SCAR_SHRINKING*UNIT_1/HORIZONTAL_SCAR_SHRINKING,AST_L> 
		#else 
			RINDE
		#end
	} 
	        
	scale 1/UNIT_1	
} 
