#
# procps.spec - procps RPM spec file
# Robert M. Love, 19 Sept 2002
#

Summary: System and process monitoring utilities
Name: procps
Version: 2.0.10
Release: 1
License: GPL
Group: Applications/System
Source: procps-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Prereq: /bin/rm /sbin/ldconfig
BuildRequires: ncurses-devel

%description
The procps package contains a set of system utilities that provide
system information -- free, oldps, pgrep, pkill, skill, snice, tload,
top, uptime, vmstat, w, and watch.

Install this package if you need to view information about processes
on your system.  You probably want at least the ps utility. 

%prep
%setup -q

%build
PATH=/usr/X11R6/bin:$PATH
make CC="gcc $RPM_OPT_FLAGS" MANDIR=%{_mandir}

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}/bin %{buildroot}/usr/bin %{buildroot}/sbin
mkdir -p %{buildroot}%{_mandir}/{man1,man5,man8}
mkdir -p %{buildroot}/lib %{buildroot}/usr/X11R6/bin
mkdir -p %{buildroot}/etc/X11/applnk/Utilities
make DESTDIR=%{buildroot} OWNERGROUP= MANDIR=%{_mandir} install

%clean
rm -rf %{buildroot}

%post
/sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(0644,root,root,755)
%doc BUGS COPYING COPYING.LIB TODO
%attr(755,root,root) /lib/libproc.so.2.0.10
%attr(555,root,root) /bin/ps
%attr(555,root,root) /sbin/sysctl
%attr(555,root,root) /usr/bin/oldps
%attr(555,root,root) /usr/bin/uptime
%attr(555,root,root) /usr/bin/tload
%attr(555,root,root) /usr/bin/free
%attr(555,root,root) /usr/bin/w
%attr(555,root,root) /usr/bin/top
%attr(555,root,root) /usr/bin/vmstat
%attr(555,root,root) /usr/bin/watch
%attr(555,root,root) /usr/bin/skill
%attr(555,root,root) /usr/bin/snice
%attr(555,root,root) /usr/bin/pgrep
%attr(555,root,root) /usr/bin/pkill
%attr(555,root,root) /usr/bin/pmap
%attr(0644,root,root) %{_mandir}/man1/free.1*
%attr(0644,root,root) %{_mandir}/man1/ps.1*
%attr(0644,root,root) %{_mandir}/man1/oldps.1*
%attr(0644,root,root) %{_mandir}/man1/skill.1*
%attr(0644,root,root) %{_mandir}/man1/snice.1*
%attr(0644,root,root) %{_mandir}/man1/pgrep.1*
%attr(0644,root,root) %{_mandir}/man1/pkill.1*
%attr(0644,root,root) %{_mandir}/man1/tload.1*
%attr(0644,root,root) %{_mandir}/man1/top.1*
%attr(0644,root,root) %{_mandir}/man1/uptime.1*
%attr(0644,root,root) %{_mandir}/man1/w.1*
%attr(0644,root,root) %{_mandir}/man1/watch.1*
%attr(0644,root,root) %{_mandir}/man8/vmstat.8*
%attr(0644,root,root) %{_mandir}/man8/sysctl.8*
%attr(0644,root,root) %{_mandir}/man5/sysctl.conf.5*

%changelog
* Fri Oct 04 2002 Robert Love <rml@tech9.net>
- support a build root so you can build RPM without being root

* Thu Sep 19 2002 Robert Love <rml@tech9.net>
- initial packaging of 2.0.7 CVS 20020919
