/*
 * top.h header file 1996/05/18, 
 *
 * function prototypes, global data definitions and string constants.
 */

extern proc_t **readproctab2(int flags, proc_t ** tab, ...);
extern void parse_options(char *Options, int secure);
extern void get_options(void);
extern void error_end(int rno);
extern void end(int signo);
extern void stop(int signo);
extern void window_size(int signo);
extern int make_header(void);
extern int getnum(void);
extern char *getstr(void);
extern int getsig(void);
extern float getfloat(void);
extern int time_sort(proc_t ** P, proc_t ** Q);
extern int pcpu_sort(proc_t ** P, proc_t ** Q);
extern int mem_sort(proc_t ** P, proc_t ** Q);
extern int age_sort(proc_t ** P, proc_t ** Q);
extern void show_fields(void);
extern void change_order(void);
extern void change_fields(void);
extern void show_task_info(proc_t * task, int pmem);
extern void show_procs(void);
extern float get_elapsed_time(void);
extern unsigned show_meminfo(void);
extern void do_stats(proc_t ** p, float elapsed_time, int pass);
extern void do_key(char c);

/* configurable field display support */

int pflags[30];
int sflags[10];
int Numfields;

	/* Name of the config file (in $HOME)  */
#ifndef RCFILE
#define RCFILE		".toprc"
#endif

#ifndef SYS_TOPRC
#define SYS_TOPRC	"/etc/toprc"
#endif

#define MAXLINES 2048
#define MAXNAMELEN 1024

/* this is what procps top does by default, so let's do this, if nothing is
 * specified
 */
#ifndef DEFAULT_SHOW
/*                       0         1         2         3 */
/*                       0123456789012345678901234567890 */
#define DEFAULT_SHOW    "AbcDgHIjklMnoTP|qrsuzyV{EFWX"
#endif
char Fields[256] = "";

/* This structure stores some critical information from one frame to
   the next. mostly used for sorting. Added cumulative and resident fields. */
struct save_hist {
	int ticks;
	int pid;
	int pcpu;
	int utime;
	int stime;
};

	/* The original terminal attributes. */
struct termios Savetty;
	/* The new terminal attributes. */
struct termios Rawtty;
	/* Cached termcap entries. */
char *cm, *cl, *top_clrtobot, *top_clrtoeol, *ho, *md, *me, *mr;
	/* Current window size.  Note that it is legal to set Display_procs
	   larger than can fit; if the window is later resized, all will be ok.
	   In other words: Display_procs is the specified max number of
	   processes to display (zero for infinite), and Maxlines is the actual
	   number. */
int Lines, Cols, Maxlines, Display_procs;
	/* Maximum length to display of the command line of a process. */
unsigned Maxcmd;

	/* The top of the main loop. */
jmp_buf redraw_jmp;

	/* Controls how long we sleep between screen updates.  Accurate to
	   microseconds. */
float Sleeptime = 5;
	/* for opening/closing the system map */
int psdbsucc = 0;
	/* Mode flags. */
int Irixmode = 1;
int Secure = 0;
int Cumulative = 0;
int Noidle = 0;
int CPU_states = 0;
char CurrUser[BUFSIZ];
int CL_pg_shift = (PAGE_SHIFT - 10);
int CL_wchan_nout = -1;
int show_stats = 1;		/* show status summary */
int show_memory = 1;		/* show memory summary */
int show_loadav = 1;		/* show load average and uptime */
int show_cmd = 1;		/* show command name instead of commandline */
int show_threads = 0;		/* show all threads */
int monpids_max = 20;
pid_t monpids[11] = { 0 };
int monpids_index = 0;
int Loops = -1;			/* number of iterations. -1 loops forever */
int Batch = 0;			/* batch mode. Collect no input, dumb output */

/* sorting order: cpu%, mem, time (cumulative, if in cumulative mode) */
enum {
	S_PCPU, S_MEM, S_TIME, S_AGE, S_NONE
};
/* default sorting by CPU% */
int sort_type = S_PCPU;

/* flags for each possible field. At the moment up to 30 are supported */
enum {
	P_PID, P_PPID, P_EUID, P_EUSER,
	P_PCPU, P_PMEM, P_TTY, P_PRI,
	P_NICE, P_PAGEIN, P_TSIZ, P_DSIZ,
	P_SIZE, P_TRS, P_SWAP, P_SHARE,
	P_A, P_WP, P_DT, P_RSS,
	P_WCHAN, P_STAT, P_TIME, P_COMMAND,
	P_LCPU, P_FLAGS, P_END
};
/* corresponding headers */
char *headers[] = {
	"  PID ", " PPID ", " UID ",
	"USER     ", "%CPU ", "%MEM ",
	"TTY      ", "PRI ", " NI ",
	"PAGEIN ", "TSIZE ", "DSIZE ",
	" SIZE ", " TRS ", "SWAP ",
	"SHARE ", "  A ", " WP ",
	"  D ", " RSS ", "WCHAN     ",
	"STAT ", "  TIME ", "COMMAND",
	"LC ",
	"   FLAGS "
};
/* corresponding field desciptions */
char *headers2[] = {
	"Process Id", "Parent Process Id", "User Id",
	"User Name", "CPU Usage", "Memory Usage",
	"Controlling tty", "Priority", "Nice Value",
	"Page Fault Count", "Code Size (kb)", "Data+Stack Size (kb)",
	"Virtual Image Size (kb)", "Resident Text Size (kb)", "Swapped kb",
	"Shared Pages (kb)", "Accessed Page count", "Write Protected Pages",
	"Dirty Pages", "Resident Set Size (kb)", "Sleeping in Function",
	"Process Status", "CPU Time", "Command",
	"Last used CPU (expect this to change regularly)",
	"Task Flags (see linux/sched.h)"
};

	/* The header printed at the top of the process list. */
char Header[MAXLINES];

	/* The response to the interactive 'h' command. */
/*                1         2         3         4         5         6       */
/*      0123456789012345678901234567890123456789012345678901234567890123456 */
#define SECURE_HELP_SCREEN \
/*03*/ "Interactive commands are:\n"\
/*04*/ "\n"\
/*05*/ "h or ?	Help		Space	Update display\n"\
/*06*/ "q	Quit		^L	Redraw the screen\n"\
/*07*/ "oO	Change order of displayed fields\n"\
/*08*/ "fF	Add and remove fields\n"\
/*09*/ "W	Write configuration file ~/.toprc\n"\
/*10*/ "n or #	Set the number of processes to show\n"\
/*11*/ "u	Show only a specific user\n"\
       "%s" /* <- help for non-secure mode keys goes here */ \
/*12*/ "Toggle:\n"\
/*13*/ "    C:collapsed SMP CPU info	H:threads		l:load average\n"\
/*14*/ "    S:cumulative mode		i:idle processes	m:memory info\n"\
/*15*/ "    I:Irix/Solaris view (SMP)	c:command line		t:summary info\n"\
/*16*/ "Sort by:\n"\
/*17*/ "    A:age		M:resident memory usage\n"\
/*18*/ "    N:pid		T:time (or cumulative time)\n"\
/*19*/ "    P:CPU usage\n"\
/*20*/ "\n"\
/*21*/ "Press any key to continue"
#define HELP_SCREEN /* shown only in non-secure mode */ \
/*22*/ "k	Kill a task (with any signal)\n"\
/*23*/ "r	Renice a task\n"\
/*24*/ "s	Set the delay in seconds between updates\n"\
/*nn*/

	/* Number of lines needed to display the header information. */
int header_lines;

/* ############## Some Macro definitions for screen handling ######### */
	/* String to use in error messages. */
#define PROGNAME "top"
	/* Clear the screen. */
#define clear_screen() \
	    PUTP(cl)
	/* Show an error in the context of the spiffy full-screen display. */
#define SHOWMESSAGE(x) do { 			\
	    PUTP(tgoto(cm, 0, header_lines-2));         \
	    PUTP(top_clrtoeol);                         \
	    PUTP(md);                                   \
	    PUTP(mr);	                                \
	    printf x;					\
	    PUTP(me);                                   \
	    fflush(stdout);				\
	    sleep(2);					\
	} while (0)
