/*
 * uptime.c - display uptime
 */

#include <stdio.h>
#include <string.h>

#include "proc/whattime.h"
#include "proc/version.h"

int
main(int argc, char *argv[])
{
	if (argc == 1) {
		print_uptime();
		return 0;
	}

	if ((argc == 2) && (!strcmp(argv[1], "-V"))) {
		display_version();
		return 0;
	}

	fprintf(stderr, "usage: %s [-V]\n", argv[0]);
	fprintf(stderr, "flags:\n");
	fprintf(stderr, "    -V    display version and quit\n");

	return 1;
}
