#include <sys/types.h>
#include <unistd.h>
#include <signal.h>

static pid_t one;

static void die(int signo){
  (void)signo;
  _exit(0);
}

static void sigchld_handler(int signo){
  (void)signo;
  kill(one,SIGHUP);          // kill parent
}

static void hang(void){
  for(;;) pause();
}

int main(int argc, char *argv[]){
  pid_t three;

  (void)argc;
  (void)argv;

  one = getpid();
  signal(SIGHUP,die);
  if(fork()) hang();    // parent later killed as readyness signal

  three = fork();
  if(three){
    signal(SIGCHLD,sigchld_handler);
    kill(three,SIGHUP);   // create the zombie
  }

  hang();
  return 0;
}
