/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class TabbedPane
extends JPanel {
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel cardPanel = new JPanel(this.cardLayout);
    private final ButtonGroup buttonGroup = new ButtonGroup();

    public TabbedPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.cardPanel, gridBagConstraints);
    }

    public Component add(final String string, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 4;
        JToggleButton jToggleButton = new JToggleButton(string);
        jToggleButton.setModel(new JToggleButton.ToggleButtonModel(){

            public void setPressed(boolean bl) {
                if (this.isPressed() == bl || !this.isEnabled()) {
                    return;
                }
                if (!bl && this.isArmed()) {
                    this.setSelected(!this.isSelected());
                }
                this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
                this.fireStateChanged();
                if (this.isPressed()) {
                    this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
                }
            }
        });
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedPane.this.cardLayout.show(TabbedPane.this.cardPanel, string);
            }
        });
        this.buttonGroup.add(jToggleButton);
        if (this.cardPanel.getComponentCount() == 0) {
            jToggleButton.setSelected(true);
        }
        this.add((Component)jToggleButton, gridBagConstraints);
        this.cardPanel.add(string, component);
        return component;
    }

    public Component addImage(final Image image) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        JPanel jPanel = new JPanel(){

            public void paintComponent(Graphics graphics) {
                graphics.drawImage(image, 0, this.getHeight() - image.getHeight(null), this);
            }
        };
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)jPanel, gridBagConstraints);
        return jPanel;
    }

    public void first() {
        this.cardLayout.first(this.cardPanel);
        this.updateButtonSelection();
    }

    public void last() {
        this.cardLayout.last(this.cardPanel);
        this.updateButtonSelection();
    }

    public void previous() {
        this.cardLayout.previous(this.cardPanel);
        this.updateButtonSelection();
    }

    public void next() {
        this.cardLayout.next(this.cardPanel);
        this.updateButtonSelection();
    }

    private void updateButtonSelection() {
        int n = this.cardPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.cardPanel.getComponent(i);
            if (!component.isShowing()) continue;
            JToggleButton jToggleButton = (JToggleButton)this.getComponent(i + 1);
            jToggleButton.setSelected(true);
        }
    }
}

