/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.editor.AnnotationAdder;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ElementValuesEditor;

public class ElementValueAdder
implements ElementValueVisitor {
    private static final ElementValue[] EMPTY_ELEMENT_VALUES = new ElementValue[0];
    private final ProgramClass targetClass;
    private final AnnotationDefaultAttribute targetAnnotationDefaultAttribute;
    private final ConstantAdder constantAdder;
    private final ElementValuesEditor elementValuesEditor;

    public ElementValueAdder(ProgramClass programClass, AnnotationDefaultAttribute annotationDefaultAttribute, boolean bl) {
        this.targetClass = programClass;
        this.targetAnnotationDefaultAttribute = annotationDefaultAttribute;
        this.constantAdder = new ConstantAdder(programClass);
        this.elementValuesEditor = null;
    }

    public ElementValueAdder(ProgramClass programClass, Annotation annotation, boolean bl) {
        this.targetClass = programClass;
        this.targetAnnotationDefaultAttribute = null;
        this.constantAdder = new ConstantAdder(programClass);
        this.elementValuesEditor = new ElementValuesEditor(programClass, annotation, bl);
    }

    public ElementValueAdder(ProgramClass programClass, ArrayElementValue arrayElementValue, boolean bl) {
        System.out.println("ElementValueAdder.ElementValueAdder " + programClass.getName());
        this.targetClass = programClass;
        this.targetAnnotationDefaultAttribute = null;
        this.constantAdder = new ConstantAdder(programClass);
        this.elementValuesEditor = new ElementValuesEditor(programClass, arrayElementValue, bl);
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        ConstantElementValue constantElementValue2 = new ConstantElementValue(constantElementValue.u1tag, constantElementValue.u2elementNameIndex == 0 ? 0 : this.constantAdder.addConstant(clazz, constantElementValue.u2elementNameIndex), this.constantAdder.addConstant(clazz, constantElementValue.u2constantValueIndex));
        constantElementValue2.referencedClass = constantElementValue.referencedClass;
        constantElementValue2.referencedMethod = constantElementValue.referencedMethod;
        this.addElementValue(constantElementValue2);
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        EnumConstantElementValue enumConstantElementValue2 = new EnumConstantElementValue(enumConstantElementValue.u2elementNameIndex == 0 ? 0 : this.constantAdder.addConstant(clazz, enumConstantElementValue.u2elementNameIndex), this.constantAdder.addConstant(clazz, enumConstantElementValue.u2typeNameIndex), this.constantAdder.addConstant(clazz, enumConstantElementValue.u2constantNameIndex));
        enumConstantElementValue2.referencedClass = enumConstantElementValue.referencedClass;
        enumConstantElementValue2.referencedMethod = enumConstantElementValue.referencedMethod;
        enumConstantElementValue2.referencedClasses = enumConstantElementValue.referencedClasses;
        this.addElementValue(enumConstantElementValue2);
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        ClassElementValue classElementValue2 = new ClassElementValue(classElementValue.u2elementNameIndex == 0 ? 0 : this.constantAdder.addConstant(clazz, classElementValue.u2elementNameIndex), this.constantAdder.addConstant(clazz, classElementValue.u2classInfoIndex));
        classElementValue2.referencedClass = classElementValue.referencedClass;
        classElementValue2.referencedMethod = classElementValue.referencedMethod;
        classElementValue2.referencedClasses = classElementValue.referencedClasses;
        this.addElementValue(classElementValue2);
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        AnnotationElementValue annotationElementValue2 = new AnnotationElementValue(annotationElementValue.u2elementNameIndex == 0 ? 0 : this.constantAdder.addConstant(clazz, annotationElementValue.u2elementNameIndex), new Annotation());
        annotationElementValue2.referencedClass = annotationElementValue.referencedClass;
        annotationElementValue2.referencedMethod = annotationElementValue.referencedMethod;
        annotationElementValue.annotationAccept(clazz, new AnnotationAdder(this.targetClass, annotationElementValue2));
        this.addElementValue(annotationElementValue2);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        ArrayElementValue arrayElementValue2 = new ArrayElementValue(arrayElementValue.u2elementNameIndex == 0 ? 0 : this.constantAdder.addConstant(clazz, arrayElementValue.u2elementNameIndex), 0, arrayElementValue.u2elementValuesCount > 0 ? new ElementValue[arrayElementValue.u2elementValuesCount] : EMPTY_ELEMENT_VALUES);
        arrayElementValue2.referencedClass = arrayElementValue.referencedClass;
        arrayElementValue2.referencedMethod = arrayElementValue.referencedMethod;
        arrayElementValue.elementValuesAccept(clazz, annotation, new ElementValueAdder(this.targetClass, arrayElementValue2, false));
        this.addElementValue(arrayElementValue2);
    }

    private void addElementValue(ElementValue elementValue) {
        if (this.targetAnnotationDefaultAttribute != null) {
            this.targetAnnotationDefaultAttribute.defaultValue = elementValue;
        } else {
            this.elementValuesEditor.addElementValue(elementValue);
        }
    }
}

