/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;

public class ClassSuperHierarchyInitializer
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter missingWarningPrinter;
    private final WarningPrinter dependencyWarningPrinter;

    public ClassSuperHierarchyInitializer(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter, WarningPrinter warningPrinter2) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.missingWarningPrinter = warningPrinter;
        this.dependencyWarningPrinter = warningPrinter2;
    }

    public void visitProgramClass(ProgramClass programClass) {
        programClass.superClassConstantAccept(this);
        programClass.interfaceConstantsAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        String string = libraryClass.getName();
        String string2 = libraryClass.superClassName;
        if (string2 != null) {
            libraryClass.superClass = this.findClass(string, string2);
        }
        if (libraryClass.interfaceNames != null) {
            String[] stringArray = libraryClass.interfaceNames;
            Clazz[] clazzArray = new Clazz[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                clazzArray[i] = this.findClass(string, stringArray[i]);
            }
            libraryClass.interfaceClasses = clazzArray;
        }
        libraryClass.superClassName = null;
        libraryClass.interfaceNames = null;
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClass = this.findClass(clazz.getName(), classConstant.getName(clazz));
    }

    private Clazz findClass(String string, String string2) {
        Clazz clazz = this.programClassPool.getClass(string2);
        if (clazz == null) {
            clazz = this.libraryClassPool.getClass(string2);
            if (clazz == null && this.missingWarningPrinter != null) {
                this.missingWarningPrinter.print("Warning: " + ClassUtil.externalClassName(string) + ": can't find superclass or interface " + ClassUtil.externalClassName(string2));
            }
        } else if (this.dependencyWarningPrinter != null) {
            this.dependencyWarningPrinter.print("Warning: library class " + ClassUtil.externalClassName(string) + " extends or implements program class " + ClassUtil.externalClassName(string2));
        }
        return clazz;
    }
}

