/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.constant.RefConstant;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MethodOptimizationInfo;

public class StoringInvocationUnit
extends BasicInvocationUnit {
    public StoringInvocationUnit(ValueFactory valueFactory) {
        super(valueFactory);
    }

    protected void setFieldClassValue(Clazz clazz, RefConstant refConstant, ReferenceValue referenceValue) {
        Member member = refConstant.referencedMember;
        if (member != null) {
            StoringInvocationUnit.generalizeFieldClassValue((Field)member, referenceValue);
        }
    }

    protected void setFieldValue(Clazz clazz, RefConstant refConstant, Value value) {
        Member member = refConstant.referencedMember;
        if (member != null) {
            StoringInvocationUnit.generalizeFieldValue((Field)member, value);
        }
    }

    protected void setMethodParameterValue(Clazz clazz, RefConstant refConstant, int n, Value value) {
        Member member = refConstant.referencedMember;
        if (member != null) {
            StoringInvocationUnit.generalizeMethodParameterValue((Method)member, n, value);
        }
    }

    protected void setMethodReturnValue(Clazz clazz, Method method, Value value) {
        StoringInvocationUnit.generalizeMethodReturnValue(method, value);
    }

    private static void generalizeFieldClassValue(Field field, ReferenceValue referenceValue) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        if (fieldOptimizationInfo != null) {
            fieldOptimizationInfo.generalizeReferencedClass(referenceValue);
        }
    }

    public static ReferenceValue getFieldClassValue(Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        return fieldOptimizationInfo != null ? fieldOptimizationInfo.getReferencedClass() : null;
    }

    private static void generalizeFieldValue(Field field, Value value) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        if (fieldOptimizationInfo != null) {
            fieldOptimizationInfo.generalizeValue(value);
        }
    }

    public static Value getFieldValue(Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        return fieldOptimizationInfo != null ? fieldOptimizationInfo.getValue() : null;
    }

    private static void generalizeMethodParameterValue(Method method, int n, Value value) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.generalizeParameter(n, value);
        }
    }

    public static Value getMethodParameterValue(Method method, int n) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo != null ? methodOptimizationInfo.getParameter(n) : null;
    }

    private static void generalizeMethodReturnValue(Method method, Value value) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.generalizeReturnValue(value);
        }
    }

    public static Value getMethodReturnValue(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo != null ? methodOptimizationInfo.getReturnValue() : null;
    }
}

