/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.pop3;

import java.io.IOException;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.commons.net.io.DotTerminatedMessageReader;
import org.apache.commons.net.pop3.POP3;
import org.apache.commons.net.pop3.POP3MessageInfo;
import org.apache.commons.net.pop3.POP3Reply;

public class POP3Client
extends POP3 {
    private static POP3MessageInfo __parseStatus(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreElements()) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        try {
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreElements()) {
                return null;
            }
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new POP3MessageInfo(n2, n);
    }

    private static POP3MessageInfo __parseUID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreElements()) {
            return null;
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreElements()) {
                return null;
            }
            string = stringTokenizer.nextToken();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new POP3MessageInfo(n, string);
    }

    public boolean deleteMessage(int n) throws IOException {
        if (this.getState() == 1) {
            return this.sendCommand(6, Integer.toString(n)) == POP3Reply.OK;
        }
        return false;
    }

    public POP3MessageInfo listMessage(int n) throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(4, Integer.toString(n)) != POP3Reply.OK) {
            return null;
        }
        return POP3Client.__parseStatus(this._lastReplyLine.substring(3));
    }

    public POP3MessageInfo[] listMessages() throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(4) != POP3Reply.OK) {
            return null;
        }
        this.getAdditionalReply();
        POP3MessageInfo[] pOP3MessageInfoArray = new POP3MessageInfo[this._replyLines.size() - 2];
        Enumeration enumeration = this._replyLines.elements();
        enumeration.nextElement();
        int n = 0;
        while (n < pOP3MessageInfoArray.length) {
            pOP3MessageInfoArray[n] = POP3Client.__parseStatus((String)enumeration.nextElement());
            ++n;
        }
        return pOP3MessageInfoArray;
    }

    public POP3MessageInfo listUniqueIdentifier(int n) throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(11, Integer.toString(n)) != POP3Reply.OK) {
            return null;
        }
        return POP3Client.__parseUID(this._lastReplyLine.substring(3));
    }

    public POP3MessageInfo[] listUniqueIdentifiers() throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(11) != POP3Reply.OK) {
            return null;
        }
        this.getAdditionalReply();
        POP3MessageInfo[] pOP3MessageInfoArray = new POP3MessageInfo[this._replyLines.size() - 2];
        Enumeration enumeration = this._replyLines.elements();
        enumeration.nextElement();
        int n = 0;
        while (n < pOP3MessageInfoArray.length) {
            pOP3MessageInfoArray[n] = POP3Client.__parseUID((String)enumeration.nextElement());
            ++n;
        }
        return pOP3MessageInfoArray;
    }

    public boolean login(String string, String string2) throws IOException {
        if (this.getState() != 0) {
            return false;
        }
        if (this.sendCommand(0, string) != POP3Reply.OK) {
            return false;
        }
        if (this.sendCommand(1, string2) != POP3Reply.OK) {
            return false;
        }
        this.setState(1);
        return true;
    }

    public boolean login(String string, String string2, String string3) throws IOException, NoSuchAlgorithmException {
        if (this.getState() != 0) {
            return false;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        string2 = String.valueOf(string2) + string3;
        byte[] byArray = messageDigest.digest(string2.getBytes());
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Integer.toHexString(byArray[n] & 0xFF));
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer(256);
        stringBuffer2.append(string);
        stringBuffer2.append(' ');
        stringBuffer2.append(stringBuffer.toString());
        if (this.sendCommand(9, stringBuffer2.toString()) != POP3Reply.OK) {
            return false;
        }
        this.setState(1);
        return true;
    }

    public boolean logout() throws IOException {
        if (this.getState() == 1) {
            this.setState(2);
        }
        this.sendCommand(2);
        return this._replyCode == POP3Reply.OK;
    }

    public boolean noop() throws IOException {
        if (this.getState() == 1) {
            return this.sendCommand(7) == POP3Reply.OK;
        }
        return false;
    }

    public boolean reset() throws IOException {
        if (this.getState() == 1) {
            return this.sendCommand(8) == POP3Reply.OK;
        }
        return false;
    }

    public Reader retrieveMessage(int n) throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(5, Integer.toString(n)) != POP3Reply.OK) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader);
    }

    public Reader retrieveMessageTop(int n, int n2) throws IOException {
        if (n2 < 0 || this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(10, String.valueOf(Integer.toString(n)) + " " + Integer.toString(n2)) != POP3Reply.OK) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader);
    }

    public POP3MessageInfo status() throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(3) != POP3Reply.OK) {
            return null;
        }
        return POP3Client.__parseStatus(this._lastReplyLine.substring(3));
    }
}

