/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.logger.Log4JLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;

public class Log4JLoggerManager
implements LoggerManager {
    private final Map m_loggers = new HashMap();
    private String m_prefix;
    private Hierarchy m_hierarchy;
    private final Logger m_defaultLogger;

    public Log4JLoggerManager() {
        this(Category.getDefaultHierarchy());
    }

    public Log4JLoggerManager(Hierarchy hierarchy) {
        this(null, hierarchy);
    }

    public Log4JLoggerManager(String prefix) {
        this(prefix, Category.getDefaultHierarchy());
    }

    public Log4JLoggerManager(String prefix, Hierarchy hierarchy) {
        this(prefix, hierarchy, (Logger)new Log4JLogger(hierarchy.getInstance("")));
    }

    public Log4JLoggerManager(String prefix, Hierarchy hierarchy, Logger defaultLogger) {
        this.m_prefix = prefix;
        this.m_hierarchy = hierarchy;
        this.m_defaultLogger = defaultLogger;
    }

    public final Logger getLoggerForCategory(String categoryName) {
        Logger logger = (Logger)this.m_loggers.get(categoryName);
        if (null != logger) {
            if (this.m_defaultLogger.isDebugEnabled()) {
                this.m_defaultLogger.debug("Logger for category " + categoryName + " returned");
            }
            return logger;
        }
        if (this.m_defaultLogger.isDebugEnabled()) {
            this.m_defaultLogger.debug("Logger for category " + categoryName + " not defined in configuration. New Logger created and returned");
        }
        logger = new Log4JLogger(this.m_hierarchy.getInstance(categoryName));
        this.m_loggers.put(categoryName, logger);
        return logger;
    }

    public final Logger getDefaultLogger() {
        return this.m_defaultLogger;
    }
}

