/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.extensions.ExtensionsTable;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemAttributeSet;
import org.apache.xalan.templates.ElemForEach;
import org.apache.xalan.templates.ElemSort;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.WhiteSpaceInfo;
import org.apache.xalan.templates.XUnresolvedVariable;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.ClonerToResultTree;
import org.apache.xalan.transformer.CountersTable;
import org.apache.xalan.transformer.KeyManager;
import org.apache.xalan.transformer.MsgMgr;
import org.apache.xalan.transformer.NodeSortKey;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.StackGuard;
import org.apache.xalan.transformer.TransformSnapshot;
import org.apache.xalan.transformer.TransformSnapshotImpl;
import org.apache.xalan.transformer.TransformerHandlerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.ObjectPool;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Arg;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.ExtensionsProvider;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.SelfIteratorNoPredicate;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class TransformerImpl
extends Transformer
implements Runnable,
DTMWSFilter,
ExtensionsProvider {
    private Boolean m_reentryGuard = new Boolean(true);
    private FileOutputStream m_outputStream = null;
    private boolean m_parserEventsOnMain = true;
    private Thread m_transformThread;
    private String m_urlOfSource = null;
    private Result m_outputTarget = null;
    private OutputProperties m_outputFormat;
    private Serializer m_serializer;
    ContentHandler m_inputContentHandler;
    private ContentHandler m_outputContentHandler = null;
    DocumentBuilder m_docBuilder = null;
    private ObjectPool m_textResultHandlerObjectPool = new ObjectPool("org.apache.xalan.transformer.ResultTreeHandler");
    private ObjectPool m_stringWriterObjectPool = new ObjectPool("java.io.StringWriter");
    private OutputProperties m_textformat = new OutputProperties("text");
    ElemTemplateElement[] m_currentTemplateElements = new ElemTemplateElement[4096];
    int m_currentTemplateElementsTop = 0;
    Stack m_currentMatchTemplates = new Stack();
    NodeVector m_currentMatchedNodes = new NodeVector();
    private StylesheetRoot m_stylesheetRoot = null;
    private boolean m_quietConflictWarnings = true;
    private XPathContext m_xcontext;
    private StackGuard m_stackGuard;
    private ResultTreeHandler m_resultTreeHandler;
    private KeyManager m_keyManager = new KeyManager();
    Stack m_attrSetStack = null;
    CountersTable m_countersTable = null;
    BoolStack m_currentTemplateRuleIsNull = new BoolStack();
    private MsgMgr m_msgMgr;
    public static boolean S_DEBUG = false;
    private ErrorListener m_errorHandler = new DefaultErrorHandler();
    private TraceManager m_traceManager = new TraceManager(this);
    private Exception m_exceptionThrown = null;
    private Source m_xmlSource;
    private int m_doc;
    private boolean m_isTransformDone = false;
    private boolean m_hasBeenReset = false;
    private boolean m_shouldReset = true;
    private Stack m_modes = new Stack();
    private ExtensionsTable m_extensionsTable = null;
    private boolean m_hasTransformThreadErrorCatcher = false;
    Vector m_userParams;
    static ThreadControler tpool = new ThreadControler();

    public void setShouldReset(boolean shouldReset) {
        this.m_shouldReset = shouldReset;
    }

    public TransformerImpl(StylesheetRoot stylesheet) {
        this.setStylesheet(stylesheet);
        this.setXPathContext(new XPathContext(this));
        this.getXPathContext().setNamespaceContext(stylesheet);
        this.m_stackGuard = new StackGuard(this);
    }

    public ExtensionsTable getExtensionsTable() {
        return this.m_extensionsTable;
    }

    void setExtensionsTable(StylesheetRoot sroot) throws TransformerException {
        try {
            if (sroot.getExtensions() != null) {
                this.m_extensionsTable = new ExtensionsTable(sroot);
            }
        }
        catch (TransformerException te) {
            te.printStackTrace();
        }
    }

    public boolean functionAvailable(String ns, String funcName) throws TransformerException {
        return this.getExtensionsTable().functionAvailable(ns, funcName);
    }

    public boolean elementAvailable(String ns, String elemName) throws TransformerException {
        return this.getExtensionsTable().elementAvailable(ns, elemName);
    }

    public Object extFunction(String ns, String funcName, Vector argVec, Object methodKey) throws TransformerException {
        return this.getExtensionsTable().extFunction(ns, funcName, argVec, methodKey, this.getXPathContext().getExpressionContext());
    }

    public void reset() {
        if (!this.m_hasBeenReset && this.m_shouldReset) {
            this.m_hasBeenReset = true;
            if (this.m_outputStream != null) {
                try {
                    this.m_outputStream.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.m_outputStream = null;
            this.m_countersTable = null;
            this.m_xcontext.reset();
            this.m_xcontext.getVarStack().reset();
            this.resetUserParameters();
            int n = this.m_currentTemplateElements.length;
            int i = 0;
            while (i < n) {
                this.m_currentTemplateElements[i] = null;
                ++i;
            }
            this.m_currentTemplateElementsTop = 0;
            this.m_currentMatchTemplates.removeAllElements();
            this.m_currentMatchedNodes.removeAllElements();
            this.m_resultTreeHandler = null;
            this.m_outputTarget = null;
            this.m_keyManager = new KeyManager();
            this.m_attrSetStack = null;
            this.m_countersTable = null;
            this.m_currentTemplateRuleIsNull = new BoolStack();
            this.m_xmlSource = null;
            this.m_doc = -1;
            this.m_isTransformDone = false;
            this.m_transformThread = null;
            this.m_xcontext.getSourceTreeManager().reset();
        }
    }

    public boolean getProperty(String property) {
        return false;
    }

    public void setProperty(String property, Object value) {
    }

    public boolean isParserEventsOnMain() {
        return this.m_parserEventsOnMain;
    }

    public Thread getTransformThread() {
        return this.m_transformThread;
    }

    public void setTransformThread(Thread t) {
        this.m_transformThread = t;
    }

    public boolean hasTransformThreadErrorCatcher() {
        return this.m_hasTransformThreadErrorCatcher;
    }

    public void transform(Source source) throws TransformerException {
        this.transform(source, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(Source source, boolean shouldRelease) throws TransformerException {
        try {
            block17: {
                Exception throwable;
                try {
                    String base = source.getSystemId();
                    if (null == base) {
                        base = this.m_stylesheetRoot.getBaseIdentifier();
                    }
                    if (null == base) {
                        String currentDir = "";
                        try {
                            currentDir = System.getProperty("user.dir");
                        }
                        catch (SecurityException se) {
                            // empty catch block
                        }
                        base = currentDir.startsWith(File.separator) ? "file://" + currentDir : "file:///" + currentDir;
                        base = base + File.separatorChar + source.getClass().getName();
                    }
                    this.setBaseURLOfSource(base);
                    DTMManager mgr = this.m_xcontext.getDTMManager();
                    DTM dtm = mgr.getDTM(source, false, this, true, true);
                    dtm.setDocumentBaseURI(base);
                    boolean hardDelete = true;
                    try {
                        this.transformNode(dtm.getDocument());
                        Object var8_12 = null;
                        if (shouldRelease) {
                            mgr.release(dtm, hardDelete);
                        }
                    }
                    catch (Throwable throwable2) {
                        Object var8_13 = null;
                        if (!shouldRelease) throw throwable2;
                        mgr.release(dtm, hardDelete);
                        throw throwable2;
                    }
                    Exception e = this.getExceptionThrown();
                    if (null != e) {
                        if (e instanceof TransformerException) {
                            throw (TransformerException)e;
                        }
                        if (!(e instanceof WrappedRuntimeException)) throw new TransformerException(e);
                        this.fatalError(((WrappedRuntimeException)e).getException());
                        break block17;
                    }
                    if (null != this.m_resultTreeHandler) {
                        this.m_resultTreeHandler.endDocument();
                    }
                }
                catch (WrappedRuntimeException wre) {
                    throwable = wre.getException();
                }
                while (true) {
                    if (!(throwable instanceof WrappedRuntimeException)) break;
                    throwable = ((WrappedRuntimeException)throwable).getException();
                }
                this.fatalError(throwable);
                Object var10_17 = null;
                this.m_hasTransformThreadErrorCatcher = false;
                this.reset();
                return;
                catch (SAXParseException spe) {
                    this.fatalError(spe);
                    Object var10_18 = null;
                    this.m_hasTransformThreadErrorCatcher = false;
                    this.reset();
                    return;
                }
                catch (SAXException se) {
                    this.m_errorHandler.fatalError(new TransformerException(se));
                    Object var10_19 = null;
                    this.m_hasTransformThreadErrorCatcher = false;
                    this.reset();
                    return;
                }
            }
            Object var10_16 = null;
            this.m_hasTransformThreadErrorCatcher = false;
            this.reset();
            return;
        }
        catch (Throwable throwable) {
            Object var10_20 = null;
            this.m_hasTransformThreadErrorCatcher = false;
            this.reset();
            throw throwable;
        }
    }

    private void fatalError(Throwable throwable) throws TransformerException {
        if (throwable instanceof SAXParseException) {
            this.m_errorHandler.fatalError(new TransformerException(throwable.getMessage(), new SAXSourceLocator((SAXParseException)throwable)));
        } else {
            this.m_errorHandler.fatalError(new TransformerException(throwable));
        }
    }

    public String getBaseURLOfSource() {
        return this.m_urlOfSource;
    }

    public void setBaseURLOfSource(String base) {
        this.m_urlOfSource = base;
    }

    public Result getOutputTarget() {
        return this.m_outputTarget;
    }

    public void setOutputTarget(Result outputTarget) {
        this.m_outputTarget = outputTarget;
    }

    public String getOutputProperty(String qnameString) throws IllegalArgumentException {
        String value = null;
        OutputProperties props = this.getOutputFormat();
        value = props.getProperty(qnameString);
        if (null == value && !props.isLegalPropertyKey(qnameString)) {
            throw new IllegalArgumentException(XSLMessages.createMessage(197, new Object[]{qnameString}));
        }
        return value;
    }

    public String getOutputPropertyNoDefault(String qnameString) throws IllegalArgumentException {
        String value = null;
        OutputProperties props = this.getOutputFormat();
        value = (String)((Hashtable)props.getProperties()).get(qnameString);
        if (null == value && !props.isLegalPropertyKey(qnameString)) {
            throw new IllegalArgumentException(XSLMessages.createMessage(197, new Object[]{qnameString}));
        }
        return value;
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (null == this.m_outputFormat) {
                this.m_outputFormat = (OutputProperties)this.getStylesheet().getOutputComposed().clone();
            }
            if (!this.m_outputFormat.isLegalPropertyKey(name)) {
                throw new IllegalArgumentException(XSLMessages.createMessage(197, new Object[]{name}));
            }
            this.m_outputFormat.setProperty(name, value);
        }
    }

    public void setOutputProperties(Properties oformat) {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (null != oformat) {
                String method = (String)((Hashtable)oformat).get("method");
                if (null != method) {
                    this.m_outputFormat = new OutputProperties(method);
                } else if (this.m_outputFormat == null) {
                    this.m_outputFormat = new OutputProperties();
                }
            }
            if (null != oformat) {
                this.m_outputFormat.copyFrom(oformat);
            }
            this.m_outputFormat.copyFrom(this.m_stylesheetRoot.getOutputProperties());
        }
    }

    public Properties getOutputProperties() {
        return (Properties)((Hashtable)this.getOutputFormat().getProperties()).clone();
    }

    public ContentHandler createResultContentHandler(Result outputTarget) throws TransformerException {
        return this.createResultContentHandler(outputTarget, this.getOutputFormat());
    }

    public ContentHandler createResultContentHandler(Result outputTarget, OutputProperties format) throws TransformerException {
        ContentHandler handler = null;
        Node outputNode = null;
        if (outputTarget instanceof DOMResult) {
            Document doc;
            short type;
            outputNode = ((DOMResult)outputTarget).getNode();
            if (null != outputNode) {
                type = outputNode.getNodeType();
                doc = 9 == type ? (Document)outputNode : outputNode.getOwnerDocument();
            } else {
                doc = DOMHelper.createDocument();
                outputNode = doc;
                type = outputNode.getNodeType();
                ((DOMResult)outputTarget).setNode(outputNode);
            }
            handler = 11 == type ? new DOMBuilder(doc, (DocumentFragment)outputNode) : new DOMBuilder(doc, outputNode);
        } else if (outputTarget instanceof SAXResult) {
            handler = ((SAXResult)outputTarget).getHandler();
            if (null == handler) {
                throw new IllegalArgumentException("handler can not be null for a SAXResult");
            }
        } else if (outputTarget instanceof StreamResult) {
            StreamResult sresult = (StreamResult)outputTarget;
            String method = format.getProperty("method");
            try {
                Serializer serializer = SerializerFactory.getSerializer(format.getProperties());
                if (null != sresult.getWriter()) {
                    serializer.setWriter(sresult.getWriter());
                } else if (null != sresult.getOutputStream()) {
                    serializer.setOutputStream(sresult.getOutputStream());
                } else if (null != sresult.getSystemId()) {
                    String fileURL = sresult.getSystemId();
                    if (fileURL.startsWith("file:///")) {
                        fileURL = fileURL.substring(8).indexOf(":") > 0 ? fileURL.substring(8) : fileURL.substring(7);
                    }
                    this.m_outputStream = new FileOutputStream(fileURL);
                    serializer.setOutputStream(this.m_outputStream);
                } else {
                    throw new TransformerException(XSLMessages.createMessage(147, null));
                }
                handler = serializer.asContentHandler();
                this.setSerializer(serializer);
            }
            catch (UnsupportedEncodingException uee) {
                throw new TransformerException(uee);
            }
            catch (IOException ioe) {
                throw new TransformerException(ioe);
            }
        } else {
            throw new TransformerException(XSLMessages.createMessage(148, new Object[]{outputTarget.getClass().getName()}));
        }
        return handler;
    }

    public void transform(Source xmlSource, Result outputTarget) throws TransformerException {
        this.transform(xmlSource, outputTarget, true);
    }

    public void transform(Source xmlSource, Result outputTarget, boolean shouldRelease) throws TransformerException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            ContentHandler handler = this.createResultContentHandler(outputTarget);
            this.m_outputTarget = outputTarget;
            this.setContentHandler(handler);
            this.transform(xmlSource, shouldRelease);
        }
    }

    public void transformNode(int node, Result outputTarget) throws TransformerException {
        ContentHandler handler = this.createResultContentHandler(outputTarget);
        this.m_outputTarget = outputTarget;
        this.setContentHandler(handler);
        this.transformNode(node);
    }

    /*
     * Unable to fully structure code
     */
    public void transformNode(int node) throws TransformerException {
        this.setExtensionsTable(this.getStylesheet());
        var2_2 = this.m_outputContentHandler;
        synchronized (var2_2) {
            block23: {
                block24: {
                    this.m_hasBeenReset = false;
                    xctxt = this.getXPathContext();
                    dtm = xctxt.getDTM(node);
                    try {
                        block22: {
                            try {
                                this.pushGlobalVars(node);
                                stylesheet = this.getStylesheet();
                                n = stylesheet.getGlobalImportCount();
                                i = 0;
                                while (i < n) {
                                    imported = stylesheet.getGlobalImport(i);
                                    includedCount = imported.getIncludeCountComposed();
                                    j = -1;
                                    while (j < includedCount) {
                                        included = imported.getIncludeComposed(j);
                                        included.runtimeInit(this);
                                        child = included.getFirstChildElem();
                                        while (child != null) {
                                            child.runtimeInit(this);
                                            child = child.getNextSiblingElem();
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                                dtmIter = new SelfIteratorNoPredicate();
                                dtmIter.setRoot(node, xctxt);
                                xctxt.pushContextNodeList(dtmIter);
                                try {
                                    this.applyTemplateToNode(null, null, node);
                                    var14_18 = null;
                                    xctxt.popContextNodeList();
                                }
                                catch (Throwable var13_20) {
                                    var14_19 = null;
                                    xctxt.popContextNodeList();
                                    throw var13_20;
                                }
                                if (null == this.m_resultTreeHandler) break block22;
                                this.m_resultTreeHandler.endDocument();
                            }
                            catch (Exception se) {
                                ** while (se instanceof WrappedRuntimeException)
                            }
                        }
                        var16_21 = null;
                        this.reset();
                        break block23;
lbl-1000:
                        // 1 sources

                        {
                            e = ((WrappedRuntimeException)se).getException();
                            if (null == e) continue;
                            se = e;
                            continue;
                        }
lbl58:
                        // 1 sources

                        if (null != this.m_resultTreeHandler) {
                            try {
                                if (se instanceof SAXParseException) {
                                    this.m_resultTreeHandler.fatalError((SAXParseException)se);
                                } else if (se instanceof TransformerException) {
                                    te = (TransformerException)se;
                                    sl = new SAXSourceLocator(te.getLocator());
                                    this.m_resultTreeHandler.fatalError(new SAXParseException(te.getMessage(), sl, te));
                                } else {
                                    this.m_resultTreeHandler.fatalError(new SAXParseException(se.getMessage(), new SAXSourceLocator(), se));
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (se instanceof TransformerException) {
                            this.m_errorHandler.fatalError((TransformerException)se);
                            break block24;
                        }
                        if (se instanceof SAXParseException) {
                            this.m_errorHandler.fatalError(new TransformerException(se.getMessage(), new SAXSourceLocator((SAXParseException)se), se));
                            break block24;
                        }
                        this.m_errorHandler.fatalError(new TransformerException(se));
                    }
                    catch (Throwable var15_24) {
                        var16_23 = null;
                        this.reset();
                        throw var15_24;
                    }
                }
                var16_22 = null;
                this.reset();
                {
                }
            }
        }
    }

    public ContentHandler getInputContentHandler() {
        return this.getInputContentHandler(false);
    }

    public ContentHandler getInputContentHandler(boolean doDocFrag) {
        if (null == this.m_inputContentHandler) {
            this.m_inputContentHandler = new TransformerHandlerImpl(this, doDocFrag, this.m_urlOfSource);
        }
        return this.m_inputContentHandler;
    }

    public DeclHandler getInputDeclHandler() {
        if (this.m_inputContentHandler instanceof DeclHandler) {
            return (DeclHandler)((Object)this.m_inputContentHandler);
        }
        return null;
    }

    public LexicalHandler getInputLexicalHandler() {
        if (this.m_inputContentHandler instanceof LexicalHandler) {
            return (LexicalHandler)((Object)this.m_inputContentHandler);
        }
        return null;
    }

    public void setOutputFormat(OutputProperties oformat) {
        this.m_outputFormat = oformat;
    }

    public OutputProperties getOutputFormat() {
        OutputProperties format = null == this.m_outputFormat ? this.getStylesheet().getOutputComposed() : this.m_outputFormat;
        return format;
    }

    public Serializer getSerializer() {
        return this.m_serializer;
    }

    public void setSerializer(Serializer s) {
        this.m_serializer = s;
    }

    public void setParameter(String name, String namespace, Object value) {
        VariableStack varstack = this.getXPathContext().getVarStack();
        QName qname = new QName(namespace, name);
        XObject xobject = XObject.create(value, this.getXPathContext());
        StylesheetRoot sroot = this.m_stylesheetRoot;
        Vector vars = sroot.getVariablesAndParamsComposed();
        int i = vars.size();
        while (--i >= 0) {
            ElemVariable variable = (ElemVariable)vars.elementAt(i);
            if (variable.getXSLToken() != 41 || !variable.getName().equals(qname)) continue;
            varstack.setGlobalVariable(i, xobject);
        }
    }

    public void setParameter(String name, Object value) {
        StringTokenizer tokenizer = new StringTokenizer(name, "{}", false);
        try {
            String s2;
            String s1 = tokenizer.nextToken();
            String string = s2 = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (null == this.m_userParams) {
                this.m_userParams = new Vector();
            }
            if (null == s2) {
                this.replaceOrPushUserParam(new QName(s1), XObject.create(value, this.getXPathContext()));
                this.setParameter(s1, null, value);
            } else {
                this.replaceOrPushUserParam(new QName(s1, s2), XObject.create(value, this.getXPathContext()));
                this.setParameter(s2, s1, value);
            }
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
    }

    private void replaceOrPushUserParam(QName qname, XObject xval) {
        int n = this.m_userParams.size();
        int i = n - 1;
        while (i >= 0) {
            Arg arg = (Arg)this.m_userParams.elementAt(i);
            if (arg.getQName().equals(qname)) {
                this.m_userParams.setElementAt(new Arg(qname, xval, true), i);
                return;
            }
            --i;
        }
        this.m_userParams.addElement(new Arg(qname, xval, true));
    }

    public Object getParameter(String name) {
        try {
            QName qname = QName.getQNameFromString(name);
            if (null == this.m_userParams) {
                return null;
            }
            int n = this.m_userParams.size();
            int i = n - 1;
            while (i >= 0) {
                Arg arg = (Arg)this.m_userParams.elementAt(i);
                if (arg.getQName().equals(qname)) {
                    return arg.getVal().object();
                }
                --i;
            }
            return null;
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    private void resetUserParameters() {
        try {
            if (null == this.m_userParams) {
                return;
            }
            int n = this.m_userParams.size();
            int i = n - 1;
            while (i >= 0) {
                Arg arg = (Arg)this.m_userParams.elementAt(i);
                QName name = arg.getQName();
                String s1 = name.getNamespace();
                String s2 = name.getLocalPart();
                this.setParameter(s2, s1, arg.getVal().object());
                --i;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void setParameters(Properties params) {
        this.clearParameters();
        Enumeration<?> names = params.propertyNames();
        while (names.hasMoreElements()) {
            String name = params.getProperty((String)names.nextElement());
            StringTokenizer tokenizer = new StringTokenizer(name, "{}", false);
            try {
                String s2;
                String s1 = tokenizer.nextToken();
                String string = s2 = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                if (null == s2) {
                    this.setParameter(s1, null, params.getProperty(name));
                    continue;
                }
                this.setParameter(s2, s1, params.getProperty(name));
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
        }
    }

    public void clearParameters() {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            VariableStack varstack = new VariableStack();
            this.m_xcontext.setVarStack(varstack);
            this.m_userParams = null;
        }
    }

    protected void pushGlobalVars(int contextNode) throws TransformerException {
        XPathContext xctxt = this.m_xcontext;
        VariableStack vs = xctxt.getVarStack();
        StylesheetRoot sr = this.getStylesheet();
        Vector vars = sr.getVariablesAndParamsComposed();
        int i = vars.size();
        vs.link(i);
        while (--i >= 0) {
            ElemVariable v = (ElemVariable)vars.elementAt(i);
            XUnresolvedVariable xobj = new XUnresolvedVariable(v, contextNode, this, vs.getStackFrame(), 0, true);
            if (null != vs.elementAt(i)) continue;
            vs.setGlobalVariable(i, xobj);
        }
    }

    public void setURIResolver(URIResolver resolver) {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            this.m_xcontext.getSourceTreeManager().setURIResolver(resolver);
        }
    }

    public URIResolver getURIResolver() {
        return this.m_xcontext.getSourceTreeManager().getURIResolver();
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException(XSLMessages.createMessage(150, null));
        }
        this.m_outputContentHandler = handler;
        if (null == this.m_resultTreeHandler) {
            this.m_resultTreeHandler = new ResultTreeHandler(this, handler);
        } else {
            this.m_resultTreeHandler.setContentHandler(handler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.m_outputContentHandler;
    }

    public int transformToRTF(ElemTemplateElement templateParent) throws TransformerException {
        DTM dtmFrag = this.m_xcontext.getRTFDTM();
        return this.transformToRTF(templateParent, dtmFrag);
    }

    public int transformToGlobalRTF(ElemTemplateElement templateParent) throws TransformerException {
        DTM dtmFrag = this.m_xcontext.getGlobalRTFDTM();
        return this.transformToRTF(templateParent, dtmFrag);
    }

    private int transformToRTF(ElemTemplateElement templateParent, DTM dtmFrag) throws TransformerException {
        int resultFragment;
        XPathContext xctxt = this.m_xcontext;
        ContentHandler rtfHandler = dtmFrag.getContentHandler();
        ResultTreeHandler savedRTreeHandler = this.m_resultTreeHandler;
        ResultTreeHandler rth = this.m_resultTreeHandler = new ResultTreeHandler(this, rtfHandler);
        try {
            try {
                rth.startDocument();
                rth.flushPending();
                try {
                    this.executeChildTemplates(templateParent, true);
                    rth.flushPending();
                    resultFragment = dtmFrag.getDocument();
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    rth.endDocument();
                    throw throwable;
                }
                rth.endDocument();
                Object var11_12 = null;
                this.m_resultTreeHandler = savedRTreeHandler;
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.m_resultTreeHandler = savedRTreeHandler;
            throw throwable;
        }
        return resultFragment;
    }

    public ObjectPool getStringWriterPool() {
        return this.m_stringWriterObjectPool;
    }

    /*
     * Loose catch block
     */
    public String transformToString(ElemTemplateElement elem) throws TransformerException {
        String result;
        StringWriter sw;
        ResultTreeHandler savedRTreeHandler;
        block12: {
            ElemTemplateElement firstChild = elem.getFirstChildElem();
            if (null == firstChild) {
                return "";
            }
            if (elem.hasTextLitOnly() && TransformerFactoryImpl.m_optimize) {
                return ((ElemTextLiteral)firstChild).getNodeValue();
            }
            savedRTreeHandler = this.m_resultTreeHandler;
            sw = (StringWriter)this.m_stringWriterObjectPool.getInstance();
            this.m_resultTreeHandler = (ResultTreeHandler)this.m_textResultHandlerObjectPool.getInstance();
            Serializer serializer = this.m_resultTreeHandler.getSerializer();
            try {
                if (null == serializer) {
                    serializer = SerializerFactory.getSerializer(this.m_textformat.getProperties());
                    this.m_resultTreeHandler.setSerializer(serializer);
                    serializer.setWriter(sw);
                    ContentHandler shandler = serializer.asContentHandler();
                    this.m_resultTreeHandler.init(this, shandler);
                }
            }
            catch (IOException ioe) {
                throw new TransformerException(ioe);
            }
            this.m_resultTreeHandler.startDocument();
            this.executeChildTemplates(elem, true);
            this.m_resultTreeHandler.endDocument();
            result = sw.toString();
            Object var9_8 = null;
            sw.getBuffer().setLength(0);
            try {
                sw.close();
                break block12;
            }
            catch (Exception ioe) {
                // empty catch block
            }
            {
                break block12;
                catch (SAXException se) {
                    throw new TransformerException(se);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                sw.getBuffer().setLength(0);
                try {
                    sw.close();
                }
                catch (Exception ioe) {
                    // empty catch block
                }
                this.m_stringWriterObjectPool.freeInstance(sw);
                this.m_textResultHandlerObjectPool.freeInstance(this.m_resultTreeHandler);
                this.m_resultTreeHandler.reset();
                this.m_resultTreeHandler = savedRTreeHandler;
                throw throwable;
            }
        }
        this.m_stringWriterObjectPool.freeInstance(sw);
        this.m_textResultHandlerObjectPool.freeInstance(this.m_resultTreeHandler);
        this.m_resultTreeHandler.reset();
        this.m_resultTreeHandler = savedRTreeHandler;
        return result;
    }

    public boolean applyTemplateToNode(ElemTemplateElement xslInstruction, ElemTemplate template, int child) throws TransformerException {
        DTM dtm = this.m_xcontext.getDTM(child);
        short nodeType = dtm.getNodeType(child);
        boolean isDefaultTextRule = false;
        if (null == template) {
            int maxImportLevel;
            boolean isApplyImports;
            int endImportLevel = 0;
            boolean bl = xslInstruction == null ? false : (isApplyImports = xslInstruction.getXSLToken() == 72);
            if (isApplyImports) {
                maxImportLevel = xslInstruction.getStylesheetComposed().getImportCountComposed() - 1;
                endImportLevel = xslInstruction.getStylesheetComposed().getEndImportCountComposed();
            } else {
                maxImportLevel = -1;
            }
            if (isApplyImports && maxImportLevel == -1) {
                template = null;
            } else {
                XPathContext xctxt = this.m_xcontext;
                try {
                    xctxt.pushNamespaceContext(xslInstruction);
                    QName mode = this.getMode();
                    template = isApplyImports ? this.m_stylesheetRoot.getTemplateComposed(xctxt, child, mode, maxImportLevel, endImportLevel, this.m_quietConflictWarnings, dtm) : this.m_stylesheetRoot.getTemplateComposed(xctxt, child, mode, this.m_quietConflictWarnings, dtm);
                    Object var13_14 = null;
                    xctxt.popNamespaceContext();
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    xctxt.popNamespaceContext();
                    throw throwable;
                }
            }
            if (null == template) {
                switch (nodeType) {
                    case 1: 
                    case 11: {
                        template = this.m_stylesheetRoot.getDefaultRule();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        template = this.m_stylesheetRoot.getDefaultTextRule();
                        isDefaultTextRule = true;
                        break;
                    }
                    case 9: {
                        template = this.m_stylesheetRoot.getDefaultRootRule();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        try {
            block23: {
                try {
                    this.pushElemTemplateElement(template);
                    this.m_xcontext.pushCurrentNode(child);
                    this.pushPairCurrentMatched(template, child);
                    NodeSetDTM cnl = new NodeSetDTM(child, this.m_xcontext.getDTMManager());
                    this.m_xcontext.pushContextNodeList(cnl);
                    if (isDefaultTextRule) {
                        switch (nodeType) {
                            case 3: 
                            case 4: {
                                ClonerToResultTree.cloneToResultTree(child, nodeType, dtm, this.getResultTreeHandler(), false);
                                break;
                            }
                            case 2: {
                                dtm.dispatchCharactersEvents(child, this.getResultTreeHandler(), false);
                            }
                        }
                        break block23;
                    }
                    if (S_DEBUG) {
                        this.getTraceManager().fireTraceEvent(template);
                    }
                    this.m_xcontext.setSAXLocator(template);
                    this.m_xcontext.getVarStack().link(template.m_frameSize);
                    this.executeChildTemplates((ElemTemplateElement)template, true);
                    if (!S_DEBUG) break block23;
                    this.getTraceManager().fireTraceEndEvent(template);
                }
                catch (SAXException se) {
                    throw new TransformerException(se);
                }
            }
            Object var15_17 = null;
            this.m_xcontext.getVarStack().unlink();
            this.m_xcontext.popCurrentNode();
            this.m_xcontext.popContextNodeList();
            this.popCurrentMatched();
            this.popElemTemplateElement();
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.m_xcontext.getVarStack().unlink();
            this.m_xcontext.popCurrentNode();
            this.m_xcontext.popContextNodeList();
            this.popCurrentMatched();
            this.popElemTemplateElement();
            throw throwable;
        }
        return true;
    }

    public void executeChildTemplates(ElemTemplateElement elem, Node context, QName mode, ContentHandler handler) throws TransformerException {
        XPathContext xctxt = this.m_xcontext;
        try {
            if (null != mode) {
                this.pushMode(mode);
            }
            xctxt.pushCurrentNode(xctxt.getDTMHandleFromNode(context));
            this.executeChildTemplates(elem, handler);
            Object var7_6 = null;
            xctxt.popCurrentNode();
            if (null != mode) {
                this.popMode();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            xctxt.popCurrentNode();
            if (null != mode) {
                this.popMode();
            }
            throw throwable;
        }
    }

    public void executeChildTemplates(ElemTemplateElement elem, ContentHandler handler) throws TransformerException {
        ResultTreeHandler rth = this.getResultTreeHandler();
        ContentHandler savedRTHHandler = rth.getContentHandler();
        ContentHandler savedHandler = this.getContentHandler();
        try {
            try {
                this.getResultTreeHandler().flushPending();
                this.setContentHandler(handler);
                this.executeChildTemplates(elem, true);
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            Object var8_6 = null;
            this.setContentHandler(savedHandler);
            rth.setContentHandler(savedRTHHandler);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.setContentHandler(savedHandler);
            rth.setContentHandler(savedRTHHandler);
            throw throwable;
        }
    }

    public void executeChildTemplates(ElemTemplateElement elem, boolean shouldAddAttrs) throws TransformerException {
        ElemTemplateElement t = elem.getFirstChildElem();
        if (null == t) {
            return;
        }
        if (elem.hasTextLitOnly() && TransformerFactoryImpl.m_optimize) {
            char[] chars = ((ElemTextLiteral)t).getChars();
            try {
                try {
                    this.pushElemTemplateElement(t);
                    this.m_resultTreeHandler.characters(chars, 0, chars.length);
                }
                catch (SAXException se) {
                    throw new TransformerException(se);
                }
                Object var7_6 = null;
                this.popElemTemplateElement();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.popElemTemplateElement();
                throw throwable;
            }
            return;
        }
        XPathContext xctxt = this.m_xcontext;
        xctxt.pushSAXLocatorNull();
        int currentTemplateElementsTop = this.m_currentTemplateElementsTop++;
        try {
            try {
                while (t != null) {
                    if (shouldAddAttrs || t.getXSLToken() != 48) {
                        xctxt.setSAXLocator(t);
                        this.m_currentTemplateElements[currentTemplateElementsTop] = t;
                        t.execute(this);
                    }
                    t = t.getNextSiblingElem();
                }
            }
            catch (RuntimeException re) {
                TransformerException te = new TransformerException(re);
                te.setLocator(t);
                throw te;
            }
            Object var9_13 = null;
            --this.m_currentTemplateElementsTop;
            xctxt.popSAXLocator();
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            --this.m_currentTemplateElementsTop;
            xctxt.popSAXLocator();
            throw throwable;
        }
    }

    public Vector processSortKeys(ElemForEach foreach, int sourceNodeContext) throws TransformerException {
        Vector<NodeSortKey> keys = null;
        XPathContext xctxt = this.m_xcontext;
        int nElems = foreach.getSortElemCount();
        if (nElems > 0) {
            keys = new Vector<NodeSortKey>();
        }
        int i = 0;
        while (i < nElems) {
            boolean caseOrderUpper;
            ElemSort sort = foreach.getSortElem(i);
            if (S_DEBUG) {
                this.getTraceManager().fireTraceEvent(sort);
            }
            String langString = null != sort.getLang() ? sort.getLang().evaluate(xctxt, sourceNodeContext, foreach) : null;
            String dataTypeString = sort.getDataType().evaluate(xctxt, sourceNodeContext, foreach);
            if (dataTypeString.indexOf(":") >= 0) {
                System.out.println("TODO: Need to write the hooks for QNAME sort data type");
            } else if (!dataTypeString.equalsIgnoreCase("text") && !dataTypeString.equalsIgnoreCase("number")) {
                foreach.error(93, new Object[]{"data-type", dataTypeString});
            }
            boolean treatAsNumbers = null != dataTypeString && dataTypeString.equals("number");
            String orderString = sort.getOrder().evaluate(xctxt, sourceNodeContext, foreach);
            if (!orderString.equalsIgnoreCase("ascending") && !orderString.equalsIgnoreCase("descending")) {
                foreach.error(93, new Object[]{"order", orderString});
            }
            boolean descending = null != orderString && orderString.equals("descending");
            AVT caseOrder = sort.getCaseOrder();
            if (null != caseOrder) {
                String caseOrderString = caseOrder.evaluate(xctxt, sourceNodeContext, foreach);
                if (!caseOrderString.equalsIgnoreCase("upper-first") && !caseOrderString.equalsIgnoreCase("lower-first")) {
                    foreach.error(93, new Object[]{"case-order", caseOrderString});
                }
                caseOrderUpper = null != caseOrderString && caseOrderString.equals("upper-first");
            } else {
                caseOrderUpper = false;
            }
            keys.addElement(new NodeSortKey(this, sort.getSelect(), treatAsNumbers, descending, langString, caseOrderUpper, foreach));
            if (S_DEBUG) {
                this.getTraceManager().fireTraceEndEvent(sort);
            }
            ++i;
        }
        return keys;
    }

    public Vector getElementCallstack() {
        Vector<ElemTemplateElement> elems = new Vector<ElemTemplateElement>();
        int nStackSize = this.m_currentTemplateElementsTop;
        int i = 0;
        while (i < nStackSize) {
            ElemTemplateElement elem = this.m_currentTemplateElements[i];
            if (null != elem) {
                elems.addElement(elem);
            }
            ++i;
        }
        return elems;
    }

    public int getCurrentTemplateElementsCount() {
        return this.m_currentTemplateElementsTop;
    }

    public ElemTemplateElement[] getCurrentTemplateElements() {
        return this.m_currentTemplateElements;
    }

    public void pushElemTemplateElement(ElemTemplateElement elem) {
        this.m_currentTemplateElements[this.m_currentTemplateElementsTop++] = elem;
    }

    public void popElemTemplateElement() {
        --this.m_currentTemplateElementsTop;
    }

    public void setCurrentElement(ElemTemplateElement e) {
        this.m_currentTemplateElements[this.m_currentTemplateElementsTop - 1] = e;
    }

    public ElemTemplateElement getCurrentElement() {
        return this.m_currentTemplateElementsTop > 0 ? this.m_currentTemplateElements[this.m_currentTemplateElementsTop - 1] : null;
    }

    public int getCurrentNode() {
        return this.m_xcontext.getCurrentNode();
    }

    public Vector getTemplateCallstack() {
        Vector<ElemTemplateElement> elems = new Vector<ElemTemplateElement>();
        int nStackSize = this.m_currentTemplateElementsTop;
        int i = 0;
        while (i < nStackSize) {
            ElemTemplateElement elem = this.m_currentTemplateElements[i];
            if (null != elem && elem.getXSLToken() != 19) {
                elems.addElement(elem);
            }
            ++i;
        }
        return elems;
    }

    public ElemTemplate getCurrentTemplate() {
        ElemTemplateElement elem = this.getCurrentElement();
        while (null != elem && elem.getXSLToken() != 19) {
            elem = elem.getParentElem();
        }
        return (ElemTemplate)elem;
    }

    public void pushPairCurrentMatched(ElemTemplateElement template, int child) {
        this.m_currentMatchTemplates.push(template);
        this.m_currentMatchedNodes.push(child);
    }

    public void popCurrentMatched() {
        this.m_currentMatchTemplates.pop();
        this.m_currentMatchedNodes.pop();
    }

    public ElemTemplate getMatchedTemplate() {
        return (ElemTemplate)this.m_currentMatchTemplates.peek();
    }

    public int getMatchedNode() {
        return this.m_currentMatchedNodes.peepTail();
    }

    public DTMIterator getContextNodeList() {
        try {
            DTMIterator cnl = this.m_xcontext.getContextNodeList();
            return cnl == null ? null : cnl.cloneWithReset();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public Transformer getTransformer() {
        return this;
    }

    public void setStylesheet(StylesheetRoot stylesheetRoot) {
        this.m_stylesheetRoot = stylesheetRoot;
    }

    public final StylesheetRoot getStylesheet() {
        return this.m_stylesheetRoot;
    }

    public boolean getQuietConflictWarnings() {
        return this.m_quietConflictWarnings;
    }

    public void setQuietConflictWarnings(boolean b) {
        this.m_quietConflictWarnings = b;
    }

    public void setXPathContext(XPathContext xcontext) {
        this.m_xcontext = xcontext;
    }

    public final XPathContext getXPathContext() {
        return this.m_xcontext;
    }

    public StackGuard getStackGuard() {
        return this.m_stackGuard;
    }

    public int getRecursionLimit() {
        return this.m_stackGuard.getRecursionLimit();
    }

    public void setRecursionLimit(int limit) {
        this.m_stackGuard.setRecursionLimit(limit);
    }

    public ResultTreeHandler getResultTreeHandler() {
        return this.m_resultTreeHandler;
    }

    public KeyManager getKeyManager() {
        return this.m_keyManager;
    }

    public boolean isRecursiveAttrSet(ElemAttributeSet attrSet) {
        int loc;
        if (null == this.m_attrSetStack) {
            this.m_attrSetStack = new Stack();
        }
        return !this.m_attrSetStack.empty() && (loc = this.m_attrSetStack.search(attrSet)) > -1;
    }

    public void pushElemAttributeSet(ElemAttributeSet attrSet) {
        this.m_attrSetStack.push(attrSet);
    }

    public void popElemAttributeSet() {
        this.m_attrSetStack.pop();
    }

    public CountersTable getCountersTable() {
        if (null == this.m_countersTable) {
            this.m_countersTable = new CountersTable();
        }
        return this.m_countersTable;
    }

    public boolean currentTemplateRuleIsNull() {
        return !this.m_currentTemplateRuleIsNull.isEmpty() && this.m_currentTemplateRuleIsNull.peek();
    }

    public void pushCurrentTemplateRuleIsNull(boolean b) {
        this.m_currentTemplateRuleIsNull.push(b);
    }

    public void popCurrentTemplateRuleIsNull() {
        this.m_currentTemplateRuleIsNull.pop();
    }

    public MsgMgr getMsgMgr() {
        if (null == this.m_msgMgr) {
            this.m_msgMgr = new MsgMgr(this);
        }
        return this.m_msgMgr;
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (listener == null) {
                throw new IllegalArgumentException(XSLMessages.createMessage(151, null));
            }
            this.m_errorHandler = listener;
        }
    }

    public ErrorListener getErrorListener() {
        return this.m_errorHandler;
    }

    public TraceManager getTraceManager() {
        return this.m_traceManager;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/trax/features/sax/input".equals(name)) {
            return true;
        }
        if ("http://xml.org/trax/features/dom/input".equals(name)) {
            return true;
        }
        throw new SAXNotRecognizedException(name);
    }

    public QName getMode() {
        return this.m_modes.isEmpty() ? null : (QName)this.m_modes.peek();
    }

    public void pushMode(QName mode) {
        this.m_modes.push(mode);
    }

    public void popMode() {
        this.m_modes.pop();
    }

    public static void setThreadControler(ThreadControler tp) {
        tpool = tp;
    }

    public void runTransformThread(int priority) {
        Thread t = tpool.run(this, priority);
        this.setTransformThread(t);
    }

    public void runTransformThread() {
        tpool.run(this, -1);
    }

    public static void runTransformThread(Runnable runnable) {
        tpool.run(runnable, -1);
    }

    public void waitTransformThread() throws SAXException {
        Thread transformThread = this.getTransformThread();
        if (null != transformThread) {
            try {
                Exception e;
                tpool.waitThread(transformThread, this);
                if (!this.hasTransformThreadErrorCatcher() && null != (e = this.getExceptionThrown())) {
                    e.printStackTrace();
                    throw new SAXException(e);
                }
                this.setTransformThread(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Exception getExceptionThrown() {
        return this.m_exceptionThrown;
    }

    public void setExceptionThrown(Exception e) {
        this.m_exceptionThrown = e;
    }

    public void setSourceTreeDocForThread(int doc) {
        this.m_doc = doc;
    }

    public void setXMLSource(Source source) {
        this.m_xmlSource = source;
    }

    public boolean isTransformDone() {
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            boolean bl = this.m_isTransformDone;
            return bl;
        }
    }

    public void setIsTransformDone(boolean done) {
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            this.m_isTransformDone = done;
        }
    }

    void postExceptionFromThread(Exception e) {
        ContentHandler ch = this.getContentHandler();
        this.m_isTransformDone = true;
        this.m_exceptionThrown = e;
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            this.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.m_hasBeenReset = false;
        try {
            try {
                try {
                    this.m_isTransformDone = false;
                    this.transformNode(this.m_doc);
                }
                catch (Exception e) {
                    if (null == this.m_transformThread) throw new RuntimeException(e.getMessage());
                    this.postExceptionFromThread(e);
                    Object var3_2 = null;
                    this.m_isTransformDone = true;
                    if (!(this.m_inputContentHandler instanceof TransformerHandlerImpl)) return;
                    ((TransformerHandlerImpl)this.m_inputContentHandler).clearCoRoutine();
                    return;
                }
                Object var3_1 = null;
                this.m_isTransformDone = true;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.m_isTransformDone = true;
                if (!(this.m_inputContentHandler instanceof TransformerHandlerImpl)) throw throwable;
                ((TransformerHandlerImpl)this.m_inputContentHandler).clearCoRoutine();
                throw throwable;
            }
            if (!(this.m_inputContentHandler instanceof TransformerHandlerImpl)) return;
            ((TransformerHandlerImpl)this.m_inputContentHandler).clearCoRoutine();
            return;
        }
        catch (Exception e) {
            if (null == this.m_transformThread) throw new RuntimeException(e.getMessage());
            this.postExceptionFromThread(e);
            return;
        }
    }

    public TransformSnapshot getSnapshot() {
        return new TransformSnapshotImpl(this);
    }

    public void executeFromSnapshot(TransformSnapshot ts) throws TransformerException {
        ElemTemplate template = this.getMatchedTemplate();
        int child = this.getMatchedNode();
        this.pushElemTemplateElement(template);
        this.m_xcontext.pushCurrentNode(child);
        this.executeChildTemplates((ElemTemplateElement)template, true);
    }

    public void resetToStylesheet(TransformSnapshot ts) {
        ((TransformSnapshotImpl)ts).apply(this);
    }

    public void stopTransformation() {
    }

    public short getShouldStripSpace(int elementHandle, DTM dtm) {
        try {
            WhiteSpaceInfo info = this.m_stylesheetRoot.getWhiteSpaceInfo(this.m_xcontext, elementHandle, dtm);
            if (null == info) {
                return 3;
            }
            return info.getShouldStripSpace() ? (short)2 : 1;
        }
        catch (TransformerException se) {
            return 3;
        }
    }

    public static class ThreadControler {
        public Thread run(Runnable task, int priority) {
            Thread t = new Thread(task);
            t.start();
            return t;
        }

        public void waitThread(Thread worker, Runnable task) throws InterruptedException {
            worker.join();
        }
    }
}

