/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateTimestampsCache {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cache$UpdateTimestampsCache == null ? (class$net$sf$hibernate$cache$UpdateTimestampsCache = UpdateTimestampsCache.class$("net.sf.hibernate.cache.UpdateTimestampsCache")) : class$net$sf$hibernate$cache$UpdateTimestampsCache));
    private Cache updateTimestamps;
    public static final String REGION_NAME = (class$net$sf$hibernate$cache$UpdateTimestampsCache == null ? (class$net$sf$hibernate$cache$UpdateTimestampsCache = UpdateTimestampsCache.class$("net.sf.hibernate.cache.UpdateTimestampsCache")) : class$net$sf$hibernate$cache$UpdateTimestampsCache).getName();
    static /* synthetic */ Class class$net$sf$hibernate$cache$UpdateTimestampsCache;

    public void clear() throws CacheException {
        this.updateTimestamps.clear();
    }

    public UpdateTimestampsCache(CacheProvider provider, Properties props) throws HibernateException {
        log.info((Object)("starting update timestamps cache at region: " + REGION_NAME));
        this.updateTimestamps = provider.buildCache(REGION_NAME, props);
    }

    public synchronized void preinvalidate(Serializable[] spaces) throws CacheException {
        Long ts = new Long(this.updateTimestamps.nextTimestamp() + (long)this.updateTimestamps.getTimeout());
        for (int i = 0; i < spaces.length; ++i) {
            this.updateTimestamps.put(spaces[i], ts);
        }
    }

    public synchronized void invalidate(Serializable[] spaces) throws CacheException {
        Long ts = new Long(this.updateTimestamps.nextTimestamp());
        for (int i = 0; i < spaces.length; ++i) {
            this.updateTimestamps.put(spaces[i], ts);
        }
    }

    public synchronized boolean isUpToDate(Set spaces, Long timestamp) throws HibernateException {
        Iterator iter = spaces.iterator();
        boolean result = true;
        while (iter.hasNext()) {
            Serializable space = (Serializable)iter.next();
            Long lastUpdate = (Long)this.updateTimestamps.get(space);
            if (lastUpdate == null || lastUpdate < timestamp) continue;
            result = false;
        }
        return result;
    }

    public void destroy() {
        try {
            this.updateTimestamps.destroy();
        }
        catch (Exception e) {
            log.warn((Object)"could not destroy UpdateTimestamps cache", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

