/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cfg;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheFactory;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.cfg.Mappings;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.mapping.Any;
import net.sf.hibernate.mapping.Array;
import net.sf.hibernate.mapping.Bag;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.Component;
import net.sf.hibernate.mapping.Fetchable;
import net.sf.hibernate.mapping.Formula;
import net.sf.hibernate.mapping.IdentifierBag;
import net.sf.hibernate.mapping.IdentifierCollection;
import net.sf.hibernate.mapping.IndexedCollection;
import net.sf.hibernate.mapping.List;
import net.sf.hibernate.mapping.ManyToOne;
import net.sf.hibernate.mapping.Map;
import net.sf.hibernate.mapping.MetaAttribute;
import net.sf.hibernate.mapping.NamedSQLQuery;
import net.sf.hibernate.mapping.OneToMany;
import net.sf.hibernate.mapping.OneToOne;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.PrimitiveArray;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.RootClass;
import net.sf.hibernate.mapping.Set;
import net.sf.hibernate.mapping.SimpleValue;
import net.sf.hibernate.mapping.Subclass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.ToOne;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.property.Getter;
import net.sf.hibernate.property.Setter;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.type.ComponentType;
import net.sf.hibernate.type.DynamicComponentType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.ForeignKeyDirection;
import net.sf.hibernate.type.PrimitiveType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

final class Binder {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cfg$Binder == null ? (class$net$sf$hibernate$cfg$Binder = Binder.class$("net.sf.hibernate.cfg.Binder")) : class$net$sf$hibernate$cfg$Binder));
    static /* synthetic */ Class class$net$sf$hibernate$cfg$Binder;
    static /* synthetic */ Class class$net$sf$hibernate$persister$EntityPersister;
    static /* synthetic */ Class class$net$sf$hibernate$persister$NormalizedEntityPersister;
    static /* synthetic */ Class class$java$io$Serializable;

    private Binder() {
    }

    public static void bindClass(Element node, PersistentClass model, Mappings mapping) throws MappingException {
        Attribute sbuNode;
        Attribute batchNode;
        Attribute discriminatorNode;
        boolean lazyTrue;
        String className = node.attributeValue("name");
        try {
            model.setMappedClass(ReflectHelper.classForName(className));
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("persistent class [" + className + "] not found", cnfe);
        }
        Attribute proxyNode = node.attribute("proxy");
        Attribute lazyNode = node.attribute("lazy");
        boolean bl = lazyTrue = lazyNode != null && "true".equals(lazyNode.getValue());
        if (proxyNode != null && (lazyNode == null || lazyTrue)) {
            try {
                model.setProxyInterface(ReflectHelper.classForName(proxyNode.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException(cnfe);
            }
        }
        if (proxyNode == null && lazyTrue) {
            model.setProxyInterface(model.getMappedClass());
        }
        model.setDiscriminatorValue((discriminatorNode = node.attribute("discriminator-value")) == null ? model.getName() : discriminatorNode.getValue());
        Attribute dynamicNode = node.attribute("dynamic-update");
        model.setDynamicUpdate(dynamicNode == null ? false : "true".equals(dynamicNode.getValue()));
        Attribute insertNode = node.attribute("dynamic-insert");
        model.setDynamicInsert(insertNode == null ? false : "true".equals(insertNode.getValue()));
        if (mapping.isAutoImport()) {
            mapping.addImport(className, StringHelper.unqualify(className));
        }
        if ((batchNode = node.attribute("batch-size")) != null) {
            model.setBatchSize(Integer.parseInt(batchNode.getValue()));
        }
        if ((sbuNode = node.attribute("select-before-update")) != null) {
            model.setSelectBeforeUpdate("true".equals(sbuNode.getValue()));
        }
        Attribute olNode = node.attribute("optimistic-lock");
        model.setOptimisticLockMode(Binder.getOptimisticLockMode(olNode));
        model.setMetaAttributes(Binder.getMetas(node));
        Attribute persisterNode = node.attribute("persister");
        if (persisterNode != null) {
            try {
                model.setClassPersisterClass(ReflectHelper.classForName(persisterNode.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("Could not find persister class: " + persisterNode.getValue());
            }
        }
    }

    public static void bindSubclass(Element node, Subclass model, Mappings mappings) throws MappingException {
        Binder.bindClass(node, model, mappings);
        if (model.getClassPersisterClass() == null) {
            model.getRootClass().setClassPersisterClass(class$net$sf$hibernate$persister$EntityPersister == null ? (class$net$sf$hibernate$persister$EntityPersister = Binder.class$("net.sf.hibernate.persister.EntityPersister")) : class$net$sf$hibernate$persister$EntityPersister);
        }
        model.setTable(model.getSuperclass().getTable());
        log.info((Object)("Mapping subclass: " + model.getName() + " -> " + model.getTable().getName()));
        Binder.propertiesFromXML(node, model, mappings);
    }

    public static void bindJoinedSubclass(Element node, Subclass model, Mappings mappings) throws MappingException {
        Attribute tableNameNode;
        Binder.bindClass(node, model, mappings);
        if (model.getClassPersisterClass() == null) {
            model.getRootClass().setClassPersisterClass(class$net$sf$hibernate$persister$NormalizedEntityPersister == null ? (class$net$sf$hibernate$persister$NormalizedEntityPersister = Binder.class$("net.sf.hibernate.persister.NormalizedEntityPersister")) : class$net$sf$hibernate$persister$NormalizedEntityPersister);
        }
        String tableName = (tableNameNode = node.attribute("table")) == null ? StringHelper.unqualify(model.getMappedClass().getName()) : tableNameNode.getValue();
        Attribute schemaNode = node.attribute("schema");
        String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
        Table mytable = mappings.addTable(schema, tableName);
        model.setTable(mytable);
        log.info((Object)("Mapping joined-subclass: " + model.getName() + " -> " + model.getTable().getName()));
        Element keyNode = node.element("key");
        SimpleValue key = new SimpleValue(mytable);
        model.setKey(key);
        Binder.bindSimpleValue(keyNode, key, false, model.getName());
        model.getKey().setType(model.getIdentifier().getType());
        model.createPrimaryKey();
        model.createForeignKey();
        Binder.propertiesFromXML(node, model, mappings);
    }

    public static void bindRootClass(Element node, RootClass model, Mappings mappings) throws MappingException {
        Attribute polyNode;
        Binder.bindClass(node, model, mappings);
        Attribute tableNameNode = node.attribute("table");
        String tableName = tableNameNode == null ? StringHelper.unqualify(model.getMappedClass().getName()) : tableNameNode.getValue();
        Attribute schemaNode = node.attribute("schema");
        String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
        Table table = mappings.addTable(schema, tableName);
        model.setTable(table);
        log.info((Object)("Mapping class: " + model.getName() + " -> " + model.getTable().getName()));
        Attribute mutableNode = node.attribute("mutable");
        model.setMutable(mutableNode == null || mutableNode.getValue().equals("true"));
        Attribute whereNode = node.attribute("where");
        if (whereNode != null) {
            model.setWhere(whereNode.getValue());
        }
        model.setExplicitPolymorphism((polyNode = node.attribute("polymorphism")) != null && polyNode.getValue().equals("explicit"));
        Iterator subnodes = node.elementIterator();
        while (subnodes.hasNext()) {
            Property prop;
            SimpleValue id;
            Element subnode = (Element)subnodes.next();
            String name = subnode.getName();
            String propertyName = Binder.getPropertyName(subnode);
            if ("id".equals(name)) {
                id = new SimpleValue(table);
                model.setIdentifier(id);
                if (propertyName == null) {
                    Binder.bindSimpleValue(subnode, id, false, "id");
                    if (id.getType() == null) {
                        throw new MappingException("must specify an identifier type: " + model.getMappedClass().getName());
                    }
                    model.setIdentifierProperty(null);
                } else {
                    Binder.bindSimpleValue(subnode, id, false, propertyName);
                    id.setTypeByReflection(model.getMappedClass(), propertyName);
                    prop = new Property(id);
                    Binder.bindProperty(subnode, prop, mappings);
                    model.setIdentifierProperty(prop);
                }
                if (id.getType().getReturnedClass().isArray()) {
                    throw new MappingException("illegal use of an array as an identifier (arrays don't reimplement equals)");
                }
                Binder.makeIdentifier(subnode, id, mappings);
                continue;
            }
            if ("composite-id".equals(name)) {
                id = new Component(model);
                model.setIdentifier(id);
                if (propertyName == null) {
                    Binder.bindComponent(subnode, (Component)id, null, model.getName() + ".id", false, mappings);
                    model.setEmbeddedIdentifier(((Component)id).isEmbedded());
                    model.setIdentifierProperty(null);
                } else {
                    Class reflectedClass = ReflectHelper.reflectedPropertyClass(model.getMappedClass(), propertyName);
                    Binder.bindComponent(subnode, (Component)id, reflectedClass, StringHelper.qualify(model.getName(), propertyName), false, mappings);
                    Property prop2 = new Property(id);
                    Binder.bindProperty(subnode, prop2, mappings);
                    model.setIdentifierProperty(prop2);
                }
                Binder.makeIdentifier(subnode, id, mappings);
                Class idClass = ((Component)id).getComponentClass();
                if (!ReflectHelper.overridesEquals(idClass)) {
                    throw new MappingException("composite-id class must override equals() and hashCode(): " + ((Component)id).getComponentClass().getName());
                }
                if ((class$java$io$Serializable == null ? Binder.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(idClass)) continue;
                throw new MappingException("composite-id class must implement Serializable: " + ((Component)id).getComponentClass().getName());
            }
            if ("version".equals(name) || "timestamp".equals(name)) {
                SimpleValue val = new SimpleValue(table);
                Binder.bindSimpleValue(subnode, val, false, propertyName);
                if (val.getType() == null) {
                    val.setType("version".equals(name) ? Hibernate.INTEGER : Hibernate.TIMESTAMP);
                }
                prop = new Property(val);
                Binder.bindProperty(subnode, prop, mappings);
                Binder.makeVersion(subnode, val);
                model.setVersion(prop);
                model.addNewProperty(prop);
                continue;
            }
            if ("discriminator".equals(name)) {
                SimpleValue discrim = new SimpleValue(table);
                model.setDiscriminator(discrim);
                Binder.bindSimpleValue(subnode, discrim, false, "class");
                if (discrim.getType() == null) {
                    discrim.setType(Hibernate.STRING);
                    ((Column)discrim.getColumnIterator().next()).setType(Hibernate.STRING);
                }
                model.setPolymorphic(true);
                if (!"true".equals(subnode.attributeValue("force"))) continue;
                model.setForceDiscriminator(true);
                continue;
            }
            if (!"jcs-cache".equals(name) && !"cache".equals(name)) continue;
            String className = model.getMappedClass().getName();
            CacheConcurrencyStrategy cache = CacheFactory.createCache(subnode, className, model.isMutable());
            mappings.addCache(className, cache);
            model.setCache(cache);
        }
        model.createPrimaryKey();
        Binder.propertiesFromXML(node, model, mappings);
    }

    public static void bindColumns(Element node, SimpleValue model, boolean isNullable, boolean autoColumn, String defaultColumnName) {
        Column col;
        Attribute columnNode = node.attribute("column");
        if (columnNode == null) {
            Iterator iter = node.elementIterator("column");
            int count = 0;
            while (iter.hasNext()) {
                Attribute uniqueNode;
                Element subnode = (Element)iter.next();
                Table table = model.getTable();
                Column col2 = new Column(model.getType(), count++);
                Binder.bindColumn(subnode, col2, isNullable);
                col2.setName(subnode.attributeValue("name"));
                if (table != null) {
                    table.addColumn(col2);
                }
                model.addColumn(col2);
                Attribute indexNode = subnode.attribute("index");
                if (indexNode != null && table != null) {
                    table.getIndex(indexNode.getValue()).addColumn(col2);
                }
                if ((uniqueNode = subnode.attribute("unique-key")) == null || table == null) continue;
                table.getUniqueKey(uniqueNode.getValue()).addColumn(col2);
            }
        } else {
            col = new Column(model.getType(), 0);
            Binder.bindColumn(node, col, isNullable);
            col.setName(columnNode.getValue());
            Table table = model.getTable();
            if (table != null) {
                table.addColumn(col);
            }
            model.addColumn(col);
        }
        if (autoColumn && model.getColumnSpan() == 0) {
            col = new Column(model.getType(), 0);
            Binder.bindColumn(node, col, isNullable);
            col.setName(defaultColumnName);
            model.getTable().addColumn(col);
            model.addColumn(col);
        }
    }

    public static void bindSimpleValue(Element node, SimpleValue model, boolean isNullable, String defaultColumnName) throws MappingException {
        model.setType(Binder.getTypeFromXML(node));
        Attribute formulaNode = node.attribute("formula");
        if (formulaNode != null) {
            Formula f = new Formula();
            f.setFormula(formulaNode.getText());
            model.setFormula(f);
        } else {
            Binder.bindColumns(node, model, isNullable, true, defaultColumnName);
        }
        Attribute fkNode = node.attribute("foreign-key");
        if (fkNode != null) {
            model.setForeignKeyName(fkNode.getValue());
        }
    }

    public static void bindProperty(Element node, Property model, Mappings mappings) throws MappingException {
        Attribute cascadeNode;
        model.setName(Binder.getPropertyName(node));
        Type type = model.getValue().getType();
        if (type == null) {
            throw new MappingException("Could not determine a property type for: " + model.getName());
        }
        Attribute accessNode = node.attribute("access");
        if (accessNode != null) {
            model.setPropertyAccessorName(accessNode.getValue());
        }
        model.setCascade((cascadeNode = node.attribute("cascade")) == null ? mappings.getDefaultCascade() : cascadeNode.getValue());
        Attribute updateNode = node.attribute("update");
        model.setUpdateable(updateNode == null ? true : "true".equals(updateNode.getValue()));
        Attribute insertNode = node.attribute("insert");
        model.setInsertable(insertNode == null ? true : "true".equals(insertNode.getValue()));
        if (log.isDebugEnabled()) {
            String msg = "Mapped property: " + model.getName();
            String columns = Binder.columns(model.getValue());
            if (columns.length() > 0) {
                msg = msg + " -> " + columns;
            }
            if (model.getType() != null) {
                msg = msg + ", type: " + model.getType().getName();
            }
            log.debug((Object)msg);
        }
        model.setMetaAttributes(Binder.getMetas(node));
    }

    private static String columns(Value val) {
        StringBuffer columns = new StringBuffer();
        Iterator iter = val.getColumnIterator();
        while (iter.hasNext()) {
            columns.append(((Column)iter.next()).getName());
            if (!iter.hasNext()) continue;
            columns.append(", ");
        }
        return columns.toString();
    }

    public static void bindCollection(Element node, Collection model, String prefix, Mappings mappings) throws MappingException {
        Attribute sortedAtt;
        Attribute persisterNode;
        Attribute batchNode;
        Attribute whereNode;
        Attribute orderNode;
        String propertyName = node.attributeValue("name");
        model.setRole(StringHelper.qualify(prefix, propertyName));
        Attribute inverseNode = node.attribute("inverse");
        if (inverseNode != null) {
            model.setInverse(StringHelper.booleanValue(inverseNode.getValue()));
        }
        if ((orderNode = node.attribute("order-by")) != null) {
            if (Environment.jvmSupportsLinkedHashCollections() || model instanceof Bag) {
                model.setOrderBy(orderNode.getValue());
            } else {
                log.warn((Object)"Attribute \"order-by\" ignored in JDK1.3 or less");
            }
        }
        if ((whereNode = node.attribute("where")) != null) {
            model.setWhere(whereNode.getValue());
        }
        if ((batchNode = node.attribute("batch-size")) != null) {
            model.setBatchSize(Integer.parseInt(batchNode.getValue()));
        }
        if ((persisterNode = node.attribute("persister")) != null) {
            try {
                model.setCollectionPersisterClass(ReflectHelper.classForName(persisterNode.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("Could not find collection persister class: " + persisterNode.getValue());
            }
        }
        Binder.initOuterJoinFetchSetting(node, model);
        Element oneToManyNode = node.element("one-to-many");
        if (oneToManyNode != null) {
            OneToMany oneToMany = new OneToMany(model.getOwner());
            model.setElement(oneToMany);
            Binder.bindOneToMany(oneToManyNode, oneToMany);
        } else {
            Attribute tableNode = node.attribute("table");
            String tableName = tableNode != null ? tableNode.getValue() : propertyName;
            Attribute schemaNode = node.attribute("schema");
            String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
            model.setCollectionTable(mappings.addTable(schema, tableName));
            log.info((Object)("Mapping collection: " + model.getRole() + " -> " + model.getCollectionTable().getName()));
        }
        Attribute lazyNode = node.attribute("lazy");
        if (lazyNode != null) {
            model.setLazy(StringHelper.booleanValue(lazyNode.getValue()));
        }
        if ((sortedAtt = node.attribute("sort")) == null || sortedAtt.getValue().equals("unsorted")) {
            model.setSorted(false);
        } else {
            model.setSorted(true);
            String className = sortedAtt.getValue();
            if (!className.equals("natural")) {
                try {
                    model.setComparator((Comparator)ReflectHelper.classForName(className).newInstance());
                }
                catch (Exception e) {
                    throw new MappingException("Could not instantiate comparator class: " + className);
                }
            }
        }
        Attribute cascadeAtt = node.attribute("cascade");
        if (cascadeAtt != null && cascadeAtt.getValue().equals("all-delete-orphan")) {
            model.setOrphanDelete(true);
        }
        if (model instanceof List) {
            mappings.addSecondPass(new ListSecondPass(node, mappings, (List)model));
        } else if (model instanceof Map) {
            mappings.addSecondPass(new MapSecondPass(node, mappings, (Map)model));
        } else if (model instanceof IdentifierCollection) {
            mappings.addSecondPass(new IdentifierCollectionSecondPass(node, mappings, (IdentifierCollection)model));
        } else {
            mappings.addSecondPass(new CollectionSecondPass(node, mappings, model));
        }
    }

    public static void bindManyToOne(Element node, ManyToOne model, String defaultColumnName, boolean isNullable, Mappings mappings) throws MappingException {
        Attribute fkNode;
        Attribute typeNode;
        Binder.bindColumns(node, model, isNullable, true, defaultColumnName);
        Binder.initOuterJoinFetchSetting(node, model);
        Attribute ukName = node.attribute("property-ref");
        if (ukName != null) {
            model.setReferencedPropertyName(ukName.getValue());
        }
        if ((typeNode = node.attribute("class")) != null) {
            try {
                model.setType(TypeFactory.manyToOne(ReflectHelper.classForName(typeNode.getValue()), model.getReferencedPropertyName()));
            }
            catch (Exception e) {
                throw new MappingException("Could not find class: " + typeNode.getValue());
            }
        }
        if ((fkNode = node.attribute("foreign-key")) != null) {
            model.setForeignKeyName(node.attributeValue("foreign-key"));
        }
    }

    public static void bindAny(Element node, Any model, boolean isNullable) throws MappingException {
        model.setIdentifierType(Binder.getTypeFromXML(node));
        Attribute metaAttribute = node.attribute("meta-type");
        if (metaAttribute != null) {
            Type metaType = TypeFactory.heuristicType(metaAttribute.getValue());
            if (metaType == null) {
                throw new MappingException("could not interpret meta-type");
            }
            model.setMetaType(metaType);
        }
        Binder.bindColumns(node, model, isNullable, false, null);
    }

    public static void bindOneToOne(Element node, OneToOne model, boolean isNullable, Mappings mappings) throws MappingException {
        Attribute typeNode;
        Attribute ukName;
        Binder.bindColumns(node, model, isNullable, false, null);
        Binder.initOuterJoinFetchSetting(node, model);
        Attribute constrNode = node.attribute("constrained");
        boolean constrained = constrNode != null && constrNode.getValue().equals("true");
        model.setConstrained(constrained);
        model.setForeignKeyType(constrained ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        Attribute fkNode = node.attribute("foreign-key");
        if (fkNode != null) {
            model.setForeignKeyName(fkNode.getValue());
        }
        if ((ukName = node.attribute("property-ref")) != null) {
            model.setReferencedPropertyName(ukName.getValue());
        }
        if ((typeNode = node.attribute("class")) != null) {
            try {
                model.setType(TypeFactory.oneToOne(ReflectHelper.classForName(typeNode.getValue()), model.getForeignKeyType(), model.getReferencedPropertyName()));
            }
            catch (Exception e) {
                throw new MappingException("Could not find class: " + typeNode.getValue());
            }
        }
    }

    public static void bindOneToMany(Element node, OneToMany model) throws MappingException {
        try {
            model.setType((EntityType)Hibernate.entity(ReflectHelper.classForName(node.attributeValue("class"))));
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("Associated class not found", cnfe);
        }
    }

    public static void bindColumn(Element node, Column model, boolean isNullable) {
        Attribute nullNode;
        Attribute lengthNode = node.attribute("length");
        if (lengthNode != null) {
            model.setLength(Integer.parseInt(lengthNode.getValue()));
        }
        model.setNullable((nullNode = node.attribute("not-null")) != null ? !StringHelper.booleanValue(nullNode.getValue()) : isNullable);
        Attribute unqNode = node.attribute("unique");
        model.setUnique(unqNode != null && StringHelper.booleanValue(unqNode.getValue()));
        Attribute typeNode = node.attribute("sql-type");
        model.setSqlType(typeNode == null ? null : typeNode.getValue());
    }

    public static void bindArray(Element node, Array model, String prefix, Mappings mappings) throws MappingException {
        Binder.bindCollection(node, model, prefix, mappings);
        Attribute att = node.attribute("element-class");
        if (att != null) {
            try {
                model.setElementClass(ReflectHelper.classForName(att.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException(cnfe);
            }
        } else {
            Iterator iter = node.elementIterator();
            while (iter.hasNext()) {
                Element subnode = (Element)iter.next();
                String name = subnode.getName();
                if ("element".equals(name)) {
                    Type type = Binder.getTypeFromXML(subnode);
                    model.setElementClass(model.isPrimitiveArray() ? ((PrimitiveType)type).getPrimitiveClass() : type.getReturnedClass());
                    continue;
                }
                if (!"one-to-many".equals(name) && !"many-to-many".equals(name) && !"composite-element".equals(name)) continue;
                try {
                    model.setElementClass(ReflectHelper.classForName(subnode.attributeValue("class")));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new MappingException(cnfe);
                }
            }
        }
    }

    public static void bindComponent(Element node, Component model, Class reflectedClass, String path, boolean isNullable, Mappings mappings) throws MappingException {
        AbstractType componentType;
        Attribute classNode = node.attribute("class");
        if ("dynamic-component".equals(node.getName())) {
            model.setEmbedded(false);
            model.setDynamic(true);
        } else if (classNode != null) {
            try {
                model.setComponentClass(ReflectHelper.classForName(classNode.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("component class not found", cnfe);
            }
            model.setEmbedded(false);
        } else if (reflectedClass != null) {
            model.setComponentClass(reflectedClass);
            model.setEmbedded(false);
        } else {
            model.setComponentClass(model.getOwner().getMappedClass());
            model.setEmbedded(true);
        }
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            String propertyName = Binder.getPropertyName(subnode);
            String subpath = propertyName == null ? null : StringHelper.qualify(path, propertyName);
            CollectionType collectType = CollectionType.collectionTypeFromString(name);
            Value value = null;
            if (collectType != null) {
                Collection collection = collectType.create(subnode, path, model.getOwner(), mappings);
                mappings.addCollection(collection);
                value = collection;
            } else if ("many-to-one".equals(name) || "key-many-to-one".equals(name)) {
                value = new ManyToOne(model.getTable());
                Binder.bindManyToOne(subnode, value, propertyName, isNullable, mappings);
            } else if ("one-to-one".equals(name)) {
                value = new OneToOne(model.getTable(), model.getOwner().getIdentifier());
                Binder.bindOneToOne(subnode, (OneToOne)value, isNullable, mappings);
            } else if ("any".equals(name)) {
                value = new Any(model.getTable());
                Binder.bindAny(subnode, (Any)value, isNullable);
            } else if ("property".equals(name) || "key-property".equals(name)) {
                value = new SimpleValue(model.getTable());
                Binder.bindSimpleValue(subnode, value, isNullable, propertyName);
            } else if ("component".equals(name) || "dynamic-component".equals(name) || "nested-composite-element".equals(name)) {
                Class subreflectedClass = model.getComponentClass() == null ? null : ReflectHelper.reflectedPropertyClass(model.getComponentClass(), propertyName);
                value = model.getOwner() != null ? new Component(model.getOwner()) : new Component(model.getTable());
                Binder.bindComponent(subnode, (Component)value, subreflectedClass, subpath, isNullable, mappings);
            } else if ("parent".equals(name)) {
                model.setParentProperty(propertyName);
            }
            if (value == null) continue;
            model.addProperty(Binder.createProperty(value, propertyName, model.getComponentClass(), subnode, mappings));
        }
        int span = model.getPropertySpan();
        String[] names = new String[span];
        Type[] types = new Type[span];
        Cascades.CascadeStyle[] cascade = new Cascades.CascadeStyle[span];
        int[] joinedFetch = new int[span];
        iter = model.getPropertyIterator();
        int i = 0;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (prop.isFormula()) {
                throw new MappingException("properties of components may not be formulas: " + prop.getName());
            }
            if (!prop.isInsertable() || !prop.isUpdateable()) {
                throw new MappingException("insert=\"false\", update=\"false\" not supported for properties of components: " + prop.getName());
            }
            names[i] = prop.getName();
            types[i] = prop.getType();
            cascade[i] = prop.getCascadeStyle();
            joinedFetch[i] = prop.getValue().getOuterJoinFetchSetting();
            ++i;
        }
        if (model.isDynamic()) {
            componentType = new DynamicComponentType(names, types, joinedFetch, cascade);
        } else {
            Getter[] getters = new Getter[span];
            Setter[] setters = new Setter[span];
            iter = model.getPropertyIterator();
            boolean foundCustomAccessor = false;
            i = 0;
            while (iter.hasNext()) {
                Property prop = (Property)iter.next();
                setters[i] = prop.getSetter(model.getComponentClass());
                getters[i] = prop.getGetter(model.getComponentClass());
                if (!prop.isBasicPropertyAccessor()) {
                    foundCustomAccessor = true;
                }
                ++i;
            }
            componentType = new ComponentType(model.getComponentClass(), names, getters, setters, foundCustomAccessor, types, joinedFetch, cascade, model.getParentProperty());
        }
        model.setType(componentType);
    }

    private static Type getTypeFromXML(Element node) throws MappingException {
        Attribute typeNode = node.attribute("type");
        if (typeNode == null) {
            typeNode = node.attribute("id-type");
        }
        if (typeNode == null) {
            return null;
        }
        Type type = TypeFactory.heuristicType(typeNode.getValue());
        if (type == null) {
            throw new MappingException("Could not interpret type: " + typeNode.getValue());
        }
        return type;
    }

    private static void initOuterJoinFetchSetting(Element node, Fetchable model) {
        Attribute jfNode = node.attribute("outer-join");
        if (jfNode == null) {
            model.setOuterJoinFetchSetting(0);
        } else {
            String eoj = jfNode.getValue();
            if ("auto".equals(eoj)) {
                model.setOuterJoinFetchSetting(0);
            } else {
                model.setOuterJoinFetchSetting("true".equals(eoj) ? 1 : -1);
            }
        }
    }

    private static void makeIdentifier(Element node, SimpleValue model, Mappings mappings) {
        Element subnode = node.element("generator");
        if (subnode != null) {
            model.setIdentifierGeneratorStrategy(subnode.attributeValue("class"));
            Properties params = new Properties();
            if (mappings.getSchemaName() != null) {
                params.setProperty("schema", mappings.getSchemaName());
            }
            params.setProperty("target_table", model.getTable().getName());
            params.setProperty("target_column", ((Column)model.getColumnIterator().next()).getName());
            Iterator iter = subnode.elementIterator("param");
            while (iter.hasNext()) {
                Element childNode = (Element)iter.next();
                params.setProperty(childNode.attributeValue("name"), childNode.getText());
            }
            model.setIdentifierGeneratorProperties(params);
        }
        model.getTable().setIdentifierValue(model);
        Attribute nullValueNode = node.attribute("unsaved-value");
        if (nullValueNode != null) {
            model.setNullValue(nullValueNode.getValue());
        } else {
            model.setNullValue("null");
        }
    }

    private static final void makeVersion(Element node, SimpleValue model) {
        Attribute nullValueNode = node.attribute("unsaved-value");
        if (nullValueNode != null) {
            model.setNullValue(nullValueNode.getValue());
        } else {
            model.setNullValue("undefined");
        }
    }

    protected static void propertiesFromXML(Element node, PersistentClass model, Mappings mappings) throws MappingException {
        String path = model.getName();
        Table table = model.getTable();
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            String propertyName = Binder.getPropertyName(subnode);
            CollectionType collectType = CollectionType.collectionTypeFromString(name);
            Value value = null;
            if (collectType != null) {
                Collection collection = collectType.create(subnode, path, model, mappings);
                mappings.addCollection(collection);
                value = collection;
            } else if ("many-to-one".equals(name)) {
                value = new ManyToOne(table);
                Binder.bindManyToOne(subnode, value, propertyName, true, mappings);
            } else if ("any".equals(name)) {
                value = new Any(table);
                Binder.bindAny(subnode, (Any)value, true);
            } else if ("one-to-one".equals(name)) {
                OneToOne oneToOne = new OneToOne(table, model.getIdentifier());
                Binder.bindOneToOne(subnode, oneToOne, true, mappings);
                value = oneToOne;
            } else if ("property".equals(name)) {
                value = new SimpleValue(table);
                Binder.bindSimpleValue(subnode, value, true, propertyName);
            } else if ("component".equals(name) || "dynamic-component".equals(name)) {
                String subpath = StringHelper.qualify(path, propertyName);
                Class reflectedClass = ReflectHelper.reflectedPropertyClass(model.getMappedClass(), propertyName);
                value = new Component(model);
                Binder.bindComponent(subnode, (Component)value, reflectedClass, subpath, true, mappings);
            } else if ("subclass".equals(name)) {
                Binder.handleSubclass(model, mappings, subnode);
            } else if ("joined-subclass".equals(name)) {
                Binder.handleJoinedSubclass(model, mappings, subnode);
            }
            if (value == null) continue;
            model.addNewProperty(Binder.createProperty(value, propertyName, model.getMappedClass(), subnode, mappings));
        }
    }

    private static Property createProperty(Value value, String propertyName, Class parentClass, Element subnode, Mappings mappings) throws MappingException {
        String propertyRef;
        if (parentClass != null && value.isSimpleValue()) {
            ((SimpleValue)value).setTypeByReflection(parentClass, propertyName);
        }
        if (value instanceof ToOne && (propertyRef = ((ToOne)value).getReferencedPropertyName()) != null) {
            mappings.addUniquePropertyReference(((EntityType)value.getType()).getAssociatedClass(), propertyRef);
        }
        value.createForeignKey();
        Property prop = new Property(value);
        Binder.bindProperty(subnode, prop, mappings);
        return prop;
    }

    private static void handleJoinedSubclass(PersistentClass model, Mappings mappings, Element subnode) throws MappingException {
        Subclass subclass = new Subclass(model);
        Binder.bindJoinedSubclass(subnode, subclass, mappings);
        model.addSubclass(subclass);
        mappings.addClass(subclass);
    }

    private static void handleSubclass(PersistentClass model, Mappings mappings, Element subnode) throws MappingException {
        Subclass subclass = new Subclass(model);
        Binder.bindSubclass(subnode, subclass, mappings);
        model.addSubclass(subclass);
        mappings.addClass(subclass);
    }

    public static void bindListSecondPass(Element node, List model, java.util.Map classes, Mappings mappings) throws MappingException {
        Binder.bindCollectionSecondPass(node, model, classes, mappings);
        Element subnode = node.element("index");
        SimpleValue iv = new SimpleValue(model.getCollectionTable());
        Binder.bindSimpleValue(subnode, iv, model.isOneToMany(), "idx");
        iv.setType(Hibernate.INTEGER);
        model.setIndex(iv);
    }

    public static void bindIdentifierCollectionSecondPass(Element node, IdentifierCollection model, java.util.Map persistentClasses, Mappings mappings) throws MappingException {
        Binder.bindCollectionSecondPass(node, model, persistentClasses, mappings);
        Element subnode = node.element("collection-id");
        SimpleValue id = new SimpleValue(model.getCollectionTable());
        Binder.bindSimpleValue(subnode, id, false, "id");
        model.setIdentifier(id);
        Binder.makeIdentifier(subnode, id, mappings);
    }

    public static void bindMapSecondPass(Element node, Map model, java.util.Map classes, Mappings mappings) throws MappingException {
        Binder.bindCollectionSecondPass(node, model, classes, mappings);
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            if ("index".equals(name)) {
                SimpleValue value = new SimpleValue(model.getCollectionTable());
                Binder.bindSimpleValue(subnode, value, model.isOneToMany(), "idx");
                model.setIndex(value);
                if (model.getIndex().getType() != null) continue;
                throw new MappingException("map index element must specify a type");
            }
            if ("index-many-to-many".equals(name)) {
                ManyToOne mto = new ManyToOne(model.getCollectionTable());
                Binder.bindManyToOne(subnode, mto, "idx", model.isOneToMany(), mappings);
                model.setIndex(mto);
                continue;
            }
            if ("composite-index".equals(name)) {
                Component component = new Component(model.getCollectionTable());
                Binder.bindComponent(subnode, component, null, model.getRole() + ".index", model.isOneToMany(), mappings);
                model.setIndex(component);
                continue;
            }
            if (!"index-many-to-any".equals(name)) continue;
            Any any = new Any(model.getCollectionTable());
            Binder.bindAny(subnode, any, model.isOneToMany());
            model.setIndex(any);
        }
    }

    public static void bindCollectionSecondPass(Element node, Collection model, java.util.Map persistentClasses, Mappings mappings) throws MappingException {
        if (model.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)model.getElement();
            Class assocClass = oneToMany.getEntityType().getAssociatedClass();
            PersistentClass persistentClass = (PersistentClass)persistentClasses.get(assocClass);
            if (persistentClass == null) {
                throw new MappingException("Association references unmapped class: " + assocClass.getName());
            }
            oneToMany.setAssociatedClass(persistentClass);
            model.setCollectionTable(persistentClass.getTable());
            log.info((Object)("Mapping collection: " + model.getRole() + " -> " + model.getCollectionTable().getName()));
        }
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            SimpleValue element;
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            if ("key".equals(name)) {
                SimpleValue key = new SimpleValue(model.getCollectionTable());
                Binder.bindSimpleValue(subnode, key, model.isOneToMany(), "id");
                key.setType(model.getOwner().getIdentifier().getType());
                if (key.getType().getReturnedClass().isArray()) {
                    throw new MappingException("illegal use of an array as an identifier (arrays don't reimplement equals)");
                }
                model.setKey(key);
                continue;
            }
            if ("element".equals(name)) {
                SimpleValue elt = new SimpleValue(model.getCollectionTable());
                model.setElement(elt);
                Binder.bindSimpleValue(subnode, elt, true, "elt");
                continue;
            }
            if ("many-to-many".equals(name)) {
                element = new ManyToOne(model.getCollectionTable());
                model.setElement(element);
                Binder.bindManyToOne(subnode, element, "elt", false, mappings);
                continue;
            }
            if ("composite-element".equals(name)) {
                element = new Component(model.getCollectionTable());
                model.setElement(element);
                Binder.bindComponent(subnode, (Component)element, null, model.getRole() + ".element", true, mappings);
                continue;
            }
            if ("many-to-any".equals(name)) {
                element = new Any(model.getCollectionTable());
                model.setElement(element);
                Binder.bindAny(subnode, (Any)element, true);
                continue;
            }
            if (!"jcs-cache".equals(name) && !"cache".equals(name)) continue;
            CacheConcurrencyStrategy cache = CacheFactory.createCache(subnode, model.getRole(), model.getOwner().isMutable());
            mappings.addCache(model.getRole(), cache);
            model.setCache(cache);
        }
    }

    public static void bindRoot(Document doc, Mappings model) throws MappingException {
        Element n;
        Element hmNode = doc.getRootElement();
        Attribute schemaNode = hmNode.attribute("schema");
        model.setSchemaName(schemaNode == null ? null : schemaNode.getValue());
        Attribute dcNode = hmNode.attribute("default-cascade");
        model.setDefaultCascade(dcNode == null ? "none" : dcNode.getValue());
        Attribute aiNode = hmNode.attribute("auto-import");
        model.setAutoImport(aiNode == null ? true : "true".equals(aiNode.getValue()));
        Iterator nodes = hmNode.elementIterator("class");
        while (nodes.hasNext()) {
            Element n2 = (Element)nodes.next();
            RootClass rootclass = new RootClass();
            Binder.bindRootClass(n2, rootclass, model);
            model.addClass(rootclass);
        }
        Iterator subclassnodes = hmNode.elementIterator("subclass");
        while (subclassnodes.hasNext()) {
            Element subnode = (Element)subclassnodes.next();
            PersistentClass superModel = Binder.getSuperclass(model, subnode);
            Binder.handleSubclass(superModel, model, subnode);
        }
        Iterator joinedsubclassnodes = hmNode.elementIterator("joined-subclass");
        while (joinedsubclassnodes.hasNext()) {
            Element subnode = (Element)joinedsubclassnodes.next();
            PersistentClass superModel = Binder.getSuperclass(model, subnode);
            Binder.handleJoinedSubclass(superModel, model, subnode);
        }
        nodes = hmNode.elementIterator("query");
        while (nodes.hasNext()) {
            n = (Element)nodes.next();
            String qname = n.attributeValue("name");
            String query = n.getText();
            log.debug((Object)("Named query: " + qname + " -> " + query));
            model.addQuery(qname, query);
        }
        nodes = hmNode.elementIterator("sql-query");
        while (nodes.hasNext()) {
            Element queryElem = (Element)nodes.next();
            Attribute queryName = queryElem.attribute("name");
            if (queryName == null || queryName.getText().trim().equals("")) continue;
            Iterator returns = queryElem.elementIterator("return");
            Class[] classes = null;
            String[] aliases = null;
            int i = 0;
            classes = new Class[queryElem.elements("return").size()];
            aliases = new String[queryElem.elements("return").size()];
            while (returns.hasNext()) {
                Element qReturn = (Element)returns.next();
                try {
                    classes[i] = Class.forName(qReturn.attribute("class").getText());
                    aliases[i] = qReturn.attribute("alias").getText();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new MappingException("Class Not ( " + qReturn.attribute("class").getText() + " ) found in named sql query " + queryName.getText());
                }
                ++i;
            }
            String qName = queryElem.getText();
            NamedSQLQuery nq = new NamedSQLQuery(qName, aliases, classes);
            log.debug((Object)("Named sql query: " + queryName.getText() + " -> " + nq.getQueryString()));
            model.addSQLQuery(queryName.getText(), nq);
        }
        nodes = hmNode.elementIterator("import");
        while (nodes.hasNext()) {
            n = (Element)nodes.next();
            String className = n.attributeValue("class");
            Attribute renameNode = n.attribute("rename");
            String rename = renameNode == null ? StringHelper.unqualify(className) : renameNode.getValue();
            log.debug((Object)("Import: " + rename + " -> " + className));
            model.addImport(className, rename);
        }
    }

    private static PersistentClass getSuperclass(Mappings model, Element subnode) throws MappingException {
        Class superclass;
        String extendsValue = subnode.attributeValue("extends");
        try {
            superclass = ReflectHelper.classForName(extendsValue);
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("extends class " + extendsValue + " not found.", e);
        }
        PersistentClass superModel = model.getClass(superclass);
        if (superModel == null) {
            throw new MappingException("Cannot extend unmapped class " + superclass.getName());
        }
        return superModel;
    }

    private static String getPropertyName(Element node) {
        return node.attributeValue("name");
    }

    private static int getOptimisticLockMode(Attribute olAtt) throws MappingException {
        if (olAtt == null) {
            return 0;
        }
        String olMode = olAtt.getValue();
        if (olMode == null || "version".equals(olMode)) {
            return 0;
        }
        if ("dirty".equals(olMode)) {
            return 1;
        }
        if ("all".equals(olMode)) {
            return 2;
        }
        if ("none".equals(olMode)) {
            return -1;
        }
        throw new MappingException("Unsupported optimistic-lock style: " + olMode);
    }

    private static final java.util.Map getMetas(Element node) {
        HashMap<String, MetaAttribute> map = new HashMap<String, MetaAttribute>();
        Iterator iter = node.elementIterator("meta");
        while (iter.hasNext()) {
            Element metaNode = (Element)iter.next();
            String name = metaNode.attributeValue("attribute");
            MetaAttribute meta = (MetaAttribute)map.get(name);
            if (meta == null) {
                meta = new MetaAttribute();
                map.put(name, meta);
            }
            meta.addValue(metaNode.getText());
        }
        return map;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static abstract class CollectionType {
        private String xmlTag;
        private static final CollectionType MAP = new CollectionType("map"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                Map map = new Map(owner);
                Binder.bindCollection(node, map, prefix, mappings);
                return map;
            }
        };
        private static final CollectionType SET = new CollectionType("set"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                Set set = new Set(owner);
                Binder.bindCollection(node, set, prefix, mappings);
                return set;
            }
        };
        private static final CollectionType LIST = new CollectionType("list"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                List list = new List(owner);
                Binder.bindCollection(node, list, prefix, mappings);
                return list;
            }
        };
        private static final CollectionType BAG = new CollectionType("bag"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                Bag bag = new Bag(owner);
                Binder.bindCollection(node, bag, prefix, mappings);
                return bag;
            }
        };
        private static final CollectionType IDBAG = new CollectionType("idbag"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                IdentifierBag bag = new IdentifierBag(owner);
                Binder.bindCollection(node, bag, prefix, mappings);
                return bag;
            }
        };
        private static final CollectionType ARRAY = new CollectionType("array"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                Array array = new Array(owner);
                Binder.bindArray(node, array, prefix, mappings);
                return array;
            }
        };
        private static final CollectionType PRIMITIVE_ARRAY = new CollectionType("primitive-array"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                PrimitiveArray array = new PrimitiveArray(owner);
                Binder.bindArray(node, array, prefix, mappings);
                return array;
            }
        };
        private static final HashMap INSTANCES = new HashMap();

        public abstract Collection create(Element var1, String var2, PersistentClass var3, Mappings var4) throws MappingException;

        CollectionType(String xmlTag) {
            this.xmlTag = xmlTag;
        }

        public String toString() {
            return this.xmlTag;
        }

        public static CollectionType collectionTypeFromString(String xmlTagName) {
            return (CollectionType)INSTANCES.get(xmlTagName);
        }

        static {
            INSTANCES.put(MAP.toString(), MAP);
            INSTANCES.put(BAG.toString(), BAG);
            INSTANCES.put(IDBAG.toString(), IDBAG);
            INSTANCES.put(SET.toString(), SET);
            INSTANCES.put(LIST.toString(), LIST);
            INSTANCES.put(ARRAY.toString(), ARRAY);
            INSTANCES.put(PRIMITIVE_ARRAY.toString(), PRIMITIVE_ARRAY);
        }
    }

    static class ListSecondPass
    extends SecondPass {
        ListSecondPass(Element node, Mappings mappings, List collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses) throws MappingException {
            Binder.bindListSecondPass(this.node, (List)this.collection, persistentClasses, this.mappings);
        }
    }

    static class MapSecondPass
    extends SecondPass {
        MapSecondPass(Element node, Mappings mappings, Map collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses) throws MappingException {
            Binder.bindMapSecondPass(this.node, (Map)this.collection, persistentClasses, this.mappings);
        }
    }

    static class IdentifierCollectionSecondPass
    extends SecondPass {
        IdentifierCollectionSecondPass(Element node, Mappings mappings, IdentifierCollection collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses) throws MappingException {
            Binder.bindIdentifierCollectionSecondPass(this.node, (IdentifierCollection)this.collection, persistentClasses, this.mappings);
        }
    }

    static class CollectionSecondPass
    extends SecondPass {
        CollectionSecondPass(Element node, Mappings mappings, Collection collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses) throws MappingException {
            Binder.bindCollectionSecondPass(this.node, this.collection, persistentClasses, this.mappings);
        }
    }

    static abstract class SecondPass {
        Element node;
        Mappings mappings;
        Collection collection;

        SecondPass(Element node, Mappings mappings, Collection collection) {
            this.node = node;
            this.collection = collection;
            this.mappings = mappings;
        }

        final void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Second pass for collection: " + this.collection.getRole()));
            }
            this.secondPass(persistentClasses);
            this.collection.createAllKeys();
            if (log.isDebugEnabled()) {
                String msg = "Mapped collection key: " + Binder.columns(this.collection.getKey());
                if (this.collection.isIndexed()) {
                    msg = msg + ", index: " + Binder.columns(((IndexedCollection)this.collection).getIndex());
                }
                if (this.collection.isOneToMany()) {
                    msg = msg + ", one-to-many: " + this.collection.getElement().getType().getName();
                } else {
                    msg = msg + ", element: " + Binder.columns(this.collection.getElement());
                    msg = msg + ", type: " + this.collection.getElement().getType().getName();
                }
                log.debug((Object)msg);
            }
        }

        abstract void secondPass(java.util.Map var1) throws MappingException;
    }
}

